/*
 * Decompiled with CFR 0.152.
 */
package org.sqlproc.engine.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sqlproc.engine.impl.SqlInputValue;
import org.sqlproc.engine.impl.SqlMetaIdentItem;
import org.sqlproc.engine.impl.SqlMetaLogOperand;
import org.sqlproc.engine.impl.SqlMetaSimple;
import org.sqlproc.engine.impl.SqlProcessContext;
import org.sqlproc.engine.impl.SqlProcessResult;
import org.sqlproc.engine.impl.SqlType;
import org.sqlproc.engine.impl.SqlUtils;

class SqlMetaIdent
implements SqlMetaSimple,
SqlMetaLogOperand {
    final Logger logger = LoggerFactory.getLogger(this.getClass());
    private SqlInputValue.Case caseConversion;
    private boolean not;
    private List<SqlMetaIdentItem> elements;
    private SqlType sqlType;
    Map<String, String> values = new HashMap<String, String>();

    SqlMetaIdent(SqlInputValue.Case caseConversion) {
        this(caseConversion, false);
    }

    SqlMetaIdent(SqlInputValue.Case caseConversion, boolean not) {
        this(caseConversion, false, new SqlType());
    }

    SqlMetaIdent(SqlInputValue.Case caseConversion, boolean not, SqlType type) {
        this.elements = new ArrayList<SqlMetaIdentItem>();
        this.caseConversion = caseConversion;
        this.not = not;
        this.sqlType = type;
    }

    void addIdent(String name) {
        SqlMetaIdentItem lastItem;
        int size = this.elements.size();
        SqlMetaIdentItem sqlMetaIdentItem = lastItem = size > 0 ? this.elements.get(size - 1) : null;
        if (lastItem != null) {
            lastItem.setType(SqlMetaIdentItem.Type.REF);
        }
        this.elements.add(new SqlMetaIdentItem(name, SqlMetaIdentItem.Type.VAL));
    }

    void addIdent(SqlMetaIdentItem element) {
        this.elements.add(element);
    }

    void setMetaType(String sMetaType) {
        this.sqlType = sMetaType.startsWith("h_") ? new SqlType(sMetaType.substring(2)) : new SqlType(sMetaType, this.sqlType);
    }

    void setHibernateType(String sHibernateType) {
        this.sqlType = new SqlType(sHibernateType);
    }

    public void setValues(String value, String value2) {
        if (value2 == null) {
            this.sqlType.setValue(value);
        } else {
            this.values.put(value.toUpperCase(), value2);
        }
    }

    SqlType getSqlType() {
        return this.sqlType;
    }

    void setNot(boolean not) {
        this.not = not;
    }

    boolean isNot() {
        return this.not;
    }

    @Override
    public SqlProcessResult process(SqlProcessContext ctx) {
        SqlProcessResult result = new SqlProcessResult();
        boolean first = true;
        Object obj = ctx.dynamicInputValues;
        StringBuilder s = new StringBuilder(this.elements.size() * 32);
        s.append(':');
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("SqlMetaIdent process " + (obj != null ? obj.getClass() : null) + " " + obj + " " + this.sqlType);
        }
        int size = this.elements.size();
        int count = 1;
        String sequenceName = this.values.get("SEQ");
        String attributeName = null;
        Class<?> attributeType = obj != null ? obj.getClass() : null;
        for (SqlMetaIdentItem item : this.elements) {
            attributeName = item.getName();
            if (attributeType != null) {
                attributeType = SqlUtils.getFieldType(attributeType, attributeName);
            }
            if (count > 1) {
                s.append('_');
            }
            s.append(attributeName);
            if (sequenceName != null && count == size) break;
            if (obj != null) {
                obj = SqlUtils.invokeMethod(obj, item.get(), item.is());
            }
            ++count;
        }
        if (sequenceName != null) {
            String sequence = SqlProcessContext.getFeature(sequenceName);
            if (sequence == null) {
                throw new RuntimeException("Missing sequence " + sequenceName);
            }
            result.add(true);
            SqlInputValue identityInputValue = new SqlInputValue(obj, attributeType, sequence, this.sqlType);
            result.addInputValue(s.substring(1), identityInputValue);
            result.addIdentity(attributeName, identityInputValue);
        } else {
            try {
                result.add(SqlUtils.isEmpty(obj, this.sqlType, ctx.inSqlSetOrInsert));
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("Input value " + attributeName + ", failed reason" + e.getMessage());
            }
            result.addInputValue(s.substring(1), new SqlInputValue(obj, attributeType, this.caseConversion, this.sqlType));
        }
        result.setSql(s);
        return result;
    }

    @Override
    public boolean processExpression(SqlProcessContext ctx) {
        Object obj = ctx.dynamicInputValues;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("SqlMetaIdent process expression " + obj.getClass() + " " + obj + " " + this.sqlType);
        }
        for (SqlMetaIdentItem item : this.elements) {
            if (obj == null) continue;
            obj = SqlUtils.invokeMethod(obj, item.get(), item.is());
        }
        boolean result = SqlUtils.isTrue(obj, this.sqlType);
        return this.not ? !result : result;
    }
}

