/*
 * Decompiled with CFR 0.152.
 */
package org.sqlproc.engine.impl.type;

import java.lang.reflect.Method;
import java.util.Date;
import org.hibernate.Hibernate;
import org.hibernate.Query;
import org.hibernate.type.Type;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.sqlproc.engine.SqlRuntimeException;
import org.sqlproc.engine.impl.BeanUtils;
import org.sqlproc.engine.impl.type.SqlGenericType;

public class SqlDateType
extends SqlGenericType {
    @Override
    public Type getHibernateType() {
        return Hibernate.DATE;
    }

    @Override
    public Class<?>[] getClassTypes() {
        return new Class[0];
    }

    @Override
    public String[] getMetaTypes() {
        return new String[]{"DATE"};
    }

    @Override
    public void setResult(Object resultInstance, String attributeName, Object resultValue, boolean ingoreError) throws SqlRuntimeException {
        Method m;
        if (this.logger.isTraceEnabled()) {
            this.logger.trace(">>> setResult " + this.getMetaTypes()[0] + ": resultInstance=" + resultInstance + ", attributeName=" + attributeName + ", resultValue=" + resultValue);
        }
        if ((m = BeanUtils.getSetter(resultInstance, attributeName, Date.class)) != null) {
            BeanUtils.simpleInvokeMethod(m, resultInstance, resultValue);
        } else {
            m = BeanUtils.getSetter(resultInstance, attributeName, LocalDate.class);
            if (m != null) {
                LocalDate dt = new LocalDate(resultValue);
                BeanUtils.simpleInvokeMethod(m, resultInstance, dt);
            } else if (ingoreError) {
                this.logger.error("Incorrect datetime " + resultValue + " for " + attributeName + " in " + resultInstance);
            } else {
                throw new SqlRuntimeException("Incorrect datetime " + resultValue + " for " + attributeName + " in " + resultInstance);
            }
        }
    }

    @Override
    public void setParameter(Query query, String paramName, Object inputValue, Class<?> inputType, boolean ingoreError) throws SqlRuntimeException {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace(">>> setParameter " + this.getMetaTypes()[0] + ": paramName=" + paramName + ", inputValue=" + inputValue + ", inputType=" + inputType);
        }
        if (inputValue == null) {
            query.setParameter(paramName, inputValue, (Type)Hibernate.DATE);
        } else {
            DateTime dt = null;
            dt = inputValue instanceof LocalDate ? ((LocalDate)inputValue).toDateTimeAtStartOfDay() : new DateTime(inputValue).withTime(0, 0, 0, 0);
            query.setTimestamp(paramName, dt.toDate());
        }
    }
}

