/*
 * Decompiled with CFR 0.152.
 */
package org.sqlproc.engine.impl.type;

import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import org.hibernate.Query;
import org.sqlproc.engine.SqlRuntimeException;
import org.sqlproc.engine.impl.BeanUtils;
import org.sqlproc.engine.impl.SqlProcessContext;
import org.sqlproc.engine.impl.SqlUtils;
import org.sqlproc.engine.impl.type.SqlMetaType;

public class SqlDefaultType
extends SqlMetaType {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setResult(Object resultInstance, String attributeName, Object resultValue, boolean ingoreError) throws SqlRuntimeException {
        Class<?> attributeType;
        if (this.logger.isTraceEnabled()) {
            this.logger.trace(">>> setResult DEFAULT: resultInstance=" + resultInstance + ", attributeName=" + attributeName + ", resultValue=" + resultValue);
        }
        if ((attributeType = BeanUtils.getFieldType(resultInstance.getClass(), attributeName)) == null) {
            if (!ingoreError) throw new SqlRuntimeException("There's problem with attribute type for '" + attributeName + "' in " + resultInstance + ", META type is DEFAULT");
            this.logger.error("There's problem with attribute type for '" + attributeName + "' in " + resultInstance + ", META type is DEFAULT");
            return;
        }
        if (attributeType.isEnum()) {
            Method m = BeanUtils.getSetter(resultInstance, attributeName, attributeType);
            if (m != null) {
                if (resultValue != null && resultValue instanceof BigDecimal) {
                    resultValue = ((BigDecimal)resultValue).intValue();
                }
                Object enumInstance = SqlUtils.getValueToEnum(attributeType, resultValue);
                BeanUtils.simpleInvokeMethod(m, resultInstance, enumInstance);
                return;
            } else {
                if (!ingoreError) throw new SqlRuntimeException("There's no setter for '" + attributeName + "' in " + resultInstance + ", META type is DEFAULT");
                this.logger.error("There's no getter for '" + attributeName + "' in " + resultInstance + ", META type is DEFAULT");
            }
            return;
        } else {
            Method m = BeanUtils.getSetter(resultInstance, attributeName, attributeType);
            if (resultValue != null && resultValue instanceof BigDecimal) {
                resultValue = this.handleBigDecimal(attributeType, resultValue);
            }
            if (m != null) {
                BeanUtils.simpleInvokeMethod(m, resultInstance, resultValue);
                return;
            } else {
                if (!ingoreError) throw new SqlRuntimeException("There's no setter for '" + attributeName + "' in " + resultInstance + ", META type is DEFAULT");
                this.logger.error("There's no getter for '" + attributeName + "' in " + resultInstance + ", META type is DEFAULT");
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setParameter(Query query, String paramName, Object inputValue, Class<?> inputType, boolean ingoreError) throws SqlRuntimeException {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace(">>> setParameter DEFAULT: paramName=" + paramName + ", inputValue=" + inputValue + ", inputType=" + inputType);
        }
        if (!(inputValue instanceof Collection)) {
            if (inputType.isEnum()) {
                Object o = SqlUtils.getEnumToValue(inputValue);
                if (o != null && o instanceof Integer) {
                    query.setInteger(paramName, ((Integer)o).intValue());
                    return;
                } else if (o != null && o instanceof String) {
                    query.setString(paramName, (String)o);
                    return;
                } else {
                    if (!ingoreError) throw new SqlRuntimeException("Incorrect type based enum " + inputValue + " for " + paramName);
                    this.logger.error("Incorrect type based enum " + inputValue + " for " + paramName);
                }
                return;
            } else {
                SqlMetaType type = SqlProcessContext.getClassToTypeMap().get(inputType);
                if (type != null) {
                    type.setParameter(query, paramName, inputValue, inputType, ingoreError);
                    return;
                } else {
                    if (!ingoreError) throw new SqlRuntimeException("Incorrect default type " + inputValue + " for " + paramName);
                    this.logger.error("Incorrect default type " + inputValue + " for " + paramName);
                }
            }
            return;
        } else {
            ArrayList<Object> vals = new ArrayList<Object>();
            boolean isEnum = false;
            for (Object val : (Collection)inputValue) {
                if (!val.getClass().isEnum()) break;
                isEnum = true;
                Object o = SqlUtils.getEnumToValue(val);
                if (o != null) {
                    vals.add(o);
                    continue;
                }
                if (!ingoreError) throw new SqlRuntimeException("Incorrect type based enum item value " + o + " for " + paramName);
                this.logger.error("Incorrect type based enum item value " + o + " for " + paramName);
            }
            if (isEnum) {
                query.setParameterList(paramName, vals.toArray());
                return;
            } else {
                query.setParameterList(paramName, ((Collection)inputValue).toArray());
            }
        }
    }

    private Object handleBigDecimal(Class<?> attributeType, Object resultValue) {
        if (resultValue == null || !(resultValue instanceof BigDecimal)) {
            return resultValue;
        }
        BigDecimal result = (BigDecimal)resultValue;
        if (attributeType == Byte.class || attributeType == Byte.TYPE) {
            return result.byteValue();
        }
        if (attributeType == Integer.class || attributeType == Integer.TYPE) {
            return result.intValue();
        }
        if (attributeType == Long.class || attributeType == Long.TYPE) {
            return result.longValue();
        }
        if (attributeType == Short.class || attributeType == Short.TYPE) {
            return result.shortValue();
        }
        return result;
    }
}

