/*
 * Decompiled with CFR 0.152.
 */
package org.sqlproc.engine.impl;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.antlr.runtime.ANTLRStringStream;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.TokenSource;
import org.antlr.runtime.TokenStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sqlproc.engine.SqlEngineException;
import org.sqlproc.engine.impl.ErrorMsg;
import org.sqlproc.engine.impl.SqlMappingRule;
import org.sqlproc.engine.impl.SqlMetaElement;
import org.sqlproc.engine.impl.SqlMetaStatement;
import org.sqlproc.engine.impl.SqlProcessorLexer;
import org.sqlproc.engine.impl.SqlProcessorParser;
import org.sqlproc.engine.type.SqlTypeFactory;

public class SqlProcessor {
    protected static Logger logger = LoggerFactory.getLogger(SqlMetaElement.class);
    Map<String, Map<String, SqlMetaStatement>> metaStatements = new LinkedHashMap<String, Map<String, SqlMetaStatement>>();
    Map<String, Map<String, SqlMappingRule>> mappingRules;
    private Map<String, Object> features;
    private Map<String, Object> defaultFeatures;
    private Set<String> onlyStatements;
    private Set<String> allArtifactsNames;
    private List<String> warnings;
    private List<ErrorMsg> errors;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SqlProcessor getInstance(StringBuilder sbStatements, SqlTypeFactory typeFactory, Map<String, Object> defaultFeatures, Set<String> onlyStatements, String ... filters) throws SqlEngineException {
        if (logger.isTraceEnabled()) {
            logger.trace(">> getInstance, sStatements=" + sbStatements);
        }
        SqlProcessor processor = null;
        try {
            SqlProcessorLexer lexer = new SqlProcessorLexer((CharStream)new ANTLRStringStream(sbStatements.toString()));
            CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
            SqlProcessorParser parser = new SqlProcessorParser((TokenStream)tokens);
            try {
                processor = parser.parse(typeFactory, defaultFeatures, onlyStatements, filters);
            }
            catch (RecognitionException ex) {
                ex.printStackTrace();
            }
            if (!(lexer.getErrors().isEmpty() && parser.getErrors().isEmpty() && processor.getErrors().isEmpty())) {
                throw new SqlEngineException("Statement error for '" + sbStatements + "'", lexer.getErrors(), parser.getErrors(), processor.getErrors());
            }
            SqlProcessor sqlProcessor = processor;
            return sqlProcessor;
        }
        finally {
            if (logger.isTraceEnabled()) {
                logger.trace("<< getInstance, queries=" + processor.getMetaStatements(StatementType.QRY));
                logger.trace("<< getInstance, cruds=" + processor.getMetaStatements(StatementType.CRUD));
                logger.trace("<< getInstance, calls=" + processor.getMetaStatements(StatementType.CALL));
                logger.trace("<< getInstance, input mappings=" + processor.getMappingRules(MappingType.IN));
                logger.trace("<< getInstance, output mappings=" + processor.getMappingRules(MappingType.OUT));
                logger.trace("<< getInstance, features=" + processor.getFeatures());
            }
        }
    }

    SqlProcessor(Map<String, Object> defaultFeatures, Set<String> onlyStatements) {
        for (StatementType statementType : StatementType.values()) {
            this.metaStatements.put(statementType.name(), new LinkedHashMap());
        }
        this.mappingRules = new LinkedHashMap<String, Map<String, SqlMappingRule>>();
        for (Enum enum_ : MappingType.values()) {
            this.mappingRules.put(enum_.name(), new LinkedHashMap());
        }
        this.defaultFeatures = defaultFeatures;
        this.features = new LinkedHashMap<String, Object>();
        this.features.putAll(defaultFeatures);
        if (onlyStatements != null && !onlyStatements.isEmpty()) {
            this.onlyStatements = onlyStatements;
        }
        this.allArtifactsNames = new HashSet<String>();
        this.warnings = new ArrayList<String>();
        this.errors = new ArrayList<ErrorMsg>();
    }

    public Map<String, SqlMetaStatement> getMetaStatements(StatementType type) {
        return this.metaStatements.get(type.name());
    }

    public Map<String, SqlMetaStatement> getMetaStatements(String type) {
        StatementType.valueOf(type);
        return this.metaStatements.get(type);
    }

    boolean addMetaStatement(String type, String name, SqlMetaStatement statement, List<ErrorMsg> errors, List<String> activeFilters, String ... filters) {
        StatementType.valueOf(type);
        if (this.nameControl(this.onlyStatements, name)) {
            this.addWarnings(errors);
            return false;
        }
        if (errors != null && !errors.isEmpty()) {
            this.errors.addAll(errors);
            return false;
        }
        FilterStatus status = this.filtersControl(filters, activeFilters);
        if (status == FilterStatus.NOK) {
            return false;
        }
        Map<String, SqlMetaStatement> statements = this.getMetaStatements(type);
        if (status == FilterStatus.OK_LOWER) {
            if (statements.containsKey(name)) {
                this.warnings.add("The artifact " + this.uniqueArtifactName(type, name, activeFilters) + " is already defined, the first definition is used.");
                return false;
            }
            statements.put(name, statement);
            return true;
        }
        this.duplicityControl(type, name, activeFilters);
        statements.put(name, statement);
        return true;
    }

    public Map<String, SqlMappingRule> getMappingRules(MappingType type) {
        return this.mappingRules.get(type.name());
    }

    public Map<String, SqlMappingRule> getMappingRules(String type) {
        MappingType.valueOf(type);
        return this.mappingRules.get(type);
    }

    public boolean addMappingRule(String type, String name, SqlMappingRule mapping, List<ErrorMsg> errors, List<String> activeFilters, String ... filters) {
        MappingType.valueOf(type);
        if (this.nameControl(this.onlyStatements, name)) {
            this.addWarnings(errors);
            return false;
        }
        if (errors != null && !errors.isEmpty()) {
            this.errors.addAll(errors);
            return false;
        }
        FilterStatus status = this.filtersControl(filters, activeFilters);
        if (status == FilterStatus.NOK) {
            return false;
        }
        Map<String, SqlMappingRule> mappings = this.getMappingRules(type);
        if (status == FilterStatus.OK_LOWER) {
            if (mappings.containsKey(name)) {
                this.warnings.add("The artifact " + this.uniqueArtifactName(type, name, activeFilters) + " is already defined, the first definition is used.");
                return false;
            }
            mappings.put(name, mapping);
            return true;
        }
        this.duplicityControl(type, name, activeFilters);
        mappings.put(name, mapping);
        return true;
    }

    public Map<String, Object> getFeatures() {
        return this.features;
    }

    protected Object getFeature(String type, String feature) {
        FeatureType ftype = FeatureType.valueOf(type);
        if (ftype == FeatureType.LOPT) {
            return Long.parseLong(feature);
        }
        if (ftype == FeatureType.IOPT) {
            return Integer.parseInt(feature);
        }
        if (ftype == FeatureType.SOPT) {
            return Short.parseShort(feature);
        }
        if (ftype == FeatureType.BOPT) {
            return Boolean.parseBoolean(feature);
        }
        return feature;
    }

    public boolean addFeature(String type, String name, String feature, List<ErrorMsg> errors, List<String> activeFilters, String ... filters) {
        FeatureType.valueOf(type);
        if (errors != null && !errors.isEmpty()) {
            this.errors.addAll(errors);
            return false;
        }
        FilterStatus status = this.filtersControl(filters, activeFilters);
        if (status == FilterStatus.NOK) {
            return false;
        }
        if (status == FilterStatus.OK_LOWER) {
            if (this.getFeatures().containsKey(name)) {
                if (!this.defaultFeatures.containsKey(name)) {
                    this.warnings.add("The artifact " + this.uniqueArtifactName(type, name, activeFilters) + " is already defined, the first definition is used.");
                    return false;
                }
                this.defaultFeatures.remove(name);
                this.getFeatures().put(name, this.getFeature(type, feature));
                return true;
            }
            this.getFeatures().put(name, this.getFeature(type, feature));
            return true;
        }
        this.duplicityControl(type, name, activeFilters);
        this.getFeatures().put(name, this.getFeature(type, feature));
        return true;
    }

    protected boolean duplicityControl(String type, String name, List<String> activeFilters) {
        String uniqueName = this.uniqueArtifactName(type, name, activeFilters);
        if (this.allArtifactsNames.contains(uniqueName)) {
            this.warnings.add("The artifact " + uniqueName + " is already defined, the latest definition is used.");
            return true;
        }
        this.allArtifactsNames.add(uniqueName);
        return false;
    }

    protected String uniqueArtifactName(String type, String name, List<String> activeFilters) {
        return type + ":" + name + (activeFilters != null && !activeFilters.isEmpty() ? activeFilters.toString() : "");
    }

    protected void addWarnings(List<ErrorMsg> errors) {
        if (errors == null || errors.isEmpty()) {
            return;
        }
        for (ErrorMsg errorMsg : errors) {
            this.warnings.add(errorMsg.toString());
        }
    }

    public List<String> getWarnings() {
        return this.warnings;
    }

    public List<ErrorMsg> getErrors() {
        return this.errors;
    }

    protected FilterStatus filtersControl(String[] filters, List<String> activeFilters) {
        if (filters == null || filters.length == 0) {
            if (activeFilters == null || activeFilters.isEmpty()) {
                return FilterStatus.OK;
            }
            return FilterStatus.NOK;
        }
        if (activeFilters == null || activeFilters.isEmpty()) {
            return FilterStatus.OK_LOWER;
        }
        ArrayList<String> commonList = new ArrayList<String>();
        for (String filter : filters) {
            if (!activeFilters.contains(filter)) continue;
            commonList.add(filter);
        }
        return commonList.isEmpty() ? FilterStatus.NOK : FilterStatus.OK;
    }

    protected boolean nameControl(Set<String> onlyStatements, String name) {
        if (onlyStatements == null || onlyStatements.isEmpty()) {
            return false;
        }
        return !onlyStatements.contains(name);
    }

    static enum FilterStatus {
        NOK,
        OK_LOWER,
        OK;

    }

    public static enum FeatureType {
        OPT,
        LOPT,
        IOPT,
        SOPT,
        BOPT;

    }

    public static enum MappingType {
        OUT,
        IN;

    }

    public static enum StatementType {
        QRY,
        CRUD,
        CALL;

    }
}

