/*
 * Decompiled with CFR 0.152.
 */
package org.sqlproc.engine.plugin;

import java.util.Collection;
import org.sqlproc.engine.impl.SqlProcessContext;
import org.sqlproc.engine.impl.SqlUtils;
import org.sqlproc.engine.plugin.IsEmptyPlugin;
import org.sqlproc.engine.plugin.IsTruePlugin;
import org.sqlproc.engine.plugin.SqlCountPlugin;
import org.sqlproc.engine.plugin.SqlFromToPlugin;
import org.sqlproc.engine.plugin.SqlIdentityPlugin;
import org.sqlproc.engine.plugin.SqlSequencePlugin;
import org.sqlproc.engine.type.SqlMetaType;

public class DefaultSqlPlugins
implements IsEmptyPlugin,
IsTruePlugin,
SqlCountPlugin,
SqlFromToPlugin,
SqlSequencePlugin,
SqlIdentityPlugin {
    public static final String SUPPVAL_NOTNULL = "notnull";
    public static final String SUPPVAL_ANY = "any";
    public static final String SUPPVAL_NULL = "null";

    @Override
    public boolean isEmpty(Object obj, SqlMetaType sqlMetaType, String sqlMetaTypeExt, boolean inSqlSetOrInsert) throws IllegalArgumentException {
        String value;
        String string = value = sqlMetaTypeExt != null ? sqlMetaTypeExt.toLowerCase() : null;
        if (SUPPVAL_NOTNULL.equalsIgnoreCase(value) && obj == null) {
            throw new IllegalArgumentException(SUPPVAL_NOTNULL);
        }
        if (inSqlSetOrInsert && obj == null) {
            return true;
        }
        if (SUPPVAL_ANY.equalsIgnoreCase(value)) {
            return true;
        }
        if (SUPPVAL_NULL.equalsIgnoreCase(value)) {
            return obj == null;
        }
        if (obj == null) {
            return false;
        }
        return !(obj instanceof Collection ? ((Collection)obj).isEmpty() : obj.toString().length() <= 0);
    }

    @Override
    public boolean isTrue(Object obj, SqlMetaType sqlMetaType, String sqlMetaTypeExt) {
        if (sqlMetaTypeExt == null) {
            if (obj != null) {
                if (obj instanceof Boolean) {
                    return (Boolean)obj;
                }
                if (obj instanceof String) {
                    String str = ((String)obj).trim();
                    return str.length() > 0 && !str.equalsIgnoreCase("false");
                }
                if (obj instanceof Number) {
                    return ((Number)obj).longValue() > 0L;
                }
                if (obj.getClass().isEnum()) {
                    return true;
                }
                return true;
            }
            return false;
        }
        if (obj == null) {
            return sqlMetaTypeExt.toLowerCase().equalsIgnoreCase(SUPPVAL_NULL);
        }
        if (obj.getClass().isEnum()) {
            if (obj.toString().equals(sqlMetaTypeExt)) {
                return true;
            }
            if (sqlMetaType == SqlProcessContext.getTypeFactory().getEnumStringType()) {
                return sqlMetaTypeExt.equals(SqlUtils.getEnumToValue(obj));
            }
            if (sqlMetaType == SqlProcessContext.getTypeFactory().getEnumIntegerType()) {
                return sqlMetaTypeExt.equals(SqlUtils.getEnumToValue(obj).toString());
            }
            Object enumVal = SqlUtils.getEnumToValue(obj);
            return enumVal.toString().equals(sqlMetaTypeExt);
        }
        return obj.toString().equals(sqlMetaTypeExt);
    }

    @Override
    public String sqlCount(StringBuilder sql) {
        String s = sql.toString().toUpperCase();
        int start = s.indexOf("ID");
        int end = s.indexOf("FROM");
        StringBuilder sb = sql;
        if (start < 0 || end < 0 || start > end) {
            return "select count(*) as vysledek from (" + sb.toString() + ") derived";
        }
        String s1 = sb.substring(0, start + 2);
        String s2 = sb.substring(end);
        start = s1.toUpperCase().indexOf("SELECT");
        if (start < 0) {
            return "select count(*) as vysledek from (" + sb.toString() + ") derived";
        }
        return s1.substring(0, start) + "select count(" + s1.substring(start + 6) + ") as vysledek " + s2;
    }

    @Override
    public SqlFromToPlugin.LimitType limitQuery(String queryString, StringBuilder queryResult, Integer firstResult, Integer maxResults, boolean ordered) {
        String limitPattern;
        SqlFromToPlugin.LimitType limitType = new SqlFromToPlugin.LimitType();
        if (maxResults == null || maxResults <= 0) {
            return null;
        }
        if (firstResult != null && firstResult > 0) {
            String limitPattern2;
            limitType.alsoFirst = true;
            String string = limitPattern2 = ordered ? SqlProcessContext.getFeature("LIMIT_FROM_TO_ORDERED") : SqlProcessContext.getFeature("LIMIT_FROM_TO");
            if (limitPattern2 == null && ordered) {
                limitPattern2 = SqlProcessContext.getFeature("LIMIT_FROM_TO");
            }
            limitType = this.limitQuery(limitPattern2, limitType, queryString, queryResult, firstResult, maxResults);
            return limitType;
        }
        String string = limitPattern = ordered ? SqlProcessContext.getFeature("LIMIT_TO_ORDERED") : SqlProcessContext.getFeature("LIMIT_TO");
        if (limitPattern == null && ordered) {
            limitPattern = SqlProcessContext.getFeature("LIMIT_TO");
        }
        limitType = this.limitQuery(limitPattern, limitType, queryString, queryResult, firstResult, maxResults);
        return limitType;
    }

    private SqlFromToPlugin.LimitType limitQuery(String limitPattern, SqlFromToPlugin.LimitType limitType, String queryString, StringBuilder queryResult, Integer firstResult, Integer maxResults) {
        if (limitPattern == null) {
            return null;
        }
        int ix = limitPattern.indexOf("$S");
        if (ix >= 0) {
            limitType.afterSql = limitPattern.indexOf("$", ix + 1) > 0;
            queryResult.append(limitPattern.substring(0, ix));
            queryResult.append(queryString);
            queryResult.append(limitPattern.substring(ix + 2));
        } else {
            ix = limitPattern.indexOf("$s");
            if (ix >= 0) {
                limitType.afterSql = limitPattern.indexOf("$", ix + 1) > 0;
                int ix2 = queryString.toLowerCase().indexOf("select");
                if (ix2 < 0) {
                    return null;
                }
                queryResult.append(limitPattern.substring(0, ix));
                queryResult.append(queryString.substring(ix2 + 6));
                queryResult.append(limitPattern.substring(ix + 2));
            } else {
                return null;
            }
        }
        if (limitType.alsoFirst) {
            ix = queryResult.indexOf("$F");
            if (ix >= 0) {
                if (queryResult.indexOf("$m", ix) < 0 && queryResult.indexOf("$M", ix) < 0) {
                    limitType.maxBeforeFirst = true;
                }
                queryResult.replace(ix, ix + 2, "?");
            } else {
                ix = queryResult.indexOf("$f");
                if (ix >= 0) {
                    limitType.zeroBasedFirst = true;
                    if (queryResult.indexOf("$m", ix) < 0 && queryResult.indexOf("$M", ix) < 0) {
                        limitType.maxBeforeFirst = true;
                    }
                    queryResult.replace(ix, ix + 2, "?");
                } else {
                    return null;
                }
            }
        }
        if ((ix = queryResult.indexOf("$M")) >= 0) {
            queryResult.replace(ix, ix + 2, "?");
        } else {
            ix = queryResult.indexOf("$m");
            if (ix >= 0) {
                limitType.rowidBasedMax = true;
                queryResult.replace(ix, ix + 2, "?");
            } else {
                return null;
            }
        }
        return limitType;
    }

    @Override
    public String identitySelect(String identitySelectName, String tableName, String columnName) {
        String identitySelect;
        String string = identitySelect = "idsel".equals(identitySelectName) ? null : SqlProcessContext.getFeature(identitySelectName);
        if (identitySelect != null) {
            return identitySelect;
        }
        return SqlProcessContext.getFeature("IDSEL");
    }

    @Override
    public String sequenceSelect(String sequenceName) {
        String sequence = SqlProcessContext.getFeature(sequenceName);
        if (sequence != null) {
            return sequence;
        }
        String sequencePattern = SqlProcessContext.getFeature("SEQ");
        if (sequencePattern == null) {
            return null;
        }
        int ix = sequencePattern.indexOf("$n");
        if (ix < 0) {
            return sequencePattern;
        }
        if ("seq".equals(sequenceName)) {
            return sequencePattern.substring(0, ix) + "SQLPROC_SEQUENCE" + sequencePattern.substring(ix + 2);
        }
        return sequencePattern.substring(0, ix) + sequenceName + sequencePattern.substring(ix + 2);
    }
}

