/*
 * Decompiled with CFR 0.152.
 */
package org.sqlproc.engine.jmx;

import org.sqlproc.engine.SqlEngineException;
import org.sqlproc.engine.SqlEngineFactory;
import org.sqlproc.engine.jmx.SqlSimpleFactoryMXBean;

public class SqlSimpleFactoryJmx
implements SqlSimpleFactoryMXBean {
    private SqlEngineFactory sqlEngineFactory;
    public static final String OK = "OK";

    @Override
    public String initQueryEngines(String names) {
        StringBuilder errors = new StringBuilder();
        for (String name : names.split(",")) {
            try {
                this.sqlEngineFactory.getCheckedQueryEngine(name);
            }
            catch (SqlEngineException ex) {
                errors.append(ex.getMessage()).append("\n");
            }
        }
        return errors.length() == 0 ? OK : errors.toString();
    }

    @Override
    public String initCrudEngines(String names) {
        StringBuilder errors = new StringBuilder();
        for (String name : names.split(",")) {
            try {
                this.sqlEngineFactory.getCheckedCrudEngine(name);
            }
            catch (SqlEngineException ex) {
                errors.append(ex.getMessage()).append("\n");
            }
        }
        return errors.length() == 0 ? OK : errors.toString();
    }

    @Override
    public String initProcedureEngines(String names) {
        StringBuilder errors = new StringBuilder();
        for (String name : names.split(",")) {
            try {
                this.sqlEngineFactory.getCheckedProcedureEngine(name);
            }
            catch (SqlEngineException ex) {
                errors.append(ex.getMessage()).append("\n");
            }
        }
        return errors.length() == 0 ? OK : errors.toString();
    }

    @Override
    public String resetQueryEngines(String names) {
        StringBuilder errors = new StringBuilder();
        for (String name : names.split(",")) {
            try {
                this.sqlEngineFactory.getCheckedStaticQueryEngine(name);
            }
            catch (SqlEngineException ex) {
                errors.append(ex.getMessage()).append("\n");
            }
        }
        return errors.length() == 0 ? OK : errors.toString();
    }

    @Override
    public String resetCrudEngines(String names) {
        StringBuilder errors = new StringBuilder();
        for (String name : names.split(",")) {
            try {
                this.sqlEngineFactory.getCheckedStaticCrudEngine(name);
            }
            catch (SqlEngineException ex) {
                errors.append(ex.getMessage()).append("\n");
            }
        }
        return errors.length() == 0 ? OK : errors.toString();
    }

    @Override
    public String resetProcedureEngines(String names) {
        StringBuilder errors = new StringBuilder();
        for (String name : names.split(",")) {
            try {
                this.sqlEngineFactory.getCheckedStaticProcedureEngine(name);
            }
            catch (SqlEngineException ex) {
                errors.append(ex.getMessage()).append("\n");
            }
        }
        return errors.length() == 0 ? OK : errors.toString();
    }

    @Override
    public String newQueryEngine(String name, String sqlStatement) throws SqlEngineException {
        try {
            this.sqlEngineFactory.getDynamicQueryEngine(name, sqlStatement);
        }
        catch (SqlEngineException ex) {
            return ex.getMessage();
        }
        return OK;
    }

    @Override
    public String newCrudEngine(String name, String sqlStatement) {
        try {
            this.sqlEngineFactory.getDynamicCrudEngine(name, sqlStatement);
        }
        catch (SqlEngineException ex) {
            return ex.getMessage();
        }
        return OK;
    }

    @Override
    public String newProcedureEngine(String name, String sqlStatement) {
        try {
            this.sqlEngineFactory.getDynamicProcedureEngine(name, sqlStatement);
        }
        catch (SqlEngineException ex) {
            return ex.getMessage();
        }
        return OK;
    }

    @Override
    public String getNames() {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (String name : this.sqlEngineFactory.getNames()) {
            if (first) {
                first = false;
            } else {
                sb.append(",");
            }
            sb.append(name);
        }
        return sb.toString();
    }

    @Override
    public String getDynamicNames() {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (String name : this.sqlEngineFactory.getDynamicNames()) {
            if (first) {
                first = false;
            } else {
                sb.append(",");
            }
            sb.append(name);
        }
        return sb.toString();
    }

    @Override
    public boolean isLazyInit() {
        return this.sqlEngineFactory.isLazyInit();
    }

    public void setSqlEngineFactory(SqlEngineFactory sqlEngineFactory) {
        this.sqlEngineFactory = sqlEngineFactory;
    }
}

