/*
 * Decompiled with CFR 0.152.
 */
package org.sqlproc.engine;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sqlproc.engine.SqlCrudEngine;
import org.sqlproc.engine.SqlEngine;
import org.sqlproc.engine.SqlEngineException;
import org.sqlproc.engine.SqlEngineFactory;
import org.sqlproc.engine.SqlFilesLoader;
import org.sqlproc.engine.SqlMonitorFactory;
import org.sqlproc.engine.SqlProcedureEngine;
import org.sqlproc.engine.SqlProcessorLoader;
import org.sqlproc.engine.SqlQueryEngine;
import org.sqlproc.engine.config.SqlEngineConfiguration;
import org.sqlproc.engine.plugin.SqlPluginFactory;
import org.sqlproc.engine.type.SqlInternalType;
import org.sqlproc.engine.type.SqlTypeFactory;
import org.sqlproc.engine.validation.SqlValidatorFactory;

public class SqlSimpleFactory
implements SqlEngineFactory {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String LINESEP = System.getProperty("line.separator");
    private List<String> metaFilesNames = new ArrayList<String>();
    private StringBuilder metaStatements;
    private SqlTypeFactory typeFactory;
    protected SqlPluginFactory pluginFactory;
    private String filter;
    private SqlMonitorFactory monitorFactory;
    private List<SqlInternalType> customTypes;
    private String[] onlyStatements;
    private boolean jdbc;
    private SqlProcessorLoader processorLoader;
    private SqlValidatorFactory validatorFactory;
    private Boolean lazyInit;
    private SqlEngineConfiguration configuration;

    public SqlSimpleFactory() {
    }

    public SqlSimpleFactory(boolean lazyInit) {
        this.lazyInit = lazyInit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void init() {
        if (this.processorLoader == null) {
            SqlSimpleFactory sqlSimpleFactory = this;
            synchronized (sqlSimpleFactory) {
                if (this.processorLoader == null && (this.metaStatements != null || this.metaFilesNames != null && !this.metaFilesNames.isEmpty())) {
                    if (this.metaStatements == null) {
                        this.metaStatements = SqlFilesLoader.getStatements(this.getClass(), this.metaFilesNames.toArray(new String[0]));
                    }
                    if (this.jdbc) {
                        this.metaStatements.append(LINESEP).append("JDBC(BOPT)=true;");
                    }
                    this.processorLoader = new SqlProcessorLoader(this.metaStatements, this.typeFactory, this.pluginFactory, this.filter, this.monitorFactory, this.validatorFactory, this.customTypes, this.isLazyInit(), this.onlyStatements);
                    if (this.isLazyInit() && this.configuration != null) {
                        for (SqlEngineConfiguration.NameValue nameValue : this.configuration.getQueryEnginesToInit(this.configuration.getInitTreshold())) {
                            this.getQueryEngine(nameValue.name);
                            if (!this.logger.isTraceEnabled()) continue;
                            this.logger.trace("== SqlSimpleFactory, initialized static Query Engine " + nameValue.name);
                        }
                        for (SqlEngineConfiguration.NameValue nameValue : this.configuration.getCrudEnginesToInit(this.configuration.getInitTreshold())) {
                            this.getCrudEngine(nameValue.name);
                            if (!this.logger.isTraceEnabled()) continue;
                            this.logger.trace("== SqlSimpleFactory, initialized static CRUD Engine " + nameValue.name);
                        }
                        for (SqlEngineConfiguration.NameValue nameValue : this.configuration.getProcedureEnginesToInit(this.configuration.getInitTreshold())) {
                            this.getProcedureEngine(nameValue.name);
                            if (!this.logger.isTraceEnabled()) continue;
                            this.logger.trace("== SqlSimpleFactory, initialized static Procedure Engine " + nameValue.name);
                        }
                        for (Map.Entry entry : this.configuration.getDynamicQueryEngines().entrySet()) {
                            this.getDynamicQueryEngine((String)entry.getKey(), (String)entry.getValue());
                            if (!this.logger.isTraceEnabled()) continue;
                            this.logger.trace("== SqlSimpleFactory, initialized dynamic Query Engine " + (String)entry.getKey());
                        }
                        for (Map.Entry entry : this.configuration.getDynamicCrudEngines().entrySet()) {
                            this.getDynamicCrudEngine((String)entry.getKey(), (String)entry.getValue());
                            if (!this.logger.isTraceEnabled()) continue;
                            this.logger.trace("== SqlSimpleFactory, initialized dynamic CRUD Engine " + (String)entry.getKey());
                        }
                        for (Map.Entry entry : this.configuration.getDynamicProcedureEngines().entrySet()) {
                            this.getDynamicProcedureEngine((String)entry.getKey(), (String)entry.getValue());
                            if (!this.logger.isTraceEnabled()) continue;
                            this.logger.trace("== SqlSimpleFactory, initialized dynamic Procedure Engine " + (String)entry.getKey());
                        }
                        if (this.configuration.getInitClearUsage() != null && this.configuration.getInitClearUsage().booleanValue()) {
                            this.configuration.clearUsage();
                        }
                    }
                }
            }
        }
    }

    public void init0() {
        if (this.getLoader() == null) {
            this.init();
        }
    }

    @Override
    public SqlQueryEngine getQueryEngine(String name) {
        this.init0();
        SqlQueryEngine sqlEngine = (SqlQueryEngine)this.getLoader().getEngine(name, SqlProcessorLoader.EngineType.Query);
        if (sqlEngine != null && this.configuration != null) {
            this.configuration.addQueryEngine(name);
        }
        return sqlEngine;
    }

    @Override
    public SqlCrudEngine getCrudEngine(String name) {
        this.init0();
        SqlCrudEngine sqlEngine = (SqlCrudEngine)this.getLoader().getEngine(name, SqlProcessorLoader.EngineType.Crud);
        if (sqlEngine != null && this.configuration != null) {
            this.configuration.addCrudEngine(name);
        }
        return sqlEngine;
    }

    @Override
    public SqlProcedureEngine getProcedureEngine(String name) {
        this.init0();
        SqlProcedureEngine sqlEngine = (SqlProcedureEngine)this.getLoader().getEngine(name, SqlProcessorLoader.EngineType.Procedure);
        if (sqlEngine != null && this.configuration != null) {
            this.configuration.addProcedureEngine(name);
        }
        return sqlEngine;
    }

    @Override
    public SqlQueryEngine getStaticQueryEngine(String name) {
        this.init0();
        SqlQueryEngine sqlEngine = (SqlQueryEngine)this.getLoader().getStaticEngine(name, SqlProcessorLoader.EngineType.Query);
        if (sqlEngine != null && this.configuration != null) {
            this.configuration.addQueryEngine(name);
            this.configuration.removeDynamicQueryEngine(name);
        }
        return sqlEngine;
    }

    @Override
    public SqlCrudEngine getStaticCrudEngine(String name) {
        this.init0();
        SqlCrudEngine sqlEngine = (SqlCrudEngine)this.getLoader().getStaticEngine(name, SqlProcessorLoader.EngineType.Crud);
        if (sqlEngine != null && this.configuration != null) {
            this.configuration.addCrudEngine(name);
            this.configuration.removeDynamicCrudEngine(name);
        }
        return sqlEngine;
    }

    @Override
    public SqlProcedureEngine getStaticProcedureEngine(String name) {
        this.init0();
        SqlProcedureEngine sqlEngine = (SqlProcedureEngine)this.getLoader().getStaticEngine(name, SqlProcessorLoader.EngineType.Procedure);
        if (sqlEngine != null && this.configuration != null) {
            this.configuration.addProcedureEngine(name);
            this.configuration.removeDynamicProcedureEngine(name);
        }
        return sqlEngine;
    }

    private void check(String name, SqlEngine sqlEngine) {
        if (sqlEngine == null) {
            throw new SqlEngineException("Missing SqlEngine " + name);
        }
    }

    @Override
    public SqlQueryEngine getCheckedQueryEngine(String name) throws SqlEngineException {
        SqlQueryEngine sqlEngine = this.getQueryEngine(name);
        this.check(name, sqlEngine);
        return sqlEngine;
    }

    @Override
    public SqlCrudEngine getCheckedCrudEngine(String name) {
        SqlCrudEngine sqlEngine = this.getCrudEngine(name);
        this.check(name, sqlEngine);
        return sqlEngine;
    }

    @Override
    public SqlProcedureEngine getCheckedProcedureEngine(String name) {
        SqlProcedureEngine sqlEngine = this.getProcedureEngine(name);
        this.check(name, sqlEngine);
        return sqlEngine;
    }

    @Override
    public SqlQueryEngine getCheckedStaticQueryEngine(String name) throws SqlEngineException {
        SqlQueryEngine sqlEngine = this.getStaticQueryEngine(name);
        this.check(name, sqlEngine);
        return sqlEngine;
    }

    @Override
    public SqlCrudEngine getCheckedStaticCrudEngine(String name) {
        SqlCrudEngine sqlEngine = this.getStaticCrudEngine(name);
        this.check(name, sqlEngine);
        return sqlEngine;
    }

    @Override
    public SqlProcedureEngine getCheckedStaticProcedureEngine(String name) {
        SqlProcedureEngine sqlEngine = this.getStaticProcedureEngine(name);
        this.check(name, sqlEngine);
        return sqlEngine;
    }

    @Override
    public SqlQueryEngine getDynamicQueryEngine(String name, String sqlStatement) throws SqlEngineException {
        this.init0();
        SqlQueryEngine sqlEngine = (SqlQueryEngine)this.getLoader().getDynamicEngine(name, SqlProcessorLoader.EngineType.Query, sqlStatement);
        if (sqlEngine != null && this.configuration != null) {
            this.configuration.addDynamicQueryEngine(name, sqlStatement);
        }
        return sqlEngine;
    }

    @Override
    public SqlCrudEngine getDynamicCrudEngine(String name, String sqlStatement) {
        this.init0();
        SqlCrudEngine sqlEngine = (SqlCrudEngine)this.getLoader().getDynamicEngine(name, SqlProcessorLoader.EngineType.Crud, sqlStatement);
        if (sqlEngine != null && this.configuration != null) {
            this.configuration.addDynamicCrudEngine(name, sqlStatement);
        }
        return sqlEngine;
    }

    @Override
    public SqlProcedureEngine getDynamicProcedureEngine(String name, String sqlStatement) {
        this.init0();
        SqlProcedureEngine sqlEngine = (SqlProcedureEngine)this.getLoader().getDynamicEngine(name, SqlProcessorLoader.EngineType.Procedure, sqlStatement);
        if (sqlEngine != null && this.configuration != null) {
            this.configuration.addDynamicProcedureEngine(name, sqlStatement);
        }
        return sqlEngine;
    }

    public List<String> getMetaFilesNames() {
        return this.metaFilesNames;
    }

    public void setMetaFilesNames(List<String> metaFilesNames) {
        this.metaFilesNames = metaFilesNames;
    }

    public void setMetaFilesNames(String ... metaFilesNames) {
        this.metaFilesNames = new ArrayList<String>();
        Collections.addAll(this.metaFilesNames, metaFilesNames);
    }

    public StringBuilder getMetaStatements() {
        return this.metaStatements;
    }

    public void setMetaStatements(StringBuilder metaStatements) {
        this.metaStatements = metaStatements;
    }

    public SqlTypeFactory getTypeFactory() {
        return this.typeFactory;
    }

    public void setTypeFactory(SqlTypeFactory typeFactory) {
        this.typeFactory = typeFactory;
    }

    public SqlPluginFactory getPluginFactory() {
        return this.pluginFactory;
    }

    public void setPluginFactory(SqlPluginFactory pluginFactory) {
        this.pluginFactory = pluginFactory;
    }

    public String getFilter() {
        return this.filter;
    }

    public void setFilter(String filter) {
        this.filter = filter;
    }

    public SqlMonitorFactory getMonitorFactory() {
        return this.monitorFactory;
    }

    public void setMonitorFactory(SqlMonitorFactory monitorFactory) {
        this.monitorFactory = monitorFactory;
    }

    public List<SqlInternalType> getCustomTypes() {
        return this.customTypes;
    }

    public void setCustomTypes(List<SqlInternalType> customTypes) {
        this.customTypes = customTypes;
    }

    public void setCustomTypes(SqlInternalType ... customTypes) {
        this.customTypes = new ArrayList<SqlInternalType>();
        Collections.addAll(this.customTypes, customTypes);
    }

    public void addCustomType(SqlInternalType customType) {
        if (this.customTypes == null) {
            this.customTypes = new ArrayList<SqlInternalType>();
        }
        this.customTypes.add(customType);
    }

    public String[] getOnlyStatements() {
        return this.onlyStatements;
    }

    public void setOnlyStatements(String[] selectQueries) {
        this.onlyStatements = selectQueries != null ? Arrays.copyOf(selectQueries, selectQueries.length) : null;
    }

    public boolean isJdbc() {
        return this.jdbc;
    }

    public void setJdbc(boolean jdbc) {
        this.jdbc = jdbc;
    }

    @Override
    public boolean isLazyInit() {
        if (this.configuration != null && this.configuration.getLazyInit() != null) {
            return this.configuration.getLazyInit();
        }
        return this.lazyInit != null && this.lazyInit != false;
    }

    public void setLazyInit(boolean lazyInit) {
        this.lazyInit = lazyInit;
    }

    public SqlProcessorLoader getLoader() {
        return this.processorLoader;
    }

    public SqlValidatorFactory getValidatorFactory() {
        return this.validatorFactory;
    }

    public void setValidatorFactory(SqlValidatorFactory validatorFactory) {
        this.validatorFactory = validatorFactory;
    }

    @Override
    public Collection<String> getNames() {
        return this.getLoader().getEngines().keySet();
    }

    @Override
    public Collection<String> getDynamicNames() {
        return this.getLoader().getDynamicEngines().keySet();
    }

    @Override
    public Map<String, SqlEngine> getEngines() {
        return this.getLoader().getEngines();
    }

    @Override
    public Map<String, SqlEngine> getDynamicEngines() {
        return this.getLoader().getDynamicEngines();
    }

    @Override
    public SqlEngineConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(SqlEngineConfiguration configuration) {
        this.configuration = configuration;
    }
}

