/*
 * Decompiled with CFR 0.152.
 */
package org.sqlproc.engine.plugin;

import java.util.Collection;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sqlproc.engine.SqlRuntimeContext;
import org.sqlproc.engine.plugin.IsEmptyPlugin;
import org.sqlproc.engine.plugin.IsTruePlugin;
import org.sqlproc.engine.plugin.SqlCountPlugin;
import org.sqlproc.engine.plugin.SqlExecutionPlugin;
import org.sqlproc.engine.plugin.SqlFromToPlugin;
import org.sqlproc.engine.plugin.SqlIdentityPlugin;
import org.sqlproc.engine.plugin.SqlSequencePlugin;
import org.sqlproc.engine.type.SqlMetaType;

public class DefaultSqlPlugins
implements IsEmptyPlugin,
IsTruePlugin,
SqlCountPlugin,
SqlFromToPlugin,
SqlSequencePlugin,
SqlIdentityPlugin,
SqlExecutionPlugin {
    final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected static final String METHOD_IS_NULL = "isNull";
    protected static final String METHOD_IS_DEF = "isDef";
    boolean debug = false;

    @Override
    public boolean isNotEmpty(SqlRuntimeContext runtimeCtx, String attributeName, Object obj, Object parentObj, SqlMetaType sqlMetaType, String inOutModifier, boolean inSqlSetOrInsert, Map<String, String> values) throws IllegalArgumentException {
        Boolean delegatedResult;
        if (this.logger.isTraceEnabled()) {
            this.logger.trace(">>> isNotEmpty attributeName=" + attributeName + ", obj=" + obj + ", parentObj=" + parentObj + ", inSqlSetOrInsert=" + inSqlSetOrInsert);
        }
        if ((delegatedResult = this.callMethod(runtimeCtx, attributeName, parentObj, values)) != null) {
            return delegatedResult;
        }
        String value = inOutModifier != null ? inOutModifier.toLowerCase() : null;
        boolean result = this.isNotEmptyInternal(runtimeCtx, attributeName, obj, parentObj, sqlMetaType, value, inSqlSetOrInsert, values);
        if (result) {
            return result;
        }
        if ("notempty".equalsIgnoreCase(value)) {
            throw new IllegalArgumentException("notempty");
        }
        return result;
    }

    protected boolean isNotEmptyInternal(SqlRuntimeContext runtimeCtx, String attributeName, Object obj, Object parentObj, SqlMetaType sqlMetaType, String inOutModifier, boolean inSqlSetOrInsert, Map<String, String> values) throws IllegalArgumentException {
        if ("notnull".equalsIgnoreCase(inOutModifier) && obj == null) {
            throw new IllegalArgumentException("notnull");
        }
        if (inSqlSetOrInsert) {
            Object o;
            boolean isEmptyUseMethodIsNull = false;
            if (obj == null && attributeName != null && parentObj != null && (o = runtimeCtx.getRawFeature("EMPTY_USE_METHOD_IS_NULL")) != null && o instanceof Boolean && ((Boolean)o).booleanValue()) {
                isEmptyUseMethodIsNull = true;
            }
            Object isNullObj = null;
            if (isEmptyUseMethodIsNull) {
                Object object = isNullObj = runtimeCtx.checkMethod(parentObj.getClass(), METHOD_IS_NULL, String.class) ? runtimeCtx.invokeMethod(parentObj, METHOD_IS_NULL, attributeName) : null;
            }
            if (isNullObj != null && isNullObj instanceof Boolean && ((Boolean)isNullObj).booleanValue()) {
                return true;
            }
            boolean isEmptyForNull = isEmptyUseMethodIsNull;
            if (this.isEmpty(obj, values)) {
                Object o2 = runtimeCtx.getRawFeature("EMPTY_FOR_NULL");
                if (o2 != null && o2 instanceof Boolean && ((Boolean)o2).booleanValue()) {
                    isEmptyForNull = true;
                }
                if (!isEmptyForNull) {
                    return true;
                }
            }
        }
        if ("any".equalsIgnoreCase(inOutModifier)) {
            return true;
        }
        if ("null".equalsIgnoreCase(inOutModifier)) {
            return obj == null;
        }
        return !this.isEmpty(obj, values);
    }

    protected boolean isEmpty(Object obj, Map<String, String> values) {
        if (obj == null) {
            return true;
        }
        if (obj instanceof Collection) {
            if (((Collection)obj).isEmpty()) {
                return !values.containsKey("anyset");
            }
        } else if (obj.toString().length() <= 0) {
            return true;
        }
        return false;
    }

    @Override
    public boolean isTrue(SqlRuntimeContext runtimeCtx, String attributeName, Object obj, Object parentObj, SqlMetaType sqlMetaType, String inOutModifier, Map<String, String> values) {
        Boolean delegatedResult = this.callMethod(runtimeCtx, attributeName, parentObj, values);
        if (delegatedResult != null) {
            return delegatedResult;
        }
        if (inOutModifier == null) {
            if (obj != null) {
                if (obj instanceof Boolean) {
                    return (Boolean)obj;
                }
                if (obj instanceof String) {
                    String str = ((String)obj).trim();
                    return str.length() > 0 && !str.equalsIgnoreCase("false");
                }
                if (obj instanceof Number) {
                    return ((Number)obj).longValue() > 0L;
                }
                if (obj.getClass().isEnum()) {
                    return true;
                }
                return true;
            }
            return false;
        }
        if (obj == null) {
            return inOutModifier.toLowerCase().equalsIgnoreCase("null");
        }
        if (obj.getClass().isEnum()) {
            if (obj.toString().equals(inOutModifier)) {
                return true;
            }
            if (sqlMetaType == runtimeCtx.getTypeFactory().getEnumStringType()) {
                return inOutModifier.equals(runtimeCtx.getEnumToValue(obj));
            }
            if (sqlMetaType == runtimeCtx.getTypeFactory().getEnumIntegerType()) {
                return inOutModifier.equals(runtimeCtx.getEnumToValue(obj).toString());
            }
            Object enumVal = runtimeCtx.getEnumToValue(obj);
            return enumVal.toString().equals(inOutModifier);
        }
        return obj.toString().equals(inOutModifier);
    }

    @Override
    public String sqlCount(String name, StringBuilder sql) {
        char c;
        int l;
        if (this.debug) {
            System.out.println("sql " + sql);
        }
        String s = sql.toString().toUpperCase();
        int start = s.indexOf("ID");
        int end = s.indexOf("FROM");
        if (this.debug) {
            System.out.println("start " + start);
        }
        if (this.debug) {
            System.out.println("end " + end);
        }
        StringBuilder sb = sql;
        if (start < 0 || end < 0 || start > end) {
            return "select count(*) as vysledek from (" + sb.toString() + ") derived";
        }
        for (l = start + 2; l < end && ((c = s.charAt(l)) == '_' || c >= 'A' && c <= 'Z'); ++l) {
        }
        if (this.debug) {
            System.out.println("l " + l);
        }
        String s1 = sb.substring(0, l);
        String s2 = sb.substring(end);
        if (this.debug) {
            System.out.println("s1 " + s1);
        }
        if (this.debug) {
            System.out.println("s2 " + s2);
        }
        start = s1.toUpperCase().indexOf("SELECT");
        if (this.debug) {
            System.out.println("start " + start);
        }
        if (start < 0) {
            return "select count(*) as vysledek from (" + sb.toString() + ") derived";
        }
        int n = end = s1.indexOf(",") < 0 ? start + 6 : s1.indexOf(",") + 1;
        if (this.debug) {
            System.out.println("end " + end);
        }
        String s11 = s1.substring(0, start);
        String s12 = s1.substring(end);
        if (this.debug) {
            System.out.println("s11 " + s11);
        }
        if (this.debug) {
            System.out.println("s12 " + s12);
        }
        String result = s11 + "select count(distinct" + s12 + ") as vysledek " + s2;
        if (this.debug) {
            System.out.println("result " + result);
        }
        return result;
    }

    @Override
    public SqlFromToPlugin.LimitType limitQuery(SqlRuntimeContext runtimeCtx, String queryString, StringBuilder queryResult, Integer firstResult, Integer maxResults, boolean ordered) {
        String limitPattern;
        SqlFromToPlugin.LimitType limitType = new SqlFromToPlugin.LimitType();
        if (maxResults == null || maxResults <= 0) {
            return null;
        }
        if (firstResult != null && firstResult > 0) {
            String limitPattern2;
            limitType.alsoFirst = true;
            String string = limitPattern2 = ordered ? runtimeCtx.getFeature("LIMIT_FROM_TO_ORDERED") : runtimeCtx.getFeature("LIMIT_FROM_TO");
            if (limitPattern2 == null && ordered) {
                limitPattern2 = runtimeCtx.getFeature("LIMIT_FROM_TO");
            }
            limitType = this.limitQuery(limitPattern2, limitType, queryString, queryResult, firstResult, maxResults);
            return limitType;
        }
        String string = limitPattern = ordered ? runtimeCtx.getFeature("LIMIT_TO_ORDERED") : runtimeCtx.getFeature("LIMIT_TO");
        if (limitPattern == null && ordered) {
            limitPattern = runtimeCtx.getFeature("LIMIT_TO");
        }
        limitType = this.limitQuery(limitPattern, limitType, queryString, queryResult, firstResult, maxResults);
        return limitType;
    }

    private Boolean callMethod(SqlRuntimeContext runtimeCtx, String attributeName, Object parentObj, Map<String, String> values) {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace(">>> callMethod attributeName=" + attributeName + ", parentObj=" + parentObj + ", values=" + values);
        }
        if (attributeName == null || parentObj == null || values == null) {
            return null;
        }
        String methodName = values.get("call");
        if (methodName == null) {
            return null;
        }
        Object result = null;
        if (methodName.equals(METHOD_IS_DEF)) {
            if (runtimeCtx.checkMethod(parentObj.getClass(), methodName, String.class)) {
                result = runtimeCtx.invokeMethod(parentObj, methodName, attributeName);
            } else if (runtimeCtx.checkMethod(parentObj.getClass(), methodName, String.class, Boolean.class)) {
                Boolean isAttributeNotNull = runtimeCtx.checkAttribute(parentObj, attributeName) ? Boolean.valueOf(runtimeCtx.getAttribute(parentObj, attributeName) != null) : null;
                result = runtimeCtx.invokeMethod(parentObj, methodName, attributeName, isAttributeNotNull);
            }
        } else {
            Object object = result = runtimeCtx.checkMethod(parentObj.getClass(), methodName, String.class) ? runtimeCtx.invokeMethod(parentObj, methodName, attributeName) : null;
        }
        if (result == null || !(result instanceof Boolean)) {
            return null;
        }
        return (Boolean)result;
    }

    private SqlFromToPlugin.LimitType limitQuery(String limitPattern, SqlFromToPlugin.LimitType limitType, String queryString, StringBuilder queryResult, Integer firstResult, Integer maxResults) {
        if (limitPattern == null) {
            return null;
        }
        int ix = limitPattern.indexOf("$S");
        if (ix >= 0) {
            limitType.afterSql = limitPattern.indexOf("$", ix + 1) > 0;
            queryResult.append(limitPattern.substring(0, ix));
            queryResult.append(queryString);
            queryResult.append(limitPattern.substring(ix + 2));
        } else {
            ix = limitPattern.indexOf("$s");
            if (ix >= 0) {
                limitType.afterSql = limitPattern.indexOf("$", ix + 1) > 0;
                int ix2 = queryString.toLowerCase().indexOf("select");
                if (ix2 < 0) {
                    return null;
                }
                queryResult.append(limitPattern.substring(0, ix));
                queryResult.append(queryString.substring(ix2 + 6));
                queryResult.append(limitPattern.substring(ix + 2));
            } else {
                return null;
            }
        }
        if (limitType.alsoFirst) {
            ix = queryResult.indexOf("$F");
            if (ix >= 0) {
                if (queryResult.indexOf("$m", ix) < 0 && queryResult.indexOf("$M", ix) < 0) {
                    limitType.maxBeforeFirst = true;
                }
                queryResult.replace(ix, ix + 2, "?");
            } else {
                ix = queryResult.indexOf("$f");
                if (ix >= 0) {
                    limitType.zeroBasedFirst = true;
                    if (queryResult.indexOf("$m", ix) < 0 && queryResult.indexOf("$M", ix) < 0) {
                        limitType.maxBeforeFirst = true;
                    }
                    queryResult.replace(ix, ix + 2, "?");
                } else {
                    return null;
                }
            }
        }
        if ((ix = queryResult.indexOf("$M")) >= 0) {
            queryResult.replace(ix, ix + 2, "?");
        } else {
            ix = queryResult.indexOf("$m");
            if (ix >= 0) {
                limitType.rowidBasedMax = true;
                queryResult.replace(ix, ix + 2, "?");
            } else {
                return null;
            }
        }
        return limitType;
    }

    @Override
    public String identitySelect(SqlRuntimeContext runtimeCtx, String identitySelectName, Class<?> inputValueType) {
        String identityName = "idsel".equals(identitySelectName) ? "IDSEL" : identitySelectName;
        String identitySelect = null;
        if (inputValueType != null) {
            identitySelect = runtimeCtx.getFeature(identityName + "_" + inputValueType.getSimpleName());
        }
        if (identitySelect != null) {
            return identitySelect;
        }
        if (inputValueType != null) {
            identitySelect = runtimeCtx.getFeature("IDSEL_" + identityName + "_" + inputValueType.getSimpleName());
        }
        if (identitySelect != null) {
            return identitySelect;
        }
        identitySelect = runtimeCtx.getFeature(identityName);
        if (identitySelect != null) {
            return identitySelect;
        }
        return runtimeCtx.getFeature("IDSEL_" + identityName);
    }

    @Override
    public String sequenceSelect(SqlRuntimeContext runtimeCtx, String sequenceName) {
        String sequence = runtimeCtx.getFeature(sequenceName);
        if (sequence == null) {
            sequence = runtimeCtx.getFeature("SEQ_" + sequenceName);
        }
        if (sequence == null) {
            sequence = runtimeCtx.getFeature("SEQ");
        }
        if (sequence == null) {
            return null;
        }
        int ix = sequence.indexOf("$n");
        if (ix < 0) {
            return sequence;
        }
        if ("seq".equals(sequenceName)) {
            return sequence.substring(0, ix) + "SQLPROC_SEQUENCE" + sequence.substring(ix + 2);
        }
        return sequence.substring(0, ix) + sequenceName + sequence.substring(ix + 2);
    }

    @Override
    public String beforeSqlExecution(String name, String queryString) {
        if (queryString == null) {
            return null;
        }
        return queryString.trim();
    }
}

