/*
 * Decompiled with CFR 0.152.
 */
package org.sqlproc.engine.config.store;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import org.sqlproc.engine.config.SqlEngineConfiguration;

@XmlRootElement(name="sqlp-configuration")
public class XmlEngineConfiguration {
    private List<EngineUsage> queryEngines = new ArrayList<EngineUsage>();
    private List<EngineUsage> crudEngines = new ArrayList<EngineUsage>();
    private List<EngineUsage> procedureEngines = new ArrayList<EngineUsage>();
    private List<EngineSql> dynamicQueryEngines = new ArrayList<EngineSql>();
    private List<EngineSql> dynamicCrudEngines = new ArrayList<EngineSql>();
    private List<EngineSql> dynamicProcedureEngines = new ArrayList<EngineSql>();
    private Boolean lazyInit;
    private Integer asyncInitThreads;
    private Integer initTreshold;
    private Boolean initInUsageOrder;
    private Boolean initClearUsage;
    private Boolean useProcessingCache;
    private List<String> doProcessingCacheEngines = new ArrayList<String>();
    private List<String> dontProcessingCacheEngines = new ArrayList<String>();

    public XmlEngineConfiguration() {
    }

    public XmlEngineConfiguration(SqlEngineConfiguration config) {
        this.copyEng(config.getQueryEngines(), this.queryEngines);
        this.copyEng(config.getCrudEngines(), this.crudEngines);
        this.copyEng(config.getProcedureEngines(), this.procedureEngines);
        this.copyDyn(config.getDynamicQueryEngines(), this.dynamicQueryEngines);
        this.copyDyn(config.getDynamicCrudEngines(), this.dynamicCrudEngines);
        this.copyDyn(config.getDynamicProcedureEngines(), this.dynamicProcedureEngines);
        this.lazyInit = config.getLazyInit();
        this.asyncInitThreads = config.getAsyncInitThreads();
        this.initTreshold = config.getInitTreshold();
        this.initInUsageOrder = config.getInitInUsageOrder();
        this.initClearUsage = config.getInitClearUsage();
        this.useProcessingCache = config.getUseProcessingCache();
        this.doProcessingCacheEngines.addAll(config.getDoProcessingCacheEngines());
        this.dontProcessingCacheEngines.addAll(config.getDontProcessingCacheEngines());
    }

    public void toConfig(SqlEngineConfiguration config) {
        config.setQueryEngines(this.copyEng(this.queryEngines));
        config.setCrudEngines(this.copyEng(this.crudEngines));
        config.setProcedureEngines(this.copyEng(this.procedureEngines));
        config.setDynamicQueryEngines(this.copyDyn(this.dynamicQueryEngines));
        config.setDynamicCrudEngines(this.copyDyn(this.dynamicCrudEngines));
        config.setDynamicProcedureEngines(this.copyDyn(this.dynamicProcedureEngines));
        config.setLazyInit(this.getLazyInit());
        config.setAsyncInitThreads(this.getAsyncInitThreads());
        config.setInitTreshold(this.getInitTreshold());
        config.setInitInUsageOrder(this.getInitInUsageOrder());
        config.setInitClearUsage(this.getInitClearUsage());
        config.setUseProcessingCache(this.getUseProcessingCache());
        config.setDoProcessingCacheEngines(new HashSet<String>());
        config.getDoProcessingCacheEngines().addAll(this.doProcessingCacheEngines);
        config.setDontProcessingCacheEngines(new HashSet<String>());
        config.getDontProcessingCacheEngines().addAll(this.dontProcessingCacheEngines);
    }

    @XmlElementWrapper(name="queries")
    public List<EngineUsage> getQueryEngines() {
        return this.queryEngines;
    }

    public void setQueryEngines(List<EngineUsage> queryEngines) {
        this.queryEngines = queryEngines;
    }

    @XmlElementWrapper(name="cruds")
    public List<EngineUsage> getCrudEngines() {
        return this.crudEngines;
    }

    public void setCrudEngines(List<EngineUsage> crudEngines) {
        this.crudEngines = crudEngines;
    }

    @XmlElementWrapper(name="procedures")
    public List<EngineUsage> getProcedureEngines() {
        return this.procedureEngines;
    }

    public void setProcedureEngines(List<EngineUsage> procedureEngines) {
        this.procedureEngines = procedureEngines;
    }

    @XmlElementWrapper(name="dynamicQueries")
    public List<EngineSql> getDynamicQueryEngines() {
        return this.dynamicQueryEngines;
    }

    public void setDynamicQueryEngines(List<EngineSql> dynamicQueryEngines) {
        this.dynamicQueryEngines = dynamicQueryEngines;
    }

    @XmlElementWrapper(name="dynamicCruds")
    public List<EngineSql> getDynamicCrudEngines() {
        return this.dynamicCrudEngines;
    }

    public void setDynamicCrudEngines(List<EngineSql> dynamicCrudEngines) {
        this.dynamicCrudEngines = dynamicCrudEngines;
    }

    @XmlElementWrapper(name="dynamicProcedures")
    public List<EngineSql> getDynamicProcedureEngines() {
        return this.dynamicProcedureEngines;
    }

    public void setDynamicProcedureEngines(List<EngineSql> dynamicProcedureEngines) {
        this.dynamicProcedureEngines = dynamicProcedureEngines;
    }

    @XmlElement
    public Boolean getLazyInit() {
        return this.lazyInit;
    }

    public void setLazyInit(Boolean lazyInit) {
        this.lazyInit = lazyInit;
    }

    @XmlElement
    public Integer getAsyncInitThreads() {
        return this.asyncInitThreads;
    }

    public void setAsyncInitThreads(Integer asyncInitThreads) {
        this.asyncInitThreads = asyncInitThreads;
    }

    @XmlElement
    public Integer getInitTreshold() {
        return this.initTreshold;
    }

    public void setInitTreshold(Integer initTreshold) {
        this.initTreshold = initTreshold;
    }

    @XmlElement
    public Boolean getInitInUsageOrder() {
        return this.initInUsageOrder;
    }

    public void setInitInUsageOrder(Boolean initInUsageOrder) {
        this.initInUsageOrder = initInUsageOrder;
    }

    @XmlElement
    public Boolean getInitClearUsage() {
        return this.initClearUsage;
    }

    public void setInitClearUsage(Boolean initClearUsage) {
        this.initClearUsage = initClearUsage;
    }

    @XmlElement
    public Boolean getUseProcessingCache() {
        return this.useProcessingCache;
    }

    public void setUseProcessingCache(Boolean useProcessingCache) {
        this.useProcessingCache = useProcessingCache;
    }

    @XmlElementWrapper(name="doProcessingCache")
    public List<String> getDoProcessingCacheEngines() {
        return this.doProcessingCacheEngines;
    }

    public void setDoProcessingCacheEngines(List<String> doProcessingCacheEngines) {
        this.doProcessingCacheEngines = doProcessingCacheEngines;
    }

    @XmlElementWrapper(name="dontProcessingCache")
    public List<String> getDontProcessingCacheEngines() {
        return this.dontProcessingCacheEngines;
    }

    public void setDontProcessingCacheEngines(List<String> dontProcessingCacheEngines) {
        this.dontProcessingCacheEngines = dontProcessingCacheEngines;
    }

    public String toString() {
        return "XmlEngineConfiguration [queryEngines=" + this.queryEngines + ", crudEngines=" + this.crudEngines + ", procedureEngines=" + this.procedureEngines + ", dynamicQueryEngines=" + this.dynamicQueryEngines + ", dynamicCrudEngines=" + this.dynamicCrudEngines + ", dynamicProcedureEngines=" + this.dynamicProcedureEngines + ", lazyInit=" + this.lazyInit + ", asyncInitThreads=" + this.asyncInitThreads + ", initTreshold=" + this.initTreshold + ", initInUsageOrder=" + this.initInUsageOrder + ", initClearUsage=" + this.initClearUsage + ", useProcessingCache=" + this.useProcessingCache + ", doProcessingCacheEngines=" + this.doProcessingCacheEngines + ", dontProcessingCacheEngines=" + this.dontProcessingCacheEngines + "]";
    }

    private void copyEng(ConcurrentHashMap<String, AtomicInteger> from, List<EngineUsage> to) {
        for (Map.Entry<String, AtomicInteger> e : from.entrySet()) {
            to.add(new EngineUsage(e.getKey(), e.getValue()));
        }
    }

    private void copyDyn(ConcurrentHashMap<String, String> from, List<EngineSql> to) {
        for (Map.Entry<String, String> e : from.entrySet()) {
            to.add(new EngineSql(e.getKey(), e.getValue()));
        }
    }

    private ConcurrentHashMap<String, AtomicInteger> copyEng(List<EngineUsage> from) {
        ConcurrentHashMap<String, AtomicInteger> engines = new ConcurrentHashMap<String, AtomicInteger>();
        if (from == null) {
            return engines;
        }
        for (EngineUsage e : from) {
            engines.put(e.getName(), new AtomicInteger(e.getUsage()));
        }
        return engines;
    }

    private ConcurrentHashMap<String, String> copyDyn(List<EngineSql> from) {
        ConcurrentHashMap<String, String> engines = new ConcurrentHashMap<String, String>();
        if (from == null) {
            return engines;
        }
        for (EngineSql e : from) {
            engines.put(e.getName(), e.getSql());
        }
        return engines;
    }

    @XmlRootElement(name="sql")
    public static class EngineSql {
        private String name;
        private String sql;

        public EngineSql() {
        }

        public EngineSql(String name, String sql) {
            this.name = name;
            this.sql = sql;
        }

        @XmlElement
        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        @XmlAttribute
        public String getSql() {
            return this.sql;
        }

        public void setSql(String sql) {
            this.sql = sql;
        }

        public String toString() {
            return "EngineSql [name=" + this.name + ", sql=" + this.sql + "]";
        }
    }

    @XmlRootElement(name="usage")
    public static class EngineUsage {
        private String name;
        private int usage;

        public EngineUsage() {
        }

        public EngineUsage(String name, AtomicInteger usage) {
            this.name = name;
            this.usage = usage.get();
        }

        @XmlElement
        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        @XmlAttribute
        public int getUsage() {
            return this.usage;
        }

        public void setUsage(int usage) {
            this.usage = usage;
        }

        public String toString() {
            return "EngineUsage [name=" + this.name + ", usage=" + this.usage + "]";
        }
    }
}

