/*
 * Decompiled with CFR 0.152.
 */
package org.sqlproc.engine.jdbc.type;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.sqlproc.engine.jdbc.type.JdbcSqlType;
import org.sqlproc.engine.type.SqlStringType;

public class JdbcStringType
extends SqlStringType
implements JdbcSqlType {
    @Override
    public Class<?>[] getClassTypes() {
        return new Class[]{String.class};
    }

    @Override
    public Object getProviderSqlType() {
        return this;
    }

    @Override
    public Integer getDatabaseSqlType() {
        return 12;
    }

    @Override
    public Object get(ResultSet rs, String columnLabel) throws SQLException {
        if (Character.isDigit(columnLabel.charAt(0))) {
            return rs.getString(Integer.parseInt(columnLabel));
        }
        return rs.getString(columnLabel);
    }

    @Override
    public void set(PreparedStatement st, int index, Object value) throws SQLException {
        st.setString(index, (String)value);
    }

    @Override
    public Object get(CallableStatement cs, int index) throws SQLException {
        String result = cs.getString(index);
        if (cs.wasNull()) {
            return null;
        }
        return result;
    }
}

