/*
 * Decompiled with CFR 0.152.
 */
package org.utplsql.api;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.utplsql.api.FileMapperOptions;
import org.utplsql.api.TestRunnerOptions;
import org.utplsql.api.Version;
import org.utplsql.api.compatibility.CompatibilityProxy;
import org.utplsql.api.db.DatabaseInformation;
import org.utplsql.api.db.DefaultDatabaseInformation;
import org.utplsql.api.exception.OracleCreateStatmenetStuckException;
import org.utplsql.api.exception.SomeTestsFailedException;
import org.utplsql.api.exception.UtPLSQLNotInstalledException;
import org.utplsql.api.reporter.DocumentationReporter;
import org.utplsql.api.reporter.Reporter;
import org.utplsql.api.reporter.ReporterFactory;
import org.utplsql.api.testRunner.TestRunnerStatement;

public class TestRunner {
    private static final Logger logger = LoggerFactory.getLogger(TestRunner.class);
    private final TestRunnerOptions options = new TestRunnerOptions();
    private final List<String> reporterNames = new ArrayList<String>();
    private CompatibilityProxy compatibilityProxy;
    private ReporterFactory reporterFactory;

    public TestRunner addPath(String path) {
        this.options.pathList.add(path);
        return this;
    }

    public TestRunner addPathList(List<String> paths) {
        this.options.pathList.addAll(paths);
        return this;
    }

    public TestRunner addReporter(Reporter reporter) {
        this.options.reporterList.add(reporter);
        return this;
    }

    public TestRunner addReporter(String reporterName) {
        if (this.reporterFactory != null) {
            this.options.reporterList.add(this.reporterFactory.createReporter(reporterName));
        } else {
            this.reporterNames.add(reporterName);
        }
        return this;
    }

    public TestRunner colorConsole(boolean colorConsole) {
        this.options.colorConsole = colorConsole;
        return this;
    }

    public TestRunner addReporterList(List<Reporter> reporterList) {
        this.options.reporterList.addAll(reporterList);
        return this;
    }

    public TestRunner addCoverageScheme(String coverageScheme) {
        this.options.coverageSchemes.add(coverageScheme);
        return this;
    }

    public TestRunner addCoverageSchemes(Collection<String> schemaNames) {
        this.options.coverageSchemes.addAll(schemaNames);
        return this;
    }

    public TestRunner includeObject(String obj) {
        this.options.includeObjects.add(obj);
        return this;
    }

    public TestRunner excludeObject(String obj) {
        this.options.excludeObjects.add(obj);
        return this;
    }

    public TestRunner includeObjects(List<String> obj) {
        this.options.includeObjects.addAll(obj);
        return this;
    }

    public TestRunner excludeObjects(List<String> obj) {
        this.options.excludeObjects.addAll(obj);
        return this;
    }

    public TestRunner includeSchemaExpr(String expr) {
        this.options.includeSchemaExpr = expr;
        return this;
    }

    public TestRunner excludeSchemaExpr(String expr) {
        this.options.excludeSchemaExpr = expr;
        return this;
    }

    public TestRunner includeObjectExpr(String expr) {
        this.options.includeObjectExpr = expr;
        return this;
    }

    public TestRunner excludeObjectExpr(String expr) {
        this.options.excludeObjectExpr = expr;
        return this;
    }

    public TestRunner sourceMappingOptions(FileMapperOptions mapperOptions) {
        this.options.sourceMappingOptions = mapperOptions;
        return this;
    }

    public TestRunner testMappingOptions(FileMapperOptions mapperOptions) {
        this.options.testMappingOptions = mapperOptions;
        return this;
    }

    public TestRunner failOnErrors(boolean failOnErrors) {
        this.options.failOnErrors = failOnErrors;
        return this;
    }

    public TestRunner skipCompatibilityCheck(boolean skipCompatibilityCheck) {
        this.options.skipCompatibilityCheck = skipCompatibilityCheck;
        return this;
    }

    public TestRunner setReporterFactory(ReporterFactory reporterFactory) {
        this.reporterFactory = reporterFactory;
        return this;
    }

    public TestRunner randomTestOrder(boolean randomTestOrder) {
        this.options.randomTestOrder = randomTestOrder;
        return this;
    }

    public TestRunner randomTestOrderSeed(Integer seed) {
        this.options.randomTestOrderSeed = seed;
        if (seed != null) {
            this.options.randomTestOrder = true;
        }
        return this;
    }

    public TestRunner addTag(String tag) {
        this.options.tags.add(tag);
        return this;
    }

    public TestRunner addTags(Collection<String> tags) {
        this.options.tags.addAll(tags);
        return this;
    }

    public TestRunner oraStuckTimeout(Integer oraStuckTimeout) {
        this.options.oraStuckTimeout = oraStuckTimeout;
        return this;
    }

    public TestRunnerOptions getOptions() {
        return this.options;
    }

    private void delayedAddReporters() {
        if (this.reporterFactory == null) {
            throw new IllegalStateException("ReporterFactory must be set to add delayed Reporters!");
        }
        this.reporterNames.forEach(this::addReporter);
    }

    private void handleException(Throwable e) throws SQLException {
        if (e instanceof UtPLSQLNotInstalledException) {
            throw (UtPLSQLNotInstalledException)e;
        }
        if (e instanceof SomeTestsFailedException) {
            throw (SomeTestsFailedException)e;
        }
        if (e instanceof OracleCreateStatmenetStuckException) {
            throw (OracleCreateStatmenetStuckException)e;
        }
        if (e instanceof SQLException) {
            SQLException sqlException = (SQLException)e;
            if (sqlException.getErrorCode() == 20213) {
                throw new SomeTestsFailedException(sqlException.getMessage(), e);
            }
            if (((SQLException)e).getErrorCode() == 904) {
                throw new UtPLSQLNotInstalledException(sqlException);
            }
            throw sqlException;
        }
        throw new SQLException("Unknown exception, wrapping: " + e.getMessage(), e);
    }

    public void run(Connection conn) throws SQLException {
        logger.info("TestRunner initialized");
        DefaultDatabaseInformation databaseInformation = new DefaultDatabaseInformation();
        this.compatibilityProxy = this.options.skipCompatibilityCheck ? new CompatibilityProxy(conn, Version.LATEST, (DatabaseInformation)databaseInformation) : new CompatibilityProxy(conn, databaseInformation);
        logger.info("Running on utPLSQL {}", (Object)this.compatibilityProxy.getVersionDescription());
        if (this.reporterFactory == null) {
            this.reporterFactory = ReporterFactory.createDefault(this.compatibilityProxy);
        }
        this.delayedAddReporters();
        this.compatibilityProxy.failOnNotCompatible();
        logger.info("Initializing reporters");
        for (Reporter r : this.options.reporterList) {
            this.validateReporter(conn, r);
        }
        if (this.options.pathList.isEmpty()) {
            this.options.pathList.add(databaseInformation.getCurrentSchema(conn));
        }
        if (this.options.reporterList.isEmpty()) {
            logger.info("No reporter given so choosing ut_documentation_reporter");
            this.options.reporterList.add(new DocumentationReporter().init(conn));
        }
        TestRunnerStatement testRunnerStatement = null;
        try {
            testRunnerStatement = this.options.oraStuckTimeout > 0 ? this.initStatementWithTimeout(conn, this.options.oraStuckTimeout) : this.initStatement(conn);
            logger.info("Running tests");
            testRunnerStatement.execute();
            logger.info("Running tests finished.");
            testRunnerStatement.close();
        }
        catch (OracleCreateStatmenetStuckException e) {
            throw e;
        }
        catch (SQLException e) {
            if (testRunnerStatement != null) {
                testRunnerStatement.close();
            }
            this.handleException(e);
        }
    }

    private TestRunnerStatement initStatement(Connection conn) throws SQLException {
        return this.compatibilityProxy.getTestRunnerStatement(this.options, conn);
    }

    private TestRunnerStatement initStatementWithTimeout(Connection conn, int timeout) throws SQLException {
        ExecutorService executor = Executors.newSingleThreadExecutor();
        Callable<TestRunnerStatement> callable = () -> this.compatibilityProxy.getTestRunnerStatement(this.options, conn);
        Future<TestRunnerStatement> future = executor.submit(callable);
        TestRunnerStatement testRunnerStatement = null;
        try {
            testRunnerStatement = future.get(timeout, TimeUnit.SECONDS);
        }
        catch (TimeoutException e) {
            logger.error("Detected Oracle driver stuck during Statement initialization");
            executor.shutdownNow();
            throw new OracleCreateStatmenetStuckException(e);
        }
        catch (InterruptedException e) {
            this.handleException(e);
        }
        catch (ExecutionException e) {
            this.handleException(e.getCause());
        }
        return testRunnerStatement;
    }

    private void validateReporter(Connection conn, Reporter reporter) throws SQLException {
        if (!reporter.isInit() || reporter.getId() == null || reporter.getId().isEmpty()) {
            reporter.init(conn, this.compatibilityProxy, this.reporterFactory);
        }
    }

    public Version getUsedDatabaseVersion() {
        if (this.compatibilityProxy != null) {
            return this.compatibilityProxy.getUtPlsqlVersion();
        }
        return null;
    }
}

