/*
 * Decompiled with CFR 0.152.
 */
package org.utplsql.api.outputBuffer;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.SQLException;
import oracle.jdbc.OracleConnection;
import org.utplsql.api.Version;
import org.utplsql.api.exception.InvalidVersionException;
import org.utplsql.api.outputBuffer.CompatibilityOutputBufferPre310;
import org.utplsql.api.outputBuffer.DefaultOutputBuffer;
import org.utplsql.api.outputBuffer.NonOutputBuffer;
import org.utplsql.api.outputBuffer.OutputBuffer;
import org.utplsql.api.reporter.Reporter;

public class OutputBufferProvider {
    private OutputBufferProvider() {
    }

    public static OutputBuffer getCompatibleOutputBuffer(Version databaseVersion, Reporter reporter, Connection conn) throws SQLException {
        OracleConnection oraConn = conn.unwrap(OracleConnection.class);
        try {
            if (databaseVersion.isGreaterOrEqualThan(Version.V3_1_0)) {
                if (OutputBufferProvider.hasOutput(reporter, oraConn)) {
                    return new DefaultOutputBuffer(reporter);
                }
                return new NonOutputBuffer(reporter);
            }
        }
        catch (InvalidVersionException invalidVersionException) {
            // empty catch block
        }
        return new CompatibilityOutputBufferPre310(reporter);
    }

    private static boolean hasOutput(Reporter reporter, OracleConnection oraConn) throws SQLException {
        String sql = "declare    l_result int;begin    begin        execute immediate '       begin            :x := case ' || dbms_assert.simple_sql_name( ? ) || '() is of (ut_output_reporter_base) when true then 1 else 0 end;       end;'       using out l_result;   end;   ? := l_result;end;";
        try (CallableStatement stmt = oraConn.prepareCall(sql);){
            stmt.setQueryTimeout(3);
            stmt.setString(1, reporter.getTypeName());
            stmt.registerOutParameter(2, 4);
            stmt.execute();
            int result = stmt.getInt(2);
            boolean bl = result == 1;
            return bl;
        }
    }
}

