/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.jqplot.lib.chart;

import org.wicketstuff.jqplot.lib.ChartConfiguration;
import org.wicketstuff.jqplot.lib.JqPlotResources;
import org.wicketstuff.jqplot.lib.chart.AbstractChart;
import org.wicketstuff.jqplot.lib.data.LabeledData;
import org.wicketstuff.jqplot.lib.data.item.LabeledItem;
import org.wicketstuff.jqplot.lib.elements.Title;
import org.wicketstuff.jqplot.lib.metadata.JqPlotPlugin;

@JqPlotPlugin(values={JqPlotResources.DateAxisRenderer, JqPlotResources.CanvasTextRenderer, JqPlotResources.CategoryAxisRenderer, JqPlotResources.DateAxisRenderer, JqPlotResources.CanvasAxisLabelRenderer, JqPlotResources.CanvasAxisTickRenderer})
public class LabeledLineChart<T extends Number>
extends AbstractChart<LabeledData<T>, String> {
    private static final long serialVersionUID = -6833884146696085085L;
    private final ChartConfiguration<String> chartConfig;
    private LabeledData<T> labeledData = new LabeledData();

    public LabeledLineChart() {
        this(null, null, null, 15);
    }

    public LabeledLineChart(String title, String labelX, String labelY) {
        this(title, labelX, labelY, 15);
    }

    public LabeledLineChart(String title, String labelX, String labelY, Integer tickAngle) {
        this.chartConfig = new ChartConfiguration();
        this.chartConfig.setTitle(new Title(title)).setLabelX(labelX).setLabelY(labelY).axesInstance().xAxisInstance().setRenderer(JqPlotResources.DateAxisRenderer).setLabelRenderer(JqPlotResources.CanvasAxisLabelRenderer).tickOptionsInstance().setAngle(tickAngle);
        this.chartConfig.axesInstance().yAxisInstance().setLabelRenderer(JqPlotResources.CanvasAxisLabelRenderer);
    }

    public void addValue(LabeledItem<T> value) {
        this.labeledData.addValue(value);
    }

    public void addValues(LabeledItem<T> ... values) {
        this.labeledData.addValues(values);
    }

    @Override
    public LabeledData<T> getChartData() {
        return this.labeledData;
    }

    @Override
    public ChartConfiguration<String> getChartConfiguration() {
        return this.chartConfig;
    }
}

