/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.jqplot.lib.chart;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.wicketstuff.jqplot.lib.Chart;
import org.wicketstuff.jqplot.lib.ChartConfiguration;
import org.wicketstuff.jqplot.lib.axis.Axis;
import org.wicketstuff.jqplot.lib.axis.XAxis;
import org.wicketstuff.jqplot.lib.axis.YAxis;
import org.wicketstuff.jqplot.lib.data.ChartData;
import org.wicketstuff.jqplot.lib.elements.Axes;
import org.wicketstuff.jqplot.lib.elements.CanvasOverlay;
import org.wicketstuff.jqplot.lib.elements.GridPadding;
import org.wicketstuff.jqplot.lib.elements.Legend;
import org.wicketstuff.jqplot.lib.elements.Serie;
import org.wicketstuff.jqplot.lib.elements.SeriesDefaults;
import org.wicketstuff.jqplot.lib.elements.Title;

public abstract class AbstractChart<T extends ChartData<?>, S extends Serializable>
implements Chart<T> {
    private static final long serialVersionUID = -5744130130488157491L;

    public AbstractChart<T, S> addSeriesColors(String ... colors) {
        this.getChartConfiguration().seriesColorsInstance().addAll(Arrays.asList(colors));
        return this;
    }

    public AbstractChart<T, S> addSeriesColors(Collection<String> colors) {
        this.getChartConfiguration().seriesColorsInstance().addAll(colors);
        return this;
    }

    public AbstractChart<T, S> setSeriesColors(Collection<String> colors) {
        this.getChartConfiguration().setSeriesColors(colors);
        return this;
    }

    public Collection<String> getSeriesColors() {
        return this.getChartConfiguration().seriesColorsInstance();
    }

    public AbstractChart<T, S> addSerie(Serie serie) {
        Collection<Serie> series = this.getSeries();
        if (series == null) {
            series = new ArrayList<Serie>();
        }
        series.add(serie);
        return this;
    }

    public AbstractChart<T, S> addSeries(Serie ... series) {
        Collection<Serie> chartSeries = this.getSeries();
        if (chartSeries == null) {
            chartSeries = new ArrayList<Serie>();
        }
        for (int i = series.length - 1; i >= 0; --i) {
            chartSeries.add(series[i]);
        }
        return this;
    }

    @Override
    public abstract ChartConfiguration<S> getChartConfiguration();

    public AbstractChart<T, S> setSimpleTitle(String title) {
        this.getChartConfiguration().setSimpleTitle(title);
        return this;
    }

    @Deprecated
    public Axes<S> createAxes() {
        return this.getChartConfiguration().createAxes();
    }

    @Deprecated
    public XAxis<S> createXAxis() {
        return this.getChartConfiguration().createXAxis();
    }

    @Deprecated
    public YAxis<S> createYAxis() {
        return this.getChartConfiguration().createYAxis();
    }

    @Deprecated
    public Axis<S> createAxesDefaults() {
        return this.getChartConfiguration().createAxesDefaults();
    }

    public AbstractChart<T, S> setLabelX(String label) {
        this.getChartConfiguration().setLabelX(label);
        return this;
    }

    public AbstractChart<T, S> setLabelY(String label) {
        this.getChartConfiguration().setLabelY(label);
        return this;
    }

    public Collection<Serie> getSeries() {
        return this.getChartConfiguration().seriesInstance();
    }

    public AbstractChart<T, S> setSeries(Collection<Serie> series) {
        this.getChartConfiguration().setSeries(series);
        return this;
    }

    public Title getTitle() {
        return this.getChartConfiguration().getTitle();
    }

    public AbstractChart<T, S> setTitle(Title title) {
        this.getChartConfiguration().setTitle(title);
        return this;
    }

    public Axis<S> getAxesDefaults() {
        return this.getChartConfiguration().axesDefaultsInstance();
    }

    public AbstractChart<T, S> setAxesDefaults(Axis<S> axesDefaults) {
        this.getChartConfiguration().setAxesDefaults(axesDefaults);
        return this;
    }

    public SeriesDefaults getSeriesDefaults() {
        return this.getChartConfiguration().seriesDefaultsInstance();
    }

    public AbstractChart<T, S> setSeriesDefaults(SeriesDefaults seriesDefaults) {
        this.getChartConfiguration().setSeriesDefaults(seriesDefaults);
        return this;
    }

    public AbstractChart<T, S> addIntervalColors(String ... values) {
        this.getChartConfiguration().seriesDefaultsInstance().getRendererOptions().getIntervalColors().addAll(Arrays.asList(values));
        return this;
    }

    public AbstractChart<T, S> addIntervals(Integer ... values) {
        this.getChartConfiguration().seriesDefaultsInstance().getRendererOptions().getIntervals().addAll(Arrays.asList(values));
        return this;
    }

    public AbstractChart<T, S> setStackSeries(Boolean stackSeries) {
        this.getChartConfiguration().setStackSeries(stackSeries);
        return this;
    }

    public AbstractChart<T, S> setCaptureRightClick(Boolean captureRightClick) {
        this.getChartConfiguration().setCaptureRightClick(captureRightClick);
        return this;
    }

    public AbstractChart<T, S> setHighlightMouseDown(Boolean highlightMouseDown) {
        this.getChartConfiguration().seriesDefaultsInstance().rendererOptionsInstance().setHighlightMouseDown(highlightMouseDown);
        return this;
    }

    public AbstractChart<T, S> setBarMargin(Integer margin) {
        this.getChartConfiguration().seriesDefaultsInstance().rendererOptionsInstance().setBarMargin(margin);
        return this;
    }

    public AbstractChart<T, S> setSliceMargin(Integer margin) {
        this.getChartConfiguration().seriesDefaultsInstance().rendererOptionsInstance().setSliceMargin(margin);
        return this;
    }

    public AbstractChart<T, S> setDataLabels(String dataLabels) {
        this.getChartConfiguration().seriesDefaultsInstance().rendererOptionsInstance().setDataLabels(dataLabels);
        return this;
    }

    public AbstractChart<T, S> setLineWidth(Integer width) {
        this.getChartConfiguration().seriesDefaultsInstance().rendererOptionsInstance().setLineWidth(width);
        return this;
    }

    public AbstractChart<T, S> setShowDataLabels(Boolean showDataLabels) {
        this.getChartConfiguration().seriesDefaultsInstance().rendererOptionsInstance().setShowDataLabels(showDataLabels);
        return this;
    }

    public AbstractChart<T, S> setFill(Boolean fill) {
        this.getChartConfiguration().seriesDefaultsInstance().rendererOptionsInstance().setFill(fill);
        return this;
    }

    public AbstractChart<T, S> setBubbleAlpha(Float alpha) {
        this.getChartConfiguration().seriesDefaultsInstance().rendererOptionsInstance().setBubbleAlpha(alpha);
        return this;
    }

    public AbstractChart<T, S> setHighlightAlpha(Float alpha) {
        this.getChartConfiguration().seriesDefaultsInstance().rendererOptionsInstance().setHighlightAlpha(alpha);
        return this;
    }

    public AbstractChart<T, S> setShowLabels(Boolean showLabels) {
        this.getChartConfiguration().seriesDefaultsInstance().rendererOptionsInstance().setShowLables(showLabels);
        return this;
    }

    public AbstractChart<T, S> setShadowAlpha(String alpha) {
        this.getChartConfiguration().seriesDefaultsInstance().setShadowAlpha(alpha);
        return this;
    }

    public AbstractChart<T, S> setFillZero(Boolean fillZero) {
        this.getChartConfiguration().seriesDefaultsInstance().rendererOptionsInstance().setFillZero(fillZero);
        return this;
    }

    public AbstractChart<T, S> setShadow(Boolean shadow) {
        this.getChartConfiguration().getSeriesDefaults().setShadow(shadow);
        return this;
    }

    public AbstractChart<T, S> setLegend(Legend legend) {
        this.getChartConfiguration().setLegend(legend);
        return this;
    }

    public AbstractChart<T, S> setGridPadding(GridPadding gridPadding) {
        this.getChartConfiguration().setGridPadding(gridPadding);
        return this;
    }

    public GridPadding getGridPadding() {
        return this.getChartConfiguration().getGridPadding();
    }

    public Axes<S> getAxes() {
        return this.getChartConfiguration().axesInstance();
    }

    public AbstractChart<T, S> setAxes(Axes<S> axes) {
        this.getChartConfiguration().setAxes(axes);
        return this;
    }

    public XAxis<S> getXAxis() {
        return this.getChartConfiguration().xAxisInstance();
    }

    public YAxis<S> getYAxis() {
        return this.getChartConfiguration().yAxisInstance();
    }

    @Deprecated
    public void setTicks(String ... ticks) {
        this.getChartConfiguration().xAxisInstance().setTicks(ticks);
    }

    @Deprecated
    public void setPadMin(Float padMin) {
        this.getChartConfiguration().yAxisInstance().setPadMin(Float.valueOf(1.05f));
    }

    public CanvasOverlay getCanvasOverlay() {
        return this.getChartConfiguration().canvasOverlayInstance();
    }
}

