/*
 * Decompiled with CFR 0.152.
 */
package org.xlightweb;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xlightweb.ExtentedHttpUtils;
import org.xlightweb.IWebSocketHandler;
import org.xlightweb.WebSocketConnection;
import org.xlightweb.WebSocketHandlerInfo;
import org.xsocket.DataConverter;

final class WebSocketHandlerAdapter {
    private static final Logger LOG = Logger.getLogger(WebSocketHandlerAdapter.class.getName());
    private final IPostConnectInterceptor interceptor;
    private final AtomicBoolean isOnConnectCalled = new AtomicBoolean(false);
    private final AtomicBoolean isOnDisconnectCalled = new AtomicBoolean(false);
    private final WebSocketHandlerInfo handlerInfo;
    private final IWebSocketHandler handler;

    public WebSocketHandlerAdapter(IWebSocketHandler handler, IPostConnectInterceptor interceptor) {
        this.handler = handler;
        this.handlerInfo = ExtentedHttpUtils.getWebSocketHandlerInfo(handler);
        this.interceptor = interceptor;
    }

    public void onConnect(final WebSocketConnection con) {
        if (this.handler != null && !this.isOnConnectCalled.getAndSet(true)) {
            if (this.handlerInfo.isUnsynchronized()) {
                this.performOnConnect(con);
            } else {
                Runnable task = new Runnable(){

                    public void run() {
                        WebSocketHandlerAdapter.this.performOnConnect(con);
                    }
                };
                if (this.handlerInfo.isOnConnectMultithreaded()) {
                    con.processMultithreaded(task);
                } else {
                    con.processNonthreaded(task);
                }
            }
        }
    }

    private void performOnConnect(WebSocketConnection con) {
        try {
            block9: {
                try {
                    this.handler.onConnect(con);
                }
                catch (IOException ioe) {
                    if (this.interceptor != null) {
                        this.interceptor.onConnectException(ioe);
                    }
                }
                catch (Exception e) {
                    if (this.interceptor == null) break block9;
                    this.interceptor.onConnectException(new IOException(e.toString()));
                }
            }
            if (this.interceptor != null) {
                this.interceptor.onPostConnect();
            }
            this.performOnMessage(con);
        }
        catch (IOException ioe) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("[" + con.getId() + "] closing connection because an error has been occured by performing onConnect of " + this.handler + " Reason: " + DataConverter.toString((Throwable)ioe));
            }
            con.closeQuitly();
        }
        catch (Throwable t) {
            LOG.warning("[" + con.getId() + "] closing connection. Error occured by performing onConnect of " + this.handler + " " + t.toString());
            con.closeQuitly();
        }
    }

    public void onDisconnect(final WebSocketConnection con) throws IOException {
        if (this.handler != null && !this.isOnDisconnectCalled.getAndSet(true)) {
            if (this.handlerInfo.isUnsynchronized()) {
                this.performOnConnect(con);
            } else {
                Runnable task = new Runnable(){

                    public void run() {
                        WebSocketHandlerAdapter.this.performOnDisconnect(con);
                    }
                };
                if (this.handlerInfo.isOnDisconnectMultithreaded()) {
                    con.processMultithreaded(task);
                } else {
                    con.processNonthreaded(task);
                }
            }
        }
    }

    private void performOnDisconnect(WebSocketConnection con) {
        try {
            this.handler.onDisconnect(con);
        }
        catch (IOException ioe) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("[" + con.getId() + "] closing connection because an error has been occured by performing onDisconnect of " + this.handler + " Reason: " + DataConverter.toString((Throwable)ioe));
            }
            con.closeQuitly();
        }
        catch (Throwable t) {
            LOG.warning("[" + con.getId() + "] closing connection. Error occured by performing onDisconnect of " + this.handler + " " + t.toString());
            con.closeQuitly();
        }
    }

    public void onMessage(final WebSocketConnection con) throws IOException {
        if (this.handler != null) {
            if (this.handlerInfo.isUnsynchronized()) {
                this.performOnMessage(con);
            } else {
                Runnable task = new Runnable(){

                    public void run() {
                        WebSocketHandlerAdapter.this.performOnMessage(con);
                    }
                };
                if (this.handlerInfo.isOnMessageMultithreaded()) {
                    con.processMultithreaded(task);
                } else {
                    con.processNonthreaded(task);
                }
                con.processNonthreaded(task);
            }
        }
    }

    private void performOnMessage(WebSocketConnection con) {
        try {
            while (con.availableMessages() > 0) {
                int ver = con.getInQueueVersion();
                this.handler.onMessage(con);
                if (ver != con.getInQueueVersion()) continue;
                return;
            }
        }
        catch (IOException ioe) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("[" + con.getId() + "] closing connection because an error has been occured by performing onMessage of " + this.handler + " Reason: " + DataConverter.toString((Throwable)ioe));
            }
            con.closeQuitly();
        }
        catch (Throwable t) {
            LOG.warning("[" + con.getId() + "] closing connection. Error occured by performing onMessage of " + this.handler + " " + t.toString());
            con.closeQuitly();
        }
    }

    static interface IPostConnectInterceptor {
        public void onConnectException(IOException var1);

        public void onPostConnect() throws IOException;
    }
}

