/*
 * Decompiled with CFR 0.152.
 */
package org.xlightweb;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xlightweb.EventDataSource;
import org.xlightweb.ExtentedHttpUtils;
import org.xlightweb.IEventHandler;
import org.xlightweb.IEventHandlerInfo;
import org.xsocket.DataConverter;

final class EventStreamHandlerAdapter {
    private static final Logger LOG = Logger.getLogger(EventStreamHandlerAdapter.class.getName());
    private final AtomicBoolean isOnConnectCalled = new AtomicBoolean(false);
    private final AtomicBoolean isOnDisconnectCalled = new AtomicBoolean(false);
    private final IEventHandlerInfo handlerInfo;
    private final IEventHandler handler;

    public EventStreamHandlerAdapter(IEventHandler handler) {
        this.handler = handler;
        this.handlerInfo = ExtentedHttpUtils.getWebEventHandlerInfo(handler);
    }

    public void onConnect(final EventDataSource ds) throws IOException {
        if (this.handler != null && !this.isOnConnectCalled.getAndSet(true)) {
            if (this.handlerInfo.isUnsynchronized()) {
                this.performOnConnect(ds);
            } else {
                Runnable task = new Runnable(){

                    public void run() {
                        EventStreamHandlerAdapter.this.performOnConnect(ds);
                    }
                };
                if (this.handlerInfo.isOnConnectMultithreaded()) {
                    ds.processMultithreaded(task);
                } else {
                    ds.processNonthreaded(task);
                }
            }
        }
    }

    private void performOnConnect(EventDataSource ds) {
        try {
            this.handler.onConnect(ds);
            this.performOnMessage(ds);
        }
        catch (IOException ioe) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("[" + ds.getId() + "] closing data source because an error has been occured by performing onConnect of " + this.handler + " Reason: " + DataConverter.toString((Throwable)ioe));
            }
            ds.destroy();
        }
        catch (Throwable t) {
            LOG.warning("[" + ds.getId() + "] closing data source. Error occured by performing onConnect of " + this.handler + " " + t.toString());
            ds.closeQuitly();
        }
    }

    public void onDisconnect(final EventDataSource ds) {
        if (this.handler != null && !this.isOnDisconnectCalled.getAndSet(true)) {
            if (this.handlerInfo.isUnsynchronized()) {
                this.performOnDisconnect(ds);
            } else {
                Runnable task = new Runnable(){

                    public void run() {
                        EventStreamHandlerAdapter.this.performOnDisconnect(ds);
                    }
                };
                if (this.handlerInfo.isOnDisconnectMultithreaded()) {
                    ds.processMultithreaded(task);
                } else {
                    ds.processNonthreaded(task);
                }
            }
        }
    }

    private void performOnDisconnect(EventDataSource ds) {
        try {
            this.handler.onDisconnect(ds);
        }
        catch (IOException ioe) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("[" + ds.getId() + "] closing data source because an error has been occured by performing onDisconnect of " + this.handler + " Reason: " + DataConverter.toString((Throwable)ioe));
            }
            ds.destroy();
        }
        catch (Throwable t) {
            LOG.warning("[" + ds.getId() + "] closing data source. Error occured by performing onDisconnect of " + this.handler + " " + t.toString());
            ds.closeQuitly();
        }
    }

    public void onMessage(final EventDataSource ds) throws IOException {
        if (this.handler != null) {
            if (this.handlerInfo.isUnsynchronized()) {
                this.performOnMessage(ds);
            } else {
                Runnable task = new Runnable(){

                    public void run() {
                        EventStreamHandlerAdapter.this.performOnMessage(ds);
                    }
                };
                if (this.handlerInfo.isOnMessageMultithreaded()) {
                    ds.processMultithreaded(task);
                } else {
                    ds.processNonthreaded(task);
                }
                ds.processNonthreaded(task);
            }
        }
    }

    private void performOnMessage(EventDataSource ds) {
        try {
            while (ds.availableMessages() > 0) {
                int ver = ds.getInQueueVersion();
                this.handler.onMessage(ds);
                if (ver != ds.getInQueueVersion()) continue;
                break;
            }
        }
        catch (IOException ioe) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("[" + ds.getId() + "] closing dataSource because an error has been occured by performing onMessage of " + this.handler + " Reason: " + DataConverter.toString((Throwable)ioe));
            }
            ds.closeQuitly();
        }
        catch (Throwable t) {
            LOG.warning("[" + ds.getId() + "] closing data source. Error occured by performing onMessage of " + this.handler + " " + t.toString());
            ds.closeQuitly();
        }
    }
}

