/*
 * Decompiled with CFR 0.152.
 */
package org.xlightweb;

import java.util.Map;
import org.xlightweb.IEventHandler;
import org.xlightweb.IEventHandlerInfo;
import org.xlightweb.IWebSocketHandler;
import org.xlightweb.WebSocketHandlerInfo;
import org.xsocket.connection.ConnectionUtils;

final class ExtentedHttpUtils {
    private static final Map<Class, WebSocketHandlerInfo> webSocketHandlerInfoCache = ConnectionUtils.newMapCache((int)25);
    private static final WebSocketHandlerInfo EMPTY_WEB_SOCKET_HANDLER_INFO = new WebSocketHandlerInfo(null);
    private static final Map<Class, IEventHandlerInfo> webEventHandlerInfoCache = ConnectionUtils.newMapCache((int)25);
    private static final IEventHandlerInfo EMPTY_WEB_EVENT_HANDLER_INFO = new IEventHandlerInfo(null);

    ExtentedHttpUtils() {
    }

    static WebSocketHandlerInfo getWebSocketHandlerInfo(IWebSocketHandler webSocketHandler) {
        if (webSocketHandler == null) {
            return EMPTY_WEB_SOCKET_HANDLER_INFO;
        }
        WebSocketHandlerInfo webSocketHandlerInfo = webSocketHandlerInfoCache.get(webSocketHandler.getClass());
        if (webSocketHandlerInfo == null) {
            webSocketHandlerInfo = new WebSocketHandlerInfo(webSocketHandler.getClass());
            webSocketHandlerInfoCache.put(webSocketHandler.getClass(), webSocketHandlerInfo);
        }
        return webSocketHandlerInfo;
    }

    static IEventHandlerInfo getWebEventHandlerInfo(IEventHandler webEventHandler) {
        if (webEventHandler == null) {
            return EMPTY_WEB_EVENT_HANDLER_INFO;
        }
        IEventHandlerInfo webEventHandlerInfo = webEventHandlerInfoCache.get(webEventHandler.getClass());
        if (webEventHandlerInfo == null) {
            webEventHandlerInfo = new IEventHandlerInfo(webEventHandler.getClass());
            webEventHandlerInfoCache.put(webEventHandler.getClass(), webEventHandlerInfo);
        }
        return webEventHandlerInfo;
    }
}

