/*
 * Decompiled with CFR 0.152.
 */
package org.xlightweb;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xlightweb.ExtentedHttpUtils;
import org.xlightweb.HttpUtils;
import org.xlightweb.IBodyCompleteListener;
import org.xlightweb.IBodyDestroyListener;
import org.xlightweb.IHttpConnection;
import org.xlightweb.IHttpExchange;
import org.xlightweb.IHttpRequest;
import org.xlightweb.IHttpRequestHandler;
import org.xlightweb.IHttpRequestTimeoutHandler;
import org.xlightweb.IWebHandler;
import org.xlightweb.IWebSocketConnection;
import org.xlightweb.IWebSocketHandler;
import org.xlightweb.NonBlockingBodyDataSource;
import org.xlightweb.UnsupportedProtocolException;
import org.xlightweb.WebSocketHandlerInfo;
import org.xsocket.Execution;
import org.xsocket.ILifeCycle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Execution(value=1)
public class XContext
implements IHttpRequestHandler,
IHttpRequestTimeoutHandler,
IWebSocketHandler,
ILifeCycle,
Cloneable {
    private static final Logger LOG = Logger.getLogger(XContext.class.getName());
    private final List<IWebHandler> handlers = new ArrayList<IWebHandler>();
    private final List<ILifeCycle> lifeCycleChain = new ArrayList<ILifeCycle>();
    private final List<IHolder> holders = new ArrayList<IHolder>();
    private final HolderCache holderCache = new HolderCache(40);
    private boolean isOnRequestTimeoutPathMultithreaded = false;
    private final List<IHttpRequestTimeoutHandler> requestTimeoutHandlerChain = new ArrayList<IHttpRequestTimeoutHandler>();
    private final String contextPath;

    public XContext(String contextPath) {
        this.contextPath = contextPath;
    }

    public XContext(String contextPath, Map<String, IHttpRequestHandler> handlers) {
        this.contextPath = contextPath;
        for (Map.Entry<String, IHttpRequestHandler> entry : handlers.entrySet()) {
            this.addHandler(entry.getKey(), (IWebHandler)entry.getValue());
        }
    }

    public XContext(XContext parentContext, String contextPath) {
        this.contextPath = contextPath;
        parentContext.addContext(this);
    }

    private void addContext(XContext ctx) {
        this.holders.add(new ContextHolder(ctx));
        this.sortHolderList();
    }

    public void addHandler(IWebHandler webHandler) {
        String[] mappings = HttpUtils.retrieveMappings((IWebHandler)webHandler);
        if (mappings == null) {
            throw new RuntimeException("handler mapping is not annotated (hint: use @Mapping()");
        }
        for (String mapping : mappings) {
            this.addHandler(mapping, webHandler);
        }
    }

    public void addHandler(String pattern, IWebHandler webHandler) {
        RequestHandlerHolder holder = new RequestHandlerHolder(pattern, webHandler);
        for (IHolder hld : this.holders) {
            if (!hld.getPattern().equalsIgnoreCase(holder.getPattern())) continue;
            this.holders.remove(hld);
            if (!LOG.isLoggable(Level.FINE)) break;
            LOG.fine("handler already exists for pattern " + pattern + " Replacing existing holder");
            break;
        }
        this.holders.add(holder);
        this.sortHolderList();
        this.handlers.add(webHandler);
        this.computePath();
    }

    private void computePath() {
        this.holderCache.clear();
        this.lifeCycleChain.clear();
        this.requestTimeoutHandlerChain.clear();
        this.isOnRequestTimeoutPathMultithreaded = false;
        for (IWebHandler handler : this.handlers) {
            HttpUtils.RequestHandlerInfo requestHandlerInfo;
            if (ILifeCycle.class.isAssignableFrom(handler.getClass())) {
                this.lifeCycleChain.add((ILifeCycle)handler);
            }
            if (!(handler instanceof IHttpRequestHandler) || !(requestHandlerInfo = HttpUtils.getRequestHandlerInfo((IHttpRequestHandler)((IHttpRequestHandler)handler))).isRequestTimeoutHandler()) continue;
            this.requestTimeoutHandlerChain.add((IHttpRequestTimeoutHandler)handler);
            this.isOnRequestTimeoutPathMultithreaded = this.isOnRequestTimeoutPathMultithreaded || requestHandlerInfo.isRequestTimeoutHandlerMultithreaded();
        }
    }

    private void sortHolderList() {
        Comparator<IHolder> comparator = new Comparator<IHolder>(){

            @Override
            public int compare(IHolder o1, IHolder o2) {
                return 0 - o1.getPattern().compareTo(o2.getPattern());
            }
        };
        Collections.sort(this.holders, comparator);
    }

    public void onInit() {
        for (IHolder holder : this.holders) {
            holder.onInit();
        }
    }

    public void onDestroy() throws IOException {
        for (IHolder holder : this.holders) {
            holder.onDestroy();
        }
    }

    public String getContextPath() {
        return this.contextPath;
    }

    List<String> getMapping() {
        ArrayList<String> result = new ArrayList<String>();
        for (IHolder holder : this.holders) {
            result.add("[" + holder.getPattern() + "] -> " + holder.getTarget());
        }
        Collections.sort(result);
        return result;
    }

    public List<IWebHandler> getHandlers() {
        ArrayList<IWebHandler> result = new ArrayList<IWebHandler>();
        for (IHolder holder : this.holders) {
            result.add(holder.getTarget());
        }
        return result;
    }

    public int size() {
        return this.holders.size();
    }

    public void onRequest(IHttpExchange exchange) throws IOException {
        String path = exchange.getRequest().getRequestURI();
        if (path.startsWith(this.contextPath)) {
            path = path.substring(this.contextPath.length(), path.length());
            this.onRequest(path, exchange, this.contextPath);
        } else {
            this.sendNotFoundError(exchange);
        }
    }

    private void onRequest(String path, IHttpExchange exchange, String totalContextPath) throws IOException {
        if (this.holderCache.containsKey(path)) {
            ((IHolder)this.holderCache.get(path)).onRequest(path, exchange, totalContextPath);
            return;
        }
        for (IHolder holder : this.holders) {
            if (!holder.match(path)) continue;
            this.holderCache.put(path, holder);
            holder.onRequest(path, exchange, totalContextPath);
            return;
        }
        this.sendNotFoundError(exchange);
    }

    private void sendNotFoundError(IHttpExchange exchange) {
        if (HttpUtils.isShowDetailedError()) {
            StringBuilder sb = new StringBuilder("Not found\r\n\r\nsupported context:\r\n");
            for (IHolder holder : this.holders) {
                sb.append("<a href=\"" + holder.getPattern() + "\">" + holder.getPattern() + "</a><br>");
            }
            exchange.sendError(404, sb.toString());
        } else {
            exchange.sendError(404);
        }
    }

    public boolean onRequestTimeout(IHttpConnection connection) throws IOException {
        if (this.requestTimeoutHandlerChain.isEmpty()) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer("no request timeout handler set. ignore callback");
            }
            return false;
        }
        for (IHttpRequestTimeoutHandler requestTimeoutHandler : this.requestTimeoutHandlerChain) {
            boolean result = requestTimeoutHandler.onRequestTimeout(connection);
            if (!result) continue;
            return true;
        }
        return false;
    }

    @Override
    public void onConnect(IWebSocketConnection con) throws IOException, UnsupportedProtocolException {
        String path = con.getUpgradeRequestHeader().getRequestURI();
        if (!path.startsWith(this.contextPath)) {
            throw new UnsupportedProtocolException();
        }
        path = path.substring(this.contextPath.length(), path.length());
        this.onConnect(path, con, this.contextPath);
    }

    private void onConnect(String path, IWebSocketConnection con, String totalContextPath) throws IOException {
        if (this.holderCache.containsKey(path)) {
            ((IHolder)this.holderCache.get(path)).onConnect(path, con, totalContextPath);
            return;
        }
        for (IHolder holder : this.holders) {
            if (!holder.match(path)) continue;
            this.holderCache.put(path, holder);
            holder.onConnect(path, con, totalContextPath);
            return;
        }
        throw new UnsupportedProtocolException();
    }

    @Override
    public void onDisconnect(IWebSocketConnection con) throws IOException {
        String path = con.getUpgradeRequestHeader().getRequestURI();
        if (path.startsWith(this.contextPath)) {
            path = path.substring(this.contextPath.length(), path.length());
            this.onDisconnect(path, con, this.contextPath);
        }
    }

    private void onDisconnect(String path, IWebSocketConnection con, String totalContextPath) throws IOException {
        if (this.holderCache.containsKey(path)) {
            ((IHolder)this.holderCache.get(path)).onDisconnect(path, con, totalContextPath);
            return;
        }
        for (IHolder holder : this.holders) {
            if (!holder.match(path)) continue;
            this.holderCache.put(path, holder);
            holder.onDisconnect(path, con, totalContextPath);
            return;
        }
    }

    @Override
    public void onMessage(IWebSocketConnection con) throws IOException {
        String path = con.getUpgradeRequestHeader().getRequestURI();
        if (path.startsWith(this.contextPath)) {
            path = path.substring(this.contextPath.length(), path.length());
            this.onMessage(path, con, this.contextPath);
        }
    }

    private void onMessage(String path, IWebSocketConnection con, String totalContextPath) throws IOException {
        if (this.holderCache.containsKey(path)) {
            ((IHolder)this.holderCache.get(path)).onMessage(path, con, totalContextPath);
            return;
        }
        for (IHolder holder : this.holders) {
            if (!holder.match(path)) continue;
            this.holderCache.put(path, holder);
            holder.onMessage(path, con, totalContextPath);
            return;
        }
    }

    protected Object clone() throws CloneNotSupportedException {
        XContext copy = (XContext)super.clone();
        return copy;
    }

    XContext copy() {
        try {
            return (XContext)this.clone();
        }
        catch (CloneNotSupportedException cnse) {
            throw new RuntimeException(cnse.toString());
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("\"" + this.contextPath + "\"->{");
        for (IHolder holder : this.holders) {
            sb.append(holder + " ");
        }
        return sb.toString().trim() + "}";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class HolderCache
    extends LinkedHashMap<String, IHolder> {
        private static final long serialVersionUID = 4513864504007457500L;
        private int maxSize = 0;

        HolderCache(int maxSize) {
            this.maxSize = maxSize;
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, IHolder> eldest) {
            return this.size() > this.maxSize;
        }
    }

    private static final class BodyListener
    implements IBodyCompleteListener,
    IBodyDestroyListener {
        private IHttpExchange exchange = null;
        private RequestHandlerHolder requestHandlerHolder = null;

        public BodyListener(IHttpExchange exchange, RequestHandlerHolder requestHandlerHolder) {
            this.exchange = exchange;
            this.requestHandlerHolder = requestHandlerHolder;
        }

        @Execution(value=0)
        public void onComplete() {
            this.requestHandlerHolder.performOnRequest(this.exchange);
        }

        public void onDestroyed() throws IOException {
            this.exchange.destroy();
        }
    }

    private static final class RequestHandlerHolder
    implements IHolder {
        private String path = null;
        private String pattern = null;
        private boolean isWildcardPath = false;
        private boolean isWildcardPathExt = false;
        private final IWebHandler handler;
        private boolean isLifeCycleHandler;
        private final HttpUtils.RequestHandlerInfo requestHandlerInfo;
        private final WebSocketHandlerInfo webSocketHandlerInfo;

        RequestHandlerHolder(String pattern, IWebHandler handler) {
            this.handler = handler;
            this.isLifeCycleHandler = handler instanceof ILifeCycle;
            this.requestHandlerInfo = handler instanceof IHttpRequestHandler ? HttpUtils.getRequestHandlerInfo((IHttpRequestHandler)((IHttpRequestHandler)handler)) : null;
            this.webSocketHandlerInfo = handler instanceof IWebSocketHandler ? ExtentedHttpUtils.getWebSocketHandlerInfo((IWebSocketHandler)handler) : null;
            this.pattern = pattern;
            this.path = pattern;
            if (pattern.endsWith("/*")) {
                this.isWildcardPath = true;
                this.path = pattern.substring(0, pattern.indexOf("/*"));
            } else if (pattern.startsWith("*")) {
                this.path = pattern.substring(1, pattern.length());
                this.isWildcardPathExt = true;
            } else {
                this.isWildcardPath = false;
                this.path = pattern;
            }
        }

        public void onInit() {
            if (this.isLifeCycleHandler) {
                ((ILifeCycle)this.handler).onInit();
            }
        }

        public void onDestroy() throws IOException {
            if (this.isLifeCycleHandler) {
                ((ILifeCycle)this.handler).onDestroy();
            }
        }

        @Execution(value=0)
        public void onRequest(String reqPath, IHttpExchange exchange, String totalContextPath) throws IOException {
            if (this.requestHandlerInfo == null) {
                exchange.forward(exchange.getRequest());
                return;
            }
            IHttpRequest request = exchange.getRequest();
            if (request == null) {
                exchange.destroy();
                return;
            }
            request.setContextPath(totalContextPath);
            request.setRequestHandlerPath(this.path);
            if (this.requestHandlerInfo.isRequestHandlerInvokeOnMessageReceived()) {
                if (request.hasBody()) {
                    BodyListener bodyListener = new BodyListener(exchange, this);
                    NonBlockingBodyDataSource ds = request.getNonBlockingBody();
                    ds.addCompleteListener((IBodyCompleteListener)bodyListener);
                    ds.addDestroyListener((IBodyDestroyListener)bodyListener);
                } else {
                    this.performOnRequest(exchange);
                }
            } else {
                this.performOnRequest(exchange);
            }
        }

        private void performOnRequest(IHttpExchange exchange) {
            try {
                ((IHttpRequestHandler)this.handler).onRequest(exchange);
            }
            catch (Exception e) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("error occured by calling on request " + this.handler + " " + e.toString());
                }
                throw new RuntimeException(e);
            }
        }

        public void onConnect(String path, IWebSocketConnection wsConnection, String totalContextPath) throws IOException, UnsupportedProtocolException {
            if (this.webSocketHandlerInfo == null) {
                throw new UnsupportedProtocolException();
            }
            ((IWebSocketHandler)this.handler).onConnect(wsConnection);
        }

        public void onDisconnect(String path, IWebSocketConnection wsConnection, String totalContextPath) throws IOException, UnsupportedProtocolException {
            if (this.webSocketHandlerInfo == null) {
                return;
            }
            ((IWebSocketHandler)this.handler).onDisconnect(wsConnection);
        }

        public void onMessage(String path, IWebSocketConnection wsConnection, String totalContextPath) throws IOException, UnsupportedProtocolException {
            if (this.webSocketHandlerInfo == null) {
                return;
            }
            ((IWebSocketHandler)this.handler).onMessage(wsConnection);
        }

        public boolean match(String requestedRessource) {
            if (this.isWildcardPath) {
                return requestedRessource.startsWith(this.path) || requestedRessource.equals(this.path);
            }
            if (this.isWildcardPathExt) {
                return requestedRessource.endsWith(this.path);
            }
            return requestedRessource.equals(this.path);
        }

        public String getPattern() {
            return this.pattern;
        }

        public IWebHandler getTarget() {
            return this.handler;
        }

        public String toString() {
            return "\"" + this.pattern + "\"->" + this.handler.getClass().getSimpleName();
        }
    }

    private static final class ContextHolder
    implements IHolder {
        private XContext context = null;

        ContextHolder(XContext context) {
            this.context = context.copy();
        }

        public void onInit() {
            this.context.onInit();
        }

        public void onDestroy() throws IOException {
            this.context.onDestroy();
        }

        public void onRequest(String path, IHttpExchange exchange, String totalContextPath) throws IOException {
            path = path.substring(this.context.contextPath.length(), path.length());
            this.context.onRequest(path, exchange, totalContextPath + this.context.contextPath);
        }

        public void onConnect(String path, IWebSocketConnection wsConnection, String totalContextPath) throws IOException {
            path = path.substring(this.context.contextPath.length(), path.length());
            this.context.onConnect(path, wsConnection, totalContextPath + this.context.contextPath);
        }

        public void onDisconnect(String path, IWebSocketConnection wsConnection, String totalContextPath) throws IOException, UnsupportedProtocolException {
            path = path.substring(this.context.contextPath.length(), path.length());
            this.context.onDisconnect(path, wsConnection, totalContextPath + this.context.contextPath);
        }

        public void onMessage(String path, IWebSocketConnection wsConnection, String totalContextPath) throws IOException, UnsupportedProtocolException {
            path = path.substring(this.context.contextPath.length(), path.length());
            this.context.onMessage(path, wsConnection, totalContextPath + this.context.contextPath);
        }

        public boolean match(String requestedRessource) {
            return requestedRessource.startsWith(this.context.contextPath) || requestedRessource.equals(this.context.contextPath);
        }

        public String getPattern() {
            return this.context.contextPath;
        }

        public IHttpRequestHandler getTarget() {
            return this.context;
        }

        public String toString() {
            return this.context.toString();
        }
    }

    private static interface IHolder {
        public void onInit();

        public void onDestroy() throws IOException;

        public void onRequest(String var1, IHttpExchange var2, String var3) throws IOException;

        public void onConnect(String var1, IWebSocketConnection var2, String var3) throws IOException, UnsupportedProtocolException;

        public void onDisconnect(String var1, IWebSocketConnection var2, String var3) throws IOException;

        public void onMessage(String var1, IWebSocketConnection var2, String var3) throws IOException;

        public boolean match(String var1);

        public String getPattern();

        public IWebHandler getTarget();
    }
}

