/*
 * Decompiled with CFR 0.152.
 */
package org.xlightweb;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.xlightweb.IWriteCompleteHandler;
import org.xlightweb.WebSocketConnection;
import org.xlightweb.WebSocketMessage;
import org.xlightweb.WebSocketMessageCompleteHandlerAdapter;
import org.xsocket.DataConverter;
import org.xsocket.connection.IConnection;
import org.xsocket.connection.IWriteCompletionHandler;

public final class TextMessage
extends WebSocketMessage {
    private static final byte START_BYTE_TEXTFRAME = 0;
    private static final byte END_BYTE = -1;

    public TextMessage(String msg) {
        this(DataConverter.toByteBuffer((String)msg, (String)"utf-8"));
    }

    TextMessage(ByteBuffer msg) {
        super(msg, "utf-8");
    }

    public boolean isTextMessage() {
        return true;
    }

    int writeTo(WebSocketConnection connection, IWriteCompleteHandler completeHandler) throws IOException {
        int written;
        if (completeHandler == null) {
            connection.getUnderlyingTcpConnection().setFlushmode(IConnection.FlushMode.SYNC);
        } else {
            connection.getUnderlyingTcpConnection().setFlushmode(IConnection.FlushMode.ASYNC);
        }
        byte[] msgData = this.getData().toBytes();
        byte[] data = new byte[msgData.length + 2];
        data[0] = 0;
        data[data.length - 1] = -1;
        System.arraycopy(msgData, 0, data, 1, msgData.length);
        if (completeHandler == null) {
            written = connection.getUnderlyingTcpConnection().write(data);
        } else {
            written = data.length;
            connection.getUnderlyingTcpConnection().write(data, (IWriteCompletionHandler)new WebSocketMessageCompleteHandlerAdapter(connection, completeHandler));
        }
        connection.getUnderlyingTcpConnection().flush();
        return written;
    }

    static TextMessage parse(ByteBuffer buffer) throws IOException {
        int savePos = buffer.position();
        int saveLimit = buffer.limit();
        while (buffer.hasRemaining()) {
            byte b = buffer.get();
            if ((b & 0xFFFFFFFF) != -1) continue;
            int pos = buffer.position();
            buffer.limit(buffer.position() - 1);
            buffer.position(savePos);
            ByteBuffer msg = buffer.slice();
            buffer.limit(saveLimit);
            buffer.position(pos);
            return new TextMessage(msg);
        }
        buffer.position(savePos);
        buffer.limit(saveLimit);
        return null;
    }

    static boolean isTextMessage(byte startByte) {
        return startByte == 0;
    }
}

