/*
 * Decompiled with CFR 0.152.
 */
package org.xlightweb.client;

import java.io.IOException;
import java.net.URI;
import javax.net.ssl.SSLContext;
import org.xlightweb.EventDataSource;
import org.xlightweb.IEventDataSource;
import org.xlightweb.IEventHandler;
import org.xlightweb.IHttpRequestHandler;
import org.xlightweb.IWebSocketConnection;
import org.xlightweb.IWebSocketHandler;
import org.xlightweb.WebSocketConnection;
import org.xlightweb.client.HttpClient;
import org.xlightweb.client.IHttpClientEndpoint;

public class XHttpClient
extends HttpClient {
    public XHttpClient(IHttpRequestHandler ... interceptors) {
        super(interceptors);
    }

    public XHttpClient(SSLContext sslCtx) {
        super(sslCtx);
    }

    public XHttpClient(SSLContext sslCtx, IHttpRequestHandler ... interceptors) {
        super(sslCtx, interceptors);
    }

    public IEventDataSource openEventDataSource(String uriString, String ... headerlines) throws IOException {
        return this.openEventDataSource(uriString, true, headerlines);
    }

    public IEventDataSource openEventDataSource(String uriString, boolean isIgnoreCommentMessage) throws IOException {
        return this.openEventDataSource(uriString, isIgnoreCommentMessage, new String[0]);
    }

    public IEventDataSource openEventDataSource(String uriString, boolean isIgnoreCommentMessage, String ... headerlines) throws IOException {
        return this.openEventDataSource(uriString, isIgnoreCommentMessage, (IEventHandler)null, headerlines);
    }

    public IEventDataSource openEventDataSource(String uriString, IEventHandler webEventHandler, String ... headerlines) throws IOException {
        return new EventDataSource(this, uriString, true, webEventHandler, headerlines);
    }

    public IEventDataSource openEventDataSource(String uriString, boolean isIgnoreCommentMessage, IEventHandler webEventHandler, String ... headerlines) throws IOException {
        return new EventDataSource(this, uriString, isIgnoreCommentMessage, webEventHandler, headerlines);
    }

    public IWebSocketConnection openWebSocketConnection(String uriString) throws IOException {
        return this.openWebSocketConnection(uriString, (String)null);
    }

    public IWebSocketConnection openWebSocketConnection(String uriString, String protocol) throws IOException {
        return this.openWebSocketConnection(uriString, protocol, null);
    }

    public IWebSocketConnection openWebSocketConnection(String uriString, IWebSocketHandler webSocketHandler) throws IOException {
        return this.openWebSocketConnection(uriString, null, webSocketHandler);
    }

    public IWebSocketConnection openWebSocketConnection(String uriString, String protocol, IWebSocketHandler webSocketHandler) throws IOException {
        URI uri = URI.create(uriString);
        int port = uri.getPort();
        if (port == -1) {
            port = uri.getScheme().toLowerCase().equals("wss") ? 443 : 80;
        }
        return new WebSocketConnection((IHttpClientEndpoint)this, uri, protocol, webSocketHandler);
    }
}

