/*
 * Decompiled with CFR 0.152.
 */
package ru.testit.listener;

import java.util.List;
import java.util.function.BiConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.testit.listener.AdapterListener;
import ru.testit.listener.DefaultListener;
import ru.testit.models.TestResult;

public class ListenerManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(ListenerManager.class);
    private List<AdapterListener> listeners;

    public ListenerManager(List<AdapterListener> listeners) {
        this.listeners = listeners;
    }

    public void beforeTestStop(TestResult result) {
        this.runSafelyMethod(this.listeners, AdapterListener::beforeTestStop, result);
    }

    protected <T extends DefaultListener, S> void runSafelyMethod(List<T> listeners, BiConsumer<T, S> method, S object) {
        listeners.forEach(listener -> {
            try {
                method.accept(listener, object);
            }
            catch (Exception e) {
                LOGGER.error("Could not invoke listener method", (Throwable)e);
            }
        });
    }
}

