/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codedeploy.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the output of a BatchGetDeployments operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchGetDeploymentsResponse extends CodeDeployResponse implements
        ToCopyableBuilder<BatchGetDeploymentsResponse.Builder, BatchGetDeploymentsResponse> {
    private static final SdkField<List<DeploymentInfo>> DEPLOYMENTS_INFO_FIELD = SdkField
            .<List<DeploymentInfo>> builder(MarshallingType.LIST)
            .getter(getter(BatchGetDeploymentsResponse::deploymentsInfo))
            .setter(setter(Builder::deploymentsInfo))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deploymentsInfo").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DeploymentInfo> builder(MarshallingType.SDK_POJO)
                                            .constructor(DeploymentInfo::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEPLOYMENTS_INFO_FIELD));

    private final List<DeploymentInfo> deploymentsInfo;

    private BatchGetDeploymentsResponse(BuilderImpl builder) {
        super(builder);
        this.deploymentsInfo = builder.deploymentsInfo;
    }

    /**
     * <p>
     * Information about the deployments.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Information about the deployments.
     */
    public List<DeploymentInfo> deploymentsInfo() {
        return deploymentsInfo;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(deploymentsInfo());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetDeploymentsResponse)) {
            return false;
        }
        BatchGetDeploymentsResponse other = (BatchGetDeploymentsResponse) obj;
        return Objects.equals(deploymentsInfo(), other.deploymentsInfo());
    }

    @Override
    public String toString() {
        return ToString.builder("BatchGetDeploymentsResponse").add("DeploymentsInfo", deploymentsInfo()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "deploymentsInfo":
            return Optional.ofNullable(clazz.cast(deploymentsInfo()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchGetDeploymentsResponse, T> g) {
        return obj -> g.apply((BatchGetDeploymentsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodeDeployResponse.Builder, SdkPojo, CopyableBuilder<Builder, BatchGetDeploymentsResponse> {
        /**
         * <p>
         * Information about the deployments.
         * </p>
         * 
         * @param deploymentsInfo
         *        Information about the deployments.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deploymentsInfo(Collection<DeploymentInfo> deploymentsInfo);

        /**
         * <p>
         * Information about the deployments.
         * </p>
         * 
         * @param deploymentsInfo
         *        Information about the deployments.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deploymentsInfo(DeploymentInfo... deploymentsInfo);

        /**
         * <p>
         * Information about the deployments.
         * </p>
         * This is a convenience that creates an instance of the {@link List<DeploymentInfo>.Builder} avoiding the need
         * to create one manually via {@link List<DeploymentInfo>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<DeploymentInfo>.Builder#build()} is called immediately and
         * its result is passed to {@link #deploymentsInfo(List<DeploymentInfo>)}.
         * 
         * @param deploymentsInfo
         *        a consumer that will call methods on {@link List<DeploymentInfo>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #deploymentsInfo(List<DeploymentInfo>)
         */
        Builder deploymentsInfo(Consumer<DeploymentInfo.Builder>... deploymentsInfo);
    }

    static final class BuilderImpl extends CodeDeployResponse.BuilderImpl implements Builder {
        private List<DeploymentInfo> deploymentsInfo = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetDeploymentsResponse model) {
            super(model);
            deploymentsInfo(model.deploymentsInfo);
        }

        public final Collection<DeploymentInfo.Builder> getDeploymentsInfo() {
            return deploymentsInfo != null ? deploymentsInfo.stream().map(DeploymentInfo::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder deploymentsInfo(Collection<DeploymentInfo> deploymentsInfo) {
            this.deploymentsInfo = DeploymentsInfoListCopier.copy(deploymentsInfo);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deploymentsInfo(DeploymentInfo... deploymentsInfo) {
            deploymentsInfo(Arrays.asList(deploymentsInfo));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deploymentsInfo(Consumer<DeploymentInfo.Builder>... deploymentsInfo) {
            deploymentsInfo(Stream.of(deploymentsInfo).map(c -> DeploymentInfo.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setDeploymentsInfo(Collection<DeploymentInfo.BuilderImpl> deploymentsInfo) {
            this.deploymentsInfo = DeploymentsInfoListCopier.copyFromBuilder(deploymentsInfo);
        }

        @Override
        public BatchGetDeploymentsResponse build() {
            return new BatchGetDeploymentsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
