/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codedeploy.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the output of a BatchGetOnPremisesInstances operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchGetOnPremisesInstancesResponse extends CodeDeployResponse implements
        ToCopyableBuilder<BatchGetOnPremisesInstancesResponse.Builder, BatchGetOnPremisesInstancesResponse> {
    private static final SdkField<List<InstanceInfo>> INSTANCE_INFOS_FIELD = SdkField
            .<List<InstanceInfo>> builder(MarshallingType.LIST)
            .getter(getter(BatchGetOnPremisesInstancesResponse::instanceInfos))
            .setter(setter(Builder::instanceInfos))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instanceInfos").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<InstanceInfo> builder(MarshallingType.SDK_POJO)
                                            .constructor(InstanceInfo::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_INFOS_FIELD));

    private final List<InstanceInfo> instanceInfos;

    private BatchGetOnPremisesInstancesResponse(BuilderImpl builder) {
        super(builder);
        this.instanceInfos = builder.instanceInfos;
    }

    /**
     * <p>
     * Information about the on-premises instances.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Information about the on-premises instances.
     */
    public List<InstanceInfo> instanceInfos() {
        return instanceInfos;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(instanceInfos());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetOnPremisesInstancesResponse)) {
            return false;
        }
        BatchGetOnPremisesInstancesResponse other = (BatchGetOnPremisesInstancesResponse) obj;
        return Objects.equals(instanceInfos(), other.instanceInfos());
    }

    @Override
    public String toString() {
        return ToString.builder("BatchGetOnPremisesInstancesResponse").add("InstanceInfos", instanceInfos()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "instanceInfos":
            return Optional.ofNullable(clazz.cast(instanceInfos()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchGetOnPremisesInstancesResponse, T> g) {
        return obj -> g.apply((BatchGetOnPremisesInstancesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodeDeployResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, BatchGetOnPremisesInstancesResponse> {
        /**
         * <p>
         * Information about the on-premises instances.
         * </p>
         * 
         * @param instanceInfos
         *        Information about the on-premises instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceInfos(Collection<InstanceInfo> instanceInfos);

        /**
         * <p>
         * Information about the on-premises instances.
         * </p>
         * 
         * @param instanceInfos
         *        Information about the on-premises instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceInfos(InstanceInfo... instanceInfos);

        /**
         * <p>
         * Information about the on-premises instances.
         * </p>
         * This is a convenience that creates an instance of the {@link List<InstanceInfo>.Builder} avoiding the need to
         * create one manually via {@link List<InstanceInfo>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<InstanceInfo>.Builder#build()} is called immediately and its
         * result is passed to {@link #instanceInfos(List<InstanceInfo>)}.
         * 
         * @param instanceInfos
         *        a consumer that will call methods on {@link List<InstanceInfo>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #instanceInfos(List<InstanceInfo>)
         */
        Builder instanceInfos(Consumer<InstanceInfo.Builder>... instanceInfos);
    }

    static final class BuilderImpl extends CodeDeployResponse.BuilderImpl implements Builder {
        private List<InstanceInfo> instanceInfos = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetOnPremisesInstancesResponse model) {
            super(model);
            instanceInfos(model.instanceInfos);
        }

        public final Collection<InstanceInfo.Builder> getInstanceInfos() {
            return instanceInfos != null ? instanceInfos.stream().map(InstanceInfo::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder instanceInfos(Collection<InstanceInfo> instanceInfos) {
            this.instanceInfos = InstanceInfoListCopier.copy(instanceInfos);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceInfos(InstanceInfo... instanceInfos) {
            instanceInfos(Arrays.asList(instanceInfos));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceInfos(Consumer<InstanceInfo.Builder>... instanceInfos) {
            instanceInfos(Stream.of(instanceInfos).map(c -> InstanceInfo.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setInstanceInfos(Collection<InstanceInfo.BuilderImpl> instanceInfos) {
            this.instanceInfos = InstanceInfoListCopier.copyFromBuilder(instanceInfos);
        }

        @Override
        public BatchGetOnPremisesInstancesResponse build() {
            return new BatchGetOnPremisesInstancesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
