/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codedeploy.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the output of a ListApplicationRevisions operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListApplicationRevisionsResponse extends CodeDeployResponse implements
        ToCopyableBuilder<ListApplicationRevisionsResponse.Builder, ListApplicationRevisionsResponse> {
    private static final SdkField<List<RevisionLocation>> REVISIONS_FIELD = SdkField
            .<List<RevisionLocation>> builder(MarshallingType.LIST)
            .getter(getter(ListApplicationRevisionsResponse::revisions))
            .setter(setter(Builder::revisions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("revisions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RevisionLocation> builder(MarshallingType.SDK_POJO)
                                            .constructor(RevisionLocation::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListApplicationRevisionsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REVISIONS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<RevisionLocation> revisions;

    private final String nextToken;

    private ListApplicationRevisionsResponse(BuilderImpl builder) {
        super(builder);
        this.revisions = builder.revisions;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * A list of locations that contain the matching revisions.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of locations that contain the matching revisions.
     */
    public List<RevisionLocation> revisions() {
        return revisions;
    }

    /**
     * <p>
     * If a large amount of information is returned, an identifier will also be returned. It can be used in a subsequent
     * list application revisions call to return the next set of application revisions in the list.
     * </p>
     * 
     * @return If a large amount of information is returned, an identifier will also be returned. It can be used in a
     *         subsequent list application revisions call to return the next set of application revisions in the list.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(revisions());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListApplicationRevisionsResponse)) {
            return false;
        }
        ListApplicationRevisionsResponse other = (ListApplicationRevisionsResponse) obj;
        return Objects.equals(revisions(), other.revisions()) && Objects.equals(nextToken(), other.nextToken());
    }

    @Override
    public String toString() {
        return ToString.builder("ListApplicationRevisionsResponse").add("Revisions", revisions()).add("NextToken", nextToken())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "revisions":
            return Optional.ofNullable(clazz.cast(revisions()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListApplicationRevisionsResponse, T> g) {
        return obj -> g.apply((ListApplicationRevisionsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodeDeployResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListApplicationRevisionsResponse> {
        /**
         * <p>
         * A list of locations that contain the matching revisions.
         * </p>
         * 
         * @param revisions
         *        A list of locations that contain the matching revisions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder revisions(Collection<RevisionLocation> revisions);

        /**
         * <p>
         * A list of locations that contain the matching revisions.
         * </p>
         * 
         * @param revisions
         *        A list of locations that contain the matching revisions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder revisions(RevisionLocation... revisions);

        /**
         * <p>
         * A list of locations that contain the matching revisions.
         * </p>
         * This is a convenience that creates an instance of the {@link List<RevisionLocation>.Builder} avoiding the
         * need to create one manually via {@link List<RevisionLocation>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<RevisionLocation>.Builder#build()} is called immediately and
         * its result is passed to {@link #revisions(List<RevisionLocation>)}.
         * 
         * @param revisions
         *        a consumer that will call methods on {@link List<RevisionLocation>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #revisions(List<RevisionLocation>)
         */
        Builder revisions(Consumer<RevisionLocation.Builder>... revisions);

        /**
         * <p>
         * If a large amount of information is returned, an identifier will also be returned. It can be used in a
         * subsequent list application revisions call to return the next set of application revisions in the list.
         * </p>
         * 
         * @param nextToken
         *        If a large amount of information is returned, an identifier will also be returned. It can be used in a
         *        subsequent list application revisions call to return the next set of application revisions in the
         *        list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends CodeDeployResponse.BuilderImpl implements Builder {
        private List<RevisionLocation> revisions = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListApplicationRevisionsResponse model) {
            super(model);
            revisions(model.revisions);
            nextToken(model.nextToken);
        }

        public final Collection<RevisionLocation.Builder> getRevisions() {
            return revisions != null ? revisions.stream().map(RevisionLocation::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder revisions(Collection<RevisionLocation> revisions) {
            this.revisions = RevisionLocationListCopier.copy(revisions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder revisions(RevisionLocation... revisions) {
            revisions(Arrays.asList(revisions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder revisions(Consumer<RevisionLocation.Builder>... revisions) {
            revisions(Stream.of(revisions).map(c -> RevisionLocation.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setRevisions(Collection<RevisionLocation.BuilderImpl> revisions) {
            this.revisions = RevisionLocationListCopier.copyFromBuilder(revisions);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListApplicationRevisionsResponse build() {
            return new ListApplicationRevisionsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
