/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codedeploy.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the input of an UpdateDeploymentGroup operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateDeploymentGroupRequest extends CodeDeployRequest implements
        ToCopyableBuilder<UpdateDeploymentGroupRequest.Builder, UpdateDeploymentGroupRequest> {
    private static final SdkField<String> APPLICATION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateDeploymentGroupRequest::applicationName)).setter(setter(Builder::applicationName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("applicationName").build()).build();

    private static final SdkField<String> CURRENT_DEPLOYMENT_GROUP_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateDeploymentGroupRequest::currentDeploymentGroupName))
            .setter(setter(Builder::currentDeploymentGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("currentDeploymentGroupName").build())
            .build();

    private static final SdkField<String> NEW_DEPLOYMENT_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateDeploymentGroupRequest::newDeploymentGroupName)).setter(setter(Builder::newDeploymentGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("newDeploymentGroupName").build())
            .build();

    private static final SdkField<String> DEPLOYMENT_CONFIG_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateDeploymentGroupRequest::deploymentConfigName)).setter(setter(Builder::deploymentConfigName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deploymentConfigName").build())
            .build();

    private static final SdkField<List<EC2TagFilter>> EC2_TAG_FILTERS_FIELD = SdkField
            .<List<EC2TagFilter>> builder(MarshallingType.LIST)
            .getter(getter(UpdateDeploymentGroupRequest::ec2TagFilters))
            .setter(setter(Builder::ec2TagFilters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ec2TagFilters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<EC2TagFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(EC2TagFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<TagFilter>> ON_PREMISES_INSTANCE_TAG_FILTERS_FIELD = SdkField
            .<List<TagFilter>> builder(MarshallingType.LIST)
            .getter(getter(UpdateDeploymentGroupRequest::onPremisesInstanceTagFilters))
            .setter(setter(Builder::onPremisesInstanceTagFilters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("onPremisesInstanceTagFilters")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<TagFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(TagFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> AUTO_SCALING_GROUPS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(UpdateDeploymentGroupRequest::autoScalingGroups))
            .setter(setter(Builder::autoScalingGroups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("autoScalingGroups").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> SERVICE_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateDeploymentGroupRequest::serviceRoleArn)).setter(setter(Builder::serviceRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceRoleArn").build()).build();

    private static final SdkField<List<TriggerConfig>> TRIGGER_CONFIGURATIONS_FIELD = SdkField
            .<List<TriggerConfig>> builder(MarshallingType.LIST)
            .getter(getter(UpdateDeploymentGroupRequest::triggerConfigurations))
            .setter(setter(Builder::triggerConfigurations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("triggerConfigurations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<TriggerConfig> builder(MarshallingType.SDK_POJO)
                                            .constructor(TriggerConfig::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<AlarmConfiguration> ALARM_CONFIGURATION_FIELD = SdkField
            .<AlarmConfiguration> builder(MarshallingType.SDK_POJO)
            .getter(getter(UpdateDeploymentGroupRequest::alarmConfiguration)).setter(setter(Builder::alarmConfiguration))
            .constructor(AlarmConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("alarmConfiguration").build())
            .build();

    private static final SdkField<AutoRollbackConfiguration> AUTO_ROLLBACK_CONFIGURATION_FIELD = SdkField
            .<AutoRollbackConfiguration> builder(MarshallingType.SDK_POJO)
            .getter(getter(UpdateDeploymentGroupRequest::autoRollbackConfiguration))
            .setter(setter(Builder::autoRollbackConfiguration)).constructor(AutoRollbackConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("autoRollbackConfiguration").build())
            .build();

    private static final SdkField<DeploymentStyle> DEPLOYMENT_STYLE_FIELD = SdkField
            .<DeploymentStyle> builder(MarshallingType.SDK_POJO).getter(getter(UpdateDeploymentGroupRequest::deploymentStyle))
            .setter(setter(Builder::deploymentStyle)).constructor(DeploymentStyle::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deploymentStyle").build()).build();

    private static final SdkField<BlueGreenDeploymentConfiguration> BLUE_GREEN_DEPLOYMENT_CONFIGURATION_FIELD = SdkField
            .<BlueGreenDeploymentConfiguration> builder(MarshallingType.SDK_POJO)
            .getter(getter(UpdateDeploymentGroupRequest::blueGreenDeploymentConfiguration))
            .setter(setter(Builder::blueGreenDeploymentConfiguration))
            .constructor(BlueGreenDeploymentConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("blueGreenDeploymentConfiguration")
                    .build()).build();

    private static final SdkField<LoadBalancerInfo> LOAD_BALANCER_INFO_FIELD = SdkField
            .<LoadBalancerInfo> builder(MarshallingType.SDK_POJO).getter(getter(UpdateDeploymentGroupRequest::loadBalancerInfo))
            .setter(setter(Builder::loadBalancerInfo)).constructor(LoadBalancerInfo::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("loadBalancerInfo").build()).build();

    private static final SdkField<EC2TagSet> EC2_TAG_SET_FIELD = SdkField.<EC2TagSet> builder(MarshallingType.SDK_POJO)
            .getter(getter(UpdateDeploymentGroupRequest::ec2TagSet)).setter(setter(Builder::ec2TagSet))
            .constructor(EC2TagSet::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ec2TagSet").build()).build();

    private static final SdkField<List<ECSService>> ECS_SERVICES_FIELD = SdkField
            .<List<ECSService>> builder(MarshallingType.LIST)
            .getter(getter(UpdateDeploymentGroupRequest::ecsServices))
            .setter(setter(Builder::ecsServices))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ecsServices").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ECSService> builder(MarshallingType.SDK_POJO)
                                            .constructor(ECSService::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<OnPremisesTagSet> ON_PREMISES_TAG_SET_FIELD = SdkField
            .<OnPremisesTagSet> builder(MarshallingType.SDK_POJO).getter(getter(UpdateDeploymentGroupRequest::onPremisesTagSet))
            .setter(setter(Builder::onPremisesTagSet)).constructor(OnPremisesTagSet::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("onPremisesTagSet").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_NAME_FIELD,
            CURRENT_DEPLOYMENT_GROUP_NAME_FIELD, NEW_DEPLOYMENT_GROUP_NAME_FIELD, DEPLOYMENT_CONFIG_NAME_FIELD,
            EC2_TAG_FILTERS_FIELD, ON_PREMISES_INSTANCE_TAG_FILTERS_FIELD, AUTO_SCALING_GROUPS_FIELD, SERVICE_ROLE_ARN_FIELD,
            TRIGGER_CONFIGURATIONS_FIELD, ALARM_CONFIGURATION_FIELD, AUTO_ROLLBACK_CONFIGURATION_FIELD, DEPLOYMENT_STYLE_FIELD,
            BLUE_GREEN_DEPLOYMENT_CONFIGURATION_FIELD, LOAD_BALANCER_INFO_FIELD, EC2_TAG_SET_FIELD, ECS_SERVICES_FIELD,
            ON_PREMISES_TAG_SET_FIELD));

    private final String applicationName;

    private final String currentDeploymentGroupName;

    private final String newDeploymentGroupName;

    private final String deploymentConfigName;

    private final List<EC2TagFilter> ec2TagFilters;

    private final List<TagFilter> onPremisesInstanceTagFilters;

    private final List<String> autoScalingGroups;

    private final String serviceRoleArn;

    private final List<TriggerConfig> triggerConfigurations;

    private final AlarmConfiguration alarmConfiguration;

    private final AutoRollbackConfiguration autoRollbackConfiguration;

    private final DeploymentStyle deploymentStyle;

    private final BlueGreenDeploymentConfiguration blueGreenDeploymentConfiguration;

    private final LoadBalancerInfo loadBalancerInfo;

    private final EC2TagSet ec2TagSet;

    private final List<ECSService> ecsServices;

    private final OnPremisesTagSet onPremisesTagSet;

    private UpdateDeploymentGroupRequest(BuilderImpl builder) {
        super(builder);
        this.applicationName = builder.applicationName;
        this.currentDeploymentGroupName = builder.currentDeploymentGroupName;
        this.newDeploymentGroupName = builder.newDeploymentGroupName;
        this.deploymentConfigName = builder.deploymentConfigName;
        this.ec2TagFilters = builder.ec2TagFilters;
        this.onPremisesInstanceTagFilters = builder.onPremisesInstanceTagFilters;
        this.autoScalingGroups = builder.autoScalingGroups;
        this.serviceRoleArn = builder.serviceRoleArn;
        this.triggerConfigurations = builder.triggerConfigurations;
        this.alarmConfiguration = builder.alarmConfiguration;
        this.autoRollbackConfiguration = builder.autoRollbackConfiguration;
        this.deploymentStyle = builder.deploymentStyle;
        this.blueGreenDeploymentConfiguration = builder.blueGreenDeploymentConfiguration;
        this.loadBalancerInfo = builder.loadBalancerInfo;
        this.ec2TagSet = builder.ec2TagSet;
        this.ecsServices = builder.ecsServices;
        this.onPremisesTagSet = builder.onPremisesTagSet;
    }

    /**
     * <p>
     * The application name corresponding to the deployment group to update.
     * </p>
     * 
     * @return The application name corresponding to the deployment group to update.
     */
    public String applicationName() {
        return applicationName;
    }

    /**
     * <p>
     * The current name of the deployment group.
     * </p>
     * 
     * @return The current name of the deployment group.
     */
    public String currentDeploymentGroupName() {
        return currentDeploymentGroupName;
    }

    /**
     * <p>
     * The new name of the deployment group, if you want to change it.
     * </p>
     * 
     * @return The new name of the deployment group, if you want to change it.
     */
    public String newDeploymentGroupName() {
        return newDeploymentGroupName;
    }

    /**
     * <p>
     * The replacement deployment configuration name to use, if you want to change it.
     * </p>
     * 
     * @return The replacement deployment configuration name to use, if you want to change it.
     */
    public String deploymentConfigName() {
        return deploymentConfigName;
    }

    /**
     * <p>
     * The replacement set of Amazon EC2 tags on which to filter, if you want to change them. To keep the existing tags,
     * enter their names. To remove tags, do not enter any tag names.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The replacement set of Amazon EC2 tags on which to filter, if you want to change them. To keep the
     *         existing tags, enter their names. To remove tags, do not enter any tag names.
     */
    public List<EC2TagFilter> ec2TagFilters() {
        return ec2TagFilters;
    }

    /**
     * <p>
     * The replacement set of on-premises instance tags on which to filter, if you want to change them. To keep the
     * existing tags, enter their names. To remove tags, do not enter any tag names.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The replacement set of on-premises instance tags on which to filter, if you want to change them. To keep
     *         the existing tags, enter their names. To remove tags, do not enter any tag names.
     */
    public List<TagFilter> onPremisesInstanceTagFilters() {
        return onPremisesInstanceTagFilters;
    }

    /**
     * <p>
     * The replacement list of Auto Scaling groups to be included in the deployment group, if you want to change them.
     * To keep the Auto Scaling groups, enter their names. To remove Auto Scaling groups, do not enter any Auto Scaling
     * group names.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The replacement list of Auto Scaling groups to be included in the deployment group, if you want to change
     *         them. To keep the Auto Scaling groups, enter their names. To remove Auto Scaling groups, do not enter any
     *         Auto Scaling group names.
     */
    public List<String> autoScalingGroups() {
        return autoScalingGroups;
    }

    /**
     * <p>
     * A replacement ARN for the service role, if you want to change it.
     * </p>
     * 
     * @return A replacement ARN for the service role, if you want to change it.
     */
    public String serviceRoleArn() {
        return serviceRoleArn;
    }

    /**
     * <p>
     * Information about triggers to change when the deployment group is updated. For examples, see <a
     * href="http://docs.aws.amazon.com/codedeploy/latest/userguide/how-to-notify-edit.html">Modify Triggers in an AWS
     * CodeDeploy Deployment Group</a> in the AWS CodeDeploy User Guide.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Information about triggers to change when the deployment group is updated. For examples, see <a
     *         href="http://docs.aws.amazon.com/codedeploy/latest/userguide/how-to-notify-edit.html">Modify Triggers in
     *         an AWS CodeDeploy Deployment Group</a> in the AWS CodeDeploy User Guide.
     */
    public List<TriggerConfig> triggerConfigurations() {
        return triggerConfigurations;
    }

    /**
     * <p>
     * Information to add or change about Amazon CloudWatch alarms when the deployment group is updated.
     * </p>
     * 
     * @return Information to add or change about Amazon CloudWatch alarms when the deployment group is updated.
     */
    public AlarmConfiguration alarmConfiguration() {
        return alarmConfiguration;
    }

    /**
     * <p>
     * Information for an automatic rollback configuration that is added or changed when a deployment group is updated.
     * </p>
     * 
     * @return Information for an automatic rollback configuration that is added or changed when a deployment group is
     *         updated.
     */
    public AutoRollbackConfiguration autoRollbackConfiguration() {
        return autoRollbackConfiguration;
    }

    /**
     * <p>
     * Information about the type of deployment, either in-place or blue/green, you want to run and whether to route
     * deployment traffic behind a load balancer.
     * </p>
     * 
     * @return Information about the type of deployment, either in-place or blue/green, you want to run and whether to
     *         route deployment traffic behind a load balancer.
     */
    public DeploymentStyle deploymentStyle() {
        return deploymentStyle;
    }

    /**
     * <p>
     * Information about blue/green deployment options for a deployment group.
     * </p>
     * 
     * @return Information about blue/green deployment options for a deployment group.
     */
    public BlueGreenDeploymentConfiguration blueGreenDeploymentConfiguration() {
        return blueGreenDeploymentConfiguration;
    }

    /**
     * <p>
     * Information about the load balancer used in a deployment.
     * </p>
     * 
     * @return Information about the load balancer used in a deployment.
     */
    public LoadBalancerInfo loadBalancerInfo() {
        return loadBalancerInfo;
    }

    /**
     * <p>
     * Information about groups of tags applied to on-premises instances. The deployment group will include only EC2
     * instances identified by all the tag groups.
     * </p>
     * 
     * @return Information about groups of tags applied to on-premises instances. The deployment group will include only
     *         EC2 instances identified by all the tag groups.
     */
    public EC2TagSet ec2TagSet() {
        return ec2TagSet;
    }

    /**
     * <p>
     * The target ECS services in the deployment group. This only applies to deployment groups that use the Amazon ECS
     * compute platform. A target ECS service is specified as an Amazon ECS cluster and service name pair using the
     * format <code>&lt;clustername&gt;:&lt;servicename&gt;</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The target ECS services in the deployment group. This only applies to deployment groups that use the
     *         Amazon ECS compute platform. A target ECS service is specified as an Amazon ECS cluster and service name
     *         pair using the format <code>&lt;clustername&gt;:&lt;servicename&gt;</code>.
     */
    public List<ECSService> ecsServices() {
        return ecsServices;
    }

    /**
     * <p>
     * Information about an on-premises instance tag set. The deployment group will include only on-premises instances
     * identified by all the tag groups.
     * </p>
     * 
     * @return Information about an on-premises instance tag set. The deployment group will include only on-premises
     *         instances identified by all the tag groups.
     */
    public OnPremisesTagSet onPremisesTagSet() {
        return onPremisesTagSet;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(applicationName());
        hashCode = 31 * hashCode + Objects.hashCode(currentDeploymentGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(newDeploymentGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(deploymentConfigName());
        hashCode = 31 * hashCode + Objects.hashCode(ec2TagFilters());
        hashCode = 31 * hashCode + Objects.hashCode(onPremisesInstanceTagFilters());
        hashCode = 31 * hashCode + Objects.hashCode(autoScalingGroups());
        hashCode = 31 * hashCode + Objects.hashCode(serviceRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(triggerConfigurations());
        hashCode = 31 * hashCode + Objects.hashCode(alarmConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(autoRollbackConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(deploymentStyle());
        hashCode = 31 * hashCode + Objects.hashCode(blueGreenDeploymentConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(loadBalancerInfo());
        hashCode = 31 * hashCode + Objects.hashCode(ec2TagSet());
        hashCode = 31 * hashCode + Objects.hashCode(ecsServices());
        hashCode = 31 * hashCode + Objects.hashCode(onPremisesTagSet());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateDeploymentGroupRequest)) {
            return false;
        }
        UpdateDeploymentGroupRequest other = (UpdateDeploymentGroupRequest) obj;
        return Objects.equals(applicationName(), other.applicationName())
                && Objects.equals(currentDeploymentGroupName(), other.currentDeploymentGroupName())
                && Objects.equals(newDeploymentGroupName(), other.newDeploymentGroupName())
                && Objects.equals(deploymentConfigName(), other.deploymentConfigName())
                && Objects.equals(ec2TagFilters(), other.ec2TagFilters())
                && Objects.equals(onPremisesInstanceTagFilters(), other.onPremisesInstanceTagFilters())
                && Objects.equals(autoScalingGroups(), other.autoScalingGroups())
                && Objects.equals(serviceRoleArn(), other.serviceRoleArn())
                && Objects.equals(triggerConfigurations(), other.triggerConfigurations())
                && Objects.equals(alarmConfiguration(), other.alarmConfiguration())
                && Objects.equals(autoRollbackConfiguration(), other.autoRollbackConfiguration())
                && Objects.equals(deploymentStyle(), other.deploymentStyle())
                && Objects.equals(blueGreenDeploymentConfiguration(), other.blueGreenDeploymentConfiguration())
                && Objects.equals(loadBalancerInfo(), other.loadBalancerInfo()) && Objects.equals(ec2TagSet(), other.ec2TagSet())
                && Objects.equals(ecsServices(), other.ecsServices())
                && Objects.equals(onPremisesTagSet(), other.onPremisesTagSet());
    }

    @Override
    public String toString() {
        return ToString.builder("UpdateDeploymentGroupRequest").add("ApplicationName", applicationName())
                .add("CurrentDeploymentGroupName", currentDeploymentGroupName())
                .add("NewDeploymentGroupName", newDeploymentGroupName()).add("DeploymentConfigName", deploymentConfigName())
                .add("Ec2TagFilters", ec2TagFilters()).add("OnPremisesInstanceTagFilters", onPremisesInstanceTagFilters())
                .add("AutoScalingGroups", autoScalingGroups()).add("ServiceRoleArn", serviceRoleArn())
                .add("TriggerConfigurations", triggerConfigurations()).add("AlarmConfiguration", alarmConfiguration())
                .add("AutoRollbackConfiguration", autoRollbackConfiguration()).add("DeploymentStyle", deploymentStyle())
                .add("BlueGreenDeploymentConfiguration", blueGreenDeploymentConfiguration())
                .add("LoadBalancerInfo", loadBalancerInfo()).add("Ec2TagSet", ec2TagSet()).add("EcsServices", ecsServices())
                .add("OnPremisesTagSet", onPremisesTagSet()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "applicationName":
            return Optional.ofNullable(clazz.cast(applicationName()));
        case "currentDeploymentGroupName":
            return Optional.ofNullable(clazz.cast(currentDeploymentGroupName()));
        case "newDeploymentGroupName":
            return Optional.ofNullable(clazz.cast(newDeploymentGroupName()));
        case "deploymentConfigName":
            return Optional.ofNullable(clazz.cast(deploymentConfigName()));
        case "ec2TagFilters":
            return Optional.ofNullable(clazz.cast(ec2TagFilters()));
        case "onPremisesInstanceTagFilters":
            return Optional.ofNullable(clazz.cast(onPremisesInstanceTagFilters()));
        case "autoScalingGroups":
            return Optional.ofNullable(clazz.cast(autoScalingGroups()));
        case "serviceRoleArn":
            return Optional.ofNullable(clazz.cast(serviceRoleArn()));
        case "triggerConfigurations":
            return Optional.ofNullable(clazz.cast(triggerConfigurations()));
        case "alarmConfiguration":
            return Optional.ofNullable(clazz.cast(alarmConfiguration()));
        case "autoRollbackConfiguration":
            return Optional.ofNullable(clazz.cast(autoRollbackConfiguration()));
        case "deploymentStyle":
            return Optional.ofNullable(clazz.cast(deploymentStyle()));
        case "blueGreenDeploymentConfiguration":
            return Optional.ofNullable(clazz.cast(blueGreenDeploymentConfiguration()));
        case "loadBalancerInfo":
            return Optional.ofNullable(clazz.cast(loadBalancerInfo()));
        case "ec2TagSet":
            return Optional.ofNullable(clazz.cast(ec2TagSet()));
        case "ecsServices":
            return Optional.ofNullable(clazz.cast(ecsServices()));
        case "onPremisesTagSet":
            return Optional.ofNullable(clazz.cast(onPremisesTagSet()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateDeploymentGroupRequest, T> g) {
        return obj -> g.apply((UpdateDeploymentGroupRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodeDeployRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateDeploymentGroupRequest> {
        /**
         * <p>
         * The application name corresponding to the deployment group to update.
         * </p>
         * 
         * @param applicationName
         *        The application name corresponding to the deployment group to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationName(String applicationName);

        /**
         * <p>
         * The current name of the deployment group.
         * </p>
         * 
         * @param currentDeploymentGroupName
         *        The current name of the deployment group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder currentDeploymentGroupName(String currentDeploymentGroupName);

        /**
         * <p>
         * The new name of the deployment group, if you want to change it.
         * </p>
         * 
         * @param newDeploymentGroupName
         *        The new name of the deployment group, if you want to change it.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder newDeploymentGroupName(String newDeploymentGroupName);

        /**
         * <p>
         * The replacement deployment configuration name to use, if you want to change it.
         * </p>
         * 
         * @param deploymentConfigName
         *        The replacement deployment configuration name to use, if you want to change it.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deploymentConfigName(String deploymentConfigName);

        /**
         * <p>
         * The replacement set of Amazon EC2 tags on which to filter, if you want to change them. To keep the existing
         * tags, enter their names. To remove tags, do not enter any tag names.
         * </p>
         * 
         * @param ec2TagFilters
         *        The replacement set of Amazon EC2 tags on which to filter, if you want to change them. To keep the
         *        existing tags, enter their names. To remove tags, do not enter any tag names.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ec2TagFilters(Collection<EC2TagFilter> ec2TagFilters);

        /**
         * <p>
         * The replacement set of Amazon EC2 tags on which to filter, if you want to change them. To keep the existing
         * tags, enter their names. To remove tags, do not enter any tag names.
         * </p>
         * 
         * @param ec2TagFilters
         *        The replacement set of Amazon EC2 tags on which to filter, if you want to change them. To keep the
         *        existing tags, enter their names. To remove tags, do not enter any tag names.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ec2TagFilters(EC2TagFilter... ec2TagFilters);

        /**
         * <p>
         * The replacement set of Amazon EC2 tags on which to filter, if you want to change them. To keep the existing
         * tags, enter their names. To remove tags, do not enter any tag names.
         * </p>
         * This is a convenience that creates an instance of the {@link List<EC2TagFilter>.Builder} avoiding the need to
         * create one manually via {@link List<EC2TagFilter>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<EC2TagFilter>.Builder#build()} is called immediately and its
         * result is passed to {@link #ec2TagFilters(List<EC2TagFilter>)}.
         * 
         * @param ec2TagFilters
         *        a consumer that will call methods on {@link List<EC2TagFilter>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ec2TagFilters(List<EC2TagFilter>)
         */
        Builder ec2TagFilters(Consumer<EC2TagFilter.Builder>... ec2TagFilters);

        /**
         * <p>
         * The replacement set of on-premises instance tags on which to filter, if you want to change them. To keep the
         * existing tags, enter their names. To remove tags, do not enter any tag names.
         * </p>
         * 
         * @param onPremisesInstanceTagFilters
         *        The replacement set of on-premises instance tags on which to filter, if you want to change them. To
         *        keep the existing tags, enter their names. To remove tags, do not enter any tag names.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder onPremisesInstanceTagFilters(Collection<TagFilter> onPremisesInstanceTagFilters);

        /**
         * <p>
         * The replacement set of on-premises instance tags on which to filter, if you want to change them. To keep the
         * existing tags, enter their names. To remove tags, do not enter any tag names.
         * </p>
         * 
         * @param onPremisesInstanceTagFilters
         *        The replacement set of on-premises instance tags on which to filter, if you want to change them. To
         *        keep the existing tags, enter their names. To remove tags, do not enter any tag names.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder onPremisesInstanceTagFilters(TagFilter... onPremisesInstanceTagFilters);

        /**
         * <p>
         * The replacement set of on-premises instance tags on which to filter, if you want to change them. To keep the
         * existing tags, enter their names. To remove tags, do not enter any tag names.
         * </p>
         * This is a convenience that creates an instance of the {@link List<TagFilter>.Builder} avoiding the need to
         * create one manually via {@link List<TagFilter>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<TagFilter>.Builder#build()} is called immediately and its
         * result is passed to {@link #onPremisesInstanceTagFilters(List<TagFilter>)}.
         * 
         * @param onPremisesInstanceTagFilters
         *        a consumer that will call methods on {@link List<TagFilter>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #onPremisesInstanceTagFilters(List<TagFilter>)
         */
        Builder onPremisesInstanceTagFilters(Consumer<TagFilter.Builder>... onPremisesInstanceTagFilters);

        /**
         * <p>
         * The replacement list of Auto Scaling groups to be included in the deployment group, if you want to change
         * them. To keep the Auto Scaling groups, enter their names. To remove Auto Scaling groups, do not enter any
         * Auto Scaling group names.
         * </p>
         * 
         * @param autoScalingGroups
         *        The replacement list of Auto Scaling groups to be included in the deployment group, if you want to
         *        change them. To keep the Auto Scaling groups, enter their names. To remove Auto Scaling groups, do not
         *        enter any Auto Scaling group names.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoScalingGroups(Collection<String> autoScalingGroups);

        /**
         * <p>
         * The replacement list of Auto Scaling groups to be included in the deployment group, if you want to change
         * them. To keep the Auto Scaling groups, enter their names. To remove Auto Scaling groups, do not enter any
         * Auto Scaling group names.
         * </p>
         * 
         * @param autoScalingGroups
         *        The replacement list of Auto Scaling groups to be included in the deployment group, if you want to
         *        change them. To keep the Auto Scaling groups, enter their names. To remove Auto Scaling groups, do not
         *        enter any Auto Scaling group names.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoScalingGroups(String... autoScalingGroups);

        /**
         * <p>
         * A replacement ARN for the service role, if you want to change it.
         * </p>
         * 
         * @param serviceRoleArn
         *        A replacement ARN for the service role, if you want to change it.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceRoleArn(String serviceRoleArn);

        /**
         * <p>
         * Information about triggers to change when the deployment group is updated. For examples, see <a
         * href="http://docs.aws.amazon.com/codedeploy/latest/userguide/how-to-notify-edit.html">Modify Triggers in an
         * AWS CodeDeploy Deployment Group</a> in the AWS CodeDeploy User Guide.
         * </p>
         * 
         * @param triggerConfigurations
         *        Information about triggers to change when the deployment group is updated. For examples, see <a
         *        href="http://docs.aws.amazon.com/codedeploy/latest/userguide/how-to-notify-edit.html">Modify Triggers
         *        in an AWS CodeDeploy Deployment Group</a> in the AWS CodeDeploy User Guide.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder triggerConfigurations(Collection<TriggerConfig> triggerConfigurations);

        /**
         * <p>
         * Information about triggers to change when the deployment group is updated. For examples, see <a
         * href="http://docs.aws.amazon.com/codedeploy/latest/userguide/how-to-notify-edit.html">Modify Triggers in an
         * AWS CodeDeploy Deployment Group</a> in the AWS CodeDeploy User Guide.
         * </p>
         * 
         * @param triggerConfigurations
         *        Information about triggers to change when the deployment group is updated. For examples, see <a
         *        href="http://docs.aws.amazon.com/codedeploy/latest/userguide/how-to-notify-edit.html">Modify Triggers
         *        in an AWS CodeDeploy Deployment Group</a> in the AWS CodeDeploy User Guide.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder triggerConfigurations(TriggerConfig... triggerConfigurations);

        /**
         * <p>
         * Information about triggers to change when the deployment group is updated. For examples, see <a
         * href="http://docs.aws.amazon.com/codedeploy/latest/userguide/how-to-notify-edit.html">Modify Triggers in an
         * AWS CodeDeploy Deployment Group</a> in the AWS CodeDeploy User Guide.
         * </p>
         * This is a convenience that creates an instance of the {@link List<TriggerConfig>.Builder} avoiding the need
         * to create one manually via {@link List<TriggerConfig>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<TriggerConfig>.Builder#build()} is called immediately and
         * its result is passed to {@link #triggerConfigurations(List<TriggerConfig>)}.
         * 
         * @param triggerConfigurations
         *        a consumer that will call methods on {@link List<TriggerConfig>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #triggerConfigurations(List<TriggerConfig>)
         */
        Builder triggerConfigurations(Consumer<TriggerConfig.Builder>... triggerConfigurations);

        /**
         * <p>
         * Information to add or change about Amazon CloudWatch alarms when the deployment group is updated.
         * </p>
         * 
         * @param alarmConfiguration
         *        Information to add or change about Amazon CloudWatch alarms when the deployment group is updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder alarmConfiguration(AlarmConfiguration alarmConfiguration);

        /**
         * <p>
         * Information to add or change about Amazon CloudWatch alarms when the deployment group is updated.
         * </p>
         * This is a convenience that creates an instance of the {@link AlarmConfiguration.Builder} avoiding the need to
         * create one manually via {@link AlarmConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link AlarmConfiguration.Builder#build()} is called immediately and its
         * result is passed to {@link #alarmConfiguration(AlarmConfiguration)}.
         * 
         * @param alarmConfiguration
         *        a consumer that will call methods on {@link AlarmConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #alarmConfiguration(AlarmConfiguration)
         */
        default Builder alarmConfiguration(Consumer<AlarmConfiguration.Builder> alarmConfiguration) {
            return alarmConfiguration(AlarmConfiguration.builder().applyMutation(alarmConfiguration).build());
        }

        /**
         * <p>
         * Information for an automatic rollback configuration that is added or changed when a deployment group is
         * updated.
         * </p>
         * 
         * @param autoRollbackConfiguration
         *        Information for an automatic rollback configuration that is added or changed when a deployment group
         *        is updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoRollbackConfiguration(AutoRollbackConfiguration autoRollbackConfiguration);

        /**
         * <p>
         * Information for an automatic rollback configuration that is added or changed when a deployment group is
         * updated.
         * </p>
         * This is a convenience that creates an instance of the {@link AutoRollbackConfiguration.Builder} avoiding the
         * need to create one manually via {@link AutoRollbackConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link AutoRollbackConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #autoRollbackConfiguration(AutoRollbackConfiguration)}.
         * 
         * @param autoRollbackConfiguration
         *        a consumer that will call methods on {@link AutoRollbackConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #autoRollbackConfiguration(AutoRollbackConfiguration)
         */
        default Builder autoRollbackConfiguration(Consumer<AutoRollbackConfiguration.Builder> autoRollbackConfiguration) {
            return autoRollbackConfiguration(AutoRollbackConfiguration.builder().applyMutation(autoRollbackConfiguration).build());
        }

        /**
         * <p>
         * Information about the type of deployment, either in-place or blue/green, you want to run and whether to route
         * deployment traffic behind a load balancer.
         * </p>
         * 
         * @param deploymentStyle
         *        Information about the type of deployment, either in-place or blue/green, you want to run and whether
         *        to route deployment traffic behind a load balancer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deploymentStyle(DeploymentStyle deploymentStyle);

        /**
         * <p>
         * Information about the type of deployment, either in-place or blue/green, you want to run and whether to route
         * deployment traffic behind a load balancer.
         * </p>
         * This is a convenience that creates an instance of the {@link DeploymentStyle.Builder} avoiding the need to
         * create one manually via {@link DeploymentStyle#builder()}.
         *
         * When the {@link Consumer} completes, {@link DeploymentStyle.Builder#build()} is called immediately and its
         * result is passed to {@link #deploymentStyle(DeploymentStyle)}.
         * 
         * @param deploymentStyle
         *        a consumer that will call methods on {@link DeploymentStyle.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #deploymentStyle(DeploymentStyle)
         */
        default Builder deploymentStyle(Consumer<DeploymentStyle.Builder> deploymentStyle) {
            return deploymentStyle(DeploymentStyle.builder().applyMutation(deploymentStyle).build());
        }

        /**
         * <p>
         * Information about blue/green deployment options for a deployment group.
         * </p>
         * 
         * @param blueGreenDeploymentConfiguration
         *        Information about blue/green deployment options for a deployment group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blueGreenDeploymentConfiguration(BlueGreenDeploymentConfiguration blueGreenDeploymentConfiguration);

        /**
         * <p>
         * Information about blue/green deployment options for a deployment group.
         * </p>
         * This is a convenience that creates an instance of the {@link BlueGreenDeploymentConfiguration.Builder}
         * avoiding the need to create one manually via {@link BlueGreenDeploymentConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link BlueGreenDeploymentConfiguration.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #blueGreenDeploymentConfiguration(BlueGreenDeploymentConfiguration)}.
         * 
         * @param blueGreenDeploymentConfiguration
         *        a consumer that will call methods on {@link BlueGreenDeploymentConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #blueGreenDeploymentConfiguration(BlueGreenDeploymentConfiguration)
         */
        default Builder blueGreenDeploymentConfiguration(
                Consumer<BlueGreenDeploymentConfiguration.Builder> blueGreenDeploymentConfiguration) {
            return blueGreenDeploymentConfiguration(BlueGreenDeploymentConfiguration.builder()
                    .applyMutation(blueGreenDeploymentConfiguration).build());
        }

        /**
         * <p>
         * Information about the load balancer used in a deployment.
         * </p>
         * 
         * @param loadBalancerInfo
         *        Information about the load balancer used in a deployment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder loadBalancerInfo(LoadBalancerInfo loadBalancerInfo);

        /**
         * <p>
         * Information about the load balancer used in a deployment.
         * </p>
         * This is a convenience that creates an instance of the {@link LoadBalancerInfo.Builder} avoiding the need to
         * create one manually via {@link LoadBalancerInfo#builder()}.
         *
         * When the {@link Consumer} completes, {@link LoadBalancerInfo.Builder#build()} is called immediately and its
         * result is passed to {@link #loadBalancerInfo(LoadBalancerInfo)}.
         * 
         * @param loadBalancerInfo
         *        a consumer that will call methods on {@link LoadBalancerInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #loadBalancerInfo(LoadBalancerInfo)
         */
        default Builder loadBalancerInfo(Consumer<LoadBalancerInfo.Builder> loadBalancerInfo) {
            return loadBalancerInfo(LoadBalancerInfo.builder().applyMutation(loadBalancerInfo).build());
        }

        /**
         * <p>
         * Information about groups of tags applied to on-premises instances. The deployment group will include only EC2
         * instances identified by all the tag groups.
         * </p>
         * 
         * @param ec2TagSet
         *        Information about groups of tags applied to on-premises instances. The deployment group will include
         *        only EC2 instances identified by all the tag groups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ec2TagSet(EC2TagSet ec2TagSet);

        /**
         * <p>
         * Information about groups of tags applied to on-premises instances. The deployment group will include only EC2
         * instances identified by all the tag groups.
         * </p>
         * This is a convenience that creates an instance of the {@link EC2TagSet.Builder} avoiding the need to create
         * one manually via {@link EC2TagSet#builder()}.
         *
         * When the {@link Consumer} completes, {@link EC2TagSet.Builder#build()} is called immediately and its result
         * is passed to {@link #ec2TagSet(EC2TagSet)}.
         * 
         * @param ec2TagSet
         *        a consumer that will call methods on {@link EC2TagSet.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ec2TagSet(EC2TagSet)
         */
        default Builder ec2TagSet(Consumer<EC2TagSet.Builder> ec2TagSet) {
            return ec2TagSet(EC2TagSet.builder().applyMutation(ec2TagSet).build());
        }

        /**
         * <p>
         * The target ECS services in the deployment group. This only applies to deployment groups that use the Amazon
         * ECS compute platform. A target ECS service is specified as an Amazon ECS cluster and service name pair using
         * the format <code>&lt;clustername&gt;:&lt;servicename&gt;</code>.
         * </p>
         * 
         * @param ecsServices
         *        The target ECS services in the deployment group. This only applies to deployment groups that use the
         *        Amazon ECS compute platform. A target ECS service is specified as an Amazon ECS cluster and service
         *        name pair using the format <code>&lt;clustername&gt;:&lt;servicename&gt;</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ecsServices(Collection<ECSService> ecsServices);

        /**
         * <p>
         * The target ECS services in the deployment group. This only applies to deployment groups that use the Amazon
         * ECS compute platform. A target ECS service is specified as an Amazon ECS cluster and service name pair using
         * the format <code>&lt;clustername&gt;:&lt;servicename&gt;</code>.
         * </p>
         * 
         * @param ecsServices
         *        The target ECS services in the deployment group. This only applies to deployment groups that use the
         *        Amazon ECS compute platform. A target ECS service is specified as an Amazon ECS cluster and service
         *        name pair using the format <code>&lt;clustername&gt;:&lt;servicename&gt;</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ecsServices(ECSService... ecsServices);

        /**
         * <p>
         * The target ECS services in the deployment group. This only applies to deployment groups that use the Amazon
         * ECS compute platform. A target ECS service is specified as an Amazon ECS cluster and service name pair using
         * the format <code>&lt;clustername&gt;:&lt;servicename&gt;</code>.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ECSService>.Builder} avoiding the need to
         * create one manually via {@link List<ECSService>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ECSService>.Builder#build()} is called immediately and its
         * result is passed to {@link #ecsServices(List<ECSService>)}.
         * 
         * @param ecsServices
         *        a consumer that will call methods on {@link List<ECSService>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ecsServices(List<ECSService>)
         */
        Builder ecsServices(Consumer<ECSService.Builder>... ecsServices);

        /**
         * <p>
         * Information about an on-premises instance tag set. The deployment group will include only on-premises
         * instances identified by all the tag groups.
         * </p>
         * 
         * @param onPremisesTagSet
         *        Information about an on-premises instance tag set. The deployment group will include only on-premises
         *        instances identified by all the tag groups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder onPremisesTagSet(OnPremisesTagSet onPremisesTagSet);

        /**
         * <p>
         * Information about an on-premises instance tag set. The deployment group will include only on-premises
         * instances identified by all the tag groups.
         * </p>
         * This is a convenience that creates an instance of the {@link OnPremisesTagSet.Builder} avoiding the need to
         * create one manually via {@link OnPremisesTagSet#builder()}.
         *
         * When the {@link Consumer} completes, {@link OnPremisesTagSet.Builder#build()} is called immediately and its
         * result is passed to {@link #onPremisesTagSet(OnPremisesTagSet)}.
         * 
         * @param onPremisesTagSet
         *        a consumer that will call methods on {@link OnPremisesTagSet.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #onPremisesTagSet(OnPremisesTagSet)
         */
        default Builder onPremisesTagSet(Consumer<OnPremisesTagSet.Builder> onPremisesTagSet) {
            return onPremisesTagSet(OnPremisesTagSet.builder().applyMutation(onPremisesTagSet).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CodeDeployRequest.BuilderImpl implements Builder {
        private String applicationName;

        private String currentDeploymentGroupName;

        private String newDeploymentGroupName;

        private String deploymentConfigName;

        private List<EC2TagFilter> ec2TagFilters = DefaultSdkAutoConstructList.getInstance();

        private List<TagFilter> onPremisesInstanceTagFilters = DefaultSdkAutoConstructList.getInstance();

        private List<String> autoScalingGroups = DefaultSdkAutoConstructList.getInstance();

        private String serviceRoleArn;

        private List<TriggerConfig> triggerConfigurations = DefaultSdkAutoConstructList.getInstance();

        private AlarmConfiguration alarmConfiguration;

        private AutoRollbackConfiguration autoRollbackConfiguration;

        private DeploymentStyle deploymentStyle;

        private BlueGreenDeploymentConfiguration blueGreenDeploymentConfiguration;

        private LoadBalancerInfo loadBalancerInfo;

        private EC2TagSet ec2TagSet;

        private List<ECSService> ecsServices = DefaultSdkAutoConstructList.getInstance();

        private OnPremisesTagSet onPremisesTagSet;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateDeploymentGroupRequest model) {
            super(model);
            applicationName(model.applicationName);
            currentDeploymentGroupName(model.currentDeploymentGroupName);
            newDeploymentGroupName(model.newDeploymentGroupName);
            deploymentConfigName(model.deploymentConfigName);
            ec2TagFilters(model.ec2TagFilters);
            onPremisesInstanceTagFilters(model.onPremisesInstanceTagFilters);
            autoScalingGroups(model.autoScalingGroups);
            serviceRoleArn(model.serviceRoleArn);
            triggerConfigurations(model.triggerConfigurations);
            alarmConfiguration(model.alarmConfiguration);
            autoRollbackConfiguration(model.autoRollbackConfiguration);
            deploymentStyle(model.deploymentStyle);
            blueGreenDeploymentConfiguration(model.blueGreenDeploymentConfiguration);
            loadBalancerInfo(model.loadBalancerInfo);
            ec2TagSet(model.ec2TagSet);
            ecsServices(model.ecsServices);
            onPremisesTagSet(model.onPremisesTagSet);
        }

        public final String getApplicationName() {
            return applicationName;
        }

        @Override
        public final Builder applicationName(String applicationName) {
            this.applicationName = applicationName;
            return this;
        }

        public final void setApplicationName(String applicationName) {
            this.applicationName = applicationName;
        }

        public final String getCurrentDeploymentGroupName() {
            return currentDeploymentGroupName;
        }

        @Override
        public final Builder currentDeploymentGroupName(String currentDeploymentGroupName) {
            this.currentDeploymentGroupName = currentDeploymentGroupName;
            return this;
        }

        public final void setCurrentDeploymentGroupName(String currentDeploymentGroupName) {
            this.currentDeploymentGroupName = currentDeploymentGroupName;
        }

        public final String getNewDeploymentGroupName() {
            return newDeploymentGroupName;
        }

        @Override
        public final Builder newDeploymentGroupName(String newDeploymentGroupName) {
            this.newDeploymentGroupName = newDeploymentGroupName;
            return this;
        }

        public final void setNewDeploymentGroupName(String newDeploymentGroupName) {
            this.newDeploymentGroupName = newDeploymentGroupName;
        }

        public final String getDeploymentConfigName() {
            return deploymentConfigName;
        }

        @Override
        public final Builder deploymentConfigName(String deploymentConfigName) {
            this.deploymentConfigName = deploymentConfigName;
            return this;
        }

        public final void setDeploymentConfigName(String deploymentConfigName) {
            this.deploymentConfigName = deploymentConfigName;
        }

        public final Collection<EC2TagFilter.Builder> getEc2TagFilters() {
            return ec2TagFilters != null ? ec2TagFilters.stream().map(EC2TagFilter::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder ec2TagFilters(Collection<EC2TagFilter> ec2TagFilters) {
            this.ec2TagFilters = EC2TagFilterListCopier.copy(ec2TagFilters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ec2TagFilters(EC2TagFilter... ec2TagFilters) {
            ec2TagFilters(Arrays.asList(ec2TagFilters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ec2TagFilters(Consumer<EC2TagFilter.Builder>... ec2TagFilters) {
            ec2TagFilters(Stream.of(ec2TagFilters).map(c -> EC2TagFilter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setEc2TagFilters(Collection<EC2TagFilter.BuilderImpl> ec2TagFilters) {
            this.ec2TagFilters = EC2TagFilterListCopier.copyFromBuilder(ec2TagFilters);
        }

        public final Collection<TagFilter.Builder> getOnPremisesInstanceTagFilters() {
            return onPremisesInstanceTagFilters != null ? onPremisesInstanceTagFilters.stream().map(TagFilter::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder onPremisesInstanceTagFilters(Collection<TagFilter> onPremisesInstanceTagFilters) {
            this.onPremisesInstanceTagFilters = TagFilterListCopier.copy(onPremisesInstanceTagFilters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder onPremisesInstanceTagFilters(TagFilter... onPremisesInstanceTagFilters) {
            onPremisesInstanceTagFilters(Arrays.asList(onPremisesInstanceTagFilters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder onPremisesInstanceTagFilters(Consumer<TagFilter.Builder>... onPremisesInstanceTagFilters) {
            onPremisesInstanceTagFilters(Stream.of(onPremisesInstanceTagFilters)
                    .map(c -> TagFilter.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setOnPremisesInstanceTagFilters(Collection<TagFilter.BuilderImpl> onPremisesInstanceTagFilters) {
            this.onPremisesInstanceTagFilters = TagFilterListCopier.copyFromBuilder(onPremisesInstanceTagFilters);
        }

        public final Collection<String> getAutoScalingGroups() {
            return autoScalingGroups;
        }

        @Override
        public final Builder autoScalingGroups(Collection<String> autoScalingGroups) {
            this.autoScalingGroups = AutoScalingGroupNameListCopier.copy(autoScalingGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder autoScalingGroups(String... autoScalingGroups) {
            autoScalingGroups(Arrays.asList(autoScalingGroups));
            return this;
        }

        public final void setAutoScalingGroups(Collection<String> autoScalingGroups) {
            this.autoScalingGroups = AutoScalingGroupNameListCopier.copy(autoScalingGroups);
        }

        public final String getServiceRoleArn() {
            return serviceRoleArn;
        }

        @Override
        public final Builder serviceRoleArn(String serviceRoleArn) {
            this.serviceRoleArn = serviceRoleArn;
            return this;
        }

        public final void setServiceRoleArn(String serviceRoleArn) {
            this.serviceRoleArn = serviceRoleArn;
        }

        public final Collection<TriggerConfig.Builder> getTriggerConfigurations() {
            return triggerConfigurations != null ? triggerConfigurations.stream().map(TriggerConfig::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder triggerConfigurations(Collection<TriggerConfig> triggerConfigurations) {
            this.triggerConfigurations = TriggerConfigListCopier.copy(triggerConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder triggerConfigurations(TriggerConfig... triggerConfigurations) {
            triggerConfigurations(Arrays.asList(triggerConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder triggerConfigurations(Consumer<TriggerConfig.Builder>... triggerConfigurations) {
            triggerConfigurations(Stream.of(triggerConfigurations).map(c -> TriggerConfig.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setTriggerConfigurations(Collection<TriggerConfig.BuilderImpl> triggerConfigurations) {
            this.triggerConfigurations = TriggerConfigListCopier.copyFromBuilder(triggerConfigurations);
        }

        public final AlarmConfiguration.Builder getAlarmConfiguration() {
            return alarmConfiguration != null ? alarmConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder alarmConfiguration(AlarmConfiguration alarmConfiguration) {
            this.alarmConfiguration = alarmConfiguration;
            return this;
        }

        public final void setAlarmConfiguration(AlarmConfiguration.BuilderImpl alarmConfiguration) {
            this.alarmConfiguration = alarmConfiguration != null ? alarmConfiguration.build() : null;
        }

        public final AutoRollbackConfiguration.Builder getAutoRollbackConfiguration() {
            return autoRollbackConfiguration != null ? autoRollbackConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder autoRollbackConfiguration(AutoRollbackConfiguration autoRollbackConfiguration) {
            this.autoRollbackConfiguration = autoRollbackConfiguration;
            return this;
        }

        public final void setAutoRollbackConfiguration(AutoRollbackConfiguration.BuilderImpl autoRollbackConfiguration) {
            this.autoRollbackConfiguration = autoRollbackConfiguration != null ? autoRollbackConfiguration.build() : null;
        }

        public final DeploymentStyle.Builder getDeploymentStyle() {
            return deploymentStyle != null ? deploymentStyle.toBuilder() : null;
        }

        @Override
        public final Builder deploymentStyle(DeploymentStyle deploymentStyle) {
            this.deploymentStyle = deploymentStyle;
            return this;
        }

        public final void setDeploymentStyle(DeploymentStyle.BuilderImpl deploymentStyle) {
            this.deploymentStyle = deploymentStyle != null ? deploymentStyle.build() : null;
        }

        public final BlueGreenDeploymentConfiguration.Builder getBlueGreenDeploymentConfiguration() {
            return blueGreenDeploymentConfiguration != null ? blueGreenDeploymentConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder blueGreenDeploymentConfiguration(BlueGreenDeploymentConfiguration blueGreenDeploymentConfiguration) {
            this.blueGreenDeploymentConfiguration = blueGreenDeploymentConfiguration;
            return this;
        }

        public final void setBlueGreenDeploymentConfiguration(
                BlueGreenDeploymentConfiguration.BuilderImpl blueGreenDeploymentConfiguration) {
            this.blueGreenDeploymentConfiguration = blueGreenDeploymentConfiguration != null ? blueGreenDeploymentConfiguration
                    .build() : null;
        }

        public final LoadBalancerInfo.Builder getLoadBalancerInfo() {
            return loadBalancerInfo != null ? loadBalancerInfo.toBuilder() : null;
        }

        @Override
        public final Builder loadBalancerInfo(LoadBalancerInfo loadBalancerInfo) {
            this.loadBalancerInfo = loadBalancerInfo;
            return this;
        }

        public final void setLoadBalancerInfo(LoadBalancerInfo.BuilderImpl loadBalancerInfo) {
            this.loadBalancerInfo = loadBalancerInfo != null ? loadBalancerInfo.build() : null;
        }

        public final EC2TagSet.Builder getEc2TagSet() {
            return ec2TagSet != null ? ec2TagSet.toBuilder() : null;
        }

        @Override
        public final Builder ec2TagSet(EC2TagSet ec2TagSet) {
            this.ec2TagSet = ec2TagSet;
            return this;
        }

        public final void setEc2TagSet(EC2TagSet.BuilderImpl ec2TagSet) {
            this.ec2TagSet = ec2TagSet != null ? ec2TagSet.build() : null;
        }

        public final Collection<ECSService.Builder> getEcsServices() {
            return ecsServices != null ? ecsServices.stream().map(ECSService::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder ecsServices(Collection<ECSService> ecsServices) {
            this.ecsServices = ECSServiceListCopier.copy(ecsServices);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ecsServices(ECSService... ecsServices) {
            ecsServices(Arrays.asList(ecsServices));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ecsServices(Consumer<ECSService.Builder>... ecsServices) {
            ecsServices(Stream.of(ecsServices).map(c -> ECSService.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setEcsServices(Collection<ECSService.BuilderImpl> ecsServices) {
            this.ecsServices = ECSServiceListCopier.copyFromBuilder(ecsServices);
        }

        public final OnPremisesTagSet.Builder getOnPremisesTagSet() {
            return onPremisesTagSet != null ? onPremisesTagSet.toBuilder() : null;
        }

        @Override
        public final Builder onPremisesTagSet(OnPremisesTagSet onPremisesTagSet) {
            this.onPremisesTagSet = onPremisesTagSet;
            return this;
        }

        public final void setOnPremisesTagSet(OnPremisesTagSet.BuilderImpl onPremisesTagSet) {
            this.onPremisesTagSet = onPremisesTagSet != null ? onPremisesTagSet.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateDeploymentGroupRequest build() {
            return new UpdateDeploymentGroupRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
