/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codedeploy.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.codedeploy.model.ECSTaskSet;
import software.amazon.awssdk.services.codedeploy.model.ECSTaskSetListCopier;
import software.amazon.awssdk.services.codedeploy.model.LifecycleEvent;
import software.amazon.awssdk.services.codedeploy.model.LifecycleEventListCopier;
import software.amazon.awssdk.services.codedeploy.model.TargetStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ECSTarget
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ECSTarget> {
    private static final SdkField<String> DEPLOYMENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ECSTarget.getter(ECSTarget::deploymentId)).setter(ECSTarget.setter(Builder::deploymentId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deploymentId").build()}).build();
    private static final SdkField<String> TARGET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ECSTarget.getter(ECSTarget::targetId)).setter(ECSTarget.setter(Builder::targetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetId").build()}).build();
    private static final SdkField<String> TARGET_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ECSTarget.getter(ECSTarget::targetArn)).setter(ECSTarget.setter(Builder::targetArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetArn").build()}).build();
    private static final SdkField<Instant> LAST_UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(ECSTarget.getter(ECSTarget::lastUpdatedAt)).setter(ECSTarget.setter(Builder::lastUpdatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedAt").build()}).build();
    private static final SdkField<List<LifecycleEvent>> LIFECYCLE_EVENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(ECSTarget.getter(ECSTarget::lifecycleEvents)).setter(ECSTarget.setter(Builder::lifecycleEvents)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lifecycleEvents").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(LifecycleEvent::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ECSTarget.getter(ECSTarget::statusAsString)).setter(ECSTarget.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<List<ECSTaskSet>> TASK_SETS_INFO_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(ECSTarget.getter(ECSTarget::taskSetsInfo)).setter(ECSTarget.setter(Builder::taskSetsInfo)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taskSetsInfo").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ECSTaskSet::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEPLOYMENT_ID_FIELD, TARGET_ID_FIELD, TARGET_ARN_FIELD, LAST_UPDATED_AT_FIELD, LIFECYCLE_EVENTS_FIELD, STATUS_FIELD, TASK_SETS_INFO_FIELD));
    private static final long serialVersionUID = 1L;
    private final String deploymentId;
    private final String targetId;
    private final String targetArn;
    private final Instant lastUpdatedAt;
    private final List<LifecycleEvent> lifecycleEvents;
    private final String status;
    private final List<ECSTaskSet> taskSetsInfo;

    private ECSTarget(BuilderImpl builder) {
        this.deploymentId = builder.deploymentId;
        this.targetId = builder.targetId;
        this.targetArn = builder.targetArn;
        this.lastUpdatedAt = builder.lastUpdatedAt;
        this.lifecycleEvents = builder.lifecycleEvents;
        this.status = builder.status;
        this.taskSetsInfo = builder.taskSetsInfo;
    }

    public String deploymentId() {
        return this.deploymentId;
    }

    public String targetId() {
        return this.targetId;
    }

    public String targetArn() {
        return this.targetArn;
    }

    public Instant lastUpdatedAt() {
        return this.lastUpdatedAt;
    }

    public List<LifecycleEvent> lifecycleEvents() {
        return this.lifecycleEvents;
    }

    public TargetStatus status() {
        return TargetStatus.fromValue(this.status);
    }

    public String statusAsString() {
        return this.status;
    }

    public List<ECSTaskSet> taskSetsInfo() {
        return this.taskSetsInfo;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.deploymentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.lifecycleEvents());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.taskSetsInfo());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ECSTarget)) {
            return false;
        }
        ECSTarget other = (ECSTarget)obj;
        return Objects.equals(this.deploymentId(), other.deploymentId()) && Objects.equals(this.targetId(), other.targetId()) && Objects.equals(this.targetArn(), other.targetArn()) && Objects.equals(this.lastUpdatedAt(), other.lastUpdatedAt()) && Objects.equals(this.lifecycleEvents(), other.lifecycleEvents()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.taskSetsInfo(), other.taskSetsInfo());
    }

    public String toString() {
        return ToString.builder((String)"ECSTarget").add("DeploymentId", (Object)this.deploymentId()).add("TargetId", (Object)this.targetId()).add("TargetArn", (Object)this.targetArn()).add("LastUpdatedAt", (Object)this.lastUpdatedAt()).add("LifecycleEvents", this.lifecycleEvents()).add("Status", (Object)this.statusAsString()).add("TaskSetsInfo", this.taskSetsInfo()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "deploymentId": {
                return Optional.ofNullable(clazz.cast(this.deploymentId()));
            }
            case "targetId": {
                return Optional.ofNullable(clazz.cast(this.targetId()));
            }
            case "targetArn": {
                return Optional.ofNullable(clazz.cast(this.targetArn()));
            }
            case "lastUpdatedAt": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedAt()));
            }
            case "lifecycleEvents": {
                return Optional.ofNullable(clazz.cast(this.lifecycleEvents()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "taskSetsInfo": {
                return Optional.ofNullable(clazz.cast(this.taskSetsInfo()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ECSTarget, T> g) {
        return obj -> g.apply((ECSTarget)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String deploymentId;
        private String targetId;
        private String targetArn;
        private Instant lastUpdatedAt;
        private List<LifecycleEvent> lifecycleEvents = DefaultSdkAutoConstructList.getInstance();
        private String status;
        private List<ECSTaskSet> taskSetsInfo = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ECSTarget model) {
            this.deploymentId(model.deploymentId);
            this.targetId(model.targetId);
            this.targetArn(model.targetArn);
            this.lastUpdatedAt(model.lastUpdatedAt);
            this.lifecycleEvents(model.lifecycleEvents);
            this.status(model.status);
            this.taskSetsInfo(model.taskSetsInfo);
        }

        public final String getDeploymentId() {
            return this.deploymentId;
        }

        @Override
        public final Builder deploymentId(String deploymentId) {
            this.deploymentId = deploymentId;
            return this;
        }

        public final void setDeploymentId(String deploymentId) {
            this.deploymentId = deploymentId;
        }

        public final String getTargetId() {
            return this.targetId;
        }

        @Override
        public final Builder targetId(String targetId) {
            this.targetId = targetId;
            return this;
        }

        public final void setTargetId(String targetId) {
            this.targetId = targetId;
        }

        public final String getTargetArn() {
            return this.targetArn;
        }

        @Override
        public final Builder targetArn(String targetArn) {
            this.targetArn = targetArn;
            return this;
        }

        public final void setTargetArn(String targetArn) {
            this.targetArn = targetArn;
        }

        public final Instant getLastUpdatedAt() {
            return this.lastUpdatedAt;
        }

        @Override
        public final Builder lastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
            return this;
        }

        public final void setLastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
        }

        public final Collection<LifecycleEvent.Builder> getLifecycleEvents() {
            return this.lifecycleEvents != null ? (Collection)this.lifecycleEvents.stream().map(LifecycleEvent::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder lifecycleEvents(Collection<LifecycleEvent> lifecycleEvents) {
            this.lifecycleEvents = LifecycleEventListCopier.copy(lifecycleEvents);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lifecycleEvents(LifecycleEvent ... lifecycleEvents) {
            this.lifecycleEvents(Arrays.asList(lifecycleEvents));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lifecycleEvents(Consumer<LifecycleEvent.Builder> ... lifecycleEvents) {
            this.lifecycleEvents(Stream.of(lifecycleEvents).map(c -> (LifecycleEvent)((LifecycleEvent.Builder)LifecycleEvent.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setLifecycleEvents(Collection<LifecycleEvent.BuilderImpl> lifecycleEvents) {
            this.lifecycleEvents = LifecycleEventListCopier.copyFromBuilder(lifecycleEvents);
        }

        public final String getStatusAsString() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(TargetStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final Collection<ECSTaskSet.Builder> getTaskSetsInfo() {
            return this.taskSetsInfo != null ? (Collection)this.taskSetsInfo.stream().map(ECSTaskSet::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder taskSetsInfo(Collection<ECSTaskSet> taskSetsInfo) {
            this.taskSetsInfo = ECSTaskSetListCopier.copy(taskSetsInfo);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder taskSetsInfo(ECSTaskSet ... taskSetsInfo) {
            this.taskSetsInfo(Arrays.asList(taskSetsInfo));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder taskSetsInfo(Consumer<ECSTaskSet.Builder> ... taskSetsInfo) {
            this.taskSetsInfo(Stream.of(taskSetsInfo).map(c -> (ECSTaskSet)((ECSTaskSet.Builder)ECSTaskSet.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTaskSetsInfo(Collection<ECSTaskSet.BuilderImpl> taskSetsInfo) {
            this.taskSetsInfo = ECSTaskSetListCopier.copyFromBuilder(taskSetsInfo);
        }

        public ECSTarget build() {
            return new ECSTarget(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ECSTarget> {
        public Builder deploymentId(String var1);

        public Builder targetId(String var1);

        public Builder targetArn(String var1);

        public Builder lastUpdatedAt(Instant var1);

        public Builder lifecycleEvents(Collection<LifecycleEvent> var1);

        public Builder lifecycleEvents(LifecycleEvent ... var1);

        public Builder lifecycleEvents(Consumer<LifecycleEvent.Builder> ... var1);

        public Builder status(String var1);

        public Builder status(TargetStatus var1);

        public Builder taskSetsInfo(Collection<ECSTaskSet> var1);

        public Builder taskSetsInfo(ECSTaskSet ... var1);

        public Builder taskSetsInfo(Consumer<ECSTaskSet.Builder> ... var1);
    }
}

