/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codedeploy.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the output of a BatchGetApplicationRevisions operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchGetApplicationRevisionsResponse extends CodeDeployResponse implements
        ToCopyableBuilder<BatchGetApplicationRevisionsResponse.Builder, BatchGetApplicationRevisionsResponse> {
    private static final SdkField<String> APPLICATION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(BatchGetApplicationRevisionsResponse::applicationName)).setter(setter(Builder::applicationName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("applicationName").build()).build();

    private static final SdkField<String> ERROR_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(BatchGetApplicationRevisionsResponse::errorMessage)).setter(setter(Builder::errorMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorMessage").build()).build();

    private static final SdkField<List<RevisionInfo>> REVISIONS_FIELD = SdkField
            .<List<RevisionInfo>> builder(MarshallingType.LIST)
            .getter(getter(BatchGetApplicationRevisionsResponse::revisions))
            .setter(setter(Builder::revisions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("revisions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RevisionInfo> builder(MarshallingType.SDK_POJO)
                                            .constructor(RevisionInfo::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_NAME_FIELD,
            ERROR_MESSAGE_FIELD, REVISIONS_FIELD));

    private final String applicationName;

    private final String errorMessage;

    private final List<RevisionInfo> revisions;

    private BatchGetApplicationRevisionsResponse(BuilderImpl builder) {
        super(builder);
        this.applicationName = builder.applicationName;
        this.errorMessage = builder.errorMessage;
        this.revisions = builder.revisions;
    }

    /**
     * <p>
     * The name of the application that corresponds to the revisions.
     * </p>
     * 
     * @return The name of the application that corresponds to the revisions.
     */
    public String applicationName() {
        return applicationName;
    }

    /**
     * <p>
     * Information about errors that might have occurred during the API call.
     * </p>
     * 
     * @return Information about errors that might have occurred during the API call.
     */
    public String errorMessage() {
        return errorMessage;
    }

    /**
     * Returns true if the Revisions property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasRevisions() {
        return revisions != null && !(revisions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Additional information about the revisions, including the type and location.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasRevisions()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Additional information about the revisions, including the type and location.
     */
    public List<RevisionInfo> revisions() {
        return revisions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(applicationName());
        hashCode = 31 * hashCode + Objects.hashCode(errorMessage());
        hashCode = 31 * hashCode + Objects.hashCode(revisions());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetApplicationRevisionsResponse)) {
            return false;
        }
        BatchGetApplicationRevisionsResponse other = (BatchGetApplicationRevisionsResponse) obj;
        return Objects.equals(applicationName(), other.applicationName()) && Objects.equals(errorMessage(), other.errorMessage())
                && Objects.equals(revisions(), other.revisions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("BatchGetApplicationRevisionsResponse").add("ApplicationName", applicationName())
                .add("ErrorMessage", errorMessage()).add("Revisions", revisions()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "applicationName":
            return Optional.ofNullable(clazz.cast(applicationName()));
        case "errorMessage":
            return Optional.ofNullable(clazz.cast(errorMessage()));
        case "revisions":
            return Optional.ofNullable(clazz.cast(revisions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchGetApplicationRevisionsResponse, T> g) {
        return obj -> g.apply((BatchGetApplicationRevisionsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodeDeployResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, BatchGetApplicationRevisionsResponse> {
        /**
         * <p>
         * The name of the application that corresponds to the revisions.
         * </p>
         * 
         * @param applicationName
         *        The name of the application that corresponds to the revisions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationName(String applicationName);

        /**
         * <p>
         * Information about errors that might have occurred during the API call.
         * </p>
         * 
         * @param errorMessage
         *        Information about errors that might have occurred during the API call.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorMessage(String errorMessage);

        /**
         * <p>
         * Additional information about the revisions, including the type and location.
         * </p>
         * 
         * @param revisions
         *        Additional information about the revisions, including the type and location.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder revisions(Collection<RevisionInfo> revisions);

        /**
         * <p>
         * Additional information about the revisions, including the type and location.
         * </p>
         * 
         * @param revisions
         *        Additional information about the revisions, including the type and location.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder revisions(RevisionInfo... revisions);

        /**
         * <p>
         * Additional information about the revisions, including the type and location.
         * </p>
         * This is a convenience that creates an instance of the {@link List<RevisionInfo>.Builder} avoiding the need to
         * create one manually via {@link List<RevisionInfo>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<RevisionInfo>.Builder#build()} is called immediately and its
         * result is passed to {@link #revisions(List<RevisionInfo>)}.
         * 
         * @param revisions
         *        a consumer that will call methods on {@link List<RevisionInfo>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #revisions(List<RevisionInfo>)
         */
        Builder revisions(Consumer<RevisionInfo.Builder>... revisions);
    }

    static final class BuilderImpl extends CodeDeployResponse.BuilderImpl implements Builder {
        private String applicationName;

        private String errorMessage;

        private List<RevisionInfo> revisions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetApplicationRevisionsResponse model) {
            super(model);
            applicationName(model.applicationName);
            errorMessage(model.errorMessage);
            revisions(model.revisions);
        }

        public final String getApplicationName() {
            return applicationName;
        }

        @Override
        public final Builder applicationName(String applicationName) {
            this.applicationName = applicationName;
            return this;
        }

        public final void setApplicationName(String applicationName) {
            this.applicationName = applicationName;
        }

        public final String getErrorMessage() {
            return errorMessage;
        }

        @Override
        public final Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public final void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        public final Collection<RevisionInfo.Builder> getRevisions() {
            return revisions != null ? revisions.stream().map(RevisionInfo::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder revisions(Collection<RevisionInfo> revisions) {
            this.revisions = RevisionInfoListCopier.copy(revisions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder revisions(RevisionInfo... revisions) {
            revisions(Arrays.asList(revisions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder revisions(Consumer<RevisionInfo.Builder>... revisions) {
            revisions(Stream.of(revisions).map(c -> RevisionInfo.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setRevisions(Collection<RevisionInfo.BuilderImpl> revisions) {
            this.revisions = RevisionInfoListCopier.copyFromBuilder(revisions);
        }

        @Override
        public BatchGetApplicationRevisionsResponse build() {
            return new BatchGetApplicationRevisionsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
