/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codedeploy.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the input of a BatchGetOnPremisesInstances operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchGetOnPremisesInstancesRequest extends CodeDeployRequest implements
        ToCopyableBuilder<BatchGetOnPremisesInstancesRequest.Builder, BatchGetOnPremisesInstancesRequest> {
    private static final SdkField<List<String>> INSTANCE_NAMES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(BatchGetOnPremisesInstancesRequest::instanceNames))
            .setter(setter(Builder::instanceNames))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instanceNames").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_NAMES_FIELD));

    private final List<String> instanceNames;

    private BatchGetOnPremisesInstancesRequest(BuilderImpl builder) {
        super(builder);
        this.instanceNames = builder.instanceNames;
    }

    /**
     * Returns true if the InstanceNames property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasInstanceNames() {
        return instanceNames != null && !(instanceNames instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The names of the on-premises instances about which to get information. The maximum number of instance names you
     * can specify is 25.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasInstanceNames()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The names of the on-premises instances about which to get information. The maximum number of instance
     *         names you can specify is 25.
     */
    public List<String> instanceNames() {
        return instanceNames;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(instanceNames());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetOnPremisesInstancesRequest)) {
            return false;
        }
        BatchGetOnPremisesInstancesRequest other = (BatchGetOnPremisesInstancesRequest) obj;
        return Objects.equals(instanceNames(), other.instanceNames());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("BatchGetOnPremisesInstancesRequest").add("InstanceNames", instanceNames()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "instanceNames":
            return Optional.ofNullable(clazz.cast(instanceNames()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchGetOnPremisesInstancesRequest, T> g) {
        return obj -> g.apply((BatchGetOnPremisesInstancesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodeDeployRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, BatchGetOnPremisesInstancesRequest> {
        /**
         * <p>
         * The names of the on-premises instances about which to get information. The maximum number of instance names
         * you can specify is 25.
         * </p>
         * 
         * @param instanceNames
         *        The names of the on-premises instances about which to get information. The maximum number of instance
         *        names you can specify is 25.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceNames(Collection<String> instanceNames);

        /**
         * <p>
         * The names of the on-premises instances about which to get information. The maximum number of instance names
         * you can specify is 25.
         * </p>
         * 
         * @param instanceNames
         *        The names of the on-premises instances about which to get information. The maximum number of instance
         *        names you can specify is 25.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceNames(String... instanceNames);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CodeDeployRequest.BuilderImpl implements Builder {
        private List<String> instanceNames = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetOnPremisesInstancesRequest model) {
            super(model);
            instanceNames(model.instanceNames);
        }

        public final Collection<String> getInstanceNames() {
            return instanceNames;
        }

        @Override
        public final Builder instanceNames(Collection<String> instanceNames) {
            this.instanceNames = InstanceNameListCopier.copy(instanceNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceNames(String... instanceNames) {
            instanceNames(Arrays.asList(instanceNames));
            return this;
        }

        public final void setInstanceNames(Collection<String> instanceNames) {
            this.instanceNames = InstanceNameListCopier.copy(instanceNames);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BatchGetOnPremisesInstancesRequest build() {
            return new BatchGetOnPremisesInstancesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
