/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codedeploy.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about an on-premises instance.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InstanceInfo implements SdkPojo, Serializable, ToCopyableBuilder<InstanceInfo.Builder, InstanceInfo> {
    private static final SdkField<String> INSTANCE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(InstanceInfo::instanceName)).setter(setter(Builder::instanceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instanceName").build()).build();

    private static final SdkField<String> IAM_SESSION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(InstanceInfo::iamSessionArn)).setter(setter(Builder::iamSessionArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("iamSessionArn").build()).build();

    private static final SdkField<String> IAM_USER_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(InstanceInfo::iamUserArn)).setter(setter(Builder::iamUserArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("iamUserArn").build()).build();

    private static final SdkField<String> INSTANCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(InstanceInfo::instanceArn)).setter(setter(Builder::instanceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instanceArn").build()).build();

    private static final SdkField<Instant> REGISTER_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(InstanceInfo::registerTime)).setter(setter(Builder::registerTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("registerTime").build()).build();

    private static final SdkField<Instant> DEREGISTER_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(InstanceInfo::deregisterTime)).setter(setter(Builder::deregisterTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deregisterTime").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .getter(getter(InstanceInfo::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(INSTANCE_NAME_FIELD, IAM_SESSION_ARN_FIELD, IAM_USER_ARN_FIELD, INSTANCE_ARN_FIELD, REGISTER_TIME_FIELD,
                    DEREGISTER_TIME_FIELD, TAGS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String instanceName;

    private final String iamSessionArn;

    private final String iamUserArn;

    private final String instanceArn;

    private final Instant registerTime;

    private final Instant deregisterTime;

    private final List<Tag> tags;

    private InstanceInfo(BuilderImpl builder) {
        this.instanceName = builder.instanceName;
        this.iamSessionArn = builder.iamSessionArn;
        this.iamUserArn = builder.iamUserArn;
        this.instanceArn = builder.instanceArn;
        this.registerTime = builder.registerTime;
        this.deregisterTime = builder.deregisterTime;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The name of the on-premises instance.
     * </p>
     * 
     * @return The name of the on-premises instance.
     */
    public String instanceName() {
        return instanceName;
    }

    /**
     * <p>
     * The ARN of the IAM session associated with the on-premises instance.
     * </p>
     * 
     * @return The ARN of the IAM session associated with the on-premises instance.
     */
    public String iamSessionArn() {
        return iamSessionArn;
    }

    /**
     * <p>
     * The IAM user ARN associated with the on-premises instance.
     * </p>
     * 
     * @return The IAM user ARN associated with the on-premises instance.
     */
    public String iamUserArn() {
        return iamUserArn;
    }

    /**
     * <p>
     * The ARN of the on-premises instance.
     * </p>
     * 
     * @return The ARN of the on-premises instance.
     */
    public String instanceArn() {
        return instanceArn;
    }

    /**
     * <p>
     * The time at which the on-premises instance was registered.
     * </p>
     * 
     * @return The time at which the on-premises instance was registered.
     */
    public Instant registerTime() {
        return registerTime;
    }

    /**
     * <p>
     * If the on-premises instance was deregistered, the time at which the on-premises instance was deregistered.
     * </p>
     * 
     * @return If the on-premises instance was deregistered, the time at which the on-premises instance was
     *         deregistered.
     */
    public Instant deregisterTime() {
        return deregisterTime;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The tags currently associated with the on-premises instance.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The tags currently associated with the on-premises instance.
     */
    public List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(instanceName());
        hashCode = 31 * hashCode + Objects.hashCode(iamSessionArn());
        hashCode = 31 * hashCode + Objects.hashCode(iamUserArn());
        hashCode = 31 * hashCode + Objects.hashCode(instanceArn());
        hashCode = 31 * hashCode + Objects.hashCode(registerTime());
        hashCode = 31 * hashCode + Objects.hashCode(deregisterTime());
        hashCode = 31 * hashCode + Objects.hashCode(tags());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceInfo)) {
            return false;
        }
        InstanceInfo other = (InstanceInfo) obj;
        return Objects.equals(instanceName(), other.instanceName()) && Objects.equals(iamSessionArn(), other.iamSessionArn())
                && Objects.equals(iamUserArn(), other.iamUserArn()) && Objects.equals(instanceArn(), other.instanceArn())
                && Objects.equals(registerTime(), other.registerTime())
                && Objects.equals(deregisterTime(), other.deregisterTime()) && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("InstanceInfo").add("InstanceName", instanceName()).add("IamSessionArn", iamSessionArn())
                .add("IamUserArn", iamUserArn()).add("InstanceArn", instanceArn()).add("RegisterTime", registerTime())
                .add("DeregisterTime", deregisterTime()).add("Tags", tags()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "instanceName":
            return Optional.ofNullable(clazz.cast(instanceName()));
        case "iamSessionArn":
            return Optional.ofNullable(clazz.cast(iamSessionArn()));
        case "iamUserArn":
            return Optional.ofNullable(clazz.cast(iamUserArn()));
        case "instanceArn":
            return Optional.ofNullable(clazz.cast(instanceArn()));
        case "registerTime":
            return Optional.ofNullable(clazz.cast(registerTime()));
        case "deregisterTime":
            return Optional.ofNullable(clazz.cast(deregisterTime()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InstanceInfo, T> g) {
        return obj -> g.apply((InstanceInfo) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InstanceInfo> {
        /**
         * <p>
         * The name of the on-premises instance.
         * </p>
         * 
         * @param instanceName
         *        The name of the on-premises instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceName(String instanceName);

        /**
         * <p>
         * The ARN of the IAM session associated with the on-premises instance.
         * </p>
         * 
         * @param iamSessionArn
         *        The ARN of the IAM session associated with the on-premises instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iamSessionArn(String iamSessionArn);

        /**
         * <p>
         * The IAM user ARN associated with the on-premises instance.
         * </p>
         * 
         * @param iamUserArn
         *        The IAM user ARN associated with the on-premises instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iamUserArn(String iamUserArn);

        /**
         * <p>
         * The ARN of the on-premises instance.
         * </p>
         * 
         * @param instanceArn
         *        The ARN of the on-premises instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceArn(String instanceArn);

        /**
         * <p>
         * The time at which the on-premises instance was registered.
         * </p>
         * 
         * @param registerTime
         *        The time at which the on-premises instance was registered.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder registerTime(Instant registerTime);

        /**
         * <p>
         * If the on-premises instance was deregistered, the time at which the on-premises instance was deregistered.
         * </p>
         * 
         * @param deregisterTime
         *        If the on-premises instance was deregistered, the time at which the on-premises instance was
         *        deregistered.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deregisterTime(Instant deregisterTime);

        /**
         * <p>
         * The tags currently associated with the on-premises instance.
         * </p>
         * 
         * @param tags
         *        The tags currently associated with the on-premises instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * The tags currently associated with the on-premises instance.
         * </p>
         * 
         * @param tags
         *        The tags currently associated with the on-premises instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * The tags currently associated with the on-premises instance.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Tag>.Builder} avoiding the need to create
         * one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);
    }

    static final class BuilderImpl implements Builder {
        private String instanceName;

        private String iamSessionArn;

        private String iamUserArn;

        private String instanceArn;

        private Instant registerTime;

        private Instant deregisterTime;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceInfo model) {
            instanceName(model.instanceName);
            iamSessionArn(model.iamSessionArn);
            iamUserArn(model.iamUserArn);
            instanceArn(model.instanceArn);
            registerTime(model.registerTime);
            deregisterTime(model.deregisterTime);
            tags(model.tags);
        }

        public final String getInstanceName() {
            return instanceName;
        }

        @Override
        public final Builder instanceName(String instanceName) {
            this.instanceName = instanceName;
            return this;
        }

        public final void setInstanceName(String instanceName) {
            this.instanceName = instanceName;
        }

        public final String getIamSessionArn() {
            return iamSessionArn;
        }

        @Override
        public final Builder iamSessionArn(String iamSessionArn) {
            this.iamSessionArn = iamSessionArn;
            return this;
        }

        public final void setIamSessionArn(String iamSessionArn) {
            this.iamSessionArn = iamSessionArn;
        }

        public final String getIamUserArn() {
            return iamUserArn;
        }

        @Override
        public final Builder iamUserArn(String iamUserArn) {
            this.iamUserArn = iamUserArn;
            return this;
        }

        public final void setIamUserArn(String iamUserArn) {
            this.iamUserArn = iamUserArn;
        }

        public final String getInstanceArn() {
            return instanceArn;
        }

        @Override
        public final Builder instanceArn(String instanceArn) {
            this.instanceArn = instanceArn;
            return this;
        }

        public final void setInstanceArn(String instanceArn) {
            this.instanceArn = instanceArn;
        }

        public final Instant getRegisterTime() {
            return registerTime;
        }

        @Override
        public final Builder registerTime(Instant registerTime) {
            this.registerTime = registerTime;
            return this;
        }

        public final void setRegisterTime(Instant registerTime) {
            this.registerTime = registerTime;
        }

        public final Instant getDeregisterTime() {
            return deregisterTime;
        }

        @Override
        public final Builder deregisterTime(Instant deregisterTime) {
            this.deregisterTime = deregisterTime;
            return this;
        }

        public final void setDeregisterTime(Instant deregisterTime) {
            this.deregisterTime = deregisterTime;
        }

        public final Collection<Tag.Builder> getTags() {
            return tags != null ? tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public InstanceInfo build() {
            return new InstanceInfo(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
