/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codedeploy.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about an on-premises instance tag filter.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TagFilter implements SdkPojo, Serializable, ToCopyableBuilder<TagFilter.Builder, TagFilter> {
    private static final SdkField<String> KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(TagFilter::key)).setter(setter(Builder::key))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Key").build()).build();

    private static final SdkField<String> VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(TagFilter::value)).setter(setter(Builder::value))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Value").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(TagFilter::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KEY_FIELD, VALUE_FIELD,
            TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String key;

    private final String value;

    private final String type;

    private TagFilter(BuilderImpl builder) {
        this.key = builder.key;
        this.value = builder.value;
        this.type = builder.type;
    }

    /**
     * <p>
     * The on-premises instance tag filter key.
     * </p>
     * 
     * @return The on-premises instance tag filter key.
     */
    public String key() {
        return key;
    }

    /**
     * <p>
     * The on-premises instance tag filter value.
     * </p>
     * 
     * @return The on-premises instance tag filter value.
     */
    public String value() {
        return value;
    }

    /**
     * <p>
     * The on-premises instance tag filter type:
     * </p>
     * <ul>
     * <li>
     * <p>
     * KEY_ONLY: Key only.
     * </p>
     * </li>
     * <li>
     * <p>
     * VALUE_ONLY: Value only.
     * </p>
     * </li>
     * <li>
     * <p>
     * KEY_AND_VALUE: Key and value.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link TagFilterType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The on-premises instance tag filter type:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         KEY_ONLY: Key only.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         VALUE_ONLY: Value only.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         KEY_AND_VALUE: Key and value.
     *         </p>
     *         </li>
     * @see TagFilterType
     */
    public TagFilterType type() {
        return TagFilterType.fromValue(type);
    }

    /**
     * <p>
     * The on-premises instance tag filter type:
     * </p>
     * <ul>
     * <li>
     * <p>
     * KEY_ONLY: Key only.
     * </p>
     * </li>
     * <li>
     * <p>
     * VALUE_ONLY: Value only.
     * </p>
     * </li>
     * <li>
     * <p>
     * KEY_AND_VALUE: Key and value.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link TagFilterType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The on-premises instance tag filter type:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         KEY_ONLY: Key only.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         VALUE_ONLY: Value only.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         KEY_AND_VALUE: Key and value.
     *         </p>
     *         </li>
     * @see TagFilterType
     */
    public String typeAsString() {
        return type;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(key());
        hashCode = 31 * hashCode + Objects.hashCode(value());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TagFilter)) {
            return false;
        }
        TagFilter other = (TagFilter) obj;
        return Objects.equals(key(), other.key()) && Objects.equals(value(), other.value())
                && Objects.equals(typeAsString(), other.typeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("TagFilter").add("Key", key()).add("Value", value()).add("Type", typeAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Key":
            return Optional.ofNullable(clazz.cast(key()));
        case "Value":
            return Optional.ofNullable(clazz.cast(value()));
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TagFilter, T> g) {
        return obj -> g.apply((TagFilter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TagFilter> {
        /**
         * <p>
         * The on-premises instance tag filter key.
         * </p>
         * 
         * @param key
         *        The on-premises instance tag filter key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder key(String key);

        /**
         * <p>
         * The on-premises instance tag filter value.
         * </p>
         * 
         * @param value
         *        The on-premises instance tag filter value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder value(String value);

        /**
         * <p>
         * The on-premises instance tag filter type:
         * </p>
         * <ul>
         * <li>
         * <p>
         * KEY_ONLY: Key only.
         * </p>
         * </li>
         * <li>
         * <p>
         * VALUE_ONLY: Value only.
         * </p>
         * </li>
         * <li>
         * <p>
         * KEY_AND_VALUE: Key and value.
         * </p>
         * </li>
         * </ul>
         * 
         * @param type
         *        The on-premises instance tag filter type:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        KEY_ONLY: Key only.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        VALUE_ONLY: Value only.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        KEY_AND_VALUE: Key and value.
         *        </p>
         *        </li>
         * @see TagFilterType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TagFilterType
         */
        Builder type(String type);

        /**
         * <p>
         * The on-premises instance tag filter type:
         * </p>
         * <ul>
         * <li>
         * <p>
         * KEY_ONLY: Key only.
         * </p>
         * </li>
         * <li>
         * <p>
         * VALUE_ONLY: Value only.
         * </p>
         * </li>
         * <li>
         * <p>
         * KEY_AND_VALUE: Key and value.
         * </p>
         * </li>
         * </ul>
         * 
         * @param type
         *        The on-premises instance tag filter type:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        KEY_ONLY: Key only.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        VALUE_ONLY: Value only.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        KEY_AND_VALUE: Key and value.
         *        </p>
         *        </li>
         * @see TagFilterType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TagFilterType
         */
        Builder type(TagFilterType type);
    }

    static final class BuilderImpl implements Builder {
        private String key;

        private String value;

        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(TagFilter model) {
            key(model.key);
            value(model.value);
            type(model.type);
        }

        public final String getKey() {
            return key;
        }

        @Override
        public final Builder key(String key) {
            this.key = key;
            return this;
        }

        public final void setKey(String key) {
            this.key = key;
        }

        public final String getValue() {
            return value;
        }

        @Override
        public final Builder value(String value) {
            this.value = value;
            return this;
        }

        public final void setValue(String value) {
            this.value = value;
        }

        public final String getTypeAsString() {
            return type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(TagFilterType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public TagFilter build() {
            return new TagFilter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
