/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codedeploy.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the instances that belong to the replacement environment in a blue/green deployment.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GreenFleetProvisioningOption implements SdkPojo, Serializable,
        ToCopyableBuilder<GreenFleetProvisioningOption.Builder, GreenFleetProvisioningOption> {
    private static final SdkField<String> ACTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GreenFleetProvisioningOption::actionAsString)).setter(setter(Builder::action))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("action").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String action;

    private GreenFleetProvisioningOption(BuilderImpl builder) {
        this.action = builder.action;
    }

    /**
     * <p>
     * The method used to add instances to a replacement environment.
     * </p>
     * <ul>
     * <li>
     * <p>
     * DISCOVER_EXISTING: Use instances that already exist or will be created manually.
     * </p>
     * </li>
     * <li>
     * <p>
     * COPY_AUTO_SCALING_GROUP: Use settings from a specified Auto Scaling group to define and create instances in a new
     * Auto Scaling group.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #action} will
     * return {@link GreenFleetProvisioningAction#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #actionAsString}.
     * </p>
     * 
     * @return The method used to add instances to a replacement environment.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         DISCOVER_EXISTING: Use instances that already exist or will be created manually.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         COPY_AUTO_SCALING_GROUP: Use settings from a specified Auto Scaling group to define and create instances
     *         in a new Auto Scaling group.
     *         </p>
     *         </li>
     * @see GreenFleetProvisioningAction
     */
    public GreenFleetProvisioningAction action() {
        return GreenFleetProvisioningAction.fromValue(action);
    }

    /**
     * <p>
     * The method used to add instances to a replacement environment.
     * </p>
     * <ul>
     * <li>
     * <p>
     * DISCOVER_EXISTING: Use instances that already exist or will be created manually.
     * </p>
     * </li>
     * <li>
     * <p>
     * COPY_AUTO_SCALING_GROUP: Use settings from a specified Auto Scaling group to define and create instances in a new
     * Auto Scaling group.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #action} will
     * return {@link GreenFleetProvisioningAction#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #actionAsString}.
     * </p>
     * 
     * @return The method used to add instances to a replacement environment.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         DISCOVER_EXISTING: Use instances that already exist or will be created manually.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         COPY_AUTO_SCALING_GROUP: Use settings from a specified Auto Scaling group to define and create instances
     *         in a new Auto Scaling group.
     *         </p>
     *         </li>
     * @see GreenFleetProvisioningAction
     */
    public String actionAsString() {
        return action;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(actionAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GreenFleetProvisioningOption)) {
            return false;
        }
        GreenFleetProvisioningOption other = (GreenFleetProvisioningOption) obj;
        return Objects.equals(actionAsString(), other.actionAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GreenFleetProvisioningOption").add("Action", actionAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "action":
            return Optional.ofNullable(clazz.cast(actionAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GreenFleetProvisioningOption, T> g) {
        return obj -> g.apply((GreenFleetProvisioningOption) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, GreenFleetProvisioningOption> {
        /**
         * <p>
         * The method used to add instances to a replacement environment.
         * </p>
         * <ul>
         * <li>
         * <p>
         * DISCOVER_EXISTING: Use instances that already exist or will be created manually.
         * </p>
         * </li>
         * <li>
         * <p>
         * COPY_AUTO_SCALING_GROUP: Use settings from a specified Auto Scaling group to define and create instances in a
         * new Auto Scaling group.
         * </p>
         * </li>
         * </ul>
         * 
         * @param action
         *        The method used to add instances to a replacement environment.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        DISCOVER_EXISTING: Use instances that already exist or will be created manually.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        COPY_AUTO_SCALING_GROUP: Use settings from a specified Auto Scaling group to define and create
         *        instances in a new Auto Scaling group.
         *        </p>
         *        </li>
         * @see GreenFleetProvisioningAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GreenFleetProvisioningAction
         */
        Builder action(String action);

        /**
         * <p>
         * The method used to add instances to a replacement environment.
         * </p>
         * <ul>
         * <li>
         * <p>
         * DISCOVER_EXISTING: Use instances that already exist or will be created manually.
         * </p>
         * </li>
         * <li>
         * <p>
         * COPY_AUTO_SCALING_GROUP: Use settings from a specified Auto Scaling group to define and create instances in a
         * new Auto Scaling group.
         * </p>
         * </li>
         * </ul>
         * 
         * @param action
         *        The method used to add instances to a replacement environment.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        DISCOVER_EXISTING: Use instances that already exist or will be created manually.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        COPY_AUTO_SCALING_GROUP: Use settings from a specified Auto Scaling group to define and create
         *        instances in a new Auto Scaling group.
         *        </p>
         *        </li>
         * @see GreenFleetProvisioningAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GreenFleetProvisioningAction
         */
        Builder action(GreenFleetProvisioningAction action);
    }

    static final class BuilderImpl implements Builder {
        private String action;

        private BuilderImpl() {
        }

        private BuilderImpl(GreenFleetProvisioningOption model) {
            action(model.action);
        }

        public final String getActionAsString() {
            return action;
        }

        @Override
        public final Builder action(String action) {
            this.action = action;
            return this;
        }

        @Override
        public final Builder action(GreenFleetProvisioningAction action) {
            this.action(action == null ? null : action.toString());
            return this;
        }

        public final void setAction(String action) {
            this.action = action;
        }

        @Override
        public GreenFleetProvisioningOption build() {
            return new GreenFleetProvisioningOption(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
