/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codedeploy.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum AutoRollbackEvent {
    DEPLOYMENT_FAILURE("DEPLOYMENT_FAILURE"),
    DEPLOYMENT_STOP_ON_ALARM("DEPLOYMENT_STOP_ON_ALARM"),
    DEPLOYMENT_STOP_ON_REQUEST("DEPLOYMENT_STOP_ON_REQUEST"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private AutoRollbackEvent(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static AutoRollbackEvent fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(AutoRollbackEvent.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<AutoRollbackEvent> knownValues() {
        return Stream.of(AutoRollbackEvent.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

