/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codedeploy.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.codedeploy.model.Alarm;
import software.amazon.awssdk.services.codedeploy.model.AlarmListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AlarmConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AlarmConfiguration> {
    private static final SdkField<Boolean> ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(AlarmConfiguration.getter(AlarmConfiguration::enabled)).setter(AlarmConfiguration.setter(Builder::enabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enabled").build()}).build();
    private static final SdkField<Boolean> IGNORE_POLL_ALARM_FAILURE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(AlarmConfiguration.getter(AlarmConfiguration::ignorePollAlarmFailure)).setter(AlarmConfiguration.setter(Builder::ignorePollAlarmFailure)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ignorePollAlarmFailure").build()}).build();
    private static final SdkField<List<Alarm>> ALARMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(AlarmConfiguration.getter(AlarmConfiguration::alarms)).setter(AlarmConfiguration.setter(Builder::alarms)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("alarms").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Alarm::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENABLED_FIELD, IGNORE_POLL_ALARM_FAILURE_FIELD, ALARMS_FIELD));
    private static final long serialVersionUID = 1L;
    private final Boolean enabled;
    private final Boolean ignorePollAlarmFailure;
    private final List<Alarm> alarms;

    private AlarmConfiguration(BuilderImpl builder) {
        this.enabled = builder.enabled;
        this.ignorePollAlarmFailure = builder.ignorePollAlarmFailure;
        this.alarms = builder.alarms;
    }

    public Boolean enabled() {
        return this.enabled;
    }

    public Boolean ignorePollAlarmFailure() {
        return this.ignorePollAlarmFailure;
    }

    public boolean hasAlarms() {
        return this.alarms != null && !(this.alarms instanceof SdkAutoConstructList);
    }

    public List<Alarm> alarms() {
        return this.alarms;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.enabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.ignorePollAlarmFailure());
        hashCode = 31 * hashCode + Objects.hashCode(this.alarms());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AlarmConfiguration)) {
            return false;
        }
        AlarmConfiguration other = (AlarmConfiguration)obj;
        return Objects.equals(this.enabled(), other.enabled()) && Objects.equals(this.ignorePollAlarmFailure(), other.ignorePollAlarmFailure()) && Objects.equals(this.alarms(), other.alarms());
    }

    public String toString() {
        return ToString.builder((String)"AlarmConfiguration").add("Enabled", (Object)this.enabled()).add("IgnorePollAlarmFailure", (Object)this.ignorePollAlarmFailure()).add("Alarms", this.alarms()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "enabled": {
                return Optional.ofNullable(clazz.cast(this.enabled()));
            }
            case "ignorePollAlarmFailure": {
                return Optional.ofNullable(clazz.cast(this.ignorePollAlarmFailure()));
            }
            case "alarms": {
                return Optional.ofNullable(clazz.cast(this.alarms()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AlarmConfiguration, T> g) {
        return obj -> g.apply((AlarmConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean enabled;
        private Boolean ignorePollAlarmFailure;
        private List<Alarm> alarms = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AlarmConfiguration model) {
            this.enabled(model.enabled);
            this.ignorePollAlarmFailure(model.ignorePollAlarmFailure);
            this.alarms(model.alarms);
        }

        public final Boolean getEnabled() {
            return this.enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        public final Boolean getIgnorePollAlarmFailure() {
            return this.ignorePollAlarmFailure;
        }

        @Override
        public final Builder ignorePollAlarmFailure(Boolean ignorePollAlarmFailure) {
            this.ignorePollAlarmFailure = ignorePollAlarmFailure;
            return this;
        }

        public final void setIgnorePollAlarmFailure(Boolean ignorePollAlarmFailure) {
            this.ignorePollAlarmFailure = ignorePollAlarmFailure;
        }

        public final Collection<Alarm.Builder> getAlarms() {
            return this.alarms != null ? (Collection)this.alarms.stream().map(Alarm::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder alarms(Collection<Alarm> alarms) {
            this.alarms = AlarmListCopier.copy(alarms);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder alarms(Alarm ... alarms) {
            this.alarms(Arrays.asList(alarms));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder alarms(Consumer<Alarm.Builder> ... alarms) {
            this.alarms(Stream.of(alarms).map(c -> (Alarm)((Alarm.Builder)Alarm.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAlarms(Collection<Alarm.BuilderImpl> alarms) {
            this.alarms = AlarmListCopier.copyFromBuilder(alarms);
        }

        public AlarmConfiguration build() {
            return new AlarmConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AlarmConfiguration> {
        public Builder enabled(Boolean var1);

        public Builder ignorePollAlarmFailure(Boolean var1);

        public Builder alarms(Collection<Alarm> var1);

        public Builder alarms(Alarm ... var1);

        public Builder alarms(Consumer<Alarm.Builder> ... var1);
    }
}

