/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codedeploy.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.codedeploy.model.AlarmConfiguration;
import software.amazon.awssdk.services.codedeploy.model.AutoRollbackConfiguration;
import software.amazon.awssdk.services.codedeploy.model.AutoScalingGroup;
import software.amazon.awssdk.services.codedeploy.model.AutoScalingGroupListCopier;
import software.amazon.awssdk.services.codedeploy.model.BlueGreenDeploymentConfiguration;
import software.amazon.awssdk.services.codedeploy.model.ComputePlatform;
import software.amazon.awssdk.services.codedeploy.model.DeploymentStyle;
import software.amazon.awssdk.services.codedeploy.model.EC2TagFilter;
import software.amazon.awssdk.services.codedeploy.model.EC2TagFilterListCopier;
import software.amazon.awssdk.services.codedeploy.model.EC2TagSet;
import software.amazon.awssdk.services.codedeploy.model.ECSService;
import software.amazon.awssdk.services.codedeploy.model.ECSServiceListCopier;
import software.amazon.awssdk.services.codedeploy.model.LastDeploymentInfo;
import software.amazon.awssdk.services.codedeploy.model.LoadBalancerInfo;
import software.amazon.awssdk.services.codedeploy.model.OnPremisesTagSet;
import software.amazon.awssdk.services.codedeploy.model.RevisionLocation;
import software.amazon.awssdk.services.codedeploy.model.TagFilter;
import software.amazon.awssdk.services.codedeploy.model.TagFilterListCopier;
import software.amazon.awssdk.services.codedeploy.model.TriggerConfig;
import software.amazon.awssdk.services.codedeploy.model.TriggerConfigListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeploymentGroupInfo
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DeploymentGroupInfo> {
    private static final SdkField<String> APPLICATION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DeploymentGroupInfo.getter(DeploymentGroupInfo::applicationName)).setter(DeploymentGroupInfo.setter(Builder::applicationName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("applicationName").build()}).build();
    private static final SdkField<String> DEPLOYMENT_GROUP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DeploymentGroupInfo.getter(DeploymentGroupInfo::deploymentGroupId)).setter(DeploymentGroupInfo.setter(Builder::deploymentGroupId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deploymentGroupId").build()}).build();
    private static final SdkField<String> DEPLOYMENT_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DeploymentGroupInfo.getter(DeploymentGroupInfo::deploymentGroupName)).setter(DeploymentGroupInfo.setter(Builder::deploymentGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deploymentGroupName").build()}).build();
    private static final SdkField<String> DEPLOYMENT_CONFIG_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DeploymentGroupInfo.getter(DeploymentGroupInfo::deploymentConfigName)).setter(DeploymentGroupInfo.setter(Builder::deploymentConfigName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deploymentConfigName").build()}).build();
    private static final SdkField<List<EC2TagFilter>> EC2_TAG_FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(DeploymentGroupInfo.getter(DeploymentGroupInfo::ec2TagFilters)).setter(DeploymentGroupInfo.setter(Builder::ec2TagFilters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ec2TagFilters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(EC2TagFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<TagFilter>> ON_PREMISES_INSTANCE_TAG_FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(DeploymentGroupInfo.getter(DeploymentGroupInfo::onPremisesInstanceTagFilters)).setter(DeploymentGroupInfo.setter(Builder::onPremisesInstanceTagFilters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("onPremisesInstanceTagFilters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TagFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<AutoScalingGroup>> AUTO_SCALING_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(DeploymentGroupInfo.getter(DeploymentGroupInfo::autoScalingGroups)).setter(DeploymentGroupInfo.setter(Builder::autoScalingGroups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("autoScalingGroups").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AutoScalingGroup::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> SERVICE_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DeploymentGroupInfo.getter(DeploymentGroupInfo::serviceRoleArn)).setter(DeploymentGroupInfo.setter(Builder::serviceRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceRoleArn").build()}).build();
    private static final SdkField<RevisionLocation> TARGET_REVISION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(DeploymentGroupInfo.getter(DeploymentGroupInfo::targetRevision)).setter(DeploymentGroupInfo.setter(Builder::targetRevision)).constructor(RevisionLocation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetRevision").build()}).build();
    private static final SdkField<List<TriggerConfig>> TRIGGER_CONFIGURATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(DeploymentGroupInfo.getter(DeploymentGroupInfo::triggerConfigurations)).setter(DeploymentGroupInfo.setter(Builder::triggerConfigurations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("triggerConfigurations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TriggerConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<AlarmConfiguration> ALARM_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(DeploymentGroupInfo.getter(DeploymentGroupInfo::alarmConfiguration)).setter(DeploymentGroupInfo.setter(Builder::alarmConfiguration)).constructor(AlarmConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("alarmConfiguration").build()}).build();
    private static final SdkField<AutoRollbackConfiguration> AUTO_ROLLBACK_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(DeploymentGroupInfo.getter(DeploymentGroupInfo::autoRollbackConfiguration)).setter(DeploymentGroupInfo.setter(Builder::autoRollbackConfiguration)).constructor(AutoRollbackConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("autoRollbackConfiguration").build()}).build();
    private static final SdkField<DeploymentStyle> DEPLOYMENT_STYLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(DeploymentGroupInfo.getter(DeploymentGroupInfo::deploymentStyle)).setter(DeploymentGroupInfo.setter(Builder::deploymentStyle)).constructor(DeploymentStyle::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deploymentStyle").build()}).build();
    private static final SdkField<BlueGreenDeploymentConfiguration> BLUE_GREEN_DEPLOYMENT_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(DeploymentGroupInfo.getter(DeploymentGroupInfo::blueGreenDeploymentConfiguration)).setter(DeploymentGroupInfo.setter(Builder::blueGreenDeploymentConfiguration)).constructor(BlueGreenDeploymentConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("blueGreenDeploymentConfiguration").build()}).build();
    private static final SdkField<LoadBalancerInfo> LOAD_BALANCER_INFO_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(DeploymentGroupInfo.getter(DeploymentGroupInfo::loadBalancerInfo)).setter(DeploymentGroupInfo.setter(Builder::loadBalancerInfo)).constructor(LoadBalancerInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("loadBalancerInfo").build()}).build();
    private static final SdkField<LastDeploymentInfo> LAST_SUCCESSFUL_DEPLOYMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(DeploymentGroupInfo.getter(DeploymentGroupInfo::lastSuccessfulDeployment)).setter(DeploymentGroupInfo.setter(Builder::lastSuccessfulDeployment)).constructor(LastDeploymentInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastSuccessfulDeployment").build()}).build();
    private static final SdkField<LastDeploymentInfo> LAST_ATTEMPTED_DEPLOYMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(DeploymentGroupInfo.getter(DeploymentGroupInfo::lastAttemptedDeployment)).setter(DeploymentGroupInfo.setter(Builder::lastAttemptedDeployment)).constructor(LastDeploymentInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastAttemptedDeployment").build()}).build();
    private static final SdkField<EC2TagSet> EC2_TAG_SET_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(DeploymentGroupInfo.getter(DeploymentGroupInfo::ec2TagSet)).setter(DeploymentGroupInfo.setter(Builder::ec2TagSet)).constructor(EC2TagSet::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ec2TagSet").build()}).build();
    private static final SdkField<OnPremisesTagSet> ON_PREMISES_TAG_SET_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(DeploymentGroupInfo.getter(DeploymentGroupInfo::onPremisesTagSet)).setter(DeploymentGroupInfo.setter(Builder::onPremisesTagSet)).constructor(OnPremisesTagSet::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("onPremisesTagSet").build()}).build();
    private static final SdkField<String> COMPUTE_PLATFORM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DeploymentGroupInfo.getter(DeploymentGroupInfo::computePlatformAsString)).setter(DeploymentGroupInfo.setter(Builder::computePlatform)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("computePlatform").build()}).build();
    private static final SdkField<List<ECSService>> ECS_SERVICES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(DeploymentGroupInfo.getter(DeploymentGroupInfo::ecsServices)).setter(DeploymentGroupInfo.setter(Builder::ecsServices)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ecsServices").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ECSService::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_NAME_FIELD, DEPLOYMENT_GROUP_ID_FIELD, DEPLOYMENT_GROUP_NAME_FIELD, DEPLOYMENT_CONFIG_NAME_FIELD, EC2_TAG_FILTERS_FIELD, ON_PREMISES_INSTANCE_TAG_FILTERS_FIELD, AUTO_SCALING_GROUPS_FIELD, SERVICE_ROLE_ARN_FIELD, TARGET_REVISION_FIELD, TRIGGER_CONFIGURATIONS_FIELD, ALARM_CONFIGURATION_FIELD, AUTO_ROLLBACK_CONFIGURATION_FIELD, DEPLOYMENT_STYLE_FIELD, BLUE_GREEN_DEPLOYMENT_CONFIGURATION_FIELD, LOAD_BALANCER_INFO_FIELD, LAST_SUCCESSFUL_DEPLOYMENT_FIELD, LAST_ATTEMPTED_DEPLOYMENT_FIELD, EC2_TAG_SET_FIELD, ON_PREMISES_TAG_SET_FIELD, COMPUTE_PLATFORM_FIELD, ECS_SERVICES_FIELD));
    private static final long serialVersionUID = 1L;
    private final String applicationName;
    private final String deploymentGroupId;
    private final String deploymentGroupName;
    private final String deploymentConfigName;
    private final List<EC2TagFilter> ec2TagFilters;
    private final List<TagFilter> onPremisesInstanceTagFilters;
    private final List<AutoScalingGroup> autoScalingGroups;
    private final String serviceRoleArn;
    private final RevisionLocation targetRevision;
    private final List<TriggerConfig> triggerConfigurations;
    private final AlarmConfiguration alarmConfiguration;
    private final AutoRollbackConfiguration autoRollbackConfiguration;
    private final DeploymentStyle deploymentStyle;
    private final BlueGreenDeploymentConfiguration blueGreenDeploymentConfiguration;
    private final LoadBalancerInfo loadBalancerInfo;
    private final LastDeploymentInfo lastSuccessfulDeployment;
    private final LastDeploymentInfo lastAttemptedDeployment;
    private final EC2TagSet ec2TagSet;
    private final OnPremisesTagSet onPremisesTagSet;
    private final String computePlatform;
    private final List<ECSService> ecsServices;

    private DeploymentGroupInfo(BuilderImpl builder) {
        this.applicationName = builder.applicationName;
        this.deploymentGroupId = builder.deploymentGroupId;
        this.deploymentGroupName = builder.deploymentGroupName;
        this.deploymentConfigName = builder.deploymentConfigName;
        this.ec2TagFilters = builder.ec2TagFilters;
        this.onPremisesInstanceTagFilters = builder.onPremisesInstanceTagFilters;
        this.autoScalingGroups = builder.autoScalingGroups;
        this.serviceRoleArn = builder.serviceRoleArn;
        this.targetRevision = builder.targetRevision;
        this.triggerConfigurations = builder.triggerConfigurations;
        this.alarmConfiguration = builder.alarmConfiguration;
        this.autoRollbackConfiguration = builder.autoRollbackConfiguration;
        this.deploymentStyle = builder.deploymentStyle;
        this.blueGreenDeploymentConfiguration = builder.blueGreenDeploymentConfiguration;
        this.loadBalancerInfo = builder.loadBalancerInfo;
        this.lastSuccessfulDeployment = builder.lastSuccessfulDeployment;
        this.lastAttemptedDeployment = builder.lastAttemptedDeployment;
        this.ec2TagSet = builder.ec2TagSet;
        this.onPremisesTagSet = builder.onPremisesTagSet;
        this.computePlatform = builder.computePlatform;
        this.ecsServices = builder.ecsServices;
    }

    public String applicationName() {
        return this.applicationName;
    }

    public String deploymentGroupId() {
        return this.deploymentGroupId;
    }

    public String deploymentGroupName() {
        return this.deploymentGroupName;
    }

    public String deploymentConfigName() {
        return this.deploymentConfigName;
    }

    public boolean hasEc2TagFilters() {
        return this.ec2TagFilters != null && !(this.ec2TagFilters instanceof SdkAutoConstructList);
    }

    public List<EC2TagFilter> ec2TagFilters() {
        return this.ec2TagFilters;
    }

    public boolean hasOnPremisesInstanceTagFilters() {
        return this.onPremisesInstanceTagFilters != null && !(this.onPremisesInstanceTagFilters instanceof SdkAutoConstructList);
    }

    public List<TagFilter> onPremisesInstanceTagFilters() {
        return this.onPremisesInstanceTagFilters;
    }

    public boolean hasAutoScalingGroups() {
        return this.autoScalingGroups != null && !(this.autoScalingGroups instanceof SdkAutoConstructList);
    }

    public List<AutoScalingGroup> autoScalingGroups() {
        return this.autoScalingGroups;
    }

    public String serviceRoleArn() {
        return this.serviceRoleArn;
    }

    public RevisionLocation targetRevision() {
        return this.targetRevision;
    }

    public boolean hasTriggerConfigurations() {
        return this.triggerConfigurations != null && !(this.triggerConfigurations instanceof SdkAutoConstructList);
    }

    public List<TriggerConfig> triggerConfigurations() {
        return this.triggerConfigurations;
    }

    public AlarmConfiguration alarmConfiguration() {
        return this.alarmConfiguration;
    }

    public AutoRollbackConfiguration autoRollbackConfiguration() {
        return this.autoRollbackConfiguration;
    }

    public DeploymentStyle deploymentStyle() {
        return this.deploymentStyle;
    }

    public BlueGreenDeploymentConfiguration blueGreenDeploymentConfiguration() {
        return this.blueGreenDeploymentConfiguration;
    }

    public LoadBalancerInfo loadBalancerInfo() {
        return this.loadBalancerInfo;
    }

    public LastDeploymentInfo lastSuccessfulDeployment() {
        return this.lastSuccessfulDeployment;
    }

    public LastDeploymentInfo lastAttemptedDeployment() {
        return this.lastAttemptedDeployment;
    }

    public EC2TagSet ec2TagSet() {
        return this.ec2TagSet;
    }

    public OnPremisesTagSet onPremisesTagSet() {
        return this.onPremisesTagSet;
    }

    public ComputePlatform computePlatform() {
        return ComputePlatform.fromValue(this.computePlatform);
    }

    public String computePlatformAsString() {
        return this.computePlatform;
    }

    public boolean hasEcsServices() {
        return this.ecsServices != null && !(this.ecsServices instanceof SdkAutoConstructList);
    }

    public List<ECSService> ecsServices() {
        return this.ecsServices;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationName());
        hashCode = 31 * hashCode + Objects.hashCode(this.deploymentGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(this.deploymentGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.deploymentConfigName());
        hashCode = 31 * hashCode + Objects.hashCode(this.ec2TagFilters());
        hashCode = 31 * hashCode + Objects.hashCode(this.onPremisesInstanceTagFilters());
        hashCode = 31 * hashCode + Objects.hashCode(this.autoScalingGroups());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetRevision());
        hashCode = 31 * hashCode + Objects.hashCode(this.triggerConfigurations());
        hashCode = 31 * hashCode + Objects.hashCode(this.alarmConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.autoRollbackConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.deploymentStyle());
        hashCode = 31 * hashCode + Objects.hashCode(this.blueGreenDeploymentConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.loadBalancerInfo());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastSuccessfulDeployment());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastAttemptedDeployment());
        hashCode = 31 * hashCode + Objects.hashCode(this.ec2TagSet());
        hashCode = 31 * hashCode + Objects.hashCode(this.onPremisesTagSet());
        hashCode = 31 * hashCode + Objects.hashCode(this.computePlatformAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.ecsServices());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeploymentGroupInfo)) {
            return false;
        }
        DeploymentGroupInfo other = (DeploymentGroupInfo)obj;
        return Objects.equals(this.applicationName(), other.applicationName()) && Objects.equals(this.deploymentGroupId(), other.deploymentGroupId()) && Objects.equals(this.deploymentGroupName(), other.deploymentGroupName()) && Objects.equals(this.deploymentConfigName(), other.deploymentConfigName()) && Objects.equals(this.ec2TagFilters(), other.ec2TagFilters()) && Objects.equals(this.onPremisesInstanceTagFilters(), other.onPremisesInstanceTagFilters()) && Objects.equals(this.autoScalingGroups(), other.autoScalingGroups()) && Objects.equals(this.serviceRoleArn(), other.serviceRoleArn()) && Objects.equals(this.targetRevision(), other.targetRevision()) && Objects.equals(this.triggerConfigurations(), other.triggerConfigurations()) && Objects.equals(this.alarmConfiguration(), other.alarmConfiguration()) && Objects.equals(this.autoRollbackConfiguration(), other.autoRollbackConfiguration()) && Objects.equals(this.deploymentStyle(), other.deploymentStyle()) && Objects.equals(this.blueGreenDeploymentConfiguration(), other.blueGreenDeploymentConfiguration()) && Objects.equals(this.loadBalancerInfo(), other.loadBalancerInfo()) && Objects.equals(this.lastSuccessfulDeployment(), other.lastSuccessfulDeployment()) && Objects.equals(this.lastAttemptedDeployment(), other.lastAttemptedDeployment()) && Objects.equals(this.ec2TagSet(), other.ec2TagSet()) && Objects.equals(this.onPremisesTagSet(), other.onPremisesTagSet()) && Objects.equals(this.computePlatformAsString(), other.computePlatformAsString()) && Objects.equals(this.ecsServices(), other.ecsServices());
    }

    public String toString() {
        return ToString.builder((String)"DeploymentGroupInfo").add("ApplicationName", (Object)this.applicationName()).add("DeploymentGroupId", (Object)this.deploymentGroupId()).add("DeploymentGroupName", (Object)this.deploymentGroupName()).add("DeploymentConfigName", (Object)this.deploymentConfigName()).add("Ec2TagFilters", this.ec2TagFilters()).add("OnPremisesInstanceTagFilters", this.onPremisesInstanceTagFilters()).add("AutoScalingGroups", this.autoScalingGroups()).add("ServiceRoleArn", (Object)this.serviceRoleArn()).add("TargetRevision", (Object)this.targetRevision()).add("TriggerConfigurations", this.triggerConfigurations()).add("AlarmConfiguration", (Object)this.alarmConfiguration()).add("AutoRollbackConfiguration", (Object)this.autoRollbackConfiguration()).add("DeploymentStyle", (Object)this.deploymentStyle()).add("BlueGreenDeploymentConfiguration", (Object)this.blueGreenDeploymentConfiguration()).add("LoadBalancerInfo", (Object)this.loadBalancerInfo()).add("LastSuccessfulDeployment", (Object)this.lastSuccessfulDeployment()).add("LastAttemptedDeployment", (Object)this.lastAttemptedDeployment()).add("Ec2TagSet", (Object)this.ec2TagSet()).add("OnPremisesTagSet", (Object)this.onPremisesTagSet()).add("ComputePlatform", (Object)this.computePlatformAsString()).add("EcsServices", this.ecsServices()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "applicationName": {
                return Optional.ofNullable(clazz.cast(this.applicationName()));
            }
            case "deploymentGroupId": {
                return Optional.ofNullable(clazz.cast(this.deploymentGroupId()));
            }
            case "deploymentGroupName": {
                return Optional.ofNullable(clazz.cast(this.deploymentGroupName()));
            }
            case "deploymentConfigName": {
                return Optional.ofNullable(clazz.cast(this.deploymentConfigName()));
            }
            case "ec2TagFilters": {
                return Optional.ofNullable(clazz.cast(this.ec2TagFilters()));
            }
            case "onPremisesInstanceTagFilters": {
                return Optional.ofNullable(clazz.cast(this.onPremisesInstanceTagFilters()));
            }
            case "autoScalingGroups": {
                return Optional.ofNullable(clazz.cast(this.autoScalingGroups()));
            }
            case "serviceRoleArn": {
                return Optional.ofNullable(clazz.cast(this.serviceRoleArn()));
            }
            case "targetRevision": {
                return Optional.ofNullable(clazz.cast(this.targetRevision()));
            }
            case "triggerConfigurations": {
                return Optional.ofNullable(clazz.cast(this.triggerConfigurations()));
            }
            case "alarmConfiguration": {
                return Optional.ofNullable(clazz.cast(this.alarmConfiguration()));
            }
            case "autoRollbackConfiguration": {
                return Optional.ofNullable(clazz.cast(this.autoRollbackConfiguration()));
            }
            case "deploymentStyle": {
                return Optional.ofNullable(clazz.cast(this.deploymentStyle()));
            }
            case "blueGreenDeploymentConfiguration": {
                return Optional.ofNullable(clazz.cast(this.blueGreenDeploymentConfiguration()));
            }
            case "loadBalancerInfo": {
                return Optional.ofNullable(clazz.cast(this.loadBalancerInfo()));
            }
            case "lastSuccessfulDeployment": {
                return Optional.ofNullable(clazz.cast(this.lastSuccessfulDeployment()));
            }
            case "lastAttemptedDeployment": {
                return Optional.ofNullable(clazz.cast(this.lastAttemptedDeployment()));
            }
            case "ec2TagSet": {
                return Optional.ofNullable(clazz.cast(this.ec2TagSet()));
            }
            case "onPremisesTagSet": {
                return Optional.ofNullable(clazz.cast(this.onPremisesTagSet()));
            }
            case "computePlatform": {
                return Optional.ofNullable(clazz.cast(this.computePlatformAsString()));
            }
            case "ecsServices": {
                return Optional.ofNullable(clazz.cast(this.ecsServices()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeploymentGroupInfo, T> g) {
        return obj -> g.apply((DeploymentGroupInfo)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String applicationName;
        private String deploymentGroupId;
        private String deploymentGroupName;
        private String deploymentConfigName;
        private List<EC2TagFilter> ec2TagFilters = DefaultSdkAutoConstructList.getInstance();
        private List<TagFilter> onPremisesInstanceTagFilters = DefaultSdkAutoConstructList.getInstance();
        private List<AutoScalingGroup> autoScalingGroups = DefaultSdkAutoConstructList.getInstance();
        private String serviceRoleArn;
        private RevisionLocation targetRevision;
        private List<TriggerConfig> triggerConfigurations = DefaultSdkAutoConstructList.getInstance();
        private AlarmConfiguration alarmConfiguration;
        private AutoRollbackConfiguration autoRollbackConfiguration;
        private DeploymentStyle deploymentStyle;
        private BlueGreenDeploymentConfiguration blueGreenDeploymentConfiguration;
        private LoadBalancerInfo loadBalancerInfo;
        private LastDeploymentInfo lastSuccessfulDeployment;
        private LastDeploymentInfo lastAttemptedDeployment;
        private EC2TagSet ec2TagSet;
        private OnPremisesTagSet onPremisesTagSet;
        private String computePlatform;
        private List<ECSService> ecsServices = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DeploymentGroupInfo model) {
            this.applicationName(model.applicationName);
            this.deploymentGroupId(model.deploymentGroupId);
            this.deploymentGroupName(model.deploymentGroupName);
            this.deploymentConfigName(model.deploymentConfigName);
            this.ec2TagFilters(model.ec2TagFilters);
            this.onPremisesInstanceTagFilters(model.onPremisesInstanceTagFilters);
            this.autoScalingGroups(model.autoScalingGroups);
            this.serviceRoleArn(model.serviceRoleArn);
            this.targetRevision(model.targetRevision);
            this.triggerConfigurations(model.triggerConfigurations);
            this.alarmConfiguration(model.alarmConfiguration);
            this.autoRollbackConfiguration(model.autoRollbackConfiguration);
            this.deploymentStyle(model.deploymentStyle);
            this.blueGreenDeploymentConfiguration(model.blueGreenDeploymentConfiguration);
            this.loadBalancerInfo(model.loadBalancerInfo);
            this.lastSuccessfulDeployment(model.lastSuccessfulDeployment);
            this.lastAttemptedDeployment(model.lastAttemptedDeployment);
            this.ec2TagSet(model.ec2TagSet);
            this.onPremisesTagSet(model.onPremisesTagSet);
            this.computePlatform(model.computePlatform);
            this.ecsServices(model.ecsServices);
        }

        public final String getApplicationName() {
            return this.applicationName;
        }

        @Override
        public final Builder applicationName(String applicationName) {
            this.applicationName = applicationName;
            return this;
        }

        public final void setApplicationName(String applicationName) {
            this.applicationName = applicationName;
        }

        public final String getDeploymentGroupId() {
            return this.deploymentGroupId;
        }

        @Override
        public final Builder deploymentGroupId(String deploymentGroupId) {
            this.deploymentGroupId = deploymentGroupId;
            return this;
        }

        public final void setDeploymentGroupId(String deploymentGroupId) {
            this.deploymentGroupId = deploymentGroupId;
        }

        public final String getDeploymentGroupName() {
            return this.deploymentGroupName;
        }

        @Override
        public final Builder deploymentGroupName(String deploymentGroupName) {
            this.deploymentGroupName = deploymentGroupName;
            return this;
        }

        public final void setDeploymentGroupName(String deploymentGroupName) {
            this.deploymentGroupName = deploymentGroupName;
        }

        public final String getDeploymentConfigName() {
            return this.deploymentConfigName;
        }

        @Override
        public final Builder deploymentConfigName(String deploymentConfigName) {
            this.deploymentConfigName = deploymentConfigName;
            return this;
        }

        public final void setDeploymentConfigName(String deploymentConfigName) {
            this.deploymentConfigName = deploymentConfigName;
        }

        public final Collection<EC2TagFilter.Builder> getEc2TagFilters() {
            return this.ec2TagFilters != null ? (Collection)this.ec2TagFilters.stream().map(EC2TagFilter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder ec2TagFilters(Collection<EC2TagFilter> ec2TagFilters) {
            this.ec2TagFilters = EC2TagFilterListCopier.copy(ec2TagFilters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ec2TagFilters(EC2TagFilter ... ec2TagFilters) {
            this.ec2TagFilters(Arrays.asList(ec2TagFilters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ec2TagFilters(Consumer<EC2TagFilter.Builder> ... ec2TagFilters) {
            this.ec2TagFilters(Stream.of(ec2TagFilters).map(c -> (EC2TagFilter)((EC2TagFilter.Builder)EC2TagFilter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setEc2TagFilters(Collection<EC2TagFilter.BuilderImpl> ec2TagFilters) {
            this.ec2TagFilters = EC2TagFilterListCopier.copyFromBuilder(ec2TagFilters);
        }

        public final Collection<TagFilter.Builder> getOnPremisesInstanceTagFilters() {
            return this.onPremisesInstanceTagFilters != null ? (Collection)this.onPremisesInstanceTagFilters.stream().map(TagFilter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder onPremisesInstanceTagFilters(Collection<TagFilter> onPremisesInstanceTagFilters) {
            this.onPremisesInstanceTagFilters = TagFilterListCopier.copy(onPremisesInstanceTagFilters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder onPremisesInstanceTagFilters(TagFilter ... onPremisesInstanceTagFilters) {
            this.onPremisesInstanceTagFilters(Arrays.asList(onPremisesInstanceTagFilters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder onPremisesInstanceTagFilters(Consumer<TagFilter.Builder> ... onPremisesInstanceTagFilters) {
            this.onPremisesInstanceTagFilters(Stream.of(onPremisesInstanceTagFilters).map(c -> (TagFilter)((TagFilter.Builder)TagFilter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setOnPremisesInstanceTagFilters(Collection<TagFilter.BuilderImpl> onPremisesInstanceTagFilters) {
            this.onPremisesInstanceTagFilters = TagFilterListCopier.copyFromBuilder(onPremisesInstanceTagFilters);
        }

        public final Collection<AutoScalingGroup.Builder> getAutoScalingGroups() {
            return this.autoScalingGroups != null ? (Collection)this.autoScalingGroups.stream().map(AutoScalingGroup::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder autoScalingGroups(Collection<AutoScalingGroup> autoScalingGroups) {
            this.autoScalingGroups = AutoScalingGroupListCopier.copy(autoScalingGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder autoScalingGroups(AutoScalingGroup ... autoScalingGroups) {
            this.autoScalingGroups(Arrays.asList(autoScalingGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder autoScalingGroups(Consumer<AutoScalingGroup.Builder> ... autoScalingGroups) {
            this.autoScalingGroups(Stream.of(autoScalingGroups).map(c -> (AutoScalingGroup)((AutoScalingGroup.Builder)AutoScalingGroup.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAutoScalingGroups(Collection<AutoScalingGroup.BuilderImpl> autoScalingGroups) {
            this.autoScalingGroups = AutoScalingGroupListCopier.copyFromBuilder(autoScalingGroups);
        }

        public final String getServiceRoleArn() {
            return this.serviceRoleArn;
        }

        @Override
        public final Builder serviceRoleArn(String serviceRoleArn) {
            this.serviceRoleArn = serviceRoleArn;
            return this;
        }

        public final void setServiceRoleArn(String serviceRoleArn) {
            this.serviceRoleArn = serviceRoleArn;
        }

        public final RevisionLocation.Builder getTargetRevision() {
            return this.targetRevision != null ? this.targetRevision.toBuilder() : null;
        }

        @Override
        public final Builder targetRevision(RevisionLocation targetRevision) {
            this.targetRevision = targetRevision;
            return this;
        }

        public final void setTargetRevision(RevisionLocation.BuilderImpl targetRevision) {
            this.targetRevision = targetRevision != null ? targetRevision.build() : null;
        }

        public final Collection<TriggerConfig.Builder> getTriggerConfigurations() {
            return this.triggerConfigurations != null ? (Collection)this.triggerConfigurations.stream().map(TriggerConfig::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder triggerConfigurations(Collection<TriggerConfig> triggerConfigurations) {
            this.triggerConfigurations = TriggerConfigListCopier.copy(triggerConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder triggerConfigurations(TriggerConfig ... triggerConfigurations) {
            this.triggerConfigurations(Arrays.asList(triggerConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder triggerConfigurations(Consumer<TriggerConfig.Builder> ... triggerConfigurations) {
            this.triggerConfigurations(Stream.of(triggerConfigurations).map(c -> (TriggerConfig)((TriggerConfig.Builder)TriggerConfig.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTriggerConfigurations(Collection<TriggerConfig.BuilderImpl> triggerConfigurations) {
            this.triggerConfigurations = TriggerConfigListCopier.copyFromBuilder(triggerConfigurations);
        }

        public final AlarmConfiguration.Builder getAlarmConfiguration() {
            return this.alarmConfiguration != null ? this.alarmConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder alarmConfiguration(AlarmConfiguration alarmConfiguration) {
            this.alarmConfiguration = alarmConfiguration;
            return this;
        }

        public final void setAlarmConfiguration(AlarmConfiguration.BuilderImpl alarmConfiguration) {
            this.alarmConfiguration = alarmConfiguration != null ? alarmConfiguration.build() : null;
        }

        public final AutoRollbackConfiguration.Builder getAutoRollbackConfiguration() {
            return this.autoRollbackConfiguration != null ? this.autoRollbackConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder autoRollbackConfiguration(AutoRollbackConfiguration autoRollbackConfiguration) {
            this.autoRollbackConfiguration = autoRollbackConfiguration;
            return this;
        }

        public final void setAutoRollbackConfiguration(AutoRollbackConfiguration.BuilderImpl autoRollbackConfiguration) {
            this.autoRollbackConfiguration = autoRollbackConfiguration != null ? autoRollbackConfiguration.build() : null;
        }

        public final DeploymentStyle.Builder getDeploymentStyle() {
            return this.deploymentStyle != null ? this.deploymentStyle.toBuilder() : null;
        }

        @Override
        public final Builder deploymentStyle(DeploymentStyle deploymentStyle) {
            this.deploymentStyle = deploymentStyle;
            return this;
        }

        public final void setDeploymentStyle(DeploymentStyle.BuilderImpl deploymentStyle) {
            this.deploymentStyle = deploymentStyle != null ? deploymentStyle.build() : null;
        }

        public final BlueGreenDeploymentConfiguration.Builder getBlueGreenDeploymentConfiguration() {
            return this.blueGreenDeploymentConfiguration != null ? this.blueGreenDeploymentConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder blueGreenDeploymentConfiguration(BlueGreenDeploymentConfiguration blueGreenDeploymentConfiguration) {
            this.blueGreenDeploymentConfiguration = blueGreenDeploymentConfiguration;
            return this;
        }

        public final void setBlueGreenDeploymentConfiguration(BlueGreenDeploymentConfiguration.BuilderImpl blueGreenDeploymentConfiguration) {
            this.blueGreenDeploymentConfiguration = blueGreenDeploymentConfiguration != null ? blueGreenDeploymentConfiguration.build() : null;
        }

        public final LoadBalancerInfo.Builder getLoadBalancerInfo() {
            return this.loadBalancerInfo != null ? this.loadBalancerInfo.toBuilder() : null;
        }

        @Override
        public final Builder loadBalancerInfo(LoadBalancerInfo loadBalancerInfo) {
            this.loadBalancerInfo = loadBalancerInfo;
            return this;
        }

        public final void setLoadBalancerInfo(LoadBalancerInfo.BuilderImpl loadBalancerInfo) {
            this.loadBalancerInfo = loadBalancerInfo != null ? loadBalancerInfo.build() : null;
        }

        public final LastDeploymentInfo.Builder getLastSuccessfulDeployment() {
            return this.lastSuccessfulDeployment != null ? this.lastSuccessfulDeployment.toBuilder() : null;
        }

        @Override
        public final Builder lastSuccessfulDeployment(LastDeploymentInfo lastSuccessfulDeployment) {
            this.lastSuccessfulDeployment = lastSuccessfulDeployment;
            return this;
        }

        public final void setLastSuccessfulDeployment(LastDeploymentInfo.BuilderImpl lastSuccessfulDeployment) {
            this.lastSuccessfulDeployment = lastSuccessfulDeployment != null ? lastSuccessfulDeployment.build() : null;
        }

        public final LastDeploymentInfo.Builder getLastAttemptedDeployment() {
            return this.lastAttemptedDeployment != null ? this.lastAttemptedDeployment.toBuilder() : null;
        }

        @Override
        public final Builder lastAttemptedDeployment(LastDeploymentInfo lastAttemptedDeployment) {
            this.lastAttemptedDeployment = lastAttemptedDeployment;
            return this;
        }

        public final void setLastAttemptedDeployment(LastDeploymentInfo.BuilderImpl lastAttemptedDeployment) {
            this.lastAttemptedDeployment = lastAttemptedDeployment != null ? lastAttemptedDeployment.build() : null;
        }

        public final EC2TagSet.Builder getEc2TagSet() {
            return this.ec2TagSet != null ? this.ec2TagSet.toBuilder() : null;
        }

        @Override
        public final Builder ec2TagSet(EC2TagSet ec2TagSet) {
            this.ec2TagSet = ec2TagSet;
            return this;
        }

        public final void setEc2TagSet(EC2TagSet.BuilderImpl ec2TagSet) {
            this.ec2TagSet = ec2TagSet != null ? ec2TagSet.build() : null;
        }

        public final OnPremisesTagSet.Builder getOnPremisesTagSet() {
            return this.onPremisesTagSet != null ? this.onPremisesTagSet.toBuilder() : null;
        }

        @Override
        public final Builder onPremisesTagSet(OnPremisesTagSet onPremisesTagSet) {
            this.onPremisesTagSet = onPremisesTagSet;
            return this;
        }

        public final void setOnPremisesTagSet(OnPremisesTagSet.BuilderImpl onPremisesTagSet) {
            this.onPremisesTagSet = onPremisesTagSet != null ? onPremisesTagSet.build() : null;
        }

        public final String getComputePlatform() {
            return this.computePlatform;
        }

        @Override
        public final Builder computePlatform(String computePlatform) {
            this.computePlatform = computePlatform;
            return this;
        }

        @Override
        public final Builder computePlatform(ComputePlatform computePlatform) {
            this.computePlatform(computePlatform == null ? null : computePlatform.toString());
            return this;
        }

        public final void setComputePlatform(String computePlatform) {
            this.computePlatform = computePlatform;
        }

        public final Collection<ECSService.Builder> getEcsServices() {
            return this.ecsServices != null ? (Collection)this.ecsServices.stream().map(ECSService::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder ecsServices(Collection<ECSService> ecsServices) {
            this.ecsServices = ECSServiceListCopier.copy(ecsServices);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ecsServices(ECSService ... ecsServices) {
            this.ecsServices(Arrays.asList(ecsServices));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ecsServices(Consumer<ECSService.Builder> ... ecsServices) {
            this.ecsServices(Stream.of(ecsServices).map(c -> (ECSService)((ECSService.Builder)ECSService.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setEcsServices(Collection<ECSService.BuilderImpl> ecsServices) {
            this.ecsServices = ECSServiceListCopier.copyFromBuilder(ecsServices);
        }

        public DeploymentGroupInfo build() {
            return new DeploymentGroupInfo(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DeploymentGroupInfo> {
        public Builder applicationName(String var1);

        public Builder deploymentGroupId(String var1);

        public Builder deploymentGroupName(String var1);

        public Builder deploymentConfigName(String var1);

        public Builder ec2TagFilters(Collection<EC2TagFilter> var1);

        public Builder ec2TagFilters(EC2TagFilter ... var1);

        public Builder ec2TagFilters(Consumer<EC2TagFilter.Builder> ... var1);

        public Builder onPremisesInstanceTagFilters(Collection<TagFilter> var1);

        public Builder onPremisesInstanceTagFilters(TagFilter ... var1);

        public Builder onPremisesInstanceTagFilters(Consumer<TagFilter.Builder> ... var1);

        public Builder autoScalingGroups(Collection<AutoScalingGroup> var1);

        public Builder autoScalingGroups(AutoScalingGroup ... var1);

        public Builder autoScalingGroups(Consumer<AutoScalingGroup.Builder> ... var1);

        public Builder serviceRoleArn(String var1);

        public Builder targetRevision(RevisionLocation var1);

        default public Builder targetRevision(Consumer<RevisionLocation.Builder> targetRevision) {
            return this.targetRevision((RevisionLocation)((RevisionLocation.Builder)RevisionLocation.builder().applyMutation(targetRevision)).build());
        }

        public Builder triggerConfigurations(Collection<TriggerConfig> var1);

        public Builder triggerConfigurations(TriggerConfig ... var1);

        public Builder triggerConfigurations(Consumer<TriggerConfig.Builder> ... var1);

        public Builder alarmConfiguration(AlarmConfiguration var1);

        default public Builder alarmConfiguration(Consumer<AlarmConfiguration.Builder> alarmConfiguration) {
            return this.alarmConfiguration((AlarmConfiguration)((AlarmConfiguration.Builder)AlarmConfiguration.builder().applyMutation(alarmConfiguration)).build());
        }

        public Builder autoRollbackConfiguration(AutoRollbackConfiguration var1);

        default public Builder autoRollbackConfiguration(Consumer<AutoRollbackConfiguration.Builder> autoRollbackConfiguration) {
            return this.autoRollbackConfiguration((AutoRollbackConfiguration)((AutoRollbackConfiguration.Builder)AutoRollbackConfiguration.builder().applyMutation(autoRollbackConfiguration)).build());
        }

        public Builder deploymentStyle(DeploymentStyle var1);

        default public Builder deploymentStyle(Consumer<DeploymentStyle.Builder> deploymentStyle) {
            return this.deploymentStyle((DeploymentStyle)((DeploymentStyle.Builder)DeploymentStyle.builder().applyMutation(deploymentStyle)).build());
        }

        public Builder blueGreenDeploymentConfiguration(BlueGreenDeploymentConfiguration var1);

        default public Builder blueGreenDeploymentConfiguration(Consumer<BlueGreenDeploymentConfiguration.Builder> blueGreenDeploymentConfiguration) {
            return this.blueGreenDeploymentConfiguration((BlueGreenDeploymentConfiguration)((BlueGreenDeploymentConfiguration.Builder)BlueGreenDeploymentConfiguration.builder().applyMutation(blueGreenDeploymentConfiguration)).build());
        }

        public Builder loadBalancerInfo(LoadBalancerInfo var1);

        default public Builder loadBalancerInfo(Consumer<LoadBalancerInfo.Builder> loadBalancerInfo) {
            return this.loadBalancerInfo((LoadBalancerInfo)((LoadBalancerInfo.Builder)LoadBalancerInfo.builder().applyMutation(loadBalancerInfo)).build());
        }

        public Builder lastSuccessfulDeployment(LastDeploymentInfo var1);

        default public Builder lastSuccessfulDeployment(Consumer<LastDeploymentInfo.Builder> lastSuccessfulDeployment) {
            return this.lastSuccessfulDeployment((LastDeploymentInfo)((LastDeploymentInfo.Builder)LastDeploymentInfo.builder().applyMutation(lastSuccessfulDeployment)).build());
        }

        public Builder lastAttemptedDeployment(LastDeploymentInfo var1);

        default public Builder lastAttemptedDeployment(Consumer<LastDeploymentInfo.Builder> lastAttemptedDeployment) {
            return this.lastAttemptedDeployment((LastDeploymentInfo)((LastDeploymentInfo.Builder)LastDeploymentInfo.builder().applyMutation(lastAttemptedDeployment)).build());
        }

        public Builder ec2TagSet(EC2TagSet var1);

        default public Builder ec2TagSet(Consumer<EC2TagSet.Builder> ec2TagSet) {
            return this.ec2TagSet((EC2TagSet)((EC2TagSet.Builder)EC2TagSet.builder().applyMutation(ec2TagSet)).build());
        }

        public Builder onPremisesTagSet(OnPremisesTagSet var1);

        default public Builder onPremisesTagSet(Consumer<OnPremisesTagSet.Builder> onPremisesTagSet) {
            return this.onPremisesTagSet((OnPremisesTagSet)((OnPremisesTagSet.Builder)OnPremisesTagSet.builder().applyMutation(onPremisesTagSet)).build());
        }

        public Builder computePlatform(String var1);

        public Builder computePlatform(ComputePlatform var1);

        public Builder ecsServices(Collection<ECSService> var1);

        public Builder ecsServices(ECSService ... var1);

        public Builder ecsServices(Consumer<ECSService.Builder> ... var1);
    }
}

