/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codedeploy.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the input of a <code>ListDeployments</code> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListDeploymentsRequest extends CodeDeployRequest implements
        ToCopyableBuilder<ListDeploymentsRequest.Builder, ListDeploymentsRequest> {
    private static final SdkField<String> APPLICATION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("applicationName").getter(getter(ListDeploymentsRequest::applicationName))
            .setter(setter(Builder::applicationName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("applicationName").build()).build();

    private static final SdkField<String> DEPLOYMENT_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("deploymentGroupName").getter(getter(ListDeploymentsRequest::deploymentGroupName))
            .setter(setter(Builder::deploymentGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deploymentGroupName").build())
            .build();

    private static final SdkField<String> EXTERNAL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("externalId").getter(getter(ListDeploymentsRequest::externalId)).setter(setter(Builder::externalId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("externalId").build()).build();

    private static final SdkField<List<String>> INCLUDE_ONLY_STATUSES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("includeOnlyStatuses")
            .getter(getter(ListDeploymentsRequest::includeOnlyStatusesAsStrings))
            .setter(setter(Builder::includeOnlyStatusesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("includeOnlyStatuses").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<TimeRange> CREATE_TIME_RANGE_FIELD = SdkField.<TimeRange> builder(MarshallingType.SDK_POJO)
            .memberName("createTimeRange").getter(getter(ListDeploymentsRequest::createTimeRange))
            .setter(setter(Builder::createTimeRange)).constructor(TimeRange::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createTimeRange").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListDeploymentsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_NAME_FIELD,
            DEPLOYMENT_GROUP_NAME_FIELD, EXTERNAL_ID_FIELD, INCLUDE_ONLY_STATUSES_FIELD, CREATE_TIME_RANGE_FIELD,
            NEXT_TOKEN_FIELD));

    private final String applicationName;

    private final String deploymentGroupName;

    private final String externalId;

    private final List<String> includeOnlyStatuses;

    private final TimeRange createTimeRange;

    private final String nextToken;

    private ListDeploymentsRequest(BuilderImpl builder) {
        super(builder);
        this.applicationName = builder.applicationName;
        this.deploymentGroupName = builder.deploymentGroupName;
        this.externalId = builder.externalId;
        this.includeOnlyStatuses = builder.includeOnlyStatuses;
        this.createTimeRange = builder.createTimeRange;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The name of an AWS CodeDeploy application associated with the IAM user or AWS account.
     * </p>
     * <note>
     * <p>
     * If <code>applicationName</code> is specified, then <code>deploymentGroupName</code> must be specified. If it is
     * not specified, then <code>deploymentGroupName</code> must not be specified.
     * </p>
     * </note>
     * 
     * @return The name of an AWS CodeDeploy application associated with the IAM user or AWS account.</p> <note>
     *         <p>
     *         If <code>applicationName</code> is specified, then <code>deploymentGroupName</code> must be specified. If
     *         it is not specified, then <code>deploymentGroupName</code> must not be specified.
     *         </p>
     */
    public String applicationName() {
        return applicationName;
    }

    /**
     * <p>
     * The name of a deployment group for the specified application.
     * </p>
     * <note>
     * <p>
     * If <code>deploymentGroupName</code> is specified, then <code>applicationName</code> must be specified. If it is
     * not specified, then <code>applicationName</code> must not be specified.
     * </p>
     * </note>
     * 
     * @return The name of a deployment group for the specified application.</p> <note>
     *         <p>
     *         If <code>deploymentGroupName</code> is specified, then <code>applicationName</code> must be specified. If
     *         it is not specified, then <code>applicationName</code> must not be specified.
     *         </p>
     */
    public String deploymentGroupName() {
        return deploymentGroupName;
    }

    /**
     * <p>
     * The unique ID of an external resource for returning deployments linked to the external resource.
     * </p>
     * 
     * @return The unique ID of an external resource for returning deployments linked to the external resource.
     */
    public String externalId() {
        return externalId;
    }

    /**
     * <p>
     * A subset of deployments to list by status:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Created</code>: Include created deployments in the resulting list.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Queued</code>: Include queued deployments in the resulting list.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>In Progress</code>: Include in-progress deployments in the resulting list.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Succeeded</code>: Include successful deployments in the resulting list.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Failed</code>: Include failed deployments in the resulting list.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Stopped</code>: Include stopped deployments in the resulting list.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasIncludeOnlyStatuses()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A subset of deployments to list by status:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>Created</code>: Include created deployments in the resulting list.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Queued</code>: Include queued deployments in the resulting list.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>In Progress</code>: Include in-progress deployments in the resulting list.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Succeeded</code>: Include successful deployments in the resulting list.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Failed</code>: Include failed deployments in the resulting list.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Stopped</code>: Include stopped deployments in the resulting list.
     *         </p>
     *         </li>
     */
    public List<DeploymentStatus> includeOnlyStatuses() {
        return DeploymentStatusListCopier.copyStringToEnum(includeOnlyStatuses);
    }

    /**
     * Returns true if the IncludeOnlyStatuses property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasIncludeOnlyStatuses() {
        return includeOnlyStatuses != null && !(includeOnlyStatuses instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A subset of deployments to list by status:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Created</code>: Include created deployments in the resulting list.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Queued</code>: Include queued deployments in the resulting list.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>In Progress</code>: Include in-progress deployments in the resulting list.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Succeeded</code>: Include successful deployments in the resulting list.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Failed</code>: Include failed deployments in the resulting list.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Stopped</code>: Include stopped deployments in the resulting list.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasIncludeOnlyStatuses()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A subset of deployments to list by status:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>Created</code>: Include created deployments in the resulting list.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Queued</code>: Include queued deployments in the resulting list.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>In Progress</code>: Include in-progress deployments in the resulting list.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Succeeded</code>: Include successful deployments in the resulting list.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Failed</code>: Include failed deployments in the resulting list.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Stopped</code>: Include stopped deployments in the resulting list.
     *         </p>
     *         </li>
     */
    public List<String> includeOnlyStatusesAsStrings() {
        return includeOnlyStatuses;
    }

    /**
     * <p>
     * A time range (start and end) for returning a subset of the list of deployments.
     * </p>
     * 
     * @return A time range (start and end) for returning a subset of the list of deployments.
     */
    public TimeRange createTimeRange() {
        return createTimeRange;
    }

    /**
     * <p>
     * An identifier returned from the previous list deployments call. It can be used to return the next set of
     * deployments in the list.
     * </p>
     * 
     * @return An identifier returned from the previous list deployments call. It can be used to return the next set of
     *         deployments in the list.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(applicationName());
        hashCode = 31 * hashCode + Objects.hashCode(deploymentGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(externalId());
        hashCode = 31 * hashCode + Objects.hashCode(hasIncludeOnlyStatuses() ? includeOnlyStatusesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(createTimeRange());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDeploymentsRequest)) {
            return false;
        }
        ListDeploymentsRequest other = (ListDeploymentsRequest) obj;
        return Objects.equals(applicationName(), other.applicationName())
                && Objects.equals(deploymentGroupName(), other.deploymentGroupName())
                && Objects.equals(externalId(), other.externalId()) && hasIncludeOnlyStatuses() == other.hasIncludeOnlyStatuses()
                && Objects.equals(includeOnlyStatusesAsStrings(), other.includeOnlyStatusesAsStrings())
                && Objects.equals(createTimeRange(), other.createTimeRange()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListDeploymentsRequest").add("ApplicationName", applicationName())
                .add("DeploymentGroupName", deploymentGroupName()).add("ExternalId", externalId())
                .add("IncludeOnlyStatuses", hasIncludeOnlyStatuses() ? includeOnlyStatusesAsStrings() : null)
                .add("CreateTimeRange", createTimeRange()).add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "applicationName":
            return Optional.ofNullable(clazz.cast(applicationName()));
        case "deploymentGroupName":
            return Optional.ofNullable(clazz.cast(deploymentGroupName()));
        case "externalId":
            return Optional.ofNullable(clazz.cast(externalId()));
        case "includeOnlyStatuses":
            return Optional.ofNullable(clazz.cast(includeOnlyStatusesAsStrings()));
        case "createTimeRange":
            return Optional.ofNullable(clazz.cast(createTimeRange()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListDeploymentsRequest, T> g) {
        return obj -> g.apply((ListDeploymentsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodeDeployRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListDeploymentsRequest> {
        /**
         * <p>
         * The name of an AWS CodeDeploy application associated with the IAM user or AWS account.
         * </p>
         * <note>
         * <p>
         * If <code>applicationName</code> is specified, then <code>deploymentGroupName</code> must be specified. If it
         * is not specified, then <code>deploymentGroupName</code> must not be specified.
         * </p>
         * </note>
         * 
         * @param applicationName
         *        The name of an AWS CodeDeploy application associated with the IAM user or AWS account.</p> <note>
         *        <p>
         *        If <code>applicationName</code> is specified, then <code>deploymentGroupName</code> must be specified.
         *        If it is not specified, then <code>deploymentGroupName</code> must not be specified.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationName(String applicationName);

        /**
         * <p>
         * The name of a deployment group for the specified application.
         * </p>
         * <note>
         * <p>
         * If <code>deploymentGroupName</code> is specified, then <code>applicationName</code> must be specified. If it
         * is not specified, then <code>applicationName</code> must not be specified.
         * </p>
         * </note>
         * 
         * @param deploymentGroupName
         *        The name of a deployment group for the specified application.</p> <note>
         *        <p>
         *        If <code>deploymentGroupName</code> is specified, then <code>applicationName</code> must be specified.
         *        If it is not specified, then <code>applicationName</code> must not be specified.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deploymentGroupName(String deploymentGroupName);

        /**
         * <p>
         * The unique ID of an external resource for returning deployments linked to the external resource.
         * </p>
         * 
         * @param externalId
         *        The unique ID of an external resource for returning deployments linked to the external resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder externalId(String externalId);

        /**
         * <p>
         * A subset of deployments to list by status:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Created</code>: Include created deployments in the resulting list.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Queued</code>: Include queued deployments in the resulting list.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>In Progress</code>: Include in-progress deployments in the resulting list.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Succeeded</code>: Include successful deployments in the resulting list.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Failed</code>: Include failed deployments in the resulting list.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Stopped</code>: Include stopped deployments in the resulting list.
         * </p>
         * </li>
         * </ul>
         * 
         * @param includeOnlyStatuses
         *        A subset of deployments to list by status:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>Created</code>: Include created deployments in the resulting list.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Queued</code>: Include queued deployments in the resulting list.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>In Progress</code>: Include in-progress deployments in the resulting list.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Succeeded</code>: Include successful deployments in the resulting list.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Failed</code>: Include failed deployments in the resulting list.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Stopped</code>: Include stopped deployments in the resulting list.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includeOnlyStatusesWithStrings(Collection<String> includeOnlyStatuses);

        /**
         * <p>
         * A subset of deployments to list by status:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Created</code>: Include created deployments in the resulting list.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Queued</code>: Include queued deployments in the resulting list.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>In Progress</code>: Include in-progress deployments in the resulting list.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Succeeded</code>: Include successful deployments in the resulting list.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Failed</code>: Include failed deployments in the resulting list.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Stopped</code>: Include stopped deployments in the resulting list.
         * </p>
         * </li>
         * </ul>
         * 
         * @param includeOnlyStatuses
         *        A subset of deployments to list by status:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>Created</code>: Include created deployments in the resulting list.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Queued</code>: Include queued deployments in the resulting list.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>In Progress</code>: Include in-progress deployments in the resulting list.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Succeeded</code>: Include successful deployments in the resulting list.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Failed</code>: Include failed deployments in the resulting list.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Stopped</code>: Include stopped deployments in the resulting list.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includeOnlyStatusesWithStrings(String... includeOnlyStatuses);

        /**
         * <p>
         * A subset of deployments to list by status:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Created</code>: Include created deployments in the resulting list.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Queued</code>: Include queued deployments in the resulting list.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>In Progress</code>: Include in-progress deployments in the resulting list.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Succeeded</code>: Include successful deployments in the resulting list.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Failed</code>: Include failed deployments in the resulting list.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Stopped</code>: Include stopped deployments in the resulting list.
         * </p>
         * </li>
         * </ul>
         * 
         * @param includeOnlyStatuses
         *        A subset of deployments to list by status:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>Created</code>: Include created deployments in the resulting list.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Queued</code>: Include queued deployments in the resulting list.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>In Progress</code>: Include in-progress deployments in the resulting list.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Succeeded</code>: Include successful deployments in the resulting list.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Failed</code>: Include failed deployments in the resulting list.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Stopped</code>: Include stopped deployments in the resulting list.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includeOnlyStatuses(Collection<DeploymentStatus> includeOnlyStatuses);

        /**
         * <p>
         * A subset of deployments to list by status:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Created</code>: Include created deployments in the resulting list.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Queued</code>: Include queued deployments in the resulting list.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>In Progress</code>: Include in-progress deployments in the resulting list.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Succeeded</code>: Include successful deployments in the resulting list.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Failed</code>: Include failed deployments in the resulting list.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Stopped</code>: Include stopped deployments in the resulting list.
         * </p>
         * </li>
         * </ul>
         * 
         * @param includeOnlyStatuses
         *        A subset of deployments to list by status:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>Created</code>: Include created deployments in the resulting list.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Queued</code>: Include queued deployments in the resulting list.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>In Progress</code>: Include in-progress deployments in the resulting list.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Succeeded</code>: Include successful deployments in the resulting list.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Failed</code>: Include failed deployments in the resulting list.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Stopped</code>: Include stopped deployments in the resulting list.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includeOnlyStatuses(DeploymentStatus... includeOnlyStatuses);

        /**
         * <p>
         * A time range (start and end) for returning a subset of the list of deployments.
         * </p>
         * 
         * @param createTimeRange
         *        A time range (start and end) for returning a subset of the list of deployments.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createTimeRange(TimeRange createTimeRange);

        /**
         * <p>
         * A time range (start and end) for returning a subset of the list of deployments.
         * </p>
         * This is a convenience that creates an instance of the {@link TimeRange.Builder} avoiding the need to create
         * one manually via {@link TimeRange#builder()}.
         *
         * When the {@link Consumer} completes, {@link TimeRange.Builder#build()} is called immediately and its result
         * is passed to {@link #createTimeRange(TimeRange)}.
         * 
         * @param createTimeRange
         *        a consumer that will call methods on {@link TimeRange.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #createTimeRange(TimeRange)
         */
        default Builder createTimeRange(Consumer<TimeRange.Builder> createTimeRange) {
            return createTimeRange(TimeRange.builder().applyMutation(createTimeRange).build());
        }

        /**
         * <p>
         * An identifier returned from the previous list deployments call. It can be used to return the next set of
         * deployments in the list.
         * </p>
         * 
         * @param nextToken
         *        An identifier returned from the previous list deployments call. It can be used to return the next set
         *        of deployments in the list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CodeDeployRequest.BuilderImpl implements Builder {
        private String applicationName;

        private String deploymentGroupName;

        private String externalId;

        private List<String> includeOnlyStatuses = DefaultSdkAutoConstructList.getInstance();

        private TimeRange createTimeRange;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDeploymentsRequest model) {
            super(model);
            applicationName(model.applicationName);
            deploymentGroupName(model.deploymentGroupName);
            externalId(model.externalId);
            includeOnlyStatusesWithStrings(model.includeOnlyStatuses);
            createTimeRange(model.createTimeRange);
            nextToken(model.nextToken);
        }

        public final String getApplicationName() {
            return applicationName;
        }

        @Override
        public final Builder applicationName(String applicationName) {
            this.applicationName = applicationName;
            return this;
        }

        public final void setApplicationName(String applicationName) {
            this.applicationName = applicationName;
        }

        public final String getDeploymentGroupName() {
            return deploymentGroupName;
        }

        @Override
        public final Builder deploymentGroupName(String deploymentGroupName) {
            this.deploymentGroupName = deploymentGroupName;
            return this;
        }

        public final void setDeploymentGroupName(String deploymentGroupName) {
            this.deploymentGroupName = deploymentGroupName;
        }

        public final String getExternalId() {
            return externalId;
        }

        @Override
        public final Builder externalId(String externalId) {
            this.externalId = externalId;
            return this;
        }

        public final void setExternalId(String externalId) {
            this.externalId = externalId;
        }

        public final Collection<String> getIncludeOnlyStatuses() {
            if (includeOnlyStatuses instanceof SdkAutoConstructList) {
                return null;
            }
            return includeOnlyStatuses;
        }

        @Override
        public final Builder includeOnlyStatusesWithStrings(Collection<String> includeOnlyStatuses) {
            this.includeOnlyStatuses = DeploymentStatusListCopier.copy(includeOnlyStatuses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder includeOnlyStatusesWithStrings(String... includeOnlyStatuses) {
            includeOnlyStatusesWithStrings(Arrays.asList(includeOnlyStatuses));
            return this;
        }

        @Override
        public final Builder includeOnlyStatuses(Collection<DeploymentStatus> includeOnlyStatuses) {
            this.includeOnlyStatuses = DeploymentStatusListCopier.copyEnumToString(includeOnlyStatuses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder includeOnlyStatuses(DeploymentStatus... includeOnlyStatuses) {
            includeOnlyStatuses(Arrays.asList(includeOnlyStatuses));
            return this;
        }

        public final void setIncludeOnlyStatuses(Collection<String> includeOnlyStatuses) {
            this.includeOnlyStatuses = DeploymentStatusListCopier.copy(includeOnlyStatuses);
        }

        public final TimeRange.Builder getCreateTimeRange() {
            return createTimeRange != null ? createTimeRange.toBuilder() : null;
        }

        @Override
        public final Builder createTimeRange(TimeRange createTimeRange) {
            this.createTimeRange = createTimeRange;
            return this;
        }

        public final void setCreateTimeRange(TimeRange.BuilderImpl createTimeRange) {
            this.createTimeRange = createTimeRange != null ? createTimeRange.build() : null;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListDeploymentsRequest build() {
            return new ListDeploymentsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
