/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codedeploy.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the Elastic Load Balancing load balancer or target group used in a deployment.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LoadBalancerInfo implements SdkPojo, Serializable,
        ToCopyableBuilder<LoadBalancerInfo.Builder, LoadBalancerInfo> {
    private static final SdkField<List<ELBInfo>> ELB_INFO_LIST_FIELD = SdkField
            .<List<ELBInfo>> builder(MarshallingType.LIST)
            .memberName("elbInfoList")
            .getter(getter(LoadBalancerInfo::elbInfoList))
            .setter(setter(Builder::elbInfoList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("elbInfoList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ELBInfo> builder(MarshallingType.SDK_POJO)
                                            .constructor(ELBInfo::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<TargetGroupInfo>> TARGET_GROUP_INFO_LIST_FIELD = SdkField
            .<List<TargetGroupInfo>> builder(MarshallingType.LIST)
            .memberName("targetGroupInfoList")
            .getter(getter(LoadBalancerInfo::targetGroupInfoList))
            .setter(setter(Builder::targetGroupInfoList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetGroupInfoList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<TargetGroupInfo> builder(MarshallingType.SDK_POJO)
                                            .constructor(TargetGroupInfo::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<TargetGroupPairInfo>> TARGET_GROUP_PAIR_INFO_LIST_FIELD = SdkField
            .<List<TargetGroupPairInfo>> builder(MarshallingType.LIST)
            .memberName("targetGroupPairInfoList")
            .getter(getter(LoadBalancerInfo::targetGroupPairInfoList))
            .setter(setter(Builder::targetGroupPairInfoList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetGroupPairInfoList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<TargetGroupPairInfo> builder(MarshallingType.SDK_POJO)
                                            .constructor(TargetGroupPairInfo::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ELB_INFO_LIST_FIELD,
            TARGET_GROUP_INFO_LIST_FIELD, TARGET_GROUP_PAIR_INFO_LIST_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<ELBInfo> elbInfoList;

    private final List<TargetGroupInfo> targetGroupInfoList;

    private final List<TargetGroupPairInfo> targetGroupPairInfoList;

    private LoadBalancerInfo(BuilderImpl builder) {
        this.elbInfoList = builder.elbInfoList;
        this.targetGroupInfoList = builder.targetGroupInfoList;
        this.targetGroupPairInfoList = builder.targetGroupPairInfoList;
    }

    /**
     * Returns true if the ElbInfoList property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasElbInfoList() {
        return elbInfoList != null && !(elbInfoList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array that contains information about the load balancer to use for load balancing in a deployment. In Elastic
     * Load Balancing, load balancers are used with Classic Load Balancers.
     * </p>
     * <note>
     * <p>
     * Adding more than one load balancer to the array is not supported.
     * </p>
     * </note>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasElbInfoList()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An array that contains information about the load balancer to use for load balancing in a deployment. In
     *         Elastic Load Balancing, load balancers are used with Classic Load Balancers.</p> <note>
     *         <p>
     *         Adding more than one load balancer to the array is not supported.
     *         </p>
     */
    public List<ELBInfo> elbInfoList() {
        return elbInfoList;
    }

    /**
     * Returns true if the TargetGroupInfoList property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasTargetGroupInfoList() {
        return targetGroupInfoList != null && !(targetGroupInfoList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array that contains information about the target group to use for load balancing in a deployment. In Elastic
     * Load Balancing, target groups are used with Application Load Balancers.
     * </p>
     * <note>
     * <p>
     * Adding more than one target group to the array is not supported.
     * </p>
     * </note>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTargetGroupInfoList()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An array that contains information about the target group to use for load balancing in a deployment. In
     *         Elastic Load Balancing, target groups are used with Application Load Balancers.</p> <note>
     *         <p>
     *         Adding more than one target group to the array is not supported.
     *         </p>
     */
    public List<TargetGroupInfo> targetGroupInfoList() {
        return targetGroupInfoList;
    }

    /**
     * Returns true if the TargetGroupPairInfoList property was specified by the sender (it may be empty), or false if
     * the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasTargetGroupPairInfoList() {
        return targetGroupPairInfoList != null && !(targetGroupPairInfoList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The target group pair information. This is an array of <code>TargeGroupPairInfo</code> objects with a maximum
     * size of one.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTargetGroupPairInfoList()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The target group pair information. This is an array of <code>TargeGroupPairInfo</code> objects with a
     *         maximum size of one.
     */
    public List<TargetGroupPairInfo> targetGroupPairInfoList() {
        return targetGroupPairInfoList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasElbInfoList() ? elbInfoList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTargetGroupInfoList() ? targetGroupInfoList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTargetGroupPairInfoList() ? targetGroupPairInfoList() : null);
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LoadBalancerInfo)) {
            return false;
        }
        LoadBalancerInfo other = (LoadBalancerInfo) obj;
        return hasElbInfoList() == other.hasElbInfoList() && Objects.equals(elbInfoList(), other.elbInfoList())
                && hasTargetGroupInfoList() == other.hasTargetGroupInfoList()
                && Objects.equals(targetGroupInfoList(), other.targetGroupInfoList())
                && hasTargetGroupPairInfoList() == other.hasTargetGroupPairInfoList()
                && Objects.equals(targetGroupPairInfoList(), other.targetGroupPairInfoList());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("LoadBalancerInfo").add("ElbInfoList", hasElbInfoList() ? elbInfoList() : null)
                .add("TargetGroupInfoList", hasTargetGroupInfoList() ? targetGroupInfoList() : null)
                .add("TargetGroupPairInfoList", hasTargetGroupPairInfoList() ? targetGroupPairInfoList() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "elbInfoList":
            return Optional.ofNullable(clazz.cast(elbInfoList()));
        case "targetGroupInfoList":
            return Optional.ofNullable(clazz.cast(targetGroupInfoList()));
        case "targetGroupPairInfoList":
            return Optional.ofNullable(clazz.cast(targetGroupPairInfoList()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LoadBalancerInfo, T> g) {
        return obj -> g.apply((LoadBalancerInfo) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LoadBalancerInfo> {
        /**
         * <p>
         * An array that contains information about the load balancer to use for load balancing in a deployment. In
         * Elastic Load Balancing, load balancers are used with Classic Load Balancers.
         * </p>
         * <note>
         * <p>
         * Adding more than one load balancer to the array is not supported.
         * </p>
         * </note>
         * 
         * @param elbInfoList
         *        An array that contains information about the load balancer to use for load balancing in a deployment.
         *        In Elastic Load Balancing, load balancers are used with Classic Load Balancers.</p> <note>
         *        <p>
         *        Adding more than one load balancer to the array is not supported.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder elbInfoList(Collection<ELBInfo> elbInfoList);

        /**
         * <p>
         * An array that contains information about the load balancer to use for load balancing in a deployment. In
         * Elastic Load Balancing, load balancers are used with Classic Load Balancers.
         * </p>
         * <note>
         * <p>
         * Adding more than one load balancer to the array is not supported.
         * </p>
         * </note>
         * 
         * @param elbInfoList
         *        An array that contains information about the load balancer to use for load balancing in a deployment.
         *        In Elastic Load Balancing, load balancers are used with Classic Load Balancers.</p> <note>
         *        <p>
         *        Adding more than one load balancer to the array is not supported.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder elbInfoList(ELBInfo... elbInfoList);

        /**
         * <p>
         * An array that contains information about the load balancer to use for load balancing in a deployment. In
         * Elastic Load Balancing, load balancers are used with Classic Load Balancers.
         * </p>
         * <note>
         * <p>
         * Adding more than one load balancer to the array is not supported.
         * </p>
         * </note> This is a convenience that creates an instance of the {@link List<ELBInfo>.Builder} avoiding the need
         * to create one manually via {@link List<ELBInfo>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ELBInfo>.Builder#build()} is called immediately and its
         * result is passed to {@link #elbInfoList(List<ELBInfo>)}.
         * 
         * @param elbInfoList
         *        a consumer that will call methods on {@link List<ELBInfo>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #elbInfoList(List<ELBInfo>)
         */
        Builder elbInfoList(Consumer<ELBInfo.Builder>... elbInfoList);

        /**
         * <p>
         * An array that contains information about the target group to use for load balancing in a deployment. In
         * Elastic Load Balancing, target groups are used with Application Load Balancers.
         * </p>
         * <note>
         * <p>
         * Adding more than one target group to the array is not supported.
         * </p>
         * </note>
         * 
         * @param targetGroupInfoList
         *        An array that contains information about the target group to use for load balancing in a deployment.
         *        In Elastic Load Balancing, target groups are used with Application Load Balancers.</p> <note>
         *        <p>
         *        Adding more than one target group to the array is not supported.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetGroupInfoList(Collection<TargetGroupInfo> targetGroupInfoList);

        /**
         * <p>
         * An array that contains information about the target group to use for load balancing in a deployment. In
         * Elastic Load Balancing, target groups are used with Application Load Balancers.
         * </p>
         * <note>
         * <p>
         * Adding more than one target group to the array is not supported.
         * </p>
         * </note>
         * 
         * @param targetGroupInfoList
         *        An array that contains information about the target group to use for load balancing in a deployment.
         *        In Elastic Load Balancing, target groups are used with Application Load Balancers.</p> <note>
         *        <p>
         *        Adding more than one target group to the array is not supported.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetGroupInfoList(TargetGroupInfo... targetGroupInfoList);

        /**
         * <p>
         * An array that contains information about the target group to use for load balancing in a deployment. In
         * Elastic Load Balancing, target groups are used with Application Load Balancers.
         * </p>
         * <note>
         * <p>
         * Adding more than one target group to the array is not supported.
         * </p>
         * </note> This is a convenience that creates an instance of the {@link List<TargetGroupInfo>.Builder} avoiding
         * the need to create one manually via {@link List<TargetGroupInfo>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<TargetGroupInfo>.Builder#build()} is called immediately and
         * its result is passed to {@link #targetGroupInfoList(List<TargetGroupInfo>)}.
         * 
         * @param targetGroupInfoList
         *        a consumer that will call methods on {@link List<TargetGroupInfo>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #targetGroupInfoList(List<TargetGroupInfo>)
         */
        Builder targetGroupInfoList(Consumer<TargetGroupInfo.Builder>... targetGroupInfoList);

        /**
         * <p>
         * The target group pair information. This is an array of <code>TargeGroupPairInfo</code> objects with a maximum
         * size of one.
         * </p>
         * 
         * @param targetGroupPairInfoList
         *        The target group pair information. This is an array of <code>TargeGroupPairInfo</code> objects with a
         *        maximum size of one.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetGroupPairInfoList(Collection<TargetGroupPairInfo> targetGroupPairInfoList);

        /**
         * <p>
         * The target group pair information. This is an array of <code>TargeGroupPairInfo</code> objects with a maximum
         * size of one.
         * </p>
         * 
         * @param targetGroupPairInfoList
         *        The target group pair information. This is an array of <code>TargeGroupPairInfo</code> objects with a
         *        maximum size of one.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetGroupPairInfoList(TargetGroupPairInfo... targetGroupPairInfoList);

        /**
         * <p>
         * The target group pair information. This is an array of <code>TargeGroupPairInfo</code> objects with a maximum
         * size of one.
         * </p>
         * This is a convenience that creates an instance of the {@link List<TargetGroupPairInfo>.Builder} avoiding the
         * need to create one manually via {@link List<TargetGroupPairInfo>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<TargetGroupPairInfo>.Builder#build()} is called immediately
         * and its result is passed to {@link #targetGroupPairInfoList(List<TargetGroupPairInfo>)}.
         * 
         * @param targetGroupPairInfoList
         *        a consumer that will call methods on {@link List<TargetGroupPairInfo>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #targetGroupPairInfoList(List<TargetGroupPairInfo>)
         */
        Builder targetGroupPairInfoList(Consumer<TargetGroupPairInfo.Builder>... targetGroupPairInfoList);
    }

    static final class BuilderImpl implements Builder {
        private List<ELBInfo> elbInfoList = DefaultSdkAutoConstructList.getInstance();

        private List<TargetGroupInfo> targetGroupInfoList = DefaultSdkAutoConstructList.getInstance();

        private List<TargetGroupPairInfo> targetGroupPairInfoList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(LoadBalancerInfo model) {
            elbInfoList(model.elbInfoList);
            targetGroupInfoList(model.targetGroupInfoList);
            targetGroupPairInfoList(model.targetGroupPairInfoList);
        }

        public final Collection<ELBInfo.Builder> getElbInfoList() {
            if (elbInfoList instanceof SdkAutoConstructList) {
                return null;
            }
            return elbInfoList != null ? elbInfoList.stream().map(ELBInfo::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder elbInfoList(Collection<ELBInfo> elbInfoList) {
            this.elbInfoList = ELBInfoListCopier.copy(elbInfoList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder elbInfoList(ELBInfo... elbInfoList) {
            elbInfoList(Arrays.asList(elbInfoList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder elbInfoList(Consumer<ELBInfo.Builder>... elbInfoList) {
            elbInfoList(Stream.of(elbInfoList).map(c -> ELBInfo.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setElbInfoList(Collection<ELBInfo.BuilderImpl> elbInfoList) {
            this.elbInfoList = ELBInfoListCopier.copyFromBuilder(elbInfoList);
        }

        public final Collection<TargetGroupInfo.Builder> getTargetGroupInfoList() {
            if (targetGroupInfoList instanceof SdkAutoConstructList) {
                return null;
            }
            return targetGroupInfoList != null ? targetGroupInfoList.stream().map(TargetGroupInfo::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder targetGroupInfoList(Collection<TargetGroupInfo> targetGroupInfoList) {
            this.targetGroupInfoList = TargetGroupInfoListCopier.copy(targetGroupInfoList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetGroupInfoList(TargetGroupInfo... targetGroupInfoList) {
            targetGroupInfoList(Arrays.asList(targetGroupInfoList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetGroupInfoList(Consumer<TargetGroupInfo.Builder>... targetGroupInfoList) {
            targetGroupInfoList(Stream.of(targetGroupInfoList).map(c -> TargetGroupInfo.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setTargetGroupInfoList(Collection<TargetGroupInfo.BuilderImpl> targetGroupInfoList) {
            this.targetGroupInfoList = TargetGroupInfoListCopier.copyFromBuilder(targetGroupInfoList);
        }

        public final Collection<TargetGroupPairInfo.Builder> getTargetGroupPairInfoList() {
            if (targetGroupPairInfoList instanceof SdkAutoConstructList) {
                return null;
            }
            return targetGroupPairInfoList != null ? targetGroupPairInfoList.stream().map(TargetGroupPairInfo::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder targetGroupPairInfoList(Collection<TargetGroupPairInfo> targetGroupPairInfoList) {
            this.targetGroupPairInfoList = TargetGroupPairInfoListCopier.copy(targetGroupPairInfoList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetGroupPairInfoList(TargetGroupPairInfo... targetGroupPairInfoList) {
            targetGroupPairInfoList(Arrays.asList(targetGroupPairInfoList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetGroupPairInfoList(Consumer<TargetGroupPairInfo.Builder>... targetGroupPairInfoList) {
            targetGroupPairInfoList(Stream.of(targetGroupPairInfoList)
                    .map(c -> TargetGroupPairInfo.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTargetGroupPairInfoList(Collection<TargetGroupPairInfo.BuilderImpl> targetGroupPairInfoList) {
            this.targetGroupPairInfoList = TargetGroupPairInfoListCopier.copyFromBuilder(targetGroupPairInfoList);
        }

        @Override
        public LoadBalancerInfo build() {
            return new LoadBalancerInfo(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
