/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codedeploy.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LambdaFunctionInfo
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LambdaFunctionInfo> {
    private static final SdkField<String> FUNCTION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("functionName").getter(LambdaFunctionInfo.getter(LambdaFunctionInfo::functionName)).setter(LambdaFunctionInfo.setter(Builder::functionName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("functionName").build()}).build();
    private static final SdkField<String> FUNCTION_ALIAS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("functionAlias").getter(LambdaFunctionInfo.getter(LambdaFunctionInfo::functionAlias)).setter(LambdaFunctionInfo.setter(Builder::functionAlias)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("functionAlias").build()}).build();
    private static final SdkField<String> CURRENT_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("currentVersion").getter(LambdaFunctionInfo.getter(LambdaFunctionInfo::currentVersion)).setter(LambdaFunctionInfo.setter(Builder::currentVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("currentVersion").build()}).build();
    private static final SdkField<String> TARGET_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("targetVersion").getter(LambdaFunctionInfo.getter(LambdaFunctionInfo::targetVersion)).setter(LambdaFunctionInfo.setter(Builder::targetVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetVersion").build()}).build();
    private static final SdkField<Double> TARGET_VERSION_WEIGHT_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("targetVersionWeight").getter(LambdaFunctionInfo.getter(LambdaFunctionInfo::targetVersionWeight)).setter(LambdaFunctionInfo.setter(Builder::targetVersionWeight)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetVersionWeight").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FUNCTION_NAME_FIELD, FUNCTION_ALIAS_FIELD, CURRENT_VERSION_FIELD, TARGET_VERSION_FIELD, TARGET_VERSION_WEIGHT_FIELD));
    private static final long serialVersionUID = 1L;
    private final String functionName;
    private final String functionAlias;
    private final String currentVersion;
    private final String targetVersion;
    private final Double targetVersionWeight;

    private LambdaFunctionInfo(BuilderImpl builder) {
        this.functionName = builder.functionName;
        this.functionAlias = builder.functionAlias;
        this.currentVersion = builder.currentVersion;
        this.targetVersion = builder.targetVersion;
        this.targetVersionWeight = builder.targetVersionWeight;
    }

    public String functionName() {
        return this.functionName;
    }

    public String functionAlias() {
        return this.functionAlias;
    }

    public String currentVersion() {
        return this.currentVersion;
    }

    public String targetVersion() {
        return this.targetVersion;
    }

    public Double targetVersionWeight() {
        return this.targetVersionWeight;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.functionName());
        hashCode = 31 * hashCode + Objects.hashCode(this.functionAlias());
        hashCode = 31 * hashCode + Objects.hashCode(this.currentVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetVersionWeight());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LambdaFunctionInfo)) {
            return false;
        }
        LambdaFunctionInfo other = (LambdaFunctionInfo)obj;
        return Objects.equals(this.functionName(), other.functionName()) && Objects.equals(this.functionAlias(), other.functionAlias()) && Objects.equals(this.currentVersion(), other.currentVersion()) && Objects.equals(this.targetVersion(), other.targetVersion()) && Objects.equals(this.targetVersionWeight(), other.targetVersionWeight());
    }

    public String toString() {
        return ToString.builder((String)"LambdaFunctionInfo").add("FunctionName", (Object)this.functionName()).add("FunctionAlias", (Object)this.functionAlias()).add("CurrentVersion", (Object)this.currentVersion()).add("TargetVersion", (Object)this.targetVersion()).add("TargetVersionWeight", (Object)this.targetVersionWeight()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "functionName": {
                return Optional.ofNullable(clazz.cast(this.functionName()));
            }
            case "functionAlias": {
                return Optional.ofNullable(clazz.cast(this.functionAlias()));
            }
            case "currentVersion": {
                return Optional.ofNullable(clazz.cast(this.currentVersion()));
            }
            case "targetVersion": {
                return Optional.ofNullable(clazz.cast(this.targetVersion()));
            }
            case "targetVersionWeight": {
                return Optional.ofNullable(clazz.cast(this.targetVersionWeight()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LambdaFunctionInfo, T> g) {
        return obj -> g.apply((LambdaFunctionInfo)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String functionName;
        private String functionAlias;
        private String currentVersion;
        private String targetVersion;
        private Double targetVersionWeight;

        private BuilderImpl() {
        }

        private BuilderImpl(LambdaFunctionInfo model) {
            this.functionName(model.functionName);
            this.functionAlias(model.functionAlias);
            this.currentVersion(model.currentVersion);
            this.targetVersion(model.targetVersion);
            this.targetVersionWeight(model.targetVersionWeight);
        }

        public final String getFunctionName() {
            return this.functionName;
        }

        @Override
        public final Builder functionName(String functionName) {
            this.functionName = functionName;
            return this;
        }

        public final void setFunctionName(String functionName) {
            this.functionName = functionName;
        }

        public final String getFunctionAlias() {
            return this.functionAlias;
        }

        @Override
        public final Builder functionAlias(String functionAlias) {
            this.functionAlias = functionAlias;
            return this;
        }

        public final void setFunctionAlias(String functionAlias) {
            this.functionAlias = functionAlias;
        }

        public final String getCurrentVersion() {
            return this.currentVersion;
        }

        @Override
        public final Builder currentVersion(String currentVersion) {
            this.currentVersion = currentVersion;
            return this;
        }

        public final void setCurrentVersion(String currentVersion) {
            this.currentVersion = currentVersion;
        }

        public final String getTargetVersion() {
            return this.targetVersion;
        }

        @Override
        public final Builder targetVersion(String targetVersion) {
            this.targetVersion = targetVersion;
            return this;
        }

        public final void setTargetVersion(String targetVersion) {
            this.targetVersion = targetVersion;
        }

        public final Double getTargetVersionWeight() {
            return this.targetVersionWeight;
        }

        @Override
        public final Builder targetVersionWeight(Double targetVersionWeight) {
            this.targetVersionWeight = targetVersionWeight;
            return this;
        }

        public final void setTargetVersionWeight(Double targetVersionWeight) {
            this.targetVersionWeight = targetVersionWeight;
        }

        public LambdaFunctionInfo build() {
            return new LambdaFunctionInfo(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LambdaFunctionInfo> {
        public Builder functionName(String var1);

        public Builder functionAlias(String var1);

        public Builder currentVersion(String var1);

        public Builder targetVersion(String var1);

        public Builder targetVersionWeight(Double var1);
    }
}

