/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codedeploy.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.codedeploy.model.CodeDeployRequest;
import software.amazon.awssdk.services.codedeploy.model.DeploymentStatus;
import software.amazon.awssdk.services.codedeploy.model.DeploymentStatusListCopier;
import software.amazon.awssdk.services.codedeploy.model.TimeRange;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListDeploymentsRequest
extends CodeDeployRequest
implements ToCopyableBuilder<Builder, ListDeploymentsRequest> {
    private static final SdkField<String> APPLICATION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("applicationName").getter(ListDeploymentsRequest.getter(ListDeploymentsRequest::applicationName)).setter(ListDeploymentsRequest.setter(Builder::applicationName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("applicationName").build()}).build();
    private static final SdkField<String> DEPLOYMENT_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("deploymentGroupName").getter(ListDeploymentsRequest.getter(ListDeploymentsRequest::deploymentGroupName)).setter(ListDeploymentsRequest.setter(Builder::deploymentGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deploymentGroupName").build()}).build();
    private static final SdkField<String> EXTERNAL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("externalId").getter(ListDeploymentsRequest.getter(ListDeploymentsRequest::externalId)).setter(ListDeploymentsRequest.setter(Builder::externalId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("externalId").build()}).build();
    private static final SdkField<List<String>> INCLUDE_ONLY_STATUSES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("includeOnlyStatuses").getter(ListDeploymentsRequest.getter(ListDeploymentsRequest::includeOnlyStatusesAsStrings)).setter(ListDeploymentsRequest.setter(Builder::includeOnlyStatusesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("includeOnlyStatuses").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<TimeRange> CREATE_TIME_RANGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("createTimeRange").getter(ListDeploymentsRequest.getter(ListDeploymentsRequest::createTimeRange)).setter(ListDeploymentsRequest.setter(Builder::createTimeRange)).constructor(TimeRange::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createTimeRange").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListDeploymentsRequest.getter(ListDeploymentsRequest::nextToken)).setter(ListDeploymentsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_NAME_FIELD, DEPLOYMENT_GROUP_NAME_FIELD, EXTERNAL_ID_FIELD, INCLUDE_ONLY_STATUSES_FIELD, CREATE_TIME_RANGE_FIELD, NEXT_TOKEN_FIELD));
    private final String applicationName;
    private final String deploymentGroupName;
    private final String externalId;
    private final List<String> includeOnlyStatuses;
    private final TimeRange createTimeRange;
    private final String nextToken;

    private ListDeploymentsRequest(BuilderImpl builder) {
        super(builder);
        this.applicationName = builder.applicationName;
        this.deploymentGroupName = builder.deploymentGroupName;
        this.externalId = builder.externalId;
        this.includeOnlyStatuses = builder.includeOnlyStatuses;
        this.createTimeRange = builder.createTimeRange;
        this.nextToken = builder.nextToken;
    }

    public String applicationName() {
        return this.applicationName;
    }

    public String deploymentGroupName() {
        return this.deploymentGroupName;
    }

    public String externalId() {
        return this.externalId;
    }

    public List<DeploymentStatus> includeOnlyStatuses() {
        return DeploymentStatusListCopier.copyStringToEnum(this.includeOnlyStatuses);
    }

    public boolean hasIncludeOnlyStatuses() {
        return this.includeOnlyStatuses != null && !(this.includeOnlyStatuses instanceof SdkAutoConstructList);
    }

    public List<String> includeOnlyStatusesAsStrings() {
        return this.includeOnlyStatuses;
    }

    public TimeRange createTimeRange() {
        return this.createTimeRange;
    }

    public String nextToken() {
        return this.nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationName());
        hashCode = 31 * hashCode + Objects.hashCode(this.deploymentGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.externalId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasIncludeOnlyStatuses() ? this.includeOnlyStatusesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.createTimeRange());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDeploymentsRequest)) {
            return false;
        }
        ListDeploymentsRequest other = (ListDeploymentsRequest)((Object)obj);
        return Objects.equals(this.applicationName(), other.applicationName()) && Objects.equals(this.deploymentGroupName(), other.deploymentGroupName()) && Objects.equals(this.externalId(), other.externalId()) && this.hasIncludeOnlyStatuses() == other.hasIncludeOnlyStatuses() && Objects.equals(this.includeOnlyStatusesAsStrings(), other.includeOnlyStatusesAsStrings()) && Objects.equals(this.createTimeRange(), other.createTimeRange()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListDeploymentsRequest").add("ApplicationName", (Object)this.applicationName()).add("DeploymentGroupName", (Object)this.deploymentGroupName()).add("ExternalId", (Object)this.externalId()).add("IncludeOnlyStatuses", this.hasIncludeOnlyStatuses() ? this.includeOnlyStatusesAsStrings() : null).add("CreateTimeRange", (Object)this.createTimeRange()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "applicationName": {
                return Optional.ofNullable(clazz.cast(this.applicationName()));
            }
            case "deploymentGroupName": {
                return Optional.ofNullable(clazz.cast(this.deploymentGroupName()));
            }
            case "externalId": {
                return Optional.ofNullable(clazz.cast(this.externalId()));
            }
            case "includeOnlyStatuses": {
                return Optional.ofNullable(clazz.cast(this.includeOnlyStatusesAsStrings()));
            }
            case "createTimeRange": {
                return Optional.ofNullable(clazz.cast(this.createTimeRange()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListDeploymentsRequest, T> g) {
        return obj -> g.apply((ListDeploymentsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CodeDeployRequest.BuilderImpl
    implements Builder {
        private String applicationName;
        private String deploymentGroupName;
        private String externalId;
        private List<String> includeOnlyStatuses = DefaultSdkAutoConstructList.getInstance();
        private TimeRange createTimeRange;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDeploymentsRequest model) {
            super(model);
            this.applicationName(model.applicationName);
            this.deploymentGroupName(model.deploymentGroupName);
            this.externalId(model.externalId);
            this.includeOnlyStatusesWithStrings(model.includeOnlyStatuses);
            this.createTimeRange(model.createTimeRange);
            this.nextToken(model.nextToken);
        }

        public final String getApplicationName() {
            return this.applicationName;
        }

        @Override
        public final Builder applicationName(String applicationName) {
            this.applicationName = applicationName;
            return this;
        }

        public final void setApplicationName(String applicationName) {
            this.applicationName = applicationName;
        }

        public final String getDeploymentGroupName() {
            return this.deploymentGroupName;
        }

        @Override
        public final Builder deploymentGroupName(String deploymentGroupName) {
            this.deploymentGroupName = deploymentGroupName;
            return this;
        }

        public final void setDeploymentGroupName(String deploymentGroupName) {
            this.deploymentGroupName = deploymentGroupName;
        }

        public final String getExternalId() {
            return this.externalId;
        }

        @Override
        public final Builder externalId(String externalId) {
            this.externalId = externalId;
            return this;
        }

        public final void setExternalId(String externalId) {
            this.externalId = externalId;
        }

        public final Collection<String> getIncludeOnlyStatuses() {
            if (this.includeOnlyStatuses instanceof SdkAutoConstructList) {
                return null;
            }
            return this.includeOnlyStatuses;
        }

        @Override
        public final Builder includeOnlyStatusesWithStrings(Collection<String> includeOnlyStatuses) {
            this.includeOnlyStatuses = DeploymentStatusListCopier.copy(includeOnlyStatuses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder includeOnlyStatusesWithStrings(String ... includeOnlyStatuses) {
            this.includeOnlyStatusesWithStrings(Arrays.asList(includeOnlyStatuses));
            return this;
        }

        @Override
        public final Builder includeOnlyStatuses(Collection<DeploymentStatus> includeOnlyStatuses) {
            this.includeOnlyStatuses = DeploymentStatusListCopier.copyEnumToString(includeOnlyStatuses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder includeOnlyStatuses(DeploymentStatus ... includeOnlyStatuses) {
            this.includeOnlyStatuses(Arrays.asList(includeOnlyStatuses));
            return this;
        }

        public final void setIncludeOnlyStatuses(Collection<String> includeOnlyStatuses) {
            this.includeOnlyStatuses = DeploymentStatusListCopier.copy(includeOnlyStatuses);
        }

        public final TimeRange.Builder getCreateTimeRange() {
            return this.createTimeRange != null ? this.createTimeRange.toBuilder() : null;
        }

        @Override
        public final Builder createTimeRange(TimeRange createTimeRange) {
            this.createTimeRange = createTimeRange;
            return this;
        }

        public final void setCreateTimeRange(TimeRange.BuilderImpl createTimeRange) {
            this.createTimeRange = createTimeRange != null ? createTimeRange.build() : null;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListDeploymentsRequest build() {
            return new ListDeploymentsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CodeDeployRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListDeploymentsRequest> {
        public Builder applicationName(String var1);

        public Builder deploymentGroupName(String var1);

        public Builder externalId(String var1);

        public Builder includeOnlyStatusesWithStrings(Collection<String> var1);

        public Builder includeOnlyStatusesWithStrings(String ... var1);

        public Builder includeOnlyStatuses(Collection<DeploymentStatus> var1);

        public Builder includeOnlyStatuses(DeploymentStatus ... var1);

        public Builder createTimeRange(TimeRange var1);

        default public Builder createTimeRange(Consumer<TimeRange.Builder> createTimeRange) {
            return this.createTimeRange((TimeRange)((TimeRange.Builder)TimeRange.builder().applyMutation(createTimeRange)).build());
        }

        public Builder nextToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

