/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codedeploy.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.codedeploy.model.LifecycleEvent;
import software.amazon.awssdk.services.codedeploy.model.LifecycleEventListCopier;
import software.amazon.awssdk.services.codedeploy.model.TargetStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CloudFormationTarget
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CloudFormationTarget> {
    private static final SdkField<String> DEPLOYMENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("deploymentId").getter(CloudFormationTarget.getter(CloudFormationTarget::deploymentId)).setter(CloudFormationTarget.setter(Builder::deploymentId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deploymentId").build()}).build();
    private static final SdkField<String> TARGET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("targetId").getter(CloudFormationTarget.getter(CloudFormationTarget::targetId)).setter(CloudFormationTarget.setter(Builder::targetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetId").build()}).build();
    private static final SdkField<Instant> LAST_UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastUpdatedAt").getter(CloudFormationTarget.getter(CloudFormationTarget::lastUpdatedAt)).setter(CloudFormationTarget.setter(Builder::lastUpdatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedAt").build()}).build();
    private static final SdkField<List<LifecycleEvent>> LIFECYCLE_EVENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("lifecycleEvents").getter(CloudFormationTarget.getter(CloudFormationTarget::lifecycleEvents)).setter(CloudFormationTarget.setter(Builder::lifecycleEvents)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lifecycleEvents").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(LifecycleEvent::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(CloudFormationTarget.getter(CloudFormationTarget::statusAsString)).setter(CloudFormationTarget.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("resourceType").getter(CloudFormationTarget.getter(CloudFormationTarget::resourceType)).setter(CloudFormationTarget.setter(Builder::resourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceType").build()}).build();
    private static final SdkField<Double> TARGET_VERSION_WEIGHT_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("targetVersionWeight").getter(CloudFormationTarget.getter(CloudFormationTarget::targetVersionWeight)).setter(CloudFormationTarget.setter(Builder::targetVersionWeight)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetVersionWeight").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEPLOYMENT_ID_FIELD, TARGET_ID_FIELD, LAST_UPDATED_AT_FIELD, LIFECYCLE_EVENTS_FIELD, STATUS_FIELD, RESOURCE_TYPE_FIELD, TARGET_VERSION_WEIGHT_FIELD));
    private static final long serialVersionUID = 1L;
    private final String deploymentId;
    private final String targetId;
    private final Instant lastUpdatedAt;
    private final List<LifecycleEvent> lifecycleEvents;
    private final String status;
    private final String resourceType;
    private final Double targetVersionWeight;

    private CloudFormationTarget(BuilderImpl builder) {
        this.deploymentId = builder.deploymentId;
        this.targetId = builder.targetId;
        this.lastUpdatedAt = builder.lastUpdatedAt;
        this.lifecycleEvents = builder.lifecycleEvents;
        this.status = builder.status;
        this.resourceType = builder.resourceType;
        this.targetVersionWeight = builder.targetVersionWeight;
    }

    public final String deploymentId() {
        return this.deploymentId;
    }

    public final String targetId() {
        return this.targetId;
    }

    public final Instant lastUpdatedAt() {
        return this.lastUpdatedAt;
    }

    public final boolean hasLifecycleEvents() {
        return this.lifecycleEvents != null && !(this.lifecycleEvents instanceof SdkAutoConstructList);
    }

    public final List<LifecycleEvent> lifecycleEvents() {
        return this.lifecycleEvents;
    }

    public final TargetStatus status() {
        return TargetStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String resourceType() {
        return this.resourceType;
    }

    public final Double targetVersionWeight() {
        return this.targetVersionWeight;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.deploymentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLifecycleEvents() ? this.lifecycleEvents() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceType());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetVersionWeight());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CloudFormationTarget)) {
            return false;
        }
        CloudFormationTarget other = (CloudFormationTarget)obj;
        return Objects.equals(this.deploymentId(), other.deploymentId()) && Objects.equals(this.targetId(), other.targetId()) && Objects.equals(this.lastUpdatedAt(), other.lastUpdatedAt()) && this.hasLifecycleEvents() == other.hasLifecycleEvents() && Objects.equals(this.lifecycleEvents(), other.lifecycleEvents()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.resourceType(), other.resourceType()) && Objects.equals(this.targetVersionWeight(), other.targetVersionWeight());
    }

    public final String toString() {
        return ToString.builder((String)"CloudFormationTarget").add("DeploymentId", (Object)this.deploymentId()).add("TargetId", (Object)this.targetId()).add("LastUpdatedAt", (Object)this.lastUpdatedAt()).add("LifecycleEvents", this.hasLifecycleEvents() ? this.lifecycleEvents() : null).add("Status", (Object)this.statusAsString()).add("ResourceType", (Object)this.resourceType()).add("TargetVersionWeight", (Object)this.targetVersionWeight()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "deploymentId": {
                return Optional.ofNullable(clazz.cast(this.deploymentId()));
            }
            case "targetId": {
                return Optional.ofNullable(clazz.cast(this.targetId()));
            }
            case "lastUpdatedAt": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedAt()));
            }
            case "lifecycleEvents": {
                return Optional.ofNullable(clazz.cast(this.lifecycleEvents()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "resourceType": {
                return Optional.ofNullable(clazz.cast(this.resourceType()));
            }
            case "targetVersionWeight": {
                return Optional.ofNullable(clazz.cast(this.targetVersionWeight()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CloudFormationTarget, T> g) {
        return obj -> g.apply((CloudFormationTarget)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String deploymentId;
        private String targetId;
        private Instant lastUpdatedAt;
        private List<LifecycleEvent> lifecycleEvents = DefaultSdkAutoConstructList.getInstance();
        private String status;
        private String resourceType;
        private Double targetVersionWeight;

        private BuilderImpl() {
        }

        private BuilderImpl(CloudFormationTarget model) {
            this.deploymentId(model.deploymentId);
            this.targetId(model.targetId);
            this.lastUpdatedAt(model.lastUpdatedAt);
            this.lifecycleEvents(model.lifecycleEvents);
            this.status(model.status);
            this.resourceType(model.resourceType);
            this.targetVersionWeight(model.targetVersionWeight);
        }

        public final String getDeploymentId() {
            return this.deploymentId;
        }

        @Override
        public final Builder deploymentId(String deploymentId) {
            this.deploymentId = deploymentId;
            return this;
        }

        public final void setDeploymentId(String deploymentId) {
            this.deploymentId = deploymentId;
        }

        public final String getTargetId() {
            return this.targetId;
        }

        @Override
        public final Builder targetId(String targetId) {
            this.targetId = targetId;
            return this;
        }

        public final void setTargetId(String targetId) {
            this.targetId = targetId;
        }

        public final Instant getLastUpdatedAt() {
            return this.lastUpdatedAt;
        }

        @Override
        public final Builder lastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
            return this;
        }

        public final void setLastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
        }

        public final Collection<LifecycleEvent.Builder> getLifecycleEvents() {
            if (this.lifecycleEvents instanceof SdkAutoConstructList) {
                return null;
            }
            return this.lifecycleEvents != null ? (Collection)this.lifecycleEvents.stream().map(LifecycleEvent::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder lifecycleEvents(Collection<LifecycleEvent> lifecycleEvents) {
            this.lifecycleEvents = LifecycleEventListCopier.copy(lifecycleEvents);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lifecycleEvents(LifecycleEvent ... lifecycleEvents) {
            this.lifecycleEvents(Arrays.asList(lifecycleEvents));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lifecycleEvents(Consumer<LifecycleEvent.Builder> ... lifecycleEvents) {
            this.lifecycleEvents(Stream.of(lifecycleEvents).map(c -> (LifecycleEvent)((LifecycleEvent.Builder)LifecycleEvent.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setLifecycleEvents(Collection<LifecycleEvent.BuilderImpl> lifecycleEvents) {
            this.lifecycleEvents = LifecycleEventListCopier.copyFromBuilder(lifecycleEvents);
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(TargetStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getResourceType() {
            return this.resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        public final Double getTargetVersionWeight() {
            return this.targetVersionWeight;
        }

        @Override
        public final Builder targetVersionWeight(Double targetVersionWeight) {
            this.targetVersionWeight = targetVersionWeight;
            return this;
        }

        public final void setTargetVersionWeight(Double targetVersionWeight) {
            this.targetVersionWeight = targetVersionWeight;
        }

        public CloudFormationTarget build() {
            return new CloudFormationTarget(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CloudFormationTarget> {
        public Builder deploymentId(String var1);

        public Builder targetId(String var1);

        public Builder lastUpdatedAt(Instant var1);

        public Builder lifecycleEvents(Collection<LifecycleEvent> var1);

        public Builder lifecycleEvents(LifecycleEvent ... var1);

        public Builder lifecycleEvents(Consumer<LifecycleEvent.Builder> ... var1);

        public Builder status(String var1);

        public Builder status(TargetStatus var1);

        public Builder resourceType(String var1);

        public Builder targetVersionWeight(Double var1);
    }
}

