/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codedeploy.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum DeploymentOption {
    WITH_TRAFFIC_CONTROL("WITH_TRAFFIC_CONTROL"),
    WITHOUT_TRAFFIC_CONTROL("WITHOUT_TRAFFIC_CONTROL"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private DeploymentOption(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static DeploymentOption fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(DeploymentOption.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<DeploymentOption> knownValues() {
        return Stream.of(DeploymentOption.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

