/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codedeploy.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.codedeploy.model.CodeDeployResponse;
import software.amazon.awssdk.services.codedeploy.model.RevisionLocation;
import software.amazon.awssdk.services.codedeploy.model.RevisionLocationListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListApplicationRevisionsResponse
extends CodeDeployResponse
implements ToCopyableBuilder<Builder, ListApplicationRevisionsResponse> {
    private static final SdkField<List<RevisionLocation>> REVISIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("revisions").getter(ListApplicationRevisionsResponse.getter(ListApplicationRevisionsResponse::revisions)).setter(ListApplicationRevisionsResponse.setter(Builder::revisions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("revisions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RevisionLocation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListApplicationRevisionsResponse.getter(ListApplicationRevisionsResponse::nextToken)).setter(ListApplicationRevisionsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REVISIONS_FIELD, NEXT_TOKEN_FIELD));
    private final List<RevisionLocation> revisions;
    private final String nextToken;

    private ListApplicationRevisionsResponse(BuilderImpl builder) {
        super(builder);
        this.revisions = builder.revisions;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasRevisions() {
        return this.revisions != null && !(this.revisions instanceof SdkAutoConstructList);
    }

    public final List<RevisionLocation> revisions() {
        return this.revisions;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRevisions() ? this.revisions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListApplicationRevisionsResponse)) {
            return false;
        }
        ListApplicationRevisionsResponse other = (ListApplicationRevisionsResponse)((Object)obj);
        return this.hasRevisions() == other.hasRevisions() && Objects.equals(this.revisions(), other.revisions()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListApplicationRevisionsResponse").add("Revisions", this.hasRevisions() ? this.revisions() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "revisions": {
                return Optional.ofNullable(clazz.cast(this.revisions()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListApplicationRevisionsResponse, T> g) {
        return obj -> g.apply((ListApplicationRevisionsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CodeDeployResponse.BuilderImpl
    implements Builder {
        private List<RevisionLocation> revisions = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListApplicationRevisionsResponse model) {
            super(model);
            this.revisions(model.revisions);
            this.nextToken(model.nextToken);
        }

        public final Collection<RevisionLocation.Builder> getRevisions() {
            if (this.revisions instanceof SdkAutoConstructList) {
                return null;
            }
            return this.revisions != null ? (Collection)this.revisions.stream().map(RevisionLocation::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder revisions(Collection<RevisionLocation> revisions) {
            this.revisions = RevisionLocationListCopier.copy(revisions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder revisions(RevisionLocation ... revisions) {
            this.revisions(Arrays.asList(revisions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder revisions(Consumer<RevisionLocation.Builder> ... revisions) {
            this.revisions(Stream.of(revisions).map(c -> (RevisionLocation)((RevisionLocation.Builder)RevisionLocation.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setRevisions(Collection<RevisionLocation.BuilderImpl> revisions) {
            this.revisions = RevisionLocationListCopier.copyFromBuilder(revisions);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListApplicationRevisionsResponse build() {
            return new ListApplicationRevisionsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CodeDeployResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListApplicationRevisionsResponse> {
        public Builder revisions(Collection<RevisionLocation> var1);

        public Builder revisions(RevisionLocation ... var1);

        public Builder revisions(Consumer<RevisionLocation.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

