/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codedeploy.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.codedeploy.model.DeploymentStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LastDeploymentInfo
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LastDeploymentInfo> {
    private static final SdkField<String> DEPLOYMENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("deploymentId").getter(LastDeploymentInfo.getter(LastDeploymentInfo::deploymentId)).setter(LastDeploymentInfo.setter(Builder::deploymentId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deploymentId").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(LastDeploymentInfo.getter(LastDeploymentInfo::statusAsString)).setter(LastDeploymentInfo.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<Instant> END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("endTime").getter(LastDeploymentInfo.getter(LastDeploymentInfo::endTime)).setter(LastDeploymentInfo.setter(Builder::endTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endTime").build()}).build();
    private static final SdkField<Instant> CREATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createTime").getter(LastDeploymentInfo.getter(LastDeploymentInfo::createTime)).setter(LastDeploymentInfo.setter(Builder::createTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEPLOYMENT_ID_FIELD, STATUS_FIELD, END_TIME_FIELD, CREATE_TIME_FIELD));
    private static final long serialVersionUID = 1L;
    private final String deploymentId;
    private final String status;
    private final Instant endTime;
    private final Instant createTime;

    private LastDeploymentInfo(BuilderImpl builder) {
        this.deploymentId = builder.deploymentId;
        this.status = builder.status;
        this.endTime = builder.endTime;
        this.createTime = builder.createTime;
    }

    public final String deploymentId() {
        return this.deploymentId;
    }

    public final DeploymentStatus status() {
        return DeploymentStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final Instant endTime() {
        return this.endTime;
    }

    public final Instant createTime() {
        return this.createTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.deploymentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.endTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.createTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LastDeploymentInfo)) {
            return false;
        }
        LastDeploymentInfo other = (LastDeploymentInfo)obj;
        return Objects.equals(this.deploymentId(), other.deploymentId()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.endTime(), other.endTime()) && Objects.equals(this.createTime(), other.createTime());
    }

    public final String toString() {
        return ToString.builder((String)"LastDeploymentInfo").add("DeploymentId", (Object)this.deploymentId()).add("Status", (Object)this.statusAsString()).add("EndTime", (Object)this.endTime()).add("CreateTime", (Object)this.createTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "deploymentId": {
                return Optional.ofNullable(clazz.cast(this.deploymentId()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "endTime": {
                return Optional.ofNullable(clazz.cast(this.endTime()));
            }
            case "createTime": {
                return Optional.ofNullable(clazz.cast(this.createTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LastDeploymentInfo, T> g) {
        return obj -> g.apply((LastDeploymentInfo)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String deploymentId;
        private String status;
        private Instant endTime;
        private Instant createTime;

        private BuilderImpl() {
        }

        private BuilderImpl(LastDeploymentInfo model) {
            this.deploymentId(model.deploymentId);
            this.status(model.status);
            this.endTime(model.endTime);
            this.createTime(model.createTime);
        }

        public final String getDeploymentId() {
            return this.deploymentId;
        }

        @Override
        public final Builder deploymentId(String deploymentId) {
            this.deploymentId = deploymentId;
            return this;
        }

        public final void setDeploymentId(String deploymentId) {
            this.deploymentId = deploymentId;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(DeploymentStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final Instant getEndTime() {
            return this.endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        public final Instant getCreateTime() {
            return this.createTime;
        }

        @Override
        public final Builder createTime(Instant createTime) {
            this.createTime = createTime;
            return this;
        }

        public final void setCreateTime(Instant createTime) {
            this.createTime = createTime;
        }

        public LastDeploymentInfo build() {
            return new LastDeploymentInfo(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LastDeploymentInfo> {
        public Builder deploymentId(String var1);

        public Builder status(String var1);

        public Builder status(DeploymentStatus var1);

        public Builder endTime(Instant var1);

        public Builder createTime(Instant var1);
    }
}

