/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codedeploy;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.services.codedeploy.model.AddTagsToOnPremisesInstancesRequest;
import software.amazon.awssdk.services.codedeploy.model.AddTagsToOnPremisesInstancesResponse;
import software.amazon.awssdk.services.codedeploy.model.BatchGetApplicationRevisionsRequest;
import software.amazon.awssdk.services.codedeploy.model.BatchGetApplicationRevisionsResponse;
import software.amazon.awssdk.services.codedeploy.model.BatchGetApplicationsRequest;
import software.amazon.awssdk.services.codedeploy.model.BatchGetApplicationsResponse;
import software.amazon.awssdk.services.codedeploy.model.BatchGetDeploymentGroupsRequest;
import software.amazon.awssdk.services.codedeploy.model.BatchGetDeploymentGroupsResponse;
import software.amazon.awssdk.services.codedeploy.model.BatchGetDeploymentTargetsRequest;
import software.amazon.awssdk.services.codedeploy.model.BatchGetDeploymentTargetsResponse;
import software.amazon.awssdk.services.codedeploy.model.BatchGetDeploymentsRequest;
import software.amazon.awssdk.services.codedeploy.model.BatchGetDeploymentsResponse;
import software.amazon.awssdk.services.codedeploy.model.BatchGetOnPremisesInstancesRequest;
import software.amazon.awssdk.services.codedeploy.model.BatchGetOnPremisesInstancesResponse;
import software.amazon.awssdk.services.codedeploy.model.ContinueDeploymentRequest;
import software.amazon.awssdk.services.codedeploy.model.ContinueDeploymentResponse;
import software.amazon.awssdk.services.codedeploy.model.CreateApplicationRequest;
import software.amazon.awssdk.services.codedeploy.model.CreateApplicationResponse;
import software.amazon.awssdk.services.codedeploy.model.CreateDeploymentConfigRequest;
import software.amazon.awssdk.services.codedeploy.model.CreateDeploymentConfigResponse;
import software.amazon.awssdk.services.codedeploy.model.CreateDeploymentGroupRequest;
import software.amazon.awssdk.services.codedeploy.model.CreateDeploymentGroupResponse;
import software.amazon.awssdk.services.codedeploy.model.CreateDeploymentRequest;
import software.amazon.awssdk.services.codedeploy.model.CreateDeploymentResponse;
import software.amazon.awssdk.services.codedeploy.model.DeleteApplicationRequest;
import software.amazon.awssdk.services.codedeploy.model.DeleteApplicationResponse;
import software.amazon.awssdk.services.codedeploy.model.DeleteDeploymentConfigRequest;
import software.amazon.awssdk.services.codedeploy.model.DeleteDeploymentConfigResponse;
import software.amazon.awssdk.services.codedeploy.model.DeleteDeploymentGroupRequest;
import software.amazon.awssdk.services.codedeploy.model.DeleteDeploymentGroupResponse;
import software.amazon.awssdk.services.codedeploy.model.DeleteGitHubAccountTokenRequest;
import software.amazon.awssdk.services.codedeploy.model.DeleteGitHubAccountTokenResponse;
import software.amazon.awssdk.services.codedeploy.model.DeleteResourcesByExternalIdRequest;
import software.amazon.awssdk.services.codedeploy.model.DeleteResourcesByExternalIdResponse;
import software.amazon.awssdk.services.codedeploy.model.DeregisterOnPremisesInstanceRequest;
import software.amazon.awssdk.services.codedeploy.model.DeregisterOnPremisesInstanceResponse;
import software.amazon.awssdk.services.codedeploy.model.GetApplicationRequest;
import software.amazon.awssdk.services.codedeploy.model.GetApplicationResponse;
import software.amazon.awssdk.services.codedeploy.model.GetApplicationRevisionRequest;
import software.amazon.awssdk.services.codedeploy.model.GetApplicationRevisionResponse;
import software.amazon.awssdk.services.codedeploy.model.GetDeploymentConfigRequest;
import software.amazon.awssdk.services.codedeploy.model.GetDeploymentConfigResponse;
import software.amazon.awssdk.services.codedeploy.model.GetDeploymentGroupRequest;
import software.amazon.awssdk.services.codedeploy.model.GetDeploymentGroupResponse;
import software.amazon.awssdk.services.codedeploy.model.GetDeploymentRequest;
import software.amazon.awssdk.services.codedeploy.model.GetDeploymentResponse;
import software.amazon.awssdk.services.codedeploy.model.GetDeploymentTargetRequest;
import software.amazon.awssdk.services.codedeploy.model.GetDeploymentTargetResponse;
import software.amazon.awssdk.services.codedeploy.model.GetOnPremisesInstanceRequest;
import software.amazon.awssdk.services.codedeploy.model.GetOnPremisesInstanceResponse;
import software.amazon.awssdk.services.codedeploy.model.ListApplicationRevisionsRequest;
import software.amazon.awssdk.services.codedeploy.model.ListApplicationRevisionsResponse;
import software.amazon.awssdk.services.codedeploy.model.ListApplicationsRequest;
import software.amazon.awssdk.services.codedeploy.model.ListApplicationsResponse;
import software.amazon.awssdk.services.codedeploy.model.ListDeploymentConfigsRequest;
import software.amazon.awssdk.services.codedeploy.model.ListDeploymentConfigsResponse;
import software.amazon.awssdk.services.codedeploy.model.ListDeploymentGroupsRequest;
import software.amazon.awssdk.services.codedeploy.model.ListDeploymentGroupsResponse;
import software.amazon.awssdk.services.codedeploy.model.ListDeploymentTargetsRequest;
import software.amazon.awssdk.services.codedeploy.model.ListDeploymentTargetsResponse;
import software.amazon.awssdk.services.codedeploy.model.ListDeploymentsRequest;
import software.amazon.awssdk.services.codedeploy.model.ListDeploymentsResponse;
import software.amazon.awssdk.services.codedeploy.model.ListGitHubAccountTokenNamesRequest;
import software.amazon.awssdk.services.codedeploy.model.ListGitHubAccountTokenNamesResponse;
import software.amazon.awssdk.services.codedeploy.model.ListOnPremisesInstancesRequest;
import software.amazon.awssdk.services.codedeploy.model.ListOnPremisesInstancesResponse;
import software.amazon.awssdk.services.codedeploy.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.codedeploy.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.codedeploy.model.PutLifecycleEventHookExecutionStatusRequest;
import software.amazon.awssdk.services.codedeploy.model.PutLifecycleEventHookExecutionStatusResponse;
import software.amazon.awssdk.services.codedeploy.model.RegisterApplicationRevisionRequest;
import software.amazon.awssdk.services.codedeploy.model.RegisterApplicationRevisionResponse;
import software.amazon.awssdk.services.codedeploy.model.RegisterOnPremisesInstanceRequest;
import software.amazon.awssdk.services.codedeploy.model.RegisterOnPremisesInstanceResponse;
import software.amazon.awssdk.services.codedeploy.model.RemoveTagsFromOnPremisesInstancesRequest;
import software.amazon.awssdk.services.codedeploy.model.RemoveTagsFromOnPremisesInstancesResponse;
import software.amazon.awssdk.services.codedeploy.model.StopDeploymentRequest;
import software.amazon.awssdk.services.codedeploy.model.StopDeploymentResponse;
import software.amazon.awssdk.services.codedeploy.model.TagResourceRequest;
import software.amazon.awssdk.services.codedeploy.model.TagResourceResponse;
import software.amazon.awssdk.services.codedeploy.model.UntagResourceRequest;
import software.amazon.awssdk.services.codedeploy.model.UntagResourceResponse;
import software.amazon.awssdk.services.codedeploy.model.UpdateApplicationRequest;
import software.amazon.awssdk.services.codedeploy.model.UpdateApplicationResponse;
import software.amazon.awssdk.services.codedeploy.model.UpdateDeploymentGroupRequest;
import software.amazon.awssdk.services.codedeploy.model.UpdateDeploymentGroupResponse;
import software.amazon.awssdk.services.codedeploy.paginators.ListApplicationRevisionsPublisher;
import software.amazon.awssdk.services.codedeploy.paginators.ListApplicationsPublisher;
import software.amazon.awssdk.services.codedeploy.paginators.ListDeploymentConfigsPublisher;
import software.amazon.awssdk.services.codedeploy.paginators.ListDeploymentGroupsPublisher;
import software.amazon.awssdk.services.codedeploy.paginators.ListDeploymentsPublisher;
import software.amazon.awssdk.services.codedeploy.waiters.CodeDeployAsyncWaiter;

/**
 * Service client for accessing CodeDeploy asynchronously. This can be created using the static {@link #builder()}
 * method.
 *
 * <fullname>AWS CodeDeploy</fullname>
 * <p>
 * AWS CodeDeploy is a deployment service that automates application deployments to Amazon EC2 instances, on-premises
 * instances running in your own facility, serverless AWS Lambda functions, or applications in an Amazon ECS service.
 * </p>
 * <p>
 * You can deploy a nearly unlimited variety of application content, such as an updated Lambda function, updated
 * applications in an Amazon ECS service, code, web and configuration files, executables, packages, scripts, multimedia
 * files, and so on. AWS CodeDeploy can deploy application content stored in Amazon S3 buckets, GitHub repositories, or
 * Bitbucket repositories. You do not need to make changes to your existing code before you can use AWS CodeDeploy.
 * </p>
 * <p>
 * AWS CodeDeploy makes it easier for you to rapidly release new features, helps you avoid downtime during application
 * deployment, and handles the complexity of updating your applications, without many of the risks associated with
 * error-prone manual deployments.
 * </p>
 * <p>
 * <b>AWS CodeDeploy Components</b>
 * </p>
 * <p>
 * Use the information in this guide to help you work with the following AWS CodeDeploy components:
 * </p>
 * <ul>
 * <li>
 * <p>
 * <b>Application</b>: A name that uniquely identifies the application you want to deploy. AWS CodeDeploy uses this
 * name, which functions as a container, to ensure the correct combination of revision, deployment configuration, and
 * deployment group are referenced during a deployment.
 * </p>
 * </li>
 * <li>
 * <p>
 * <b>Deployment group</b>: A set of individual instances, CodeDeploy Lambda deployment configuration settings, or an
 * Amazon ECS service and network details. A Lambda deployment group specifies how to route traffic to a new version of
 * a Lambda function. An Amazon ECS deployment group specifies the service created in Amazon ECS to deploy, a load
 * balancer, and a listener to reroute production traffic to an updated containerized application. An EC2/On-premises
 * deployment group contains individually tagged instances, Amazon EC2 instances in Amazon EC2 Auto Scaling groups, or
 * both. All deployment groups can specify optional trigger, alarm, and rollback settings.
 * </p>
 * </li>
 * <li>
 * <p>
 * <b>Deployment configuration</b>: A set of deployment rules and deployment success and failure conditions used by AWS
 * CodeDeploy during a deployment.
 * </p>
 * </li>
 * <li>
 * <p>
 * <b>Deployment</b>: The process and the components used when updating a Lambda function, a containerized application
 * in an Amazon ECS service, or of installing content on one or more instances.
 * </p>
 * </li>
 * <li>
 * <p>
 * <b>Application revisions</b>: For an AWS Lambda deployment, this is an AppSpec file that specifies the Lambda
 * function to be updated and one or more functions to validate deployment lifecycle events. For an Amazon ECS
 * deployment, this is an AppSpec file that specifies the Amazon ECS task definition, container, and port where
 * production traffic is rerouted. For an EC2/On-premises deployment, this is an archive file that contains source
 * content—source code, webpages, executable files, and deployment scripts—along with an AppSpec file. Revisions are
 * stored in Amazon S3 buckets or GitHub repositories. For Amazon S3, a revision is uniquely identified by its Amazon S3
 * object key and its ETag, version, or both. For GitHub, a revision is uniquely identified by its commit ID.
 * </p>
 * </li>
 * </ul>
 * <p>
 * This guide also contains information to help you get details about the instances in your deployments, to make
 * on-premises instances available for AWS CodeDeploy deployments, to get details about a Lambda function deployment,
 * and to get details about Amazon ECS service deployments.
 * </p>
 * <p>
 * <b>AWS CodeDeploy Information Resources</b>
 * </p>
 * <ul>
 * <li>
 * <p>
 * <a href="https://docs.aws.amazon.com/codedeploy/latest/userguide">AWS CodeDeploy User Guide</a>
 * </p>
 * </li>
 * <li>
 * <p>
 * <a href="https://docs.aws.amazon.com/codedeploy/latest/APIReference/">AWS CodeDeploy API Reference Guide</a>
 * </p>
 * </li>
 * <li>
 * <p>
 * <a href="https://docs.aws.amazon.com/cli/latest/reference/deploy/index.html">AWS CLI Reference for AWS CodeDeploy</a>
 * </p>
 * </li>
 * <li>
 * <p>
 * <a href="https://forums.aws.amazon.com/forum.jspa?forumID=179">AWS CodeDeploy Developer Forum</a>
 * </p>
 * </li>
 * </ul>
 */
@Generated("software.amazon.awssdk:codegen")
public interface CodeDeployAsyncClient extends SdkClient {
    String SERVICE_NAME = "codedeploy";

    /**
     * Create a {@link CodeDeployAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static CodeDeployAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link CodeDeployAsyncClient}.
     */
    static CodeDeployAsyncClientBuilder builder() {
        return new DefaultCodeDeployAsyncClientBuilder();
    }

    /**
     * <p>
     * Adds tags to on-premises instances.
     * </p>
     *
     * @param addTagsToOnPremisesInstancesRequest
     *        Represents the input of, and adds tags to, an on-premises instance operation.
     * @return A Java Future containing the result of the AddTagsToOnPremisesInstances operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InstanceNameRequiredException An on-premises instance name was not specified.</li>
     *         <li>InvalidInstanceNameException The on-premises instance name was specified in an invalid format.</li>
     *         <li>TagRequiredException A tag was not specified.</li>
     *         <li>InvalidTagException The tag was specified in an invalid format.</li>
     *         <li>TagLimitExceededException The maximum allowed number of tags was exceeded.</li>
     *         <li>InstanceLimitExceededException The maximum number of allowed on-premises instances in a single call
     *         was exceeded.</li>
     *         <li>InstanceNotRegisteredException The specified on-premises instance is not registered.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeDeployException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeDeployAsyncClient.AddTagsToOnPremisesInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/AddTagsToOnPremisesInstances"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AddTagsToOnPremisesInstancesResponse> addTagsToOnPremisesInstances(
            AddTagsToOnPremisesInstancesRequest addTagsToOnPremisesInstancesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds tags to on-premises instances.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AddTagsToOnPremisesInstancesRequest.Builder}
     * avoiding the need to create one manually via {@link AddTagsToOnPremisesInstancesRequest#builder()}
     * </p>
     *
     * @param addTagsToOnPremisesInstancesRequest
     *        A {@link Consumer} that will call methods on {@link AddTagsToOnPremisesInstancesInput.Builder} to create a
     *        request. Represents the input of, and adds tags to, an on-premises instance operation.
     * @return A Java Future containing the result of the AddTagsToOnPremisesInstances operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InstanceNameRequiredException An on-premises instance name was not specified.</li>
     *         <li>InvalidInstanceNameException The on-premises instance name was specified in an invalid format.</li>
     *         <li>TagRequiredException A tag was not specified.</li>
     *         <li>InvalidTagException The tag was specified in an invalid format.</li>
     *         <li>TagLimitExceededException The maximum allowed number of tags was exceeded.</li>
     *         <li>InstanceLimitExceededException The maximum number of allowed on-premises instances in a single call
     *         was exceeded.</li>
     *         <li>InstanceNotRegisteredException The specified on-premises instance is not registered.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeDeployException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeDeployAsyncClient.AddTagsToOnPremisesInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/AddTagsToOnPremisesInstances"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AddTagsToOnPremisesInstancesResponse> addTagsToOnPremisesInstances(
            Consumer<AddTagsToOnPremisesInstancesRequest.Builder> addTagsToOnPremisesInstancesRequest) {
        return addTagsToOnPremisesInstances(AddTagsToOnPremisesInstancesRequest.builder()
                .applyMutation(addTagsToOnPremisesInstancesRequest).build());
    }

    /**
     * <p>
     * Gets information about one or more application revisions. The maximum number of application revisions that can be
     * returned is 25.
     * </p>
     *
     * @param batchGetApplicationRevisionsRequest
     *        Represents the input of a <code>BatchGetApplicationRevisions</code> operation.
     * @return A Java Future containing the result of the BatchGetApplicationRevisions operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ApplicationDoesNotExistException The application does not exist with the IAM user or AWS account.</li>
     *         <li>ApplicationNameRequiredException The minimum number of required application names was not specified.</li>
     *         <li>InvalidApplicationNameException The application name was specified in an invalid format.</li>
     *         <li>RevisionRequiredException The revision ID was not specified.</li>
     *         <li>InvalidRevisionException The revision was specified in an invalid format.</li>
     *         <li>BatchLimitExceededException The maximum number of names or IDs allowed for this request (100) was
     *         exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeDeployException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeDeployAsyncClient.BatchGetApplicationRevisions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/BatchGetApplicationRevisions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<BatchGetApplicationRevisionsResponse> batchGetApplicationRevisions(
            BatchGetApplicationRevisionsRequest batchGetApplicationRevisionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about one or more application revisions. The maximum number of application revisions that can be
     * returned is 25.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchGetApplicationRevisionsRequest.Builder}
     * avoiding the need to create one manually via {@link BatchGetApplicationRevisionsRequest#builder()}
     * </p>
     *
     * @param batchGetApplicationRevisionsRequest
     *        A {@link Consumer} that will call methods on {@link BatchGetApplicationRevisionsInput.Builder} to create a
     *        request. Represents the input of a <code>BatchGetApplicationRevisions</code> operation.
     * @return A Java Future containing the result of the BatchGetApplicationRevisions operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ApplicationDoesNotExistException The application does not exist with the IAM user or AWS account.</li>
     *         <li>ApplicationNameRequiredException The minimum number of required application names was not specified.</li>
     *         <li>InvalidApplicationNameException The application name was specified in an invalid format.</li>
     *         <li>RevisionRequiredException The revision ID was not specified.</li>
     *         <li>InvalidRevisionException The revision was specified in an invalid format.</li>
     *         <li>BatchLimitExceededException The maximum number of names or IDs allowed for this request (100) was
     *         exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeDeployException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeDeployAsyncClient.BatchGetApplicationRevisions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/BatchGetApplicationRevisions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<BatchGetApplicationRevisionsResponse> batchGetApplicationRevisions(
            Consumer<BatchGetApplicationRevisionsRequest.Builder> batchGetApplicationRevisionsRequest) {
        return batchGetApplicationRevisions(BatchGetApplicationRevisionsRequest.builder()
                .applyMutation(batchGetApplicationRevisionsRequest).build());
    }

    /**
     * <p>
     * Gets information about one or more applications. The maximum number of applications that can be returned is 100.
     * </p>
     *
     * @param batchGetApplicationsRequest
     *        Represents the input of a <code>BatchGetApplications</code> operation.
     * @return A Java Future containing the result of the BatchGetApplications operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ApplicationNameRequiredException The minimum number of required application names was not specified.</li>
     *         <li>InvalidApplicationNameException The application name was specified in an invalid format.</li>
     *         <li>ApplicationDoesNotExistException The application does not exist with the IAM user or AWS account.</li>
     *         <li>BatchLimitExceededException The maximum number of names or IDs allowed for this request (100) was
     *         exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeDeployException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeDeployAsyncClient.BatchGetApplications
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/BatchGetApplications"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<BatchGetApplicationsResponse> batchGetApplications(
            BatchGetApplicationsRequest batchGetApplicationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about one or more applications. The maximum number of applications that can be returned is 100.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchGetApplicationsRequest.Builder} avoiding the
     * need to create one manually via {@link BatchGetApplicationsRequest#builder()}
     * </p>
     *
     * @param batchGetApplicationsRequest
     *        A {@link Consumer} that will call methods on {@link BatchGetApplicationsInput.Builder} to create a
     *        request. Represents the input of a <code>BatchGetApplications</code> operation.
     * @return A Java Future containing the result of the BatchGetApplications operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ApplicationNameRequiredException The minimum number of required application names was not specified.</li>
     *         <li>InvalidApplicationNameException The application name was specified in an invalid format.</li>
     *         <li>ApplicationDoesNotExistException The application does not exist with the IAM user or AWS account.</li>
     *         <li>BatchLimitExceededException The maximum number of names or IDs allowed for this request (100) was
     *         exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeDeployException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeDeployAsyncClient.BatchGetApplications
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/BatchGetApplications"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<BatchGetApplicationsResponse> batchGetApplications(
            Consumer<BatchGetApplicationsRequest.Builder> batchGetApplicationsRequest) {
        return batchGetApplications(BatchGetApplicationsRequest.builder().applyMutation(batchGetApplicationsRequest).build());
    }

    /**
     * <p>
     * Gets information about one or more deployment groups.
     * </p>
     *
     * @param batchGetDeploymentGroupsRequest
     *        Represents the input of a <code>BatchGetDeploymentGroups</code> operation.
     * @return A Java Future containing the result of the BatchGetDeploymentGroups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ApplicationNameRequiredException The minimum number of required application names was not specified.</li>
     *         <li>InvalidApplicationNameException The application name was specified in an invalid format.</li>
     *         <li>ApplicationDoesNotExistException The application does not exist with the IAM user or AWS account.</li>
     *         <li>DeploymentGroupNameRequiredException The deployment group name was not specified.</li>
     *         <li>InvalidDeploymentGroupNameException The deployment group name was specified in an invalid format.</li>
     *         <li>BatchLimitExceededException The maximum number of names or IDs allowed for this request (100) was
     *         exceeded.</li>
     *         <li>DeploymentConfigDoesNotExistException The deployment configuration does not exist with the IAM user
     *         or AWS account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeDeployException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeDeployAsyncClient.BatchGetDeploymentGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/BatchGetDeploymentGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<BatchGetDeploymentGroupsResponse> batchGetDeploymentGroups(
            BatchGetDeploymentGroupsRequest batchGetDeploymentGroupsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about one or more deployment groups.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchGetDeploymentGroupsRequest.Builder} avoiding
     * the need to create one manually via {@link BatchGetDeploymentGroupsRequest#builder()}
     * </p>
     *
     * @param batchGetDeploymentGroupsRequest
     *        A {@link Consumer} that will call methods on {@link BatchGetDeploymentGroupsInput.Builder} to create a
     *        request. Represents the input of a <code>BatchGetDeploymentGroups</code> operation.
     * @return A Java Future containing the result of the BatchGetDeploymentGroups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ApplicationNameRequiredException The minimum number of required application names was not specified.</li>
     *         <li>InvalidApplicationNameException The application name was specified in an invalid format.</li>
     *         <li>ApplicationDoesNotExistException The application does not exist with the IAM user or AWS account.</li>
     *         <li>DeploymentGroupNameRequiredException The deployment group name was not specified.</li>
     *         <li>InvalidDeploymentGroupNameException The deployment group name was specified in an invalid format.</li>
     *         <li>BatchLimitExceededException The maximum number of names or IDs allowed for this request (100) was
     *         exceeded.</li>
     *         <li>DeploymentConfigDoesNotExistException The deployment configuration does not exist with the IAM user
     *         or AWS account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeDeployException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeDeployAsyncClient.BatchGetDeploymentGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/BatchGetDeploymentGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<BatchGetDeploymentGroupsResponse> batchGetDeploymentGroups(
            Consumer<BatchGetDeploymentGroupsRequest.Builder> batchGetDeploymentGroupsRequest) {
        return batchGetDeploymentGroups(BatchGetDeploymentGroupsRequest.builder().applyMutation(batchGetDeploymentGroupsRequest)
                .build());
    }

    /**
     * <p>
     * Returns an array of one or more targets associated with a deployment. This method works with all compute types
     * and should be used instead of the deprecated <code>BatchGetDeploymentInstances</code>. The maximum number of
     * targets that can be returned is 25.
     * </p>
     * <p>
     * The type of targets returned depends on the deployment's compute platform or deployment method:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>EC2/On-premises</b>: Information about EC2 instance targets.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>AWS Lambda</b>: Information about Lambda functions targets.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Amazon ECS</b>: Information about Amazon ECS service targets.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>CloudFormation</b>: Information about targets of blue/green deployments initiated by a CloudFormation stack
     * update.
     * </p>
     * </li>
     * </ul>
     *
     * @param batchGetDeploymentTargetsRequest
     * @return A Java Future containing the result of the BatchGetDeploymentTargets operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidDeploymentIdException At least one of the deployment IDs was specified in an invalid format.</li>
     *         <li>DeploymentIdRequiredException At least one deployment ID must be specified.</li>
     *         <li>DeploymentDoesNotExistException The deployment with the IAM user or AWS account does not exist.</li>
     *         <li>DeploymentNotStartedException The specified deployment has not started.</li>
     *         <li>DeploymentTargetIdRequiredException A deployment target ID was not provided.</li>
     *         <li>InvalidDeploymentTargetIdException The target ID provided was not valid.</li>
     *         <li>DeploymentTargetDoesNotExistException The provided target ID does not belong to the attempted
     *         deployment.</li>
     *         <li>DeploymentTargetListSizeExceededException The maximum number of targets that can be associated with
     *         an Amazon ECS or AWS Lambda deployment was exceeded. The target list of both types of deployments must
     *         have exactly one item. This exception does not apply to EC2/On-premises deployments.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeDeployException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeDeployAsyncClient.BatchGetDeploymentTargets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/BatchGetDeploymentTargets"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<BatchGetDeploymentTargetsResponse> batchGetDeploymentTargets(
            BatchGetDeploymentTargetsRequest batchGetDeploymentTargetsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns an array of one or more targets associated with a deployment. This method works with all compute types
     * and should be used instead of the deprecated <code>BatchGetDeploymentInstances</code>. The maximum number of
     * targets that can be returned is 25.
     * </p>
     * <p>
     * The type of targets returned depends on the deployment's compute platform or deployment method:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>EC2/On-premises</b>: Information about EC2 instance targets.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>AWS Lambda</b>: Information about Lambda functions targets.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Amazon ECS</b>: Information about Amazon ECS service targets.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>CloudFormation</b>: Information about targets of blue/green deployments initiated by a CloudFormation stack
     * update.
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchGetDeploymentTargetsRequest.Builder} avoiding
     * the need to create one manually via {@link BatchGetDeploymentTargetsRequest#builder()}
     * </p>
     *
     * @param batchGetDeploymentTargetsRequest
     *        A {@link Consumer} that will call methods on {@link BatchGetDeploymentTargetsInput.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the BatchGetDeploymentTargets operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidDeploymentIdException At least one of the deployment IDs was specified in an invalid format.</li>
     *         <li>DeploymentIdRequiredException At least one deployment ID must be specified.</li>
     *         <li>DeploymentDoesNotExistException The deployment with the IAM user or AWS account does not exist.</li>
     *         <li>DeploymentNotStartedException The specified deployment has not started.</li>
     *         <li>DeploymentTargetIdRequiredException A deployment target ID was not provided.</li>
     *         <li>InvalidDeploymentTargetIdException The target ID provided was not valid.</li>
     *         <li>DeploymentTargetDoesNotExistException The provided target ID does not belong to the attempted
     *         deployment.</li>
     *         <li>DeploymentTargetListSizeExceededException The maximum number of targets that can be associated with
     *         an Amazon ECS or AWS Lambda deployment was exceeded. The target list of both types of deployments must
     *         have exactly one item. This exception does not apply to EC2/On-premises deployments.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeDeployException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeDeployAsyncClient.BatchGetDeploymentTargets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/BatchGetDeploymentTargets"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<BatchGetDeploymentTargetsResponse> batchGetDeploymentTargets(
            Consumer<BatchGetDeploymentTargetsRequest.Builder> batchGetDeploymentTargetsRequest) {
        return batchGetDeploymentTargets(BatchGetDeploymentTargetsRequest.builder()
                .applyMutation(batchGetDeploymentTargetsRequest).build());
    }

    /**
     * <p>
     * Gets information about one or more deployments. The maximum number of deployments that can be returned is 25.
     * </p>
     *
     * @param batchGetDeploymentsRequest
     *        Represents the input of a <code>BatchGetDeployments</code> operation.
     * @return A Java Future containing the result of the BatchGetDeployments operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DeploymentIdRequiredException At least one deployment ID must be specified.</li>
     *         <li>InvalidDeploymentIdException At least one of the deployment IDs was specified in an invalid format.</li>
     *         <li>BatchLimitExceededException The maximum number of names or IDs allowed for this request (100) was
     *         exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeDeployException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeDeployAsyncClient.BatchGetDeployments
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/BatchGetDeployments"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<BatchGetDeploymentsResponse> batchGetDeployments(
            BatchGetDeploymentsRequest batchGetDeploymentsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about one or more deployments. The maximum number of deployments that can be returned is 25.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchGetDeploymentsRequest.Builder} avoiding the
     * need to create one manually via {@link BatchGetDeploymentsRequest#builder()}
     * </p>
     *
     * @param batchGetDeploymentsRequest
     *        A {@link Consumer} that will call methods on {@link BatchGetDeploymentsInput.Builder} to create a request.
     *        Represents the input of a <code>BatchGetDeployments</code> operation.
     * @return A Java Future containing the result of the BatchGetDeployments operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DeploymentIdRequiredException At least one deployment ID must be specified.</li>
     *         <li>InvalidDeploymentIdException At least one of the deployment IDs was specified in an invalid format.</li>
     *         <li>BatchLimitExceededException The maximum number of names or IDs allowed for this request (100) was
     *         exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeDeployException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeDeployAsyncClient.BatchGetDeployments
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/BatchGetDeployments"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<BatchGetDeploymentsResponse> batchGetDeployments(
            Consumer<BatchGetDeploymentsRequest.Builder> batchGetDeploymentsRequest) {
        return batchGetDeployments(BatchGetDeploymentsRequest.builder().applyMutation(batchGetDeploymentsRequest).build());
    }

    /**
     * <p>
     * Gets information about one or more on-premises instances. The maximum number of on-premises instances that can be
     * returned is 25.
     * </p>
     *
     * @param batchGetOnPremisesInstancesRequest
     *        Represents the input of a <code>BatchGetOnPremisesInstances</code> operation.
     * @return A Java Future containing the result of the BatchGetOnPremisesInstances operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InstanceNameRequiredException An on-premises instance name was not specified.</li>
     *         <li>InvalidInstanceNameException The on-premises instance name was specified in an invalid format.</li>
     *         <li>BatchLimitExceededException The maximum number of names or IDs allowed for this request (100) was
     *         exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeDeployException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeDeployAsyncClient.BatchGetOnPremisesInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/BatchGetOnPremisesInstances"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<BatchGetOnPremisesInstancesResponse> batchGetOnPremisesInstances(
            BatchGetOnPremisesInstancesRequest batchGetOnPremisesInstancesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about one or more on-premises instances. The maximum number of on-premises instances that can be
     * returned is 25.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchGetOnPremisesInstancesRequest.Builder}
     * avoiding the need to create one manually via {@link BatchGetOnPremisesInstancesRequest#builder()}
     * </p>
     *
     * @param batchGetOnPremisesInstancesRequest
     *        A {@link Consumer} that will call methods on {@link BatchGetOnPremisesInstancesInput.Builder} to create a
     *        request. Represents the input of a <code>BatchGetOnPremisesInstances</code> operation.
     * @return A Java Future containing the result of the BatchGetOnPremisesInstances operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InstanceNameRequiredException An on-premises instance name was not specified.</li>
     *         <li>InvalidInstanceNameException The on-premises instance name was specified in an invalid format.</li>
     *         <li>BatchLimitExceededException The maximum number of names or IDs allowed for this request (100) was
     *         exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeDeployException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeDeployAsyncClient.BatchGetOnPremisesInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/BatchGetOnPremisesInstances"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<BatchGetOnPremisesInstancesResponse> batchGetOnPremisesInstances(
            Consumer<BatchGetOnPremisesInstancesRequest.Builder> batchGetOnPremisesInstancesRequest) {
        return batchGetOnPremisesInstances(BatchGetOnPremisesInstancesRequest.builder()
                .applyMutation(batchGetOnPremisesInstancesRequest).build());
    }

    /**
     * <p>
     * For a blue/green deployment, starts the process of rerouting traffic from instances in the original environment
     * to instances in the replacement environment without waiting for a specified wait time to elapse. (Traffic
     * rerouting, which is achieved by registering instances in the replacement environment with the load balancer, can
     * start as soon as all instances have a status of Ready.)
     * </p>
     *
     * @param continueDeploymentRequest
     * @return A Java Future containing the result of the ContinueDeployment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DeploymentIdRequiredException At least one deployment ID must be specified.</li>
     *         <li>DeploymentDoesNotExistException The deployment with the IAM user or AWS account does not exist.</li>
     *         <li>DeploymentAlreadyCompletedException The deployment is already complete.</li>
     *         <li>InvalidDeploymentIdException At least one of the deployment IDs was specified in an invalid format.</li>
     *         <li>DeploymentIsNotInReadyStateException The deployment does not have a status of Ready and can't
     *         continue yet.</li>
     *         <li>UnsupportedActionForDeploymentTypeException A call was submitted that is not supported for the
     *         specified deployment type.</li>
     *         <li>InvalidDeploymentWaitTypeException The wait type is invalid.</li>
     *         <li>InvalidDeploymentStatusException The specified deployment status doesn't exist or cannot be
     *         determined.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeDeployException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeDeployAsyncClient.ContinueDeployment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/ContinueDeployment" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ContinueDeploymentResponse> continueDeployment(ContinueDeploymentRequest continueDeploymentRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * For a blue/green deployment, starts the process of rerouting traffic from instances in the original environment
     * to instances in the replacement environment without waiting for a specified wait time to elapse. (Traffic
     * rerouting, which is achieved by registering instances in the replacement environment with the load balancer, can
     * start as soon as all instances have a status of Ready.)
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ContinueDeploymentRequest.Builder} avoiding the
     * need to create one manually via {@link ContinueDeploymentRequest#builder()}
     * </p>
     *
     * @param continueDeploymentRequest
     *        A {@link Consumer} that will call methods on {@link ContinueDeploymentInput.Builder} to create a request.
     * @return A Java Future containing the result of the ContinueDeployment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DeploymentIdRequiredException At least one deployment ID must be specified.</li>
     *         <li>DeploymentDoesNotExistException The deployment with the IAM user or AWS account does not exist.</li>
     *         <li>DeploymentAlreadyCompletedException The deployment is already complete.</li>
     *         <li>InvalidDeploymentIdException At least one of the deployment IDs was specified in an invalid format.</li>
     *         <li>DeploymentIsNotInReadyStateException The deployment does not have a status of Ready and can't
     *         continue yet.</li>
     *         <li>UnsupportedActionForDeploymentTypeException A call was submitted that is not supported for the
     *         specified deployment type.</li>
     *         <li>InvalidDeploymentWaitTypeException The wait type is invalid.</li>
     *         <li>InvalidDeploymentStatusException The specified deployment status doesn't exist or cannot be
     *         determined.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeDeployException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeDeployAsyncClient.ContinueDeployment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/ContinueDeployment" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ContinueDeploymentResponse> continueDeployment(
            Consumer<ContinueDeploymentRequest.Builder> continueDeploymentRequest) {
        return continueDeployment(ContinueDeploymentRequest.builder().applyMutation(continueDeploymentRequest).build());
    }

    /**
     * <p>
     * Creates an application.
     * </p>
     *
     * @param createApplicationRequest
     *        Represents the input of a <code>CreateApplication</code> operation.
     * @return A Java Future containing the result of the CreateApplication operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ApplicationNameRequiredException The minimum number of required application names was not specified.</li>
     *         <li>InvalidApplicationNameException The application name was specified in an invalid format.</li>
     *         <li>ApplicationAlreadyExistsException An application with the specified name with the IAM user or AWS
     *         account already exists.</li>
     *         <li>ApplicationLimitExceededException More applications were attempted to be created than are allowed.</li>
     *         <li>InvalidComputePlatformException The computePlatform is invalid. The computePlatform should be
     *         <code>Lambda</code>, <code>Server</code>, or <code>ECS</code>.</li>
     *         <li>InvalidTagsToAddException The specified tags are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeDeployException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeDeployAsyncClient.CreateApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/CreateApplication" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateApplicationResponse> createApplication(CreateApplicationRequest createApplicationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an application.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateApplicationRequest.Builder} avoiding the need
     * to create one manually via {@link CreateApplicationRequest#builder()}
     * </p>
     *
     * @param createApplicationRequest
     *        A {@link Consumer} that will call methods on {@link CreateApplicationInput.Builder} to create a request.
     *        Represents the input of a <code>CreateApplication</code> operation.
     * @return A Java Future containing the result of the CreateApplication operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ApplicationNameRequiredException The minimum number of required application names was not specified.</li>
     *         <li>InvalidApplicationNameException The application name was specified in an invalid format.</li>
     *         <li>ApplicationAlreadyExistsException An application with the specified name with the IAM user or AWS
     *         account already exists.</li>
     *         <li>ApplicationLimitExceededException More applications were attempted to be created than are allowed.</li>
     *         <li>InvalidComputePlatformException The computePlatform is invalid. The computePlatform should be
     *         <code>Lambda</code>, <code>Server</code>, or <code>ECS</code>.</li>
     *         <li>InvalidTagsToAddException The specified tags are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeDeployException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeDeployAsyncClient.CreateApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/CreateApplication" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateApplicationResponse> createApplication(
            Consumer<CreateApplicationRequest.Builder> createApplicationRequest) {
        return createApplication(CreateApplicationRequest.builder().applyMutation(createApplicationRequest).build());
    }

    /**
     * <p>
     * Deploys an application revision through the specified deployment group.
     * </p>
     *
     * @param createDeploymentRequest
     *        Represents the input of a <code>CreateDeployment</code> operation.
     * @return A Java Future containing the result of the CreateDeployment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ApplicationNameRequiredException The minimum number of required application names was not specified.</li>
     *         <li>InvalidApplicationNameException The application name was specified in an invalid format.</li>
     *         <li>ApplicationDoesNotExistException The application does not exist with the IAM user or AWS account.</li>
     *         <li>DeploymentGroupNameRequiredException The deployment group name was not specified.</li>
     *         <li>InvalidDeploymentGroupNameException The deployment group name was specified in an invalid format.</li>
     *         <li>DeploymentGroupDoesNotExistException The named deployment group with the IAM user or AWS account does
     *         not exist.</li>
     *         <li>RevisionRequiredException The revision ID was not specified.</li>
     *         <li>RevisionDoesNotExistException The named revision does not exist with the IAM user or AWS account.</li>
     *         <li>InvalidRevisionException The revision was specified in an invalid format.</li>
     *         <li>InvalidDeploymentConfigNameException The deployment configuration name was specified in an invalid
     *         format.</li>
     *         <li>DeploymentConfigDoesNotExistException The deployment configuration does not exist with the IAM user
     *         or AWS account.</li>
     *         <li>DescriptionTooLongException The description is too long.</li>
     *         <li>DeploymentLimitExceededException The number of allowed deployments was exceeded.</li>
     *         <li>InvalidTargetInstancesException The target instance configuration is invalid. Possible causes
     *         include:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Configuration data for target instances was entered for an in-place deployment.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The limit of 10 tags for a tag type was exceeded.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The combined length of the tag names exceeded the limit.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         A specified tag is not currently applied to any instances.
     *         </p>
     *         </li></li>
     *         <li>InvalidAutoRollbackConfigException The automatic rollback configuration was specified in an invalid
     *         format. For example, automatic rollback is enabled, but an invalid triggering event type or no event
     *         types were listed.</li>
     *         <li>InvalidLoadBalancerInfoException An invalid load balancer name, or no load balancer name, was
     *         specified.</li>
     *         <li>InvalidFileExistsBehaviorException An invalid fileExistsBehavior option was specified to determine
     *         how AWS CodeDeploy handles files or directories that already exist in a deployment target location, but
     *         weren't part of the previous successful deployment. Valid values include "DISALLOW," "OVERWRITE," and
     *         "RETAIN."</li>
     *         <li>InvalidRoleException The service role ARN was specified in an invalid format. Or, if an Auto Scaling
     *         group was specified, the specified service role does not grant the appropriate permissions to Amazon EC2
     *         Auto Scaling.</li>
     *         <li>InvalidAutoScalingGroupException The Auto Scaling group was specified in an invalid format or does
     *         not exist.</li>
     *         <li>ThrottlingException An API function was called too frequently.</li>
     *         <li>InvalidUpdateOutdatedInstancesOnlyValueException The UpdateOutdatedInstancesOnly value is invalid.
     *         For AWS Lambda deployments, <code>false</code> is expected. For EC2/On-premises deployments,
     *         <code>true</code> or <code>false</code> is expected.</li>
     *         <li>InvalidIgnoreApplicationStopFailuresValueException The IgnoreApplicationStopFailures value is
     *         invalid. For AWS Lambda deployments, <code>false</code> is expected. For EC2/On-premises deployments,
     *         <code>true</code> or <code>false</code> is expected.</li>
     *         <li>InvalidGitHubAccountTokenException The GitHub token is not valid.</li>
     *         <li>InvalidTrafficRoutingConfigurationException The configuration that specifies how traffic is routed
     *         during a deployment is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeDeployException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeDeployAsyncClient.CreateDeployment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/CreateDeployment" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateDeploymentResponse> createDeployment(CreateDeploymentRequest createDeploymentRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deploys an application revision through the specified deployment group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateDeploymentRequest.Builder} avoiding the need
     * to create one manually via {@link CreateDeploymentRequest#builder()}
     * </p>
     *
     * @param createDeploymentRequest
     *        A {@link Consumer} that will call methods on {@link CreateDeploymentInput.Builder} to create a request.
     *        Represents the input of a <code>CreateDeployment</code> operation.
     * @return A Java Future containing the result of the CreateDeployment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ApplicationNameRequiredException The minimum number of required application names was not specified.</li>
     *         <li>InvalidApplicationNameException The application name was specified in an invalid format.</li>
     *         <li>ApplicationDoesNotExistException The application does not exist with the IAM user or AWS account.</li>
     *         <li>DeploymentGroupNameRequiredException The deployment group name was not specified.</li>
     *         <li>InvalidDeploymentGroupNameException The deployment group name was specified in an invalid format.</li>
     *         <li>DeploymentGroupDoesNotExistException The named deployment group with the IAM user or AWS account does
     *         not exist.</li>
     *         <li>RevisionRequiredException The revision ID was not specified.</li>
     *         <li>RevisionDoesNotExistException The named revision does not exist with the IAM user or AWS account.</li>
     *         <li>InvalidRevisionException The revision was specified in an invalid format.</li>
     *         <li>InvalidDeploymentConfigNameException The deployment configuration name was specified in an invalid
     *         format.</li>
     *         <li>DeploymentConfigDoesNotExistException The deployment configuration does not exist with the IAM user
     *         or AWS account.</li>
     *         <li>DescriptionTooLongException The description is too long.</li>
     *         <li>DeploymentLimitExceededException The number of allowed deployments was exceeded.</li>
     *         <li>InvalidTargetInstancesException The target instance configuration is invalid. Possible causes
     *         include:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Configuration data for target instances was entered for an in-place deployment.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The limit of 10 tags for a tag type was exceeded.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The combined length of the tag names exceeded the limit.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         A specified tag is not currently applied to any instances.
     *         </p>
     *         </li></li>
     *         <li>InvalidAutoRollbackConfigException The automatic rollback configuration was specified in an invalid
     *         format. For example, automatic rollback is enabled, but an invalid triggering event type or no event
     *         types were listed.</li>
     *         <li>InvalidLoadBalancerInfoException An invalid load balancer name, or no load balancer name, was
     *         specified.</li>
     *         <li>InvalidFileExistsBehaviorException An invalid fileExistsBehavior option was specified to determine
     *         how AWS CodeDeploy handles files or directories that already exist in a deployment target location, but
     *         weren't part of the previous successful deployment. Valid values include "DISALLOW," "OVERWRITE," and
     *         "RETAIN."</li>
     *         <li>InvalidRoleException The service role ARN was specified in an invalid format. Or, if an Auto Scaling
     *         group was specified, the specified service role does not grant the appropriate permissions to Amazon EC2
     *         Auto Scaling.</li>
     *         <li>InvalidAutoScalingGroupException The Auto Scaling group was specified in an invalid format or does
     *         not exist.</li>
     *         <li>ThrottlingException An API function was called too frequently.</li>
     *         <li>InvalidUpdateOutdatedInstancesOnlyValueException The UpdateOutdatedInstancesOnly value is invalid.
     *         For AWS Lambda deployments, <code>false</code> is expected. For EC2/On-premises deployments,
     *         <code>true</code> or <code>false</code> is expected.</li>
     *         <li>InvalidIgnoreApplicationStopFailuresValueException The IgnoreApplicationStopFailures value is
     *         invalid. For AWS Lambda deployments, <code>false</code> is expected. For EC2/On-premises deployments,
     *         <code>true</code> or <code>false</code> is expected.</li>
     *         <li>InvalidGitHubAccountTokenException The GitHub token is not valid.</li>
     *         <li>InvalidTrafficRoutingConfigurationException The configuration that specifies how traffic is routed
     *         during a deployment is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeDeployException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeDeployAsyncClient.CreateDeployment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/CreateDeployment" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateDeploymentResponse> createDeployment(
            Consumer<CreateDeploymentRequest.Builder> createDeploymentRequest) {
        return createDeployment(CreateDeploymentRequest.builder().applyMutation(createDeploymentRequest).build());
    }

    /**
     * <p>
     * Creates a deployment configuration.
     * </p>
     *
     * @param createDeploymentConfigRequest
     *        Represents the input of a <code>CreateDeploymentConfig</code> operation.
     * @return A Java Future containing the result of the CreateDeploymentConfig operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidDeploymentConfigNameException The deployment configuration name was specified in an invalid
     *         format.</li>
     *         <li>DeploymentConfigNameRequiredException The deployment configuration name was not specified.</li>
     *         <li>DeploymentConfigAlreadyExistsException A deployment configuration with the specified name with the
     *         IAM user or AWS account already exists.</li>
     *         <li>InvalidMinimumHealthyHostValueException The minimum healthy instance value was specified in an
     *         invalid format.</li>
     *         <li>DeploymentConfigLimitExceededException The deployment configurations limit was exceeded.</li>
     *         <li>InvalidComputePlatformException The computePlatform is invalid. The computePlatform should be
     *         <code>Lambda</code>, <code>Server</code>, or <code>ECS</code>.</li>
     *         <li>InvalidTrafficRoutingConfigurationException The configuration that specifies how traffic is routed
     *         during a deployment is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeDeployException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeDeployAsyncClient.CreateDeploymentConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/CreateDeploymentConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateDeploymentConfigResponse> createDeploymentConfig(
            CreateDeploymentConfigRequest createDeploymentConfigRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a deployment configuration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateDeploymentConfigRequest.Builder} avoiding the
     * need to create one manually via {@link CreateDeploymentConfigRequest#builder()}
     * </p>
     *
     * @param createDeploymentConfigRequest
     *        A {@link Consumer} that will call methods on {@link CreateDeploymentConfigInput.Builder} to create a
     *        request. Represents the input of a <code>CreateDeploymentConfig</code> operation.
     * @return A Java Future containing the result of the CreateDeploymentConfig operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidDeploymentConfigNameException The deployment configuration name was specified in an invalid
     *         format.</li>
     *         <li>DeploymentConfigNameRequiredException The deployment configuration name was not specified.</li>
     *         <li>DeploymentConfigAlreadyExistsException A deployment configuration with the specified name with the
     *         IAM user or AWS account already exists.</li>
     *         <li>InvalidMinimumHealthyHostValueException The minimum healthy instance value was specified in an
     *         invalid format.</li>
     *         <li>DeploymentConfigLimitExceededException The deployment configurations limit was exceeded.</li>
     *         <li>InvalidComputePlatformException The computePlatform is invalid. The computePlatform should be
     *         <code>Lambda</code>, <code>Server</code>, or <code>ECS</code>.</li>
     *         <li>InvalidTrafficRoutingConfigurationException The configuration that specifies how traffic is routed
     *         during a deployment is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeDeployException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeDeployAsyncClient.CreateDeploymentConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/CreateDeploymentConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateDeploymentConfigResponse> createDeploymentConfig(
            Consumer<CreateDeploymentConfigRequest.Builder> createDeploymentConfigRequest) {
        return createDeploymentConfig(CreateDeploymentConfigRequest.builder().applyMutation(createDeploymentConfigRequest)
                .build());
    }

    /**
     * <p>
     * Creates a deployment group to which application revisions are deployed.
     * </p>
     *
     * @param createDeploymentGroupRequest
     *        Represents the input of a <code>CreateDeploymentGroup</code> operation.
     * @return A Java Future containing the result of the CreateDeploymentGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ApplicationNameRequiredException The minimum number of required application names was not specified.</li>
     *         <li>InvalidApplicationNameException The application name was specified in an invalid format.</li>
     *         <li>ApplicationDoesNotExistException The application does not exist with the IAM user or AWS account.</li>
     *         <li>DeploymentGroupNameRequiredException The deployment group name was not specified.</li>
     *         <li>InvalidDeploymentGroupNameException The deployment group name was specified in an invalid format.</li>
     *         <li>DeploymentGroupAlreadyExistsException A deployment group with the specified name with the IAM user or
     *         AWS account already exists.</li>
     *         <li>InvalidEc2TagException The tag was specified in an invalid format.</li>
     *         <li>InvalidTagException The tag was specified in an invalid format.</li>
     *         <li>InvalidAutoScalingGroupException The Auto Scaling group was specified in an invalid format or does
     *         not exist.</li>
     *         <li>InvalidDeploymentConfigNameException The deployment configuration name was specified in an invalid
     *         format.</li>
     *         <li>DeploymentConfigDoesNotExistException The deployment configuration does not exist with the IAM user
     *         or AWS account.</li>
     *         <li>RoleRequiredException The role ID was not specified.</li>
     *         <li>InvalidRoleException The service role ARN was specified in an invalid format. Or, if an Auto Scaling
     *         group was specified, the specified service role does not grant the appropriate permissions to Amazon EC2
     *         Auto Scaling.</li>
     *         <li>DeploymentGroupLimitExceededException The deployment groups limit was exceeded.</li>
     *         <li>LifecycleHookLimitExceededException The limit for lifecycle hooks was exceeded.</li>
     *         <li>InvalidTriggerConfigException The trigger was specified in an invalid format.</li>
     *         <li>TriggerTargetsLimitExceededException The maximum allowed number of triggers was exceeded.</li>
     *         <li>InvalidAlarmConfigException The format of the alarm configuration is invalid. Possible causes
     *         include:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         The alarm list is null.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The alarm object is null.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The alarm name is empty or null or exceeds the limit of 255 characters.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Two alarms with the same name have been specified.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The alarm configuration is enabled, but the alarm list is empty.
     *         </p>
     *         </li></li>
     *         <li>AlarmsLimitExceededException The maximum number of alarms for a deployment group (10) was exceeded.</li>
     *         <li>InvalidAutoRollbackConfigException The automatic rollback configuration was specified in an invalid
     *         format. For example, automatic rollback is enabled, but an invalid triggering event type or no event
     *         types were listed.</li>
     *         <li>InvalidLoadBalancerInfoException An invalid load balancer name, or no load balancer name, was
     *         specified.</li>
     *         <li>InvalidDeploymentStyleException An invalid deployment style was specified. Valid deployment types
     *         include "IN_PLACE" and "BLUE_GREEN." Valid deployment options include "WITH_TRAFFIC_CONTROL" and
     *         "WITHOUT_TRAFFIC_CONTROL."</li>
     *         <li>InvalidBlueGreenDeploymentConfigurationException The configuration for the blue/green deployment
     *         group was provided in an invalid format. For information about deployment configuration format, see
     *         <a>CreateDeploymentConfig</a>.</li>
     *         <li>InvalidEc2TagCombinationException A call was submitted that specified both Ec2TagFilters and
     *         Ec2TagSet, but only one of these data types can be used in a single call.</li>
     *         <li>InvalidOnPremisesTagCombinationException A call was submitted that specified both
     *         OnPremisesTagFilters and OnPremisesTagSet, but only one of these data types can be used in a single call.
     *         </li>
     *         <li>TagSetListLimitExceededException The number of tag groups included in the tag set list exceeded the
     *         maximum allowed limit of 3.</li>
     *         <li>InvalidInputException The input was specified in an invalid format.</li>
     *         <li>ThrottlingException An API function was called too frequently.</li>
     *         <li>InvalidEcsServiceException The Amazon ECS service identifier is not valid.</li>
     *         <li>InvalidTargetGroupPairException A target group pair associated with this deployment is not valid.</li>
     *         <li>EcsServiceMappingLimitExceededException The Amazon ECS service is associated with more than one
     *         deployment groups. An Amazon ECS service can be associated with only one deployment group.</li>
     *         <li>InvalidTagsToAddException The specified tags are not valid.</li>
     *         <li>InvalidTrafficRoutingConfigurationException The configuration that specifies how traffic is routed
     *         during a deployment is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeDeployException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeDeployAsyncClient.CreateDeploymentGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/CreateDeploymentGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateDeploymentGroupResponse> createDeploymentGroup(
            CreateDeploymentGroupRequest createDeploymentGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a deployment group to which application revisions are deployed.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateDeploymentGroupRequest.Builder} avoiding the
     * need to create one manually via {@link CreateDeploymentGroupRequest#builder()}
     * </p>
     *
     * @param createDeploymentGroupRequest
     *        A {@link Consumer} that will call methods on {@link CreateDeploymentGroupInput.Builder} to create a
     *        request. Represents the input of a <code>CreateDeploymentGroup</code> operation.
     * @return A Java Future containing the result of the CreateDeploymentGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ApplicationNameRequiredException The minimum number of required application names was not specified.</li>
     *         <li>InvalidApplicationNameException The application name was specified in an invalid format.</li>
     *         <li>ApplicationDoesNotExistException The application does not exist with the IAM user or AWS account.</li>
     *         <li>DeploymentGroupNameRequiredException The deployment group name was not specified.</li>
     *         <li>InvalidDeploymentGroupNameException The deployment group name was specified in an invalid format.</li>
     *         <li>DeploymentGroupAlreadyExistsException A deployment group with the specified name with the IAM user or
     *         AWS account already exists.</li>
     *         <li>InvalidEc2TagException The tag was specified in an invalid format.</li>
     *         <li>InvalidTagException The tag was specified in an invalid format.</li>
     *         <li>InvalidAutoScalingGroupException The Auto Scaling group was specified in an invalid format or does
     *         not exist.</li>
     *         <li>InvalidDeploymentConfigNameException The deployment configuration name was specified in an invalid
     *         format.</li>
     *         <li>DeploymentConfigDoesNotExistException The deployment configuration does not exist with the IAM user
     *         or AWS account.</li>
     *         <li>RoleRequiredException The role ID was not specified.</li>
     *         <li>InvalidRoleException The service role ARN was specified in an invalid format. Or, if an Auto Scaling
     *         group was specified, the specified service role does not grant the appropriate permissions to Amazon EC2
     *         Auto Scaling.</li>
     *         <li>DeploymentGroupLimitExceededException The deployment groups limit was exceeded.</li>
     *         <li>LifecycleHookLimitExceededException The limit for lifecycle hooks was exceeded.</li>
     *         <li>InvalidTriggerConfigException The trigger was specified in an invalid format.</li>
     *         <li>TriggerTargetsLimitExceededException The maximum allowed number of triggers was exceeded.</li>
     *         <li>InvalidAlarmConfigException The format of the alarm configuration is invalid. Possible causes
     *         include:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         The alarm list is null.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The alarm object is null.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The alarm name is empty or null or exceeds the limit of 255 characters.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Two alarms with the same name have been specified.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The alarm configuration is enabled, but the alarm list is empty.
     *         </p>
     *         </li></li>
     *         <li>AlarmsLimitExceededException The maximum number of alarms for a deployment group (10) was exceeded.</li>
     *         <li>InvalidAutoRollbackConfigException The automatic rollback configuration was specified in an invalid
     *         format. For example, automatic rollback is enabled, but an invalid triggering event type or no event
     *         types were listed.</li>
     *         <li>InvalidLoadBalancerInfoException An invalid load balancer name, or no load balancer name, was
     *         specified.</li>
     *         <li>InvalidDeploymentStyleException An invalid deployment style was specified. Valid deployment types
     *         include "IN_PLACE" and "BLUE_GREEN." Valid deployment options include "WITH_TRAFFIC_CONTROL" and
     *         "WITHOUT_TRAFFIC_CONTROL."</li>
     *         <li>InvalidBlueGreenDeploymentConfigurationException The configuration for the blue/green deployment
     *         group was provided in an invalid format. For information about deployment configuration format, see
     *         <a>CreateDeploymentConfig</a>.</li>
     *         <li>InvalidEc2TagCombinationException A call was submitted that specified both Ec2TagFilters and
     *         Ec2TagSet, but only one of these data types can be used in a single call.</li>
     *         <li>InvalidOnPremisesTagCombinationException A call was submitted that specified both
     *         OnPremisesTagFilters and OnPremisesTagSet, but only one of these data types can be used in a single call.
     *         </li>
     *         <li>TagSetListLimitExceededException The number of tag groups included in the tag set list exceeded the
     *         maximum allowed limit of 3.</li>
     *         <li>InvalidInputException The input was specified in an invalid format.</li>
     *         <li>ThrottlingException An API function was called too frequently.</li>
     *         <li>InvalidEcsServiceException The Amazon ECS service identifier is not valid.</li>
     *         <li>InvalidTargetGroupPairException A target group pair associated with this deployment is not valid.</li>
     *         <li>EcsServiceMappingLimitExceededException The Amazon ECS service is associated with more than one
     *         deployment groups. An Amazon ECS service can be associated with only one deployment group.</li>
     *         <li>InvalidTagsToAddException The specified tags are not valid.</li>
     *         <li>InvalidTrafficRoutingConfigurationException The configuration that specifies how traffic is routed
     *         during a deployment is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeDeployException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeDeployAsyncClient.CreateDeploymentGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/CreateDeploymentGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateDeploymentGroupResponse> createDeploymentGroup(
            Consumer<CreateDeploymentGroupRequest.Builder> createDeploymentGroupRequest) {
        return createDeploymentGroup(CreateDeploymentGroupRequest.builder().applyMutation(createDeploymentGroupRequest).build());
    }

    /**
     * <p>
     * Deletes an application.
     * </p>
     *
     * @param deleteApplicationRequest
     *        Represents the input of a <code>DeleteApplication</code> operation.
     * @return A Java Future containing the result of the DeleteApplication operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ApplicationNameRequiredException The minimum number of required application names was not specified.</li>
     *         <li>InvalidApplicationNameException The application name was specified in an invalid format.</li>
     *         <li>InvalidRoleException The service role ARN was specified in an invalid format. Or, if an Auto Scaling
     *         group was specified, the specified service role does not grant the appropriate permissions to Amazon EC2
     *         Auto Scaling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeDeployException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeDeployAsyncClient.DeleteApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/DeleteApplication" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteApplicationResponse> deleteApplication(DeleteApplicationRequest deleteApplicationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an application.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteApplicationRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteApplicationRequest#builder()}
     * </p>
     *
     * @param deleteApplicationRequest
     *        A {@link Consumer} that will call methods on {@link DeleteApplicationInput.Builder} to create a request.
     *        Represents the input of a <code>DeleteApplication</code> operation.
     * @return A Java Future containing the result of the DeleteApplication operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ApplicationNameRequiredException The minimum number of required application names was not specified.</li>
     *         <li>InvalidApplicationNameException The application name was specified in an invalid format.</li>
     *         <li>InvalidRoleException The service role ARN was specified in an invalid format. Or, if an Auto Scaling
     *         group was specified, the specified service role does not grant the appropriate permissions to Amazon EC2
     *         Auto Scaling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeDeployException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeDeployAsyncClient.DeleteApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/DeleteApplication" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteApplicationResponse> deleteApplication(
            Consumer<DeleteApplicationRequest.Builder> deleteApplicationRequest) {
        return deleteApplication(DeleteApplicationRequest.builder().applyMutation(deleteApplicationRequest).build());
    }

    /**
     * <p>
     * Deletes a deployment configuration.
     * </p>
     * <note>
     * <p>
     * A deployment configuration cannot be deleted if it is currently in use. Predefined configurations cannot be
     * deleted.
     * </p>
     * </note>
     *
     * @param deleteDeploymentConfigRequest
     *        Represents the input of a <code>DeleteDeploymentConfig</code> operation.
     * @return A Java Future containing the result of the DeleteDeploymentConfig operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidDeploymentConfigNameException The deployment configuration name was specified in an invalid
     *         format.</li>
     *         <li>DeploymentConfigNameRequiredException The deployment configuration name was not specified.</li>
     *         <li>DeploymentConfigInUseException The deployment configuration is still in use.</li>
     *         <li>InvalidOperationException An invalid operation was detected.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeDeployException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeDeployAsyncClient.DeleteDeploymentConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/DeleteDeploymentConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteDeploymentConfigResponse> deleteDeploymentConfig(
            DeleteDeploymentConfigRequest deleteDeploymentConfigRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a deployment configuration.
     * </p>
     * <note>
     * <p>
     * A deployment configuration cannot be deleted if it is currently in use. Predefined configurations cannot be
     * deleted.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteDeploymentConfigRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteDeploymentConfigRequest#builder()}
     * </p>
     *
     * @param deleteDeploymentConfigRequest
     *        A {@link Consumer} that will call methods on {@link DeleteDeploymentConfigInput.Builder} to create a
     *        request. Represents the input of a <code>DeleteDeploymentConfig</code> operation.
     * @return A Java Future containing the result of the DeleteDeploymentConfig operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidDeploymentConfigNameException The deployment configuration name was specified in an invalid
     *         format.</li>
     *         <li>DeploymentConfigNameRequiredException The deployment configuration name was not specified.</li>
     *         <li>DeploymentConfigInUseException The deployment configuration is still in use.</li>
     *         <li>InvalidOperationException An invalid operation was detected.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeDeployException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeDeployAsyncClient.DeleteDeploymentConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/DeleteDeploymentConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteDeploymentConfigResponse> deleteDeploymentConfig(
            Consumer<DeleteDeploymentConfigRequest.Builder> deleteDeploymentConfigRequest) {
        return deleteDeploymentConfig(DeleteDeploymentConfigRequest.builder().applyMutation(deleteDeploymentConfigRequest)
                .build());
    }

    /**
     * <p>
     * Deletes a deployment group.
     * </p>
     *
     * @param deleteDeploymentGroupRequest
     *        Represents the input of a <code>DeleteDeploymentGroup</code> operation.
     * @return A Java Future containing the result of the DeleteDeploymentGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ApplicationNameRequiredException The minimum number of required application names was not specified.</li>
     *         <li>InvalidApplicationNameException The application name was specified in an invalid format.</li>
     *         <li>DeploymentGroupNameRequiredException The deployment group name was not specified.</li>
     *         <li>InvalidDeploymentGroupNameException The deployment group name was specified in an invalid format.</li>
     *         <li>InvalidRoleException The service role ARN was specified in an invalid format. Or, if an Auto Scaling
     *         group was specified, the specified service role does not grant the appropriate permissions to Amazon EC2
     *         Auto Scaling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeDeployException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeDeployAsyncClient.DeleteDeploymentGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/DeleteDeploymentGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteDeploymentGroupResponse> deleteDeploymentGroup(
            DeleteDeploymentGroupRequest deleteDeploymentGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a deployment group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteDeploymentGroupRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteDeploymentGroupRequest#builder()}
     * </p>
     *
     * @param deleteDeploymentGroupRequest
     *        A {@link Consumer} that will call methods on {@link DeleteDeploymentGroupInput.Builder} to create a
     *        request. Represents the input of a <code>DeleteDeploymentGroup</code> operation.
     * @return A Java Future containing the result of the DeleteDeploymentGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ApplicationNameRequiredException The minimum number of required application names was not specified.</li>
     *         <li>InvalidApplicationNameException The application name was specified in an invalid format.</li>
     *         <li>DeploymentGroupNameRequiredException The deployment group name was not specified.</li>
     *         <li>InvalidDeploymentGroupNameException The deployment group name was specified in an invalid format.</li>
     *         <li>InvalidRoleException The service role ARN was specified in an invalid format. Or, if an Auto Scaling
     *         group was specified, the specified service role does not grant the appropriate permissions to Amazon EC2
     *         Auto Scaling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeDeployException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeDeployAsyncClient.DeleteDeploymentGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/DeleteDeploymentGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteDeploymentGroupResponse> deleteDeploymentGroup(
            Consumer<DeleteDeploymentGroupRequest.Builder> deleteDeploymentGroupRequest) {
        return deleteDeploymentGroup(DeleteDeploymentGroupRequest.builder().applyMutation(deleteDeploymentGroupRequest).build());
    }

    /**
     * <p>
     * Deletes a GitHub account connection.
     * </p>
     *
     * @param deleteGitHubAccountTokenRequest
     *        Represents the input of a <code>DeleteGitHubAccount</code> operation.
     * @return A Java Future containing the result of the DeleteGitHubAccountToken operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>GitHubAccountTokenNameRequiredException The call is missing a required GitHub account connection
     *         name.</li>
     *         <li>GitHubAccountTokenDoesNotExistException No GitHub account connection exists with the named specified
     *         in the call.</li>
     *         <li>InvalidGitHubAccountTokenNameException The format of the specified GitHub account connection name is
     *         invalid.</li>
     *         <li>ResourceValidationException The specified resource could not be validated.</li>
     *         <li>OperationNotSupportedException The API used does not support the deployment.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeDeployException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeDeployAsyncClient.DeleteGitHubAccountToken
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/DeleteGitHubAccountToken"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteGitHubAccountTokenResponse> deleteGitHubAccountToken(
            DeleteGitHubAccountTokenRequest deleteGitHubAccountTokenRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a GitHub account connection.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteGitHubAccountTokenRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteGitHubAccountTokenRequest#builder()}
     * </p>
     *
     * @param deleteGitHubAccountTokenRequest
     *        A {@link Consumer} that will call methods on {@link DeleteGitHubAccountTokenInput.Builder} to create a
     *        request. Represents the input of a <code>DeleteGitHubAccount</code> operation.
     * @return A Java Future containing the result of the DeleteGitHubAccountToken operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>GitHubAccountTokenNameRequiredException The call is missing a required GitHub account connection
     *         name.</li>
     *         <li>GitHubAccountTokenDoesNotExistException No GitHub account connection exists with the named specified
     *         in the call.</li>
     *         <li>InvalidGitHubAccountTokenNameException The format of the specified GitHub account connection name is
     *         invalid.</li>
     *         <li>ResourceValidationException The specified resource could not be validated.</li>
     *         <li>OperationNotSupportedException The API used does not support the deployment.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeDeployException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeDeployAsyncClient.DeleteGitHubAccountToken
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/DeleteGitHubAccountToken"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteGitHubAccountTokenResponse> deleteGitHubAccountToken(
            Consumer<DeleteGitHubAccountTokenRequest.Builder> deleteGitHubAccountTokenRequest) {
        return deleteGitHubAccountToken(DeleteGitHubAccountTokenRequest.builder().applyMutation(deleteGitHubAccountTokenRequest)
                .build());
    }

    /**
     * <p>
     * Deletes resources linked to an external ID.
     * </p>
     *
     * @param deleteResourcesByExternalIdRequest
     * @return A Java Future containing the result of the DeleteResourcesByExternalId operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeDeployException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeDeployAsyncClient.DeleteResourcesByExternalId
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/DeleteResourcesByExternalId"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteResourcesByExternalIdResponse> deleteResourcesByExternalId(
            DeleteResourcesByExternalIdRequest deleteResourcesByExternalIdRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes resources linked to an external ID.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteResourcesByExternalIdRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteResourcesByExternalIdRequest#builder()}
     * </p>
     *
     * @param deleteResourcesByExternalIdRequest
     *        A {@link Consumer} that will call methods on {@link DeleteResourcesByExternalIdInput.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteResourcesByExternalId operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeDeployException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeDeployAsyncClient.DeleteResourcesByExternalId
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/DeleteResourcesByExternalId"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteResourcesByExternalIdResponse> deleteResourcesByExternalId(
            Consumer<DeleteResourcesByExternalIdRequest.Builder> deleteResourcesByExternalIdRequest) {
        return deleteResourcesByExternalId(DeleteResourcesByExternalIdRequest.builder()
                .applyMutation(deleteResourcesByExternalIdRequest).build());
    }

    /**
     * <p>
     * Deregisters an on-premises instance.
     * </p>
     *
     * @param deregisterOnPremisesInstanceRequest
     *        Represents the input of a <code>DeregisterOnPremisesInstance</code> operation.
     * @return A Java Future containing the result of the DeregisterOnPremisesInstance operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InstanceNameRequiredException An on-premises instance name was not specified.</li>
     *         <li>InvalidInstanceNameException The on-premises instance name was specified in an invalid format.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeDeployException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeDeployAsyncClient.DeregisterOnPremisesInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/DeregisterOnPremisesInstance"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeregisterOnPremisesInstanceResponse> deregisterOnPremisesInstance(
            DeregisterOnPremisesInstanceRequest deregisterOnPremisesInstanceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deregisters an on-premises instance.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeregisterOnPremisesInstanceRequest.Builder}
     * avoiding the need to create one manually via {@link DeregisterOnPremisesInstanceRequest#builder()}
     * </p>
     *
     * @param deregisterOnPremisesInstanceRequest
     *        A {@link Consumer} that will call methods on {@link DeregisterOnPremisesInstanceInput.Builder} to create a
     *        request. Represents the input of a <code>DeregisterOnPremisesInstance</code> operation.
     * @return A Java Future containing the result of the DeregisterOnPremisesInstance operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InstanceNameRequiredException An on-premises instance name was not specified.</li>
     *         <li>InvalidInstanceNameException The on-premises instance name was specified in an invalid format.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeDeployException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeDeployAsyncClient.DeregisterOnPremisesInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/DeregisterOnPremisesInstance"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeregisterOnPremisesInstanceResponse> deregisterOnPremisesInstance(
            Consumer<DeregisterOnPremisesInstanceRequest.Builder> deregisterOnPremisesInstanceRequest) {
        return deregisterOnPremisesInstance(DeregisterOnPremisesInstanceRequest.builder()
                .applyMutation(deregisterOnPremisesInstanceRequest).build());
    }

    /**
     * <p>
     * Gets information about an application.
     * </p>
     *
     * @param getApplicationRequest
     *        Represents the input of a <code>GetApplication</code> operation.
     * @return A Java Future containing the result of the GetApplication operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ApplicationNameRequiredException The minimum number of required application names was not specified.</li>
     *         <li>InvalidApplicationNameException The application name was specified in an invalid format.</li>
     *         <li>ApplicationDoesNotExistException The application does not exist with the IAM user or AWS account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeDeployException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeDeployAsyncClient.GetApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/GetApplication" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetApplicationResponse> getApplication(GetApplicationRequest getApplicationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about an application.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetApplicationRequest.Builder} avoiding the need to
     * create one manually via {@link GetApplicationRequest#builder()}
     * </p>
     *
     * @param getApplicationRequest
     *        A {@link Consumer} that will call methods on {@link GetApplicationInput.Builder} to create a request.
     *        Represents the input of a <code>GetApplication</code> operation.
     * @return A Java Future containing the result of the GetApplication operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ApplicationNameRequiredException The minimum number of required application names was not specified.</li>
     *         <li>InvalidApplicationNameException The application name was specified in an invalid format.</li>
     *         <li>ApplicationDoesNotExistException The application does not exist with the IAM user or AWS account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeDeployException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeDeployAsyncClient.GetApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/GetApplication" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetApplicationResponse> getApplication(Consumer<GetApplicationRequest.Builder> getApplicationRequest) {
        return getApplication(GetApplicationRequest.builder().applyMutation(getApplicationRequest).build());
    }

    /**
     * <p>
     * Gets information about an application revision.
     * </p>
     *
     * @param getApplicationRevisionRequest
     *        Represents the input of a <code>GetApplicationRevision</code> operation.
     * @return A Java Future containing the result of the GetApplicationRevision operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ApplicationDoesNotExistException The application does not exist with the IAM user or AWS account.</li>
     *         <li>ApplicationNameRequiredException The minimum number of required application names was not specified.</li>
     *         <li>InvalidApplicationNameException The application name was specified in an invalid format.</li>
     *         <li>RevisionDoesNotExistException The named revision does not exist with the IAM user or AWS account.</li>
     *         <li>RevisionRequiredException The revision ID was not specified.</li>
     *         <li>InvalidRevisionException The revision was specified in an invalid format.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeDeployException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeDeployAsyncClient.GetApplicationRevision
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/GetApplicationRevision"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetApplicationRevisionResponse> getApplicationRevision(
            GetApplicationRevisionRequest getApplicationRevisionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about an application revision.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetApplicationRevisionRequest.Builder} avoiding the
     * need to create one manually via {@link GetApplicationRevisionRequest#builder()}
     * </p>
     *
     * @param getApplicationRevisionRequest
     *        A {@link Consumer} that will call methods on {@link GetApplicationRevisionInput.Builder} to create a
     *        request. Represents the input of a <code>GetApplicationRevision</code> operation.
     * @return A Java Future containing the result of the GetApplicationRevision operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ApplicationDoesNotExistException The application does not exist with the IAM user or AWS account.</li>
     *         <li>ApplicationNameRequiredException The minimum number of required application names was not specified.</li>
     *         <li>InvalidApplicationNameException The application name was specified in an invalid format.</li>
     *         <li>RevisionDoesNotExistException The named revision does not exist with the IAM user or AWS account.</li>
     *         <li>RevisionRequiredException The revision ID was not specified.</li>
     *         <li>InvalidRevisionException The revision was specified in an invalid format.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeDeployException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeDeployAsyncClient.GetApplicationRevision
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/GetApplicationRevision"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetApplicationRevisionResponse> getApplicationRevision(
            Consumer<GetApplicationRevisionRequest.Builder> getApplicationRevisionRequest) {
        return getApplicationRevision(GetApplicationRevisionRequest.builder().applyMutation(getApplicationRevisionRequest)
                .build());
    }

    /**
     * <p>
     * Gets information about a deployment.
     * </p>
     * <note>
     * <p>
     * The <code>content</code> property of the <code>appSpecContent</code> object in the returned revision is always
     * null. Use <code>GetApplicationRevision</code> and the <code>sha256</code> property of the returned
     * <code>appSpecContent</code> object to get the content of the deployment’s AppSpec file.
     * </p>
     * </note>
     *
     * @param getDeploymentRequest
     *        Represents the input of a <code>GetDeployment</code> operation.
     * @return A Java Future containing the result of the GetDeployment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DeploymentIdRequiredException At least one deployment ID must be specified.</li>
     *         <li>InvalidDeploymentIdException At least one of the deployment IDs was specified in an invalid format.</li>
     *         <li>DeploymentDoesNotExistException The deployment with the IAM user or AWS account does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeDeployException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeDeployAsyncClient.GetDeployment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/GetDeployment" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetDeploymentResponse> getDeployment(GetDeploymentRequest getDeploymentRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about a deployment.
     * </p>
     * <note>
     * <p>
     * The <code>content</code> property of the <code>appSpecContent</code> object in the returned revision is always
     * null. Use <code>GetApplicationRevision</code> and the <code>sha256</code> property of the returned
     * <code>appSpecContent</code> object to get the content of the deployment’s AppSpec file.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDeploymentRequest.Builder} avoiding the need to
     * create one manually via {@link GetDeploymentRequest#builder()}
     * </p>
     *
     * @param getDeploymentRequest
     *        A {@link Consumer} that will call methods on {@link GetDeploymentInput.Builder} to create a request.
     *        Represents the input of a <code>GetDeployment</code> operation.
     * @return A Java Future containing the result of the GetDeployment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DeploymentIdRequiredException At least one deployment ID must be specified.</li>
     *         <li>InvalidDeploymentIdException At least one of the deployment IDs was specified in an invalid format.</li>
     *         <li>DeploymentDoesNotExistException The deployment with the IAM user or AWS account does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeDeployException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeDeployAsyncClient.GetDeployment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/GetDeployment" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetDeploymentResponse> getDeployment(Consumer<GetDeploymentRequest.Builder> getDeploymentRequest) {
        return getDeployment(GetDeploymentRequest.builder().applyMutation(getDeploymentRequest).build());
    }

    /**
     * <p>
     * Gets information about a deployment configuration.
     * </p>
     *
     * @param getDeploymentConfigRequest
     *        Represents the input of a <code>GetDeploymentConfig</code> operation.
     * @return A Java Future containing the result of the GetDeploymentConfig operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidDeploymentConfigNameException The deployment configuration name was specified in an invalid
     *         format.</li>
     *         <li>DeploymentConfigNameRequiredException The deployment configuration name was not specified.</li>
     *         <li>DeploymentConfigDoesNotExistException The deployment configuration does not exist with the IAM user
     *         or AWS account.</li>
     *         <li>InvalidComputePlatformException The computePlatform is invalid. The computePlatform should be
     *         <code>Lambda</code>, <code>Server</code>, or <code>ECS</code>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeDeployException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeDeployAsyncClient.GetDeploymentConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/GetDeploymentConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetDeploymentConfigResponse> getDeploymentConfig(
            GetDeploymentConfigRequest getDeploymentConfigRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about a deployment configuration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDeploymentConfigRequest.Builder} avoiding the
     * need to create one manually via {@link GetDeploymentConfigRequest#builder()}
     * </p>
     *
     * @param getDeploymentConfigRequest
     *        A {@link Consumer} that will call methods on {@link GetDeploymentConfigInput.Builder} to create a request.
     *        Represents the input of a <code>GetDeploymentConfig</code> operation.
     * @return A Java Future containing the result of the GetDeploymentConfig operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidDeploymentConfigNameException The deployment configuration name was specified in an invalid
     *         format.</li>
     *         <li>DeploymentConfigNameRequiredException The deployment configuration name was not specified.</li>
     *         <li>DeploymentConfigDoesNotExistException The deployment configuration does not exist with the IAM user
     *         or AWS account.</li>
     *         <li>InvalidComputePlatformException The computePlatform is invalid. The computePlatform should be
     *         <code>Lambda</code>, <code>Server</code>, or <code>ECS</code>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeDeployException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeDeployAsyncClient.GetDeploymentConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/GetDeploymentConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetDeploymentConfigResponse> getDeploymentConfig(
            Consumer<GetDeploymentConfigRequest.Builder> getDeploymentConfigRequest) {
        return getDeploymentConfig(GetDeploymentConfigRequest.builder().applyMutation(getDeploymentConfigRequest).build());
    }

    /**
     * <p>
     * Gets information about a deployment group.
     * </p>
     *
     * @param getDeploymentGroupRequest
     *        Represents the input of a <code>GetDeploymentGroup</code> operation.
     * @return A Java Future containing the result of the GetDeploymentGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ApplicationNameRequiredException The minimum number of required application names was not specified.</li>
     *         <li>InvalidApplicationNameException The application name was specified in an invalid format.</li>
     *         <li>ApplicationDoesNotExistException The application does not exist with the IAM user or AWS account.</li>
     *         <li>DeploymentGroupNameRequiredException The deployment group name was not specified.</li>
     *         <li>InvalidDeploymentGroupNameException The deployment group name was specified in an invalid format.</li>
     *         <li>DeploymentGroupDoesNotExistException The named deployment group with the IAM user or AWS account does
     *         not exist.</li>
     *         <li>DeploymentConfigDoesNotExistException The deployment configuration does not exist with the IAM user
     *         or AWS account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeDeployException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeDeployAsyncClient.GetDeploymentGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/GetDeploymentGroup" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetDeploymentGroupResponse> getDeploymentGroup(GetDeploymentGroupRequest getDeploymentGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about a deployment group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDeploymentGroupRequest.Builder} avoiding the
     * need to create one manually via {@link GetDeploymentGroupRequest#builder()}
     * </p>
     *
     * @param getDeploymentGroupRequest
     *        A {@link Consumer} that will call methods on {@link GetDeploymentGroupInput.Builder} to create a request.
     *        Represents the input of a <code>GetDeploymentGroup</code> operation.
     * @return A Java Future containing the result of the GetDeploymentGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ApplicationNameRequiredException The minimum number of required application names was not specified.</li>
     *         <li>InvalidApplicationNameException The application name was specified in an invalid format.</li>
     *         <li>ApplicationDoesNotExistException The application does not exist with the IAM user or AWS account.</li>
     *         <li>DeploymentGroupNameRequiredException The deployment group name was not specified.</li>
     *         <li>InvalidDeploymentGroupNameException The deployment group name was specified in an invalid format.</li>
     *         <li>DeploymentGroupDoesNotExistException The named deployment group with the IAM user or AWS account does
     *         not exist.</li>
     *         <li>DeploymentConfigDoesNotExistException The deployment configuration does not exist with the IAM user
     *         or AWS account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeDeployException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeDeployAsyncClient.GetDeploymentGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/GetDeploymentGroup" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetDeploymentGroupResponse> getDeploymentGroup(
            Consumer<GetDeploymentGroupRequest.Builder> getDeploymentGroupRequest) {
        return getDeploymentGroup(GetDeploymentGroupRequest.builder().applyMutation(getDeploymentGroupRequest).build());
    }

    /**
     * <p>
     * Returns information about a deployment target.
     * </p>
     *
     * @param getDeploymentTargetRequest
     * @return A Java Future containing the result of the GetDeploymentTarget operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidDeploymentIdException At least one of the deployment IDs was specified in an invalid format.</li>
     *         <li>DeploymentIdRequiredException At least one deployment ID must be specified.</li>
     *         <li>DeploymentDoesNotExistException The deployment with the IAM user or AWS account does not exist.</li>
     *         <li>DeploymentNotStartedException The specified deployment has not started.</li>
     *         <li>DeploymentTargetIdRequiredException A deployment target ID was not provided.</li>
     *         <li>InvalidDeploymentTargetIdException The target ID provided was not valid.</li>
     *         <li>DeploymentTargetDoesNotExistException The provided target ID does not belong to the attempted
     *         deployment.</li>
     *         <li>InvalidInstanceNameException The on-premises instance name was specified in an invalid format.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeDeployException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeDeployAsyncClient.GetDeploymentTarget
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/GetDeploymentTarget"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetDeploymentTargetResponse> getDeploymentTarget(
            GetDeploymentTargetRequest getDeploymentTargetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about a deployment target.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDeploymentTargetRequest.Builder} avoiding the
     * need to create one manually via {@link GetDeploymentTargetRequest#builder()}
     * </p>
     *
     * @param getDeploymentTargetRequest
     *        A {@link Consumer} that will call methods on {@link GetDeploymentTargetInput.Builder} to create a request.
     * @return A Java Future containing the result of the GetDeploymentTarget operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidDeploymentIdException At least one of the deployment IDs was specified in an invalid format.</li>
     *         <li>DeploymentIdRequiredException At least one deployment ID must be specified.</li>
     *         <li>DeploymentDoesNotExistException The deployment with the IAM user or AWS account does not exist.</li>
     *         <li>DeploymentNotStartedException The specified deployment has not started.</li>
     *         <li>DeploymentTargetIdRequiredException A deployment target ID was not provided.</li>
     *         <li>InvalidDeploymentTargetIdException The target ID provided was not valid.</li>
     *         <li>DeploymentTargetDoesNotExistException The provided target ID does not belong to the attempted
     *         deployment.</li>
     *         <li>InvalidInstanceNameException The on-premises instance name was specified in an invalid format.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeDeployException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeDeployAsyncClient.GetDeploymentTarget
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/GetDeploymentTarget"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetDeploymentTargetResponse> getDeploymentTarget(
            Consumer<GetDeploymentTargetRequest.Builder> getDeploymentTargetRequest) {
        return getDeploymentTarget(GetDeploymentTargetRequest.builder().applyMutation(getDeploymentTargetRequest).build());
    }

    /**
     * <p>
     * Gets information about an on-premises instance.
     * </p>
     *
     * @param getOnPremisesInstanceRequest
     *        Represents the input of a <code>GetOnPremisesInstance</code> operation.
     * @return A Java Future containing the result of the GetOnPremisesInstance operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InstanceNameRequiredException An on-premises instance name was not specified.</li>
     *         <li>InstanceNotRegisteredException The specified on-premises instance is not registered.</li>
     *         <li>InvalidInstanceNameException The on-premises instance name was specified in an invalid format.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeDeployException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeDeployAsyncClient.GetOnPremisesInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/GetOnPremisesInstance"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetOnPremisesInstanceResponse> getOnPremisesInstance(
            GetOnPremisesInstanceRequest getOnPremisesInstanceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about an on-premises instance.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetOnPremisesInstanceRequest.Builder} avoiding the
     * need to create one manually via {@link GetOnPremisesInstanceRequest#builder()}
     * </p>
     *
     * @param getOnPremisesInstanceRequest
     *        A {@link Consumer} that will call methods on {@link GetOnPremisesInstanceInput.Builder} to create a
     *        request. Represents the input of a <code>GetOnPremisesInstance</code> operation.
     * @return A Java Future containing the result of the GetOnPremisesInstance operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InstanceNameRequiredException An on-premises instance name was not specified.</li>
     *         <li>InstanceNotRegisteredException The specified on-premises instance is not registered.</li>
     *         <li>InvalidInstanceNameException The on-premises instance name was specified in an invalid format.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeDeployException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeDeployAsyncClient.GetOnPremisesInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/GetOnPremisesInstance"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetOnPremisesInstanceResponse> getOnPremisesInstance(
            Consumer<GetOnPremisesInstanceRequest.Builder> getOnPremisesInstanceRequest) {
        return getOnPremisesInstance(GetOnPremisesInstanceRequest.builder().applyMutation(getOnPremisesInstanceRequest).build());
    }

    /**
     * <p>
     * Lists information about revisions for an application.
     * </p>
     *
     * @param listApplicationRevisionsRequest
     *        Represents the input of a <code>ListApplicationRevisions</code> operation.
     * @return A Java Future containing the result of the ListApplicationRevisions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ApplicationDoesNotExistException The application does not exist with the IAM user or AWS account.</li>
     *         <li>ApplicationNameRequiredException The minimum number of required application names was not specified.</li>
     *         <li>InvalidApplicationNameException The application name was specified in an invalid format.</li>
     *         <li>InvalidSortByException The column name to sort by is either not present or was specified in an
     *         invalid format.</li>
     *         <li>InvalidSortOrderException The sort order was specified in an invalid format.</li>
     *         <li>InvalidBucketNameFilterException The bucket name either doesn't exist or was specified in an invalid
     *         format.</li>
     *         <li>InvalidKeyPrefixFilterException The specified key prefix filter was specified in an invalid format.</li>
     *         <li>BucketNameFilterRequiredException A bucket name is required, but was not provided.</li>
     *         <li>InvalidDeployedStateFilterException The deployed state filter was specified in an invalid format.</li>
     *         <li>InvalidNextTokenException The next token was specified in an invalid format.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeDeployException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeDeployAsyncClient.ListApplicationRevisions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/ListApplicationRevisions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListApplicationRevisionsResponse> listApplicationRevisions(
            ListApplicationRevisionsRequest listApplicationRevisionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists information about revisions for an application.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListApplicationRevisionsRequest.Builder} avoiding
     * the need to create one manually via {@link ListApplicationRevisionsRequest#builder()}
     * </p>
     *
     * @param listApplicationRevisionsRequest
     *        A {@link Consumer} that will call methods on {@link ListApplicationRevisionsInput.Builder} to create a
     *        request. Represents the input of a <code>ListApplicationRevisions</code> operation.
     * @return A Java Future containing the result of the ListApplicationRevisions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ApplicationDoesNotExistException The application does not exist with the IAM user or AWS account.</li>
     *         <li>ApplicationNameRequiredException The minimum number of required application names was not specified.</li>
     *         <li>InvalidApplicationNameException The application name was specified in an invalid format.</li>
     *         <li>InvalidSortByException The column name to sort by is either not present or was specified in an
     *         invalid format.</li>
     *         <li>InvalidSortOrderException The sort order was specified in an invalid format.</li>
     *         <li>InvalidBucketNameFilterException The bucket name either doesn't exist or was specified in an invalid
     *         format.</li>
     *         <li>InvalidKeyPrefixFilterException The specified key prefix filter was specified in an invalid format.</li>
     *         <li>BucketNameFilterRequiredException A bucket name is required, but was not provided.</li>
     *         <li>InvalidDeployedStateFilterException The deployed state filter was specified in an invalid format.</li>
     *         <li>InvalidNextTokenException The next token was specified in an invalid format.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeDeployException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeDeployAsyncClient.ListApplicationRevisions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/ListApplicationRevisions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListApplicationRevisionsResponse> listApplicationRevisions(
            Consumer<ListApplicationRevisionsRequest.Builder> listApplicationRevisionsRequest) {
        return listApplicationRevisions(ListApplicationRevisionsRequest.builder().applyMutation(listApplicationRevisionsRequest)
                .build());
    }

    /**
     * <p>
     * Lists information about revisions for an application.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listApplicationRevisions(software.amazon.awssdk.services.codedeploy.model.ListApplicationRevisionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codedeploy.paginators.ListApplicationRevisionsPublisher publisher = client.listApplicationRevisionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codedeploy.paginators.ListApplicationRevisionsPublisher publisher = client.listApplicationRevisionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.codedeploy.model.ListApplicationRevisionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.codedeploy.model.ListApplicationRevisionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listApplicationRevisions(software.amazon.awssdk.services.codedeploy.model.ListApplicationRevisionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listApplicationRevisionsRequest
     *        Represents the input of a <code>ListApplicationRevisions</code> operation.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ApplicationDoesNotExistException The application does not exist with the IAM user or AWS account.</li>
     *         <li>ApplicationNameRequiredException The minimum number of required application names was not specified.</li>
     *         <li>InvalidApplicationNameException The application name was specified in an invalid format.</li>
     *         <li>InvalidSortByException The column name to sort by is either not present or was specified in an
     *         invalid format.</li>
     *         <li>InvalidSortOrderException The sort order was specified in an invalid format.</li>
     *         <li>InvalidBucketNameFilterException The bucket name either doesn't exist or was specified in an invalid
     *         format.</li>
     *         <li>InvalidKeyPrefixFilterException The specified key prefix filter was specified in an invalid format.</li>
     *         <li>BucketNameFilterRequiredException A bucket name is required, but was not provided.</li>
     *         <li>InvalidDeployedStateFilterException The deployed state filter was specified in an invalid format.</li>
     *         <li>InvalidNextTokenException The next token was specified in an invalid format.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeDeployException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeDeployAsyncClient.ListApplicationRevisions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/ListApplicationRevisions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListApplicationRevisionsPublisher listApplicationRevisionsPaginator(
            ListApplicationRevisionsRequest listApplicationRevisionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists information about revisions for an application.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listApplicationRevisions(software.amazon.awssdk.services.codedeploy.model.ListApplicationRevisionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codedeploy.paginators.ListApplicationRevisionsPublisher publisher = client.listApplicationRevisionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codedeploy.paginators.ListApplicationRevisionsPublisher publisher = client.listApplicationRevisionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.codedeploy.model.ListApplicationRevisionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.codedeploy.model.ListApplicationRevisionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listApplicationRevisions(software.amazon.awssdk.services.codedeploy.model.ListApplicationRevisionsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListApplicationRevisionsRequest.Builder} avoiding
     * the need to create one manually via {@link ListApplicationRevisionsRequest#builder()}
     * </p>
     *
     * @param listApplicationRevisionsRequest
     *        A {@link Consumer} that will call methods on {@link ListApplicationRevisionsInput.Builder} to create a
     *        request. Represents the input of a <code>ListApplicationRevisions</code> operation.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ApplicationDoesNotExistException The application does not exist with the IAM user or AWS account.</li>
     *         <li>ApplicationNameRequiredException The minimum number of required application names was not specified.</li>
     *         <li>InvalidApplicationNameException The application name was specified in an invalid format.</li>
     *         <li>InvalidSortByException The column name to sort by is either not present or was specified in an
     *         invalid format.</li>
     *         <li>InvalidSortOrderException The sort order was specified in an invalid format.</li>
     *         <li>InvalidBucketNameFilterException The bucket name either doesn't exist or was specified in an invalid
     *         format.</li>
     *         <li>InvalidKeyPrefixFilterException The specified key prefix filter was specified in an invalid format.</li>
     *         <li>BucketNameFilterRequiredException A bucket name is required, but was not provided.</li>
     *         <li>InvalidDeployedStateFilterException The deployed state filter was specified in an invalid format.</li>
     *         <li>InvalidNextTokenException The next token was specified in an invalid format.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeDeployException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeDeployAsyncClient.ListApplicationRevisions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/ListApplicationRevisions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListApplicationRevisionsPublisher listApplicationRevisionsPaginator(
            Consumer<ListApplicationRevisionsRequest.Builder> listApplicationRevisionsRequest) {
        return listApplicationRevisionsPaginator(ListApplicationRevisionsRequest.builder()
                .applyMutation(listApplicationRevisionsRequest).build());
    }

    /**
     * <p>
     * Lists the applications registered with the IAM user or AWS account.
     * </p>
     *
     * @param listApplicationsRequest
     *        Represents the input of a <code>ListApplications</code> operation.
     * @return A Java Future containing the result of the ListApplications operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidNextTokenException The next token was specified in an invalid format.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeDeployException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeDeployAsyncClient.ListApplications
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/ListApplications" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListApplicationsResponse> listApplications(ListApplicationsRequest listApplicationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the applications registered with the IAM user or AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListApplicationsRequest.Builder} avoiding the need
     * to create one manually via {@link ListApplicationsRequest#builder()}
     * </p>
     *
     * @param listApplicationsRequest
     *        A {@link Consumer} that will call methods on {@link ListApplicationsInput.Builder} to create a request.
     *        Represents the input of a <code>ListApplications</code> operation.
     * @return A Java Future containing the result of the ListApplications operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidNextTokenException The next token was specified in an invalid format.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeDeployException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeDeployAsyncClient.ListApplications
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/ListApplications" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListApplicationsResponse> listApplications(
            Consumer<ListApplicationsRequest.Builder> listApplicationsRequest) {
        return listApplications(ListApplicationsRequest.builder().applyMutation(listApplicationsRequest).build());
    }

    /**
     * <p>
     * Lists the applications registered with the IAM user or AWS account.
     * </p>
     *
     * @return A Java Future containing the result of the ListApplications operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidNextTokenException The next token was specified in an invalid format.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeDeployException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeDeployAsyncClient.ListApplications
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/ListApplications" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListApplicationsResponse> listApplications() {
        return listApplications(ListApplicationsRequest.builder().build());
    }

    /**
     * <p>
     * Lists the applications registered with the IAM user or AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listApplications(software.amazon.awssdk.services.codedeploy.model.ListApplicationsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codedeploy.paginators.ListApplicationsPublisher publisher = client.listApplicationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codedeploy.paginators.ListApplicationsPublisher publisher = client.listApplicationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.codedeploy.model.ListApplicationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.codedeploy.model.ListApplicationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listApplications(software.amazon.awssdk.services.codedeploy.model.ListApplicationsRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidNextTokenException The next token was specified in an invalid format.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeDeployException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeDeployAsyncClient.ListApplications
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/ListApplications" target="_top">AWS
     *      API Documentation</a>
     */
    default ListApplicationsPublisher listApplicationsPaginator() {
        return listApplicationsPaginator(ListApplicationsRequest.builder().build());
    }

    /**
     * <p>
     * Lists the applications registered with the IAM user or AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listApplications(software.amazon.awssdk.services.codedeploy.model.ListApplicationsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codedeploy.paginators.ListApplicationsPublisher publisher = client.listApplicationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codedeploy.paginators.ListApplicationsPublisher publisher = client.listApplicationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.codedeploy.model.ListApplicationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.codedeploy.model.ListApplicationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listApplications(software.amazon.awssdk.services.codedeploy.model.ListApplicationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listApplicationsRequest
     *        Represents the input of a <code>ListApplications</code> operation.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidNextTokenException The next token was specified in an invalid format.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeDeployException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeDeployAsyncClient.ListApplications
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/ListApplications" target="_top">AWS
     *      API Documentation</a>
     */
    default ListApplicationsPublisher listApplicationsPaginator(ListApplicationsRequest listApplicationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the applications registered with the IAM user or AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listApplications(software.amazon.awssdk.services.codedeploy.model.ListApplicationsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codedeploy.paginators.ListApplicationsPublisher publisher = client.listApplicationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codedeploy.paginators.ListApplicationsPublisher publisher = client.listApplicationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.codedeploy.model.ListApplicationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.codedeploy.model.ListApplicationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listApplications(software.amazon.awssdk.services.codedeploy.model.ListApplicationsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListApplicationsRequest.Builder} avoiding the need
     * to create one manually via {@link ListApplicationsRequest#builder()}
     * </p>
     *
     * @param listApplicationsRequest
     *        A {@link Consumer} that will call methods on {@link ListApplicationsInput.Builder} to create a request.
     *        Represents the input of a <code>ListApplications</code> operation.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidNextTokenException The next token was specified in an invalid format.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeDeployException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeDeployAsyncClient.ListApplications
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/ListApplications" target="_top">AWS
     *      API Documentation</a>
     */
    default ListApplicationsPublisher listApplicationsPaginator(Consumer<ListApplicationsRequest.Builder> listApplicationsRequest) {
        return listApplicationsPaginator(ListApplicationsRequest.builder().applyMutation(listApplicationsRequest).build());
    }

    /**
     * <p>
     * Lists the deployment configurations with the IAM user or AWS account.
     * </p>
     *
     * @param listDeploymentConfigsRequest
     *        Represents the input of a <code>ListDeploymentConfigs</code> operation.
     * @return A Java Future containing the result of the ListDeploymentConfigs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidNextTokenException The next token was specified in an invalid format.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeDeployException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeDeployAsyncClient.ListDeploymentConfigs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/ListDeploymentConfigs"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListDeploymentConfigsResponse> listDeploymentConfigs(
            ListDeploymentConfigsRequest listDeploymentConfigsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the deployment configurations with the IAM user or AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDeploymentConfigsRequest.Builder} avoiding the
     * need to create one manually via {@link ListDeploymentConfigsRequest#builder()}
     * </p>
     *
     * @param listDeploymentConfigsRequest
     *        A {@link Consumer} that will call methods on {@link ListDeploymentConfigsInput.Builder} to create a
     *        request. Represents the input of a <code>ListDeploymentConfigs</code> operation.
     * @return A Java Future containing the result of the ListDeploymentConfigs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidNextTokenException The next token was specified in an invalid format.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeDeployException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeDeployAsyncClient.ListDeploymentConfigs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/ListDeploymentConfigs"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListDeploymentConfigsResponse> listDeploymentConfigs(
            Consumer<ListDeploymentConfigsRequest.Builder> listDeploymentConfigsRequest) {
        return listDeploymentConfigs(ListDeploymentConfigsRequest.builder().applyMutation(listDeploymentConfigsRequest).build());
    }

    /**
     * <p>
     * Lists the deployment configurations with the IAM user or AWS account.
     * </p>
     *
     * @return A Java Future containing the result of the ListDeploymentConfigs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidNextTokenException The next token was specified in an invalid format.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeDeployException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeDeployAsyncClient.ListDeploymentConfigs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/ListDeploymentConfigs"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListDeploymentConfigsResponse> listDeploymentConfigs() {
        return listDeploymentConfigs(ListDeploymentConfigsRequest.builder().build());
    }

    /**
     * <p>
     * Lists the deployment configurations with the IAM user or AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listDeploymentConfigs(software.amazon.awssdk.services.codedeploy.model.ListDeploymentConfigsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codedeploy.paginators.ListDeploymentConfigsPublisher publisher = client.listDeploymentConfigsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codedeploy.paginators.ListDeploymentConfigsPublisher publisher = client.listDeploymentConfigsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.codedeploy.model.ListDeploymentConfigsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.codedeploy.model.ListDeploymentConfigsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDeploymentConfigs(software.amazon.awssdk.services.codedeploy.model.ListDeploymentConfigsRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidNextTokenException The next token was specified in an invalid format.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeDeployException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeDeployAsyncClient.ListDeploymentConfigs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/ListDeploymentConfigs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDeploymentConfigsPublisher listDeploymentConfigsPaginator() {
        return listDeploymentConfigsPaginator(ListDeploymentConfigsRequest.builder().build());
    }

    /**
     * <p>
     * Lists the deployment configurations with the IAM user or AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listDeploymentConfigs(software.amazon.awssdk.services.codedeploy.model.ListDeploymentConfigsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codedeploy.paginators.ListDeploymentConfigsPublisher publisher = client.listDeploymentConfigsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codedeploy.paginators.ListDeploymentConfigsPublisher publisher = client.listDeploymentConfigsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.codedeploy.model.ListDeploymentConfigsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.codedeploy.model.ListDeploymentConfigsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDeploymentConfigs(software.amazon.awssdk.services.codedeploy.model.ListDeploymentConfigsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listDeploymentConfigsRequest
     *        Represents the input of a <code>ListDeploymentConfigs</code> operation.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidNextTokenException The next token was specified in an invalid format.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeDeployException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeDeployAsyncClient.ListDeploymentConfigs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/ListDeploymentConfigs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDeploymentConfigsPublisher listDeploymentConfigsPaginator(
            ListDeploymentConfigsRequest listDeploymentConfigsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the deployment configurations with the IAM user or AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listDeploymentConfigs(software.amazon.awssdk.services.codedeploy.model.ListDeploymentConfigsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codedeploy.paginators.ListDeploymentConfigsPublisher publisher = client.listDeploymentConfigsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codedeploy.paginators.ListDeploymentConfigsPublisher publisher = client.listDeploymentConfigsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.codedeploy.model.ListDeploymentConfigsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.codedeploy.model.ListDeploymentConfigsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDeploymentConfigs(software.amazon.awssdk.services.codedeploy.model.ListDeploymentConfigsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDeploymentConfigsRequest.Builder} avoiding the
     * need to create one manually via {@link ListDeploymentConfigsRequest#builder()}
     * </p>
     *
     * @param listDeploymentConfigsRequest
     *        A {@link Consumer} that will call methods on {@link ListDeploymentConfigsInput.Builder} to create a
     *        request. Represents the input of a <code>ListDeploymentConfigs</code> operation.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidNextTokenException The next token was specified in an invalid format.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeDeployException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeDeployAsyncClient.ListDeploymentConfigs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/ListDeploymentConfigs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDeploymentConfigsPublisher listDeploymentConfigsPaginator(
            Consumer<ListDeploymentConfigsRequest.Builder> listDeploymentConfigsRequest) {
        return listDeploymentConfigsPaginator(ListDeploymentConfigsRequest.builder().applyMutation(listDeploymentConfigsRequest)
                .build());
    }

    /**
     * <p>
     * Lists the deployment groups for an application registered with the IAM user or AWS account.
     * </p>
     *
     * @param listDeploymentGroupsRequest
     *        Represents the input of a <code>ListDeploymentGroups</code> operation.
     * @return A Java Future containing the result of the ListDeploymentGroups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ApplicationNameRequiredException The minimum number of required application names was not specified.</li>
     *         <li>InvalidApplicationNameException The application name was specified in an invalid format.</li>
     *         <li>ApplicationDoesNotExistException The application does not exist with the IAM user or AWS account.</li>
     *         <li>InvalidNextTokenException The next token was specified in an invalid format.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeDeployException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeDeployAsyncClient.ListDeploymentGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/ListDeploymentGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListDeploymentGroupsResponse> listDeploymentGroups(
            ListDeploymentGroupsRequest listDeploymentGroupsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the deployment groups for an application registered with the IAM user or AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDeploymentGroupsRequest.Builder} avoiding the
     * need to create one manually via {@link ListDeploymentGroupsRequest#builder()}
     * </p>
     *
     * @param listDeploymentGroupsRequest
     *        A {@link Consumer} that will call methods on {@link ListDeploymentGroupsInput.Builder} to create a
     *        request. Represents the input of a <code>ListDeploymentGroups</code> operation.
     * @return A Java Future containing the result of the ListDeploymentGroups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ApplicationNameRequiredException The minimum number of required application names was not specified.</li>
     *         <li>InvalidApplicationNameException The application name was specified in an invalid format.</li>
     *         <li>ApplicationDoesNotExistException The application does not exist with the IAM user or AWS account.</li>
     *         <li>InvalidNextTokenException The next token was specified in an invalid format.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeDeployException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeDeployAsyncClient.ListDeploymentGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/ListDeploymentGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListDeploymentGroupsResponse> listDeploymentGroups(
            Consumer<ListDeploymentGroupsRequest.Builder> listDeploymentGroupsRequest) {
        return listDeploymentGroups(ListDeploymentGroupsRequest.builder().applyMutation(listDeploymentGroupsRequest).build());
    }

    /**
     * <p>
     * Lists the deployment groups for an application registered with the IAM user or AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listDeploymentGroups(software.amazon.awssdk.services.codedeploy.model.ListDeploymentGroupsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codedeploy.paginators.ListDeploymentGroupsPublisher publisher = client.listDeploymentGroupsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codedeploy.paginators.ListDeploymentGroupsPublisher publisher = client.listDeploymentGroupsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.codedeploy.model.ListDeploymentGroupsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.codedeploy.model.ListDeploymentGroupsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDeploymentGroups(software.amazon.awssdk.services.codedeploy.model.ListDeploymentGroupsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listDeploymentGroupsRequest
     *        Represents the input of a <code>ListDeploymentGroups</code> operation.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ApplicationNameRequiredException The minimum number of required application names was not specified.</li>
     *         <li>InvalidApplicationNameException The application name was specified in an invalid format.</li>
     *         <li>ApplicationDoesNotExistException The application does not exist with the IAM user or AWS account.</li>
     *         <li>InvalidNextTokenException The next token was specified in an invalid format.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeDeployException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeDeployAsyncClient.ListDeploymentGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/ListDeploymentGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDeploymentGroupsPublisher listDeploymentGroupsPaginator(ListDeploymentGroupsRequest listDeploymentGroupsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the deployment groups for an application registered with the IAM user or AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listDeploymentGroups(software.amazon.awssdk.services.codedeploy.model.ListDeploymentGroupsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codedeploy.paginators.ListDeploymentGroupsPublisher publisher = client.listDeploymentGroupsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codedeploy.paginators.ListDeploymentGroupsPublisher publisher = client.listDeploymentGroupsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.codedeploy.model.ListDeploymentGroupsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.codedeploy.model.ListDeploymentGroupsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDeploymentGroups(software.amazon.awssdk.services.codedeploy.model.ListDeploymentGroupsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDeploymentGroupsRequest.Builder} avoiding the
     * need to create one manually via {@link ListDeploymentGroupsRequest#builder()}
     * </p>
     *
     * @param listDeploymentGroupsRequest
     *        A {@link Consumer} that will call methods on {@link ListDeploymentGroupsInput.Builder} to create a
     *        request. Represents the input of a <code>ListDeploymentGroups</code> operation.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ApplicationNameRequiredException The minimum number of required application names was not specified.</li>
     *         <li>InvalidApplicationNameException The application name was specified in an invalid format.</li>
     *         <li>ApplicationDoesNotExistException The application does not exist with the IAM user or AWS account.</li>
     *         <li>InvalidNextTokenException The next token was specified in an invalid format.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeDeployException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeDeployAsyncClient.ListDeploymentGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/ListDeploymentGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDeploymentGroupsPublisher listDeploymentGroupsPaginator(
            Consumer<ListDeploymentGroupsRequest.Builder> listDeploymentGroupsRequest) {
        return listDeploymentGroupsPaginator(ListDeploymentGroupsRequest.builder().applyMutation(listDeploymentGroupsRequest)
                .build());
    }

    /**
     * <p>
     * Returns an array of target IDs that are associated a deployment.
     * </p>
     *
     * @param listDeploymentTargetsRequest
     * @return A Java Future containing the result of the ListDeploymentTargets operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DeploymentIdRequiredException At least one deployment ID must be specified.</li>
     *         <li>DeploymentDoesNotExistException The deployment with the IAM user or AWS account does not exist.</li>
     *         <li>DeploymentNotStartedException The specified deployment has not started.</li>
     *         <li>InvalidNextTokenException The next token was specified in an invalid format.</li>
     *         <li>InvalidDeploymentIdException At least one of the deployment IDs was specified in an invalid format.</li>
     *         <li>InvalidInstanceStatusException The specified instance status does not exist.</li>
     *         <li>InvalidInstanceTypeException An invalid instance type was specified for instances in a blue/green
     *         deployment. Valid values include "Blue" for an original environment and "Green" for a replacement
     *         environment.</li>
     *         <li>InvalidDeploymentInstanceTypeException An instance type was specified for an in-place deployment.
     *         Instance types are supported for blue/green deployments only.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeDeployException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeDeployAsyncClient.ListDeploymentTargets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/ListDeploymentTargets"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListDeploymentTargetsResponse> listDeploymentTargets(
            ListDeploymentTargetsRequest listDeploymentTargetsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns an array of target IDs that are associated a deployment.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDeploymentTargetsRequest.Builder} avoiding the
     * need to create one manually via {@link ListDeploymentTargetsRequest#builder()}
     * </p>
     *
     * @param listDeploymentTargetsRequest
     *        A {@link Consumer} that will call methods on {@link ListDeploymentTargetsInput.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListDeploymentTargets operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DeploymentIdRequiredException At least one deployment ID must be specified.</li>
     *         <li>DeploymentDoesNotExistException The deployment with the IAM user or AWS account does not exist.</li>
     *         <li>DeploymentNotStartedException The specified deployment has not started.</li>
     *         <li>InvalidNextTokenException The next token was specified in an invalid format.</li>
     *         <li>InvalidDeploymentIdException At least one of the deployment IDs was specified in an invalid format.</li>
     *         <li>InvalidInstanceStatusException The specified instance status does not exist.</li>
     *         <li>InvalidInstanceTypeException An invalid instance type was specified for instances in a blue/green
     *         deployment. Valid values include "Blue" for an original environment and "Green" for a replacement
     *         environment.</li>
     *         <li>InvalidDeploymentInstanceTypeException An instance type was specified for an in-place deployment.
     *         Instance types are supported for blue/green deployments only.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeDeployException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeDeployAsyncClient.ListDeploymentTargets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/ListDeploymentTargets"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListDeploymentTargetsResponse> listDeploymentTargets(
            Consumer<ListDeploymentTargetsRequest.Builder> listDeploymentTargetsRequest) {
        return listDeploymentTargets(ListDeploymentTargetsRequest.builder().applyMutation(listDeploymentTargetsRequest).build());
    }

    /**
     * <p>
     * Lists the deployments in a deployment group for an application registered with the IAM user or AWS account.
     * </p>
     *
     * @param listDeploymentsRequest
     *        Represents the input of a <code>ListDeployments</code> operation.
     * @return A Java Future containing the result of the ListDeployments operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ApplicationNameRequiredException The minimum number of required application names was not specified.</li>
     *         <li>InvalidApplicationNameException The application name was specified in an invalid format.</li>
     *         <li>ApplicationDoesNotExistException The application does not exist with the IAM user or AWS account.</li>
     *         <li>InvalidDeploymentGroupNameException The deployment group name was specified in an invalid format.</li>
     *         <li>DeploymentGroupDoesNotExistException The named deployment group with the IAM user or AWS account does
     *         not exist.</li>
     *         <li>DeploymentGroupNameRequiredException The deployment group name was not specified.</li>
     *         <li>InvalidTimeRangeException The specified time range was specified in an invalid format.</li>
     *         <li>InvalidDeploymentStatusException The specified deployment status doesn't exist or cannot be
     *         determined.</li>
     *         <li>InvalidNextTokenException The next token was specified in an invalid format.</li>
     *         <li>InvalidExternalIdException The external ID was specified in an invalid format.</li>
     *         <li>InvalidInputException The input was specified in an invalid format.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeDeployException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeDeployAsyncClient.ListDeployments
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/ListDeployments" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListDeploymentsResponse> listDeployments(ListDeploymentsRequest listDeploymentsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the deployments in a deployment group for an application registered with the IAM user or AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDeploymentsRequest.Builder} avoiding the need
     * to create one manually via {@link ListDeploymentsRequest#builder()}
     * </p>
     *
     * @param listDeploymentsRequest
     *        A {@link Consumer} that will call methods on {@link ListDeploymentsInput.Builder} to create a request.
     *        Represents the input of a <code>ListDeployments</code> operation.
     * @return A Java Future containing the result of the ListDeployments operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ApplicationNameRequiredException The minimum number of required application names was not specified.</li>
     *         <li>InvalidApplicationNameException The application name was specified in an invalid format.</li>
     *         <li>ApplicationDoesNotExistException The application does not exist with the IAM user or AWS account.</li>
     *         <li>InvalidDeploymentGroupNameException The deployment group name was specified in an invalid format.</li>
     *         <li>DeploymentGroupDoesNotExistException The named deployment group with the IAM user or AWS account does
     *         not exist.</li>
     *         <li>DeploymentGroupNameRequiredException The deployment group name was not specified.</li>
     *         <li>InvalidTimeRangeException The specified time range was specified in an invalid format.</li>
     *         <li>InvalidDeploymentStatusException The specified deployment status doesn't exist or cannot be
     *         determined.</li>
     *         <li>InvalidNextTokenException The next token was specified in an invalid format.</li>
     *         <li>InvalidExternalIdException The external ID was specified in an invalid format.</li>
     *         <li>InvalidInputException The input was specified in an invalid format.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeDeployException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeDeployAsyncClient.ListDeployments
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/ListDeployments" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListDeploymentsResponse> listDeployments(
            Consumer<ListDeploymentsRequest.Builder> listDeploymentsRequest) {
        return listDeployments(ListDeploymentsRequest.builder().applyMutation(listDeploymentsRequest).build());
    }

    /**
     * <p>
     * Lists the deployments in a deployment group for an application registered with the IAM user or AWS account.
     * </p>
     *
     * @return A Java Future containing the result of the ListDeployments operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ApplicationNameRequiredException The minimum number of required application names was not specified.</li>
     *         <li>InvalidApplicationNameException The application name was specified in an invalid format.</li>
     *         <li>ApplicationDoesNotExistException The application does not exist with the IAM user or AWS account.</li>
     *         <li>InvalidDeploymentGroupNameException The deployment group name was specified in an invalid format.</li>
     *         <li>DeploymentGroupDoesNotExistException The named deployment group with the IAM user or AWS account does
     *         not exist.</li>
     *         <li>DeploymentGroupNameRequiredException The deployment group name was not specified.</li>
     *         <li>InvalidTimeRangeException The specified time range was specified in an invalid format.</li>
     *         <li>InvalidDeploymentStatusException The specified deployment status doesn't exist or cannot be
     *         determined.</li>
     *         <li>InvalidNextTokenException The next token was specified in an invalid format.</li>
     *         <li>InvalidExternalIdException The external ID was specified in an invalid format.</li>
     *         <li>InvalidInputException The input was specified in an invalid format.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeDeployException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeDeployAsyncClient.ListDeployments
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/ListDeployments" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListDeploymentsResponse> listDeployments() {
        return listDeployments(ListDeploymentsRequest.builder().build());
    }

    /**
     * <p>
     * Lists the deployments in a deployment group for an application registered with the IAM user or AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listDeployments(software.amazon.awssdk.services.codedeploy.model.ListDeploymentsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codedeploy.paginators.ListDeploymentsPublisher publisher = client.listDeploymentsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codedeploy.paginators.ListDeploymentsPublisher publisher = client.listDeploymentsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.codedeploy.model.ListDeploymentsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.codedeploy.model.ListDeploymentsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDeployments(software.amazon.awssdk.services.codedeploy.model.ListDeploymentsRequest)} operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ApplicationNameRequiredException The minimum number of required application names was not specified.</li>
     *         <li>InvalidApplicationNameException The application name was specified in an invalid format.</li>
     *         <li>ApplicationDoesNotExistException The application does not exist with the IAM user or AWS account.</li>
     *         <li>InvalidDeploymentGroupNameException The deployment group name was specified in an invalid format.</li>
     *         <li>DeploymentGroupDoesNotExistException The named deployment group with the IAM user or AWS account does
     *         not exist.</li>
     *         <li>DeploymentGroupNameRequiredException The deployment group name was not specified.</li>
     *         <li>InvalidTimeRangeException The specified time range was specified in an invalid format.</li>
     *         <li>InvalidDeploymentStatusException The specified deployment status doesn't exist or cannot be
     *         determined.</li>
     *         <li>InvalidNextTokenException The next token was specified in an invalid format.</li>
     *         <li>InvalidExternalIdException The external ID was specified in an invalid format.</li>
     *         <li>InvalidInputException The input was specified in an invalid format.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeDeployException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeDeployAsyncClient.ListDeployments
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/ListDeployments" target="_top">AWS
     *      API Documentation</a>
     */
    default ListDeploymentsPublisher listDeploymentsPaginator() {
        return listDeploymentsPaginator(ListDeploymentsRequest.builder().build());
    }

    /**
     * <p>
     * Lists the deployments in a deployment group for an application registered with the IAM user or AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listDeployments(software.amazon.awssdk.services.codedeploy.model.ListDeploymentsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codedeploy.paginators.ListDeploymentsPublisher publisher = client.listDeploymentsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codedeploy.paginators.ListDeploymentsPublisher publisher = client.listDeploymentsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.codedeploy.model.ListDeploymentsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.codedeploy.model.ListDeploymentsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDeployments(software.amazon.awssdk.services.codedeploy.model.ListDeploymentsRequest)} operation.</b>
     * </p>
     *
     * @param listDeploymentsRequest
     *        Represents the input of a <code>ListDeployments</code> operation.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ApplicationNameRequiredException The minimum number of required application names was not specified.</li>
     *         <li>InvalidApplicationNameException The application name was specified in an invalid format.</li>
     *         <li>ApplicationDoesNotExistException The application does not exist with the IAM user or AWS account.</li>
     *         <li>InvalidDeploymentGroupNameException The deployment group name was specified in an invalid format.</li>
     *         <li>DeploymentGroupDoesNotExistException The named deployment group with the IAM user or AWS account does
     *         not exist.</li>
     *         <li>DeploymentGroupNameRequiredException The deployment group name was not specified.</li>
     *         <li>InvalidTimeRangeException The specified time range was specified in an invalid format.</li>
     *         <li>InvalidDeploymentStatusException The specified deployment status doesn't exist or cannot be
     *         determined.</li>
     *         <li>InvalidNextTokenException The next token was specified in an invalid format.</li>
     *         <li>InvalidExternalIdException The external ID was specified in an invalid format.</li>
     *         <li>InvalidInputException The input was specified in an invalid format.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeDeployException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeDeployAsyncClient.ListDeployments
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/ListDeployments" target="_top">AWS
     *      API Documentation</a>
     */
    default ListDeploymentsPublisher listDeploymentsPaginator(ListDeploymentsRequest listDeploymentsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the deployments in a deployment group for an application registered with the IAM user or AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listDeployments(software.amazon.awssdk.services.codedeploy.model.ListDeploymentsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codedeploy.paginators.ListDeploymentsPublisher publisher = client.listDeploymentsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codedeploy.paginators.ListDeploymentsPublisher publisher = client.listDeploymentsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.codedeploy.model.ListDeploymentsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.codedeploy.model.ListDeploymentsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDeployments(software.amazon.awssdk.services.codedeploy.model.ListDeploymentsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDeploymentsRequest.Builder} avoiding the need
     * to create one manually via {@link ListDeploymentsRequest#builder()}
     * </p>
     *
     * @param listDeploymentsRequest
     *        A {@link Consumer} that will call methods on {@link ListDeploymentsInput.Builder} to create a request.
     *        Represents the input of a <code>ListDeployments</code> operation.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ApplicationNameRequiredException The minimum number of required application names was not specified.</li>
     *         <li>InvalidApplicationNameException The application name was specified in an invalid format.</li>
     *         <li>ApplicationDoesNotExistException The application does not exist with the IAM user or AWS account.</li>
     *         <li>InvalidDeploymentGroupNameException The deployment group name was specified in an invalid format.</li>
     *         <li>DeploymentGroupDoesNotExistException The named deployment group with the IAM user or AWS account does
     *         not exist.</li>
     *         <li>DeploymentGroupNameRequiredException The deployment group name was not specified.</li>
     *         <li>InvalidTimeRangeException The specified time range was specified in an invalid format.</li>
     *         <li>InvalidDeploymentStatusException The specified deployment status doesn't exist or cannot be
     *         determined.</li>
     *         <li>InvalidNextTokenException The next token was specified in an invalid format.</li>
     *         <li>InvalidExternalIdException The external ID was specified in an invalid format.</li>
     *         <li>InvalidInputException The input was specified in an invalid format.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeDeployException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeDeployAsyncClient.ListDeployments
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/ListDeployments" target="_top">AWS
     *      API Documentation</a>
     */
    default ListDeploymentsPublisher listDeploymentsPaginator(Consumer<ListDeploymentsRequest.Builder> listDeploymentsRequest) {
        return listDeploymentsPaginator(ListDeploymentsRequest.builder().applyMutation(listDeploymentsRequest).build());
    }

    /**
     * <p>
     * Lists the names of stored connections to GitHub accounts.
     * </p>
     *
     * @param listGitHubAccountTokenNamesRequest
     *        Represents the input of a <code>ListGitHubAccountTokenNames</code> operation.
     * @return A Java Future containing the result of the ListGitHubAccountTokenNames operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidNextTokenException The next token was specified in an invalid format.</li>
     *         <li>ResourceValidationException The specified resource could not be validated.</li>
     *         <li>OperationNotSupportedException The API used does not support the deployment.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeDeployException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeDeployAsyncClient.ListGitHubAccountTokenNames
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/ListGitHubAccountTokenNames"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListGitHubAccountTokenNamesResponse> listGitHubAccountTokenNames(
            ListGitHubAccountTokenNamesRequest listGitHubAccountTokenNamesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the names of stored connections to GitHub accounts.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListGitHubAccountTokenNamesRequest.Builder}
     * avoiding the need to create one manually via {@link ListGitHubAccountTokenNamesRequest#builder()}
     * </p>
     *
     * @param listGitHubAccountTokenNamesRequest
     *        A {@link Consumer} that will call methods on {@link ListGitHubAccountTokenNamesInput.Builder} to create a
     *        request. Represents the input of a <code>ListGitHubAccountTokenNames</code> operation.
     * @return A Java Future containing the result of the ListGitHubAccountTokenNames operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidNextTokenException The next token was specified in an invalid format.</li>
     *         <li>ResourceValidationException The specified resource could not be validated.</li>
     *         <li>OperationNotSupportedException The API used does not support the deployment.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeDeployException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeDeployAsyncClient.ListGitHubAccountTokenNames
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/ListGitHubAccountTokenNames"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListGitHubAccountTokenNamesResponse> listGitHubAccountTokenNames(
            Consumer<ListGitHubAccountTokenNamesRequest.Builder> listGitHubAccountTokenNamesRequest) {
        return listGitHubAccountTokenNames(ListGitHubAccountTokenNamesRequest.builder()
                .applyMutation(listGitHubAccountTokenNamesRequest).build());
    }

    /**
     * <p>
     * Lists the names of stored connections to GitHub accounts.
     * </p>
     *
     * @return A Java Future containing the result of the ListGitHubAccountTokenNames operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidNextTokenException The next token was specified in an invalid format.</li>
     *         <li>ResourceValidationException The specified resource could not be validated.</li>
     *         <li>OperationNotSupportedException The API used does not support the deployment.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeDeployException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeDeployAsyncClient.ListGitHubAccountTokenNames
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/ListGitHubAccountTokenNames"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListGitHubAccountTokenNamesResponse> listGitHubAccountTokenNames() {
        return listGitHubAccountTokenNames(ListGitHubAccountTokenNamesRequest.builder().build());
    }

    /**
     * <p>
     * Gets a list of names for one or more on-premises instances.
     * </p>
     * <p>
     * Unless otherwise specified, both registered and deregistered on-premises instance names are listed. To list only
     * registered or deregistered on-premises instance names, use the registration status parameter.
     * </p>
     *
     * @param listOnPremisesInstancesRequest
     *        Represents the input of a <code>ListOnPremisesInstances</code> operation.
     * @return A Java Future containing the result of the ListOnPremisesInstances operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRegistrationStatusException The registration status was specified in an invalid format.</li>
     *         <li>InvalidTagFilterException The tag filter was specified in an invalid format.</li>
     *         <li>InvalidNextTokenException The next token was specified in an invalid format.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeDeployException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeDeployAsyncClient.ListOnPremisesInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/ListOnPremisesInstances"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListOnPremisesInstancesResponse> listOnPremisesInstances(
            ListOnPremisesInstancesRequest listOnPremisesInstancesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a list of names for one or more on-premises instances.
     * </p>
     * <p>
     * Unless otherwise specified, both registered and deregistered on-premises instance names are listed. To list only
     * registered or deregistered on-premises instance names, use the registration status parameter.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListOnPremisesInstancesRequest.Builder} avoiding
     * the need to create one manually via {@link ListOnPremisesInstancesRequest#builder()}
     * </p>
     *
     * @param listOnPremisesInstancesRequest
     *        A {@link Consumer} that will call methods on {@link ListOnPremisesInstancesInput.Builder} to create a
     *        request. Represents the input of a <code>ListOnPremisesInstances</code> operation.
     * @return A Java Future containing the result of the ListOnPremisesInstances operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRegistrationStatusException The registration status was specified in an invalid format.</li>
     *         <li>InvalidTagFilterException The tag filter was specified in an invalid format.</li>
     *         <li>InvalidNextTokenException The next token was specified in an invalid format.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeDeployException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeDeployAsyncClient.ListOnPremisesInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/ListOnPremisesInstances"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListOnPremisesInstancesResponse> listOnPremisesInstances(
            Consumer<ListOnPremisesInstancesRequest.Builder> listOnPremisesInstancesRequest) {
        return listOnPremisesInstances(ListOnPremisesInstancesRequest.builder().applyMutation(listOnPremisesInstancesRequest)
                .build());
    }

    /**
     * <p>
     * Gets a list of names for one or more on-premises instances.
     * </p>
     * <p>
     * Unless otherwise specified, both registered and deregistered on-premises instance names are listed. To list only
     * registered or deregistered on-premises instance names, use the registration status parameter.
     * </p>
     *
     * @return A Java Future containing the result of the ListOnPremisesInstances operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRegistrationStatusException The registration status was specified in an invalid format.</li>
     *         <li>InvalidTagFilterException The tag filter was specified in an invalid format.</li>
     *         <li>InvalidNextTokenException The next token was specified in an invalid format.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeDeployException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeDeployAsyncClient.ListOnPremisesInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/ListOnPremisesInstances"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListOnPremisesInstancesResponse> listOnPremisesInstances() {
        return listOnPremisesInstances(ListOnPremisesInstancesRequest.builder().build());
    }

    /**
     * <p>
     * Returns a list of tags for the resource identified by a specified Amazon Resource Name (ARN). Tags are used to
     * organize and categorize your CodeDeploy resources.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ArnNotSupportedException The specified ARN is not supported. For example, it might be an ARN for a
     *         resource that is not expected.</li>
     *         <li>InvalidArnException The specified ARN is not in a valid format.</li>
     *         <li>ResourceArnRequiredException The ARN of a resource is required, but was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeDeployException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeDeployAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            ListTagsForResourceRequest listTagsForResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of tags for the resource identified by a specified Amazon Resource Name (ARN). Tags are used to
     * organize and categorize your CodeDeploy resources.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on {@link ListTagsForResourceInput.Builder} to create a request.
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ArnNotSupportedException The specified ARN is not supported. For example, it might be an ARN for a
     *         resource that is not expected.</li>
     *         <li>InvalidArnException The specified ARN is not in a valid format.</li>
     *         <li>ResourceArnRequiredException The ARN of a resource is required, but was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeDeployException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeDeployAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Sets the result of a Lambda validation function. The function validates lifecycle hooks during a deployment that
     * uses the AWS Lambda or Amazon ECS compute platform. For AWS Lambda deployments, the available lifecycle hooks are
     * <code>BeforeAllowTraffic</code> and <code>AfterAllowTraffic</code>. For Amazon ECS deployments, the available
     * lifecycle hooks are <code>BeforeInstall</code>, <code>AfterInstall</code>, <code>AfterAllowTestTraffic</code>,
     * <code>BeforeAllowTraffic</code>, and <code>AfterAllowTraffic</code>. Lambda validation functions return
     * <code>Succeeded</code> or <code>Failed</code>. For more information, see <a href=
     * "https://docs.aws.amazon.com/codedeploy/latest/userguide/reference-appspec-file-structure-hooks.html#appspec-hooks-lambda"
     * >AppSpec 'hooks' Section for an AWS Lambda Deployment </a> and <a href=
     * "https://docs.aws.amazon.com/codedeploy/latest/userguide/reference-appspec-file-structure-hooks.html#appspec-hooks-ecs"
     * >AppSpec 'hooks' Section for an Amazon ECS Deployment</a>.
     * </p>
     *
     * @param putLifecycleEventHookExecutionStatusRequest
     * @return A Java Future containing the result of the PutLifecycleEventHookExecutionStatus operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidLifecycleEventHookExecutionStatusException The result of a Lambda validation function that
     *         verifies a lifecycle event is invalid. It should return <code>Succeeded</code> or <code>Failed</code>.</li>
     *         <li>InvalidLifecycleEventHookExecutionIdException A lifecycle event hook is invalid. Review the
     *         <code>hooks</code> section in your AppSpec file to ensure the lifecycle events and <code>hooks</code>
     *         functions are valid.</li>
     *         <li>LifecycleEventAlreadyCompletedException An attempt to return the status of an already completed
     *         lifecycle event occurred.</li>
     *         <li>DeploymentIdRequiredException At least one deployment ID must be specified.</li>
     *         <li>DeploymentDoesNotExistException The deployment with the IAM user or AWS account does not exist.</li>
     *         <li>InvalidDeploymentIdException At least one of the deployment IDs was specified in an invalid format.</li>
     *         <li>UnsupportedActionForDeploymentTypeException A call was submitted that is not supported for the
     *         specified deployment type.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeDeployException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeDeployAsyncClient.PutLifecycleEventHookExecutionStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/PutLifecycleEventHookExecutionStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutLifecycleEventHookExecutionStatusResponse> putLifecycleEventHookExecutionStatus(
            PutLifecycleEventHookExecutionStatusRequest putLifecycleEventHookExecutionStatusRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Sets the result of a Lambda validation function. The function validates lifecycle hooks during a deployment that
     * uses the AWS Lambda or Amazon ECS compute platform. For AWS Lambda deployments, the available lifecycle hooks are
     * <code>BeforeAllowTraffic</code> and <code>AfterAllowTraffic</code>. For Amazon ECS deployments, the available
     * lifecycle hooks are <code>BeforeInstall</code>, <code>AfterInstall</code>, <code>AfterAllowTestTraffic</code>,
     * <code>BeforeAllowTraffic</code>, and <code>AfterAllowTraffic</code>. Lambda validation functions return
     * <code>Succeeded</code> or <code>Failed</code>. For more information, see <a href=
     * "https://docs.aws.amazon.com/codedeploy/latest/userguide/reference-appspec-file-structure-hooks.html#appspec-hooks-lambda"
     * >AppSpec 'hooks' Section for an AWS Lambda Deployment </a> and <a href=
     * "https://docs.aws.amazon.com/codedeploy/latest/userguide/reference-appspec-file-structure-hooks.html#appspec-hooks-ecs"
     * >AppSpec 'hooks' Section for an Amazon ECS Deployment</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link PutLifecycleEventHookExecutionStatusRequest.Builder} avoiding the need to create one manually via
     * {@link PutLifecycleEventHookExecutionStatusRequest#builder()}
     * </p>
     *
     * @param putLifecycleEventHookExecutionStatusRequest
     *        A {@link Consumer} that will call methods on {@link PutLifecycleEventHookExecutionStatusInput.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the PutLifecycleEventHookExecutionStatus operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidLifecycleEventHookExecutionStatusException The result of a Lambda validation function that
     *         verifies a lifecycle event is invalid. It should return <code>Succeeded</code> or <code>Failed</code>.</li>
     *         <li>InvalidLifecycleEventHookExecutionIdException A lifecycle event hook is invalid. Review the
     *         <code>hooks</code> section in your AppSpec file to ensure the lifecycle events and <code>hooks</code>
     *         functions are valid.</li>
     *         <li>LifecycleEventAlreadyCompletedException An attempt to return the status of an already completed
     *         lifecycle event occurred.</li>
     *         <li>DeploymentIdRequiredException At least one deployment ID must be specified.</li>
     *         <li>DeploymentDoesNotExistException The deployment with the IAM user or AWS account does not exist.</li>
     *         <li>InvalidDeploymentIdException At least one of the deployment IDs was specified in an invalid format.</li>
     *         <li>UnsupportedActionForDeploymentTypeException A call was submitted that is not supported for the
     *         specified deployment type.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeDeployException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeDeployAsyncClient.PutLifecycleEventHookExecutionStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/PutLifecycleEventHookExecutionStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutLifecycleEventHookExecutionStatusResponse> putLifecycleEventHookExecutionStatus(
            Consumer<PutLifecycleEventHookExecutionStatusRequest.Builder> putLifecycleEventHookExecutionStatusRequest) {
        return putLifecycleEventHookExecutionStatus(PutLifecycleEventHookExecutionStatusRequest.builder()
                .applyMutation(putLifecycleEventHookExecutionStatusRequest).build());
    }

    /**
     * <p>
     * Registers with AWS CodeDeploy a revision for the specified application.
     * </p>
     *
     * @param registerApplicationRevisionRequest
     *        Represents the input of a RegisterApplicationRevision operation.
     * @return A Java Future containing the result of the RegisterApplicationRevision operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ApplicationDoesNotExistException The application does not exist with the IAM user or AWS account.</li>
     *         <li>ApplicationNameRequiredException The minimum number of required application names was not specified.</li>
     *         <li>InvalidApplicationNameException The application name was specified in an invalid format.</li>
     *         <li>DescriptionTooLongException The description is too long.</li>
     *         <li>RevisionRequiredException The revision ID was not specified.</li>
     *         <li>InvalidRevisionException The revision was specified in an invalid format.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeDeployException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeDeployAsyncClient.RegisterApplicationRevision
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/RegisterApplicationRevision"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<RegisterApplicationRevisionResponse> registerApplicationRevision(
            RegisterApplicationRevisionRequest registerApplicationRevisionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Registers with AWS CodeDeploy a revision for the specified application.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RegisterApplicationRevisionRequest.Builder}
     * avoiding the need to create one manually via {@link RegisterApplicationRevisionRequest#builder()}
     * </p>
     *
     * @param registerApplicationRevisionRequest
     *        A {@link Consumer} that will call methods on {@link RegisterApplicationRevisionInput.Builder} to create a
     *        request. Represents the input of a RegisterApplicationRevision operation.
     * @return A Java Future containing the result of the RegisterApplicationRevision operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ApplicationDoesNotExistException The application does not exist with the IAM user or AWS account.</li>
     *         <li>ApplicationNameRequiredException The minimum number of required application names was not specified.</li>
     *         <li>InvalidApplicationNameException The application name was specified in an invalid format.</li>
     *         <li>DescriptionTooLongException The description is too long.</li>
     *         <li>RevisionRequiredException The revision ID was not specified.</li>
     *         <li>InvalidRevisionException The revision was specified in an invalid format.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeDeployException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeDeployAsyncClient.RegisterApplicationRevision
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/RegisterApplicationRevision"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<RegisterApplicationRevisionResponse> registerApplicationRevision(
            Consumer<RegisterApplicationRevisionRequest.Builder> registerApplicationRevisionRequest) {
        return registerApplicationRevision(RegisterApplicationRevisionRequest.builder()
                .applyMutation(registerApplicationRevisionRequest).build());
    }

    /**
     * <p>
     * Registers an on-premises instance.
     * </p>
     * <note>
     * <p>
     * Only one IAM ARN (an IAM session ARN or IAM user ARN) is supported in the request. You cannot use both.
     * </p>
     * </note>
     *
     * @param registerOnPremisesInstanceRequest
     *        Represents the input of the register on-premises instance operation.
     * @return A Java Future containing the result of the RegisterOnPremisesInstance operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InstanceNameAlreadyRegisteredException The specified on-premises instance name is already registered.
     *         </li>
     *         <li>IamArnRequiredException No IAM ARN was included in the request. You must use an IAM session ARN or
     *         IAM user ARN in the request.</li>
     *         <li>IamSessionArnAlreadyRegisteredException The request included an IAM session ARN that has already been
     *         used to register a different instance.</li>
     *         <li>IamUserArnAlreadyRegisteredException The specified IAM user ARN is already registered with an
     *         on-premises instance.</li>
     *         <li>InstanceNameRequiredException An on-premises instance name was not specified.</li>
     *         <li>IamUserArnRequiredException An IAM user ARN was not specified.</li>
     *         <li>InvalidInstanceNameException The on-premises instance name was specified in an invalid format.</li>
     *         <li>InvalidIamSessionArnException The IAM session ARN was specified in an invalid format.</li>
     *         <li>InvalidIamUserArnException The IAM user ARN was specified in an invalid format.</li>
     *         <li>MultipleIamArnsProvidedException Both an IAM user ARN and an IAM session ARN were included in the
     *         request. Use only one ARN type.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeDeployException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeDeployAsyncClient.RegisterOnPremisesInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/RegisterOnPremisesInstance"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<RegisterOnPremisesInstanceResponse> registerOnPremisesInstance(
            RegisterOnPremisesInstanceRequest registerOnPremisesInstanceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Registers an on-premises instance.
     * </p>
     * <note>
     * <p>
     * Only one IAM ARN (an IAM session ARN or IAM user ARN) is supported in the request. You cannot use both.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RegisterOnPremisesInstanceRequest.Builder} avoiding
     * the need to create one manually via {@link RegisterOnPremisesInstanceRequest#builder()}
     * </p>
     *
     * @param registerOnPremisesInstanceRequest
     *        A {@link Consumer} that will call methods on {@link RegisterOnPremisesInstanceInput.Builder} to create a
     *        request. Represents the input of the register on-premises instance operation.
     * @return A Java Future containing the result of the RegisterOnPremisesInstance operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InstanceNameAlreadyRegisteredException The specified on-premises instance name is already registered.
     *         </li>
     *         <li>IamArnRequiredException No IAM ARN was included in the request. You must use an IAM session ARN or
     *         IAM user ARN in the request.</li>
     *         <li>IamSessionArnAlreadyRegisteredException The request included an IAM session ARN that has already been
     *         used to register a different instance.</li>
     *         <li>IamUserArnAlreadyRegisteredException The specified IAM user ARN is already registered with an
     *         on-premises instance.</li>
     *         <li>InstanceNameRequiredException An on-premises instance name was not specified.</li>
     *         <li>IamUserArnRequiredException An IAM user ARN was not specified.</li>
     *         <li>InvalidInstanceNameException The on-premises instance name was specified in an invalid format.</li>
     *         <li>InvalidIamSessionArnException The IAM session ARN was specified in an invalid format.</li>
     *         <li>InvalidIamUserArnException The IAM user ARN was specified in an invalid format.</li>
     *         <li>MultipleIamArnsProvidedException Both an IAM user ARN and an IAM session ARN were included in the
     *         request. Use only one ARN type.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeDeployException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeDeployAsyncClient.RegisterOnPremisesInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/RegisterOnPremisesInstance"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<RegisterOnPremisesInstanceResponse> registerOnPremisesInstance(
            Consumer<RegisterOnPremisesInstanceRequest.Builder> registerOnPremisesInstanceRequest) {
        return registerOnPremisesInstance(RegisterOnPremisesInstanceRequest.builder()
                .applyMutation(registerOnPremisesInstanceRequest).build());
    }

    /**
     * <p>
     * Removes one or more tags from one or more on-premises instances.
     * </p>
     *
     * @param removeTagsFromOnPremisesInstancesRequest
     *        Represents the input of a <code>RemoveTagsFromOnPremisesInstances</code> operation.
     * @return A Java Future containing the result of the RemoveTagsFromOnPremisesInstances operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InstanceNameRequiredException An on-premises instance name was not specified.</li>
     *         <li>InvalidInstanceNameException The on-premises instance name was specified in an invalid format.</li>
     *         <li>TagRequiredException A tag was not specified.</li>
     *         <li>InvalidTagException The tag was specified in an invalid format.</li>
     *         <li>TagLimitExceededException The maximum allowed number of tags was exceeded.</li>
     *         <li>InstanceLimitExceededException The maximum number of allowed on-premises instances in a single call
     *         was exceeded.</li>
     *         <li>InstanceNotRegisteredException The specified on-premises instance is not registered.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeDeployException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeDeployAsyncClient.RemoveTagsFromOnPremisesInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/RemoveTagsFromOnPremisesInstances"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<RemoveTagsFromOnPremisesInstancesResponse> removeTagsFromOnPremisesInstances(
            RemoveTagsFromOnPremisesInstancesRequest removeTagsFromOnPremisesInstancesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes one or more tags from one or more on-premises instances.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RemoveTagsFromOnPremisesInstancesRequest.Builder}
     * avoiding the need to create one manually via {@link RemoveTagsFromOnPremisesInstancesRequest#builder()}
     * </p>
     *
     * @param removeTagsFromOnPremisesInstancesRequest
     *        A {@link Consumer} that will call methods on {@link RemoveTagsFromOnPremisesInstancesInput.Builder} to
     *        create a request. Represents the input of a <code>RemoveTagsFromOnPremisesInstances</code> operation.
     * @return A Java Future containing the result of the RemoveTagsFromOnPremisesInstances operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InstanceNameRequiredException An on-premises instance name was not specified.</li>
     *         <li>InvalidInstanceNameException The on-premises instance name was specified in an invalid format.</li>
     *         <li>TagRequiredException A tag was not specified.</li>
     *         <li>InvalidTagException The tag was specified in an invalid format.</li>
     *         <li>TagLimitExceededException The maximum allowed number of tags was exceeded.</li>
     *         <li>InstanceLimitExceededException The maximum number of allowed on-premises instances in a single call
     *         was exceeded.</li>
     *         <li>InstanceNotRegisteredException The specified on-premises instance is not registered.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeDeployException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeDeployAsyncClient.RemoveTagsFromOnPremisesInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/RemoveTagsFromOnPremisesInstances"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<RemoveTagsFromOnPremisesInstancesResponse> removeTagsFromOnPremisesInstances(
            Consumer<RemoveTagsFromOnPremisesInstancesRequest.Builder> removeTagsFromOnPremisesInstancesRequest) {
        return removeTagsFromOnPremisesInstances(RemoveTagsFromOnPremisesInstancesRequest.builder()
                .applyMutation(removeTagsFromOnPremisesInstancesRequest).build());
    }

    /**
     * <p>
     * Attempts to stop an ongoing deployment.
     * </p>
     *
     * @param stopDeploymentRequest
     *        Represents the input of a <code>StopDeployment</code> operation.
     * @return A Java Future containing the result of the StopDeployment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DeploymentIdRequiredException At least one deployment ID must be specified.</li>
     *         <li>DeploymentDoesNotExistException The deployment with the IAM user or AWS account does not exist.</li>
     *         <li>DeploymentGroupDoesNotExistException The named deployment group with the IAM user or AWS account does
     *         not exist.</li>
     *         <li>DeploymentAlreadyCompletedException The deployment is already complete.</li>
     *         <li>InvalidDeploymentIdException At least one of the deployment IDs was specified in an invalid format.</li>
     *         <li>UnsupportedActionForDeploymentTypeException A call was submitted that is not supported for the
     *         specified deployment type.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeDeployException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeDeployAsyncClient.StopDeployment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/StopDeployment" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<StopDeploymentResponse> stopDeployment(StopDeploymentRequest stopDeploymentRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Attempts to stop an ongoing deployment.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StopDeploymentRequest.Builder} avoiding the need to
     * create one manually via {@link StopDeploymentRequest#builder()}
     * </p>
     *
     * @param stopDeploymentRequest
     *        A {@link Consumer} that will call methods on {@link StopDeploymentInput.Builder} to create a request.
     *        Represents the input of a <code>StopDeployment</code> operation.
     * @return A Java Future containing the result of the StopDeployment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DeploymentIdRequiredException At least one deployment ID must be specified.</li>
     *         <li>DeploymentDoesNotExistException The deployment with the IAM user or AWS account does not exist.</li>
     *         <li>DeploymentGroupDoesNotExistException The named deployment group with the IAM user or AWS account does
     *         not exist.</li>
     *         <li>DeploymentAlreadyCompletedException The deployment is already complete.</li>
     *         <li>InvalidDeploymentIdException At least one of the deployment IDs was specified in an invalid format.</li>
     *         <li>UnsupportedActionForDeploymentTypeException A call was submitted that is not supported for the
     *         specified deployment type.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeDeployException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeDeployAsyncClient.StopDeployment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/StopDeployment" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<StopDeploymentResponse> stopDeployment(Consumer<StopDeploymentRequest.Builder> stopDeploymentRequest) {
        return stopDeployment(StopDeploymentRequest.builder().applyMutation(stopDeploymentRequest).build());
    }

    /**
     * <p>
     * Associates the list of tags in the input <code>Tags</code> parameter with the resource identified by the
     * <code>ResourceArn</code> input parameter.
     * </p>
     *
     * @param tagResourceRequest
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceArnRequiredException The ARN of a resource is required, but was not found.</li>
     *         <li>ApplicationDoesNotExistException The application does not exist with the IAM user or AWS account.</li>
     *         <li>DeploymentGroupDoesNotExistException The named deployment group with the IAM user or AWS account does
     *         not exist.</li>
     *         <li>DeploymentConfigDoesNotExistException The deployment configuration does not exist with the IAM user
     *         or AWS account.</li>
     *         <li>TagRequiredException A tag was not specified.</li>
     *         <li>InvalidTagsToAddException The specified tags are not valid.</li>
     *         <li>ArnNotSupportedException The specified ARN is not supported. For example, it might be an ARN for a
     *         resource that is not expected.</li>
     *         <li>InvalidArnException The specified ARN is not in a valid format.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeDeployException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeDeployAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates the list of tags in the input <code>Tags</code> parameter with the resource identified by the
     * <code>ResourceArn</code> input parameter.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on {@link TagResourceInput.Builder} to create a request.
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceArnRequiredException The ARN of a resource is required, but was not found.</li>
     *         <li>ApplicationDoesNotExistException The application does not exist with the IAM user or AWS account.</li>
     *         <li>DeploymentGroupDoesNotExistException The named deployment group with the IAM user or AWS account does
     *         not exist.</li>
     *         <li>DeploymentConfigDoesNotExistException The deployment configuration does not exist with the IAM user
     *         or AWS account.</li>
     *         <li>TagRequiredException A tag was not specified.</li>
     *         <li>InvalidTagsToAddException The specified tags are not valid.</li>
     *         <li>ArnNotSupportedException The specified ARN is not supported. For example, it might be an ARN for a
     *         resource that is not expected.</li>
     *         <li>InvalidArnException The specified ARN is not in a valid format.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeDeployException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeDeployAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Disassociates a resource from a list of tags. The resource is identified by the <code>ResourceArn</code> input
     * parameter. The tags are identified by the list of keys in the <code>TagKeys</code> input parameter.
     * </p>
     *
     * @param untagResourceRequest
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceArnRequiredException The ARN of a resource is required, but was not found.</li>
     *         <li>ApplicationDoesNotExistException The application does not exist with the IAM user or AWS account.</li>
     *         <li>DeploymentGroupDoesNotExistException The named deployment group with the IAM user or AWS account does
     *         not exist.</li>
     *         <li>DeploymentConfigDoesNotExistException The deployment configuration does not exist with the IAM user
     *         or AWS account.</li>
     *         <li>TagRequiredException A tag was not specified.</li>
     *         <li>InvalidTagsToAddException The specified tags are not valid.</li>
     *         <li>ArnNotSupportedException The specified ARN is not supported. For example, it might be an ARN for a
     *         resource that is not expected.</li>
     *         <li>InvalidArnException The specified ARN is not in a valid format.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeDeployException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeDeployAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disassociates a resource from a list of tags. The resource is identified by the <code>ResourceArn</code> input
     * parameter. The tags are identified by the list of keys in the <code>TagKeys</code> input parameter.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on {@link UntagResourceInput.Builder} to create a request.
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceArnRequiredException The ARN of a resource is required, but was not found.</li>
     *         <li>ApplicationDoesNotExistException The application does not exist with the IAM user or AWS account.</li>
     *         <li>DeploymentGroupDoesNotExistException The named deployment group with the IAM user or AWS account does
     *         not exist.</li>
     *         <li>DeploymentConfigDoesNotExistException The deployment configuration does not exist with the IAM user
     *         or AWS account.</li>
     *         <li>TagRequiredException A tag was not specified.</li>
     *         <li>InvalidTagsToAddException The specified tags are not valid.</li>
     *         <li>ArnNotSupportedException The specified ARN is not supported. For example, it might be an ARN for a
     *         resource that is not expected.</li>
     *         <li>InvalidArnException The specified ARN is not in a valid format.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeDeployException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeDeployAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest) {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Changes the name of an application.
     * </p>
     *
     * @param updateApplicationRequest
     *        Represents the input of an <code>UpdateApplication</code> operation.
     * @return A Java Future containing the result of the UpdateApplication operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ApplicationNameRequiredException The minimum number of required application names was not specified.</li>
     *         <li>InvalidApplicationNameException The application name was specified in an invalid format.</li>
     *         <li>ApplicationAlreadyExistsException An application with the specified name with the IAM user or AWS
     *         account already exists.</li>
     *         <li>ApplicationDoesNotExistException The application does not exist with the IAM user or AWS account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeDeployException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeDeployAsyncClient.UpdateApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/UpdateApplication" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateApplicationResponse> updateApplication(UpdateApplicationRequest updateApplicationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Changes the name of an application.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateApplicationRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateApplicationRequest#builder()}
     * </p>
     *
     * @param updateApplicationRequest
     *        A {@link Consumer} that will call methods on {@link UpdateApplicationInput.Builder} to create a request.
     *        Represents the input of an <code>UpdateApplication</code> operation.
     * @return A Java Future containing the result of the UpdateApplication operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ApplicationNameRequiredException The minimum number of required application names was not specified.</li>
     *         <li>InvalidApplicationNameException The application name was specified in an invalid format.</li>
     *         <li>ApplicationAlreadyExistsException An application with the specified name with the IAM user or AWS
     *         account already exists.</li>
     *         <li>ApplicationDoesNotExistException The application does not exist with the IAM user or AWS account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeDeployException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeDeployAsyncClient.UpdateApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/UpdateApplication" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateApplicationResponse> updateApplication(
            Consumer<UpdateApplicationRequest.Builder> updateApplicationRequest) {
        return updateApplication(UpdateApplicationRequest.builder().applyMutation(updateApplicationRequest).build());
    }

    /**
     * <p>
     * Changes information about a deployment group.
     * </p>
     *
     * @param updateDeploymentGroupRequest
     *        Represents the input of an <code>UpdateDeploymentGroup</code> operation.
     * @return A Java Future containing the result of the UpdateDeploymentGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ApplicationNameRequiredException The minimum number of required application names was not specified.</li>
     *         <li>InvalidApplicationNameException The application name was specified in an invalid format.</li>
     *         <li>ApplicationDoesNotExistException The application does not exist with the IAM user or AWS account.</li>
     *         <li>InvalidDeploymentGroupNameException The deployment group name was specified in an invalid format.</li>
     *         <li>DeploymentGroupAlreadyExistsException A deployment group with the specified name with the IAM user or
     *         AWS account already exists.</li>
     *         <li>DeploymentGroupNameRequiredException The deployment group name was not specified.</li>
     *         <li>DeploymentGroupDoesNotExistException The named deployment group with the IAM user or AWS account does
     *         not exist.</li>
     *         <li>InvalidEc2TagException The tag was specified in an invalid format.</li>
     *         <li>InvalidTagException The tag was specified in an invalid format.</li>
     *         <li>InvalidAutoScalingGroupException The Auto Scaling group was specified in an invalid format or does
     *         not exist.</li>
     *         <li>InvalidDeploymentConfigNameException The deployment configuration name was specified in an invalid
     *         format.</li>
     *         <li>DeploymentConfigDoesNotExistException The deployment configuration does not exist with the IAM user
     *         or AWS account.</li>
     *         <li>InvalidRoleException The service role ARN was specified in an invalid format. Or, if an Auto Scaling
     *         group was specified, the specified service role does not grant the appropriate permissions to Amazon EC2
     *         Auto Scaling.</li>
     *         <li>LifecycleHookLimitExceededException The limit for lifecycle hooks was exceeded.</li>
     *         <li>InvalidTriggerConfigException The trigger was specified in an invalid format.</li>
     *         <li>TriggerTargetsLimitExceededException The maximum allowed number of triggers was exceeded.</li>
     *         <li>InvalidAlarmConfigException The format of the alarm configuration is invalid. Possible causes
     *         include:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         The alarm list is null.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The alarm object is null.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The alarm name is empty or null or exceeds the limit of 255 characters.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Two alarms with the same name have been specified.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The alarm configuration is enabled, but the alarm list is empty.
     *         </p>
     *         </li></li>
     *         <li>AlarmsLimitExceededException The maximum number of alarms for a deployment group (10) was exceeded.</li>
     *         <li>InvalidAutoRollbackConfigException The automatic rollback configuration was specified in an invalid
     *         format. For example, automatic rollback is enabled, but an invalid triggering event type or no event
     *         types were listed.</li>
     *         <li>InvalidLoadBalancerInfoException An invalid load balancer name, or no load balancer name, was
     *         specified.</li>
     *         <li>InvalidDeploymentStyleException An invalid deployment style was specified. Valid deployment types
     *         include "IN_PLACE" and "BLUE_GREEN." Valid deployment options include "WITH_TRAFFIC_CONTROL" and
     *         "WITHOUT_TRAFFIC_CONTROL."</li>
     *         <li>InvalidBlueGreenDeploymentConfigurationException The configuration for the blue/green deployment
     *         group was provided in an invalid format. For information about deployment configuration format, see
     *         <a>CreateDeploymentConfig</a>.</li>
     *         <li>InvalidEc2TagCombinationException A call was submitted that specified both Ec2TagFilters and
     *         Ec2TagSet, but only one of these data types can be used in a single call.</li>
     *         <li>InvalidOnPremisesTagCombinationException A call was submitted that specified both
     *         OnPremisesTagFilters and OnPremisesTagSet, but only one of these data types can be used in a single call.
     *         </li>
     *         <li>TagSetListLimitExceededException The number of tag groups included in the tag set list exceeded the
     *         maximum allowed limit of 3.</li>
     *         <li>InvalidInputException The input was specified in an invalid format.</li>
     *         <li>ThrottlingException An API function was called too frequently.</li>
     *         <li>InvalidEcsServiceException The Amazon ECS service identifier is not valid.</li>
     *         <li>InvalidTargetGroupPairException A target group pair associated with this deployment is not valid.</li>
     *         <li>EcsServiceMappingLimitExceededException The Amazon ECS service is associated with more than one
     *         deployment groups. An Amazon ECS service can be associated with only one deployment group.</li>
     *         <li>InvalidTrafficRoutingConfigurationException The configuration that specifies how traffic is routed
     *         during a deployment is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeDeployException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeDeployAsyncClient.UpdateDeploymentGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/UpdateDeploymentGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateDeploymentGroupResponse> updateDeploymentGroup(
            UpdateDeploymentGroupRequest updateDeploymentGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Changes information about a deployment group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateDeploymentGroupRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateDeploymentGroupRequest#builder()}
     * </p>
     *
     * @param updateDeploymentGroupRequest
     *        A {@link Consumer} that will call methods on {@link UpdateDeploymentGroupInput.Builder} to create a
     *        request. Represents the input of an <code>UpdateDeploymentGroup</code> operation.
     * @return A Java Future containing the result of the UpdateDeploymentGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ApplicationNameRequiredException The minimum number of required application names was not specified.</li>
     *         <li>InvalidApplicationNameException The application name was specified in an invalid format.</li>
     *         <li>ApplicationDoesNotExistException The application does not exist with the IAM user or AWS account.</li>
     *         <li>InvalidDeploymentGroupNameException The deployment group name was specified in an invalid format.</li>
     *         <li>DeploymentGroupAlreadyExistsException A deployment group with the specified name with the IAM user or
     *         AWS account already exists.</li>
     *         <li>DeploymentGroupNameRequiredException The deployment group name was not specified.</li>
     *         <li>DeploymentGroupDoesNotExistException The named deployment group with the IAM user or AWS account does
     *         not exist.</li>
     *         <li>InvalidEc2TagException The tag was specified in an invalid format.</li>
     *         <li>InvalidTagException The tag was specified in an invalid format.</li>
     *         <li>InvalidAutoScalingGroupException The Auto Scaling group was specified in an invalid format or does
     *         not exist.</li>
     *         <li>InvalidDeploymentConfigNameException The deployment configuration name was specified in an invalid
     *         format.</li>
     *         <li>DeploymentConfigDoesNotExistException The deployment configuration does not exist with the IAM user
     *         or AWS account.</li>
     *         <li>InvalidRoleException The service role ARN was specified in an invalid format. Or, if an Auto Scaling
     *         group was specified, the specified service role does not grant the appropriate permissions to Amazon EC2
     *         Auto Scaling.</li>
     *         <li>LifecycleHookLimitExceededException The limit for lifecycle hooks was exceeded.</li>
     *         <li>InvalidTriggerConfigException The trigger was specified in an invalid format.</li>
     *         <li>TriggerTargetsLimitExceededException The maximum allowed number of triggers was exceeded.</li>
     *         <li>InvalidAlarmConfigException The format of the alarm configuration is invalid. Possible causes
     *         include:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         The alarm list is null.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The alarm object is null.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The alarm name is empty or null or exceeds the limit of 255 characters.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Two alarms with the same name have been specified.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The alarm configuration is enabled, but the alarm list is empty.
     *         </p>
     *         </li></li>
     *         <li>AlarmsLimitExceededException The maximum number of alarms for a deployment group (10) was exceeded.</li>
     *         <li>InvalidAutoRollbackConfigException The automatic rollback configuration was specified in an invalid
     *         format. For example, automatic rollback is enabled, but an invalid triggering event type or no event
     *         types were listed.</li>
     *         <li>InvalidLoadBalancerInfoException An invalid load balancer name, or no load balancer name, was
     *         specified.</li>
     *         <li>InvalidDeploymentStyleException An invalid deployment style was specified. Valid deployment types
     *         include "IN_PLACE" and "BLUE_GREEN." Valid deployment options include "WITH_TRAFFIC_CONTROL" and
     *         "WITHOUT_TRAFFIC_CONTROL."</li>
     *         <li>InvalidBlueGreenDeploymentConfigurationException The configuration for the blue/green deployment
     *         group was provided in an invalid format. For information about deployment configuration format, see
     *         <a>CreateDeploymentConfig</a>.</li>
     *         <li>InvalidEc2TagCombinationException A call was submitted that specified both Ec2TagFilters and
     *         Ec2TagSet, but only one of these data types can be used in a single call.</li>
     *         <li>InvalidOnPremisesTagCombinationException A call was submitted that specified both
     *         OnPremisesTagFilters and OnPremisesTagSet, but only one of these data types can be used in a single call.
     *         </li>
     *         <li>TagSetListLimitExceededException The number of tag groups included in the tag set list exceeded the
     *         maximum allowed limit of 3.</li>
     *         <li>InvalidInputException The input was specified in an invalid format.</li>
     *         <li>ThrottlingException An API function was called too frequently.</li>
     *         <li>InvalidEcsServiceException The Amazon ECS service identifier is not valid.</li>
     *         <li>InvalidTargetGroupPairException A target group pair associated with this deployment is not valid.</li>
     *         <li>EcsServiceMappingLimitExceededException The Amazon ECS service is associated with more than one
     *         deployment groups. An Amazon ECS service can be associated with only one deployment group.</li>
     *         <li>InvalidTrafficRoutingConfigurationException The configuration that specifies how traffic is routed
     *         during a deployment is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeDeployException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeDeployAsyncClient.UpdateDeploymentGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/UpdateDeploymentGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateDeploymentGroupResponse> updateDeploymentGroup(
            Consumer<UpdateDeploymentGroupRequest.Builder> updateDeploymentGroupRequest) {
        return updateDeploymentGroup(UpdateDeploymentGroupRequest.builder().applyMutation(updateDeploymentGroupRequest).build());
    }

    /**
     * Create an instance of {@link CodeDeployAsyncWaiter} using this client.
     * <p>
     * Waiters created via this method are managed by the SDK and resources will be released when the service client is
     * closed.
     *
     * @return an instance of {@link CodeDeployAsyncWaiter}
     */
    default CodeDeployAsyncWaiter waiter() {
        throw new UnsupportedOperationException();
    }
}
