/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codedeploy.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.codedeploy.CodeDeployClient;
import software.amazon.awssdk.services.codedeploy.model.ListApplicationRevisionsRequest;
import software.amazon.awssdk.services.codedeploy.model.ListApplicationRevisionsResponse;
import software.amazon.awssdk.services.codedeploy.model.RevisionLocation;

public class ListApplicationRevisionsIterable
implements SdkIterable<ListApplicationRevisionsResponse> {
    private final CodeDeployClient client;
    private final ListApplicationRevisionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListApplicationRevisionsIterable(CodeDeployClient client, ListApplicationRevisionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListApplicationRevisionsResponseFetcher();
    }

    public Iterator<ListApplicationRevisionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<RevisionLocation> revisions() {
        Function<ListApplicationRevisionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.revisions() != null) {
                return response.revisions().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListApplicationRevisionsResponseFetcher
    implements SyncPageFetcher<ListApplicationRevisionsResponse> {
        private ListApplicationRevisionsResponseFetcher() {
        }

        public boolean hasNextPage(ListApplicationRevisionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListApplicationRevisionsResponse nextPage(ListApplicationRevisionsResponse previousPage) {
            if (previousPage == null) {
                return ListApplicationRevisionsIterable.this.client.listApplicationRevisions(ListApplicationRevisionsIterable.this.firstRequest);
            }
            return ListApplicationRevisionsIterable.this.client.listApplicationRevisions((ListApplicationRevisionsRequest)((Object)ListApplicationRevisionsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

