/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codedeploy.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a deployment group.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeploymentGroupInfo implements SdkPojo, Serializable,
        ToCopyableBuilder<DeploymentGroupInfo.Builder, DeploymentGroupInfo> {
    private static final SdkField<String> APPLICATION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("applicationName").getter(getter(DeploymentGroupInfo::applicationName))
            .setter(setter(Builder::applicationName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("applicationName").build()).build();

    private static final SdkField<String> DEPLOYMENT_GROUP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("deploymentGroupId").getter(getter(DeploymentGroupInfo::deploymentGroupId))
            .setter(setter(Builder::deploymentGroupId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deploymentGroupId").build()).build();

    private static final SdkField<String> DEPLOYMENT_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("deploymentGroupName").getter(getter(DeploymentGroupInfo::deploymentGroupName))
            .setter(setter(Builder::deploymentGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deploymentGroupName").build())
            .build();

    private static final SdkField<String> DEPLOYMENT_CONFIG_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("deploymentConfigName").getter(getter(DeploymentGroupInfo::deploymentConfigName))
            .setter(setter(Builder::deploymentConfigName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deploymentConfigName").build())
            .build();

    private static final SdkField<List<EC2TagFilter>> EC2_TAG_FILTERS_FIELD = SdkField
            .<List<EC2TagFilter>> builder(MarshallingType.LIST)
            .memberName("ec2TagFilters")
            .getter(getter(DeploymentGroupInfo::ec2TagFilters))
            .setter(setter(Builder::ec2TagFilters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ec2TagFilters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<EC2TagFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(EC2TagFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<TagFilter>> ON_PREMISES_INSTANCE_TAG_FILTERS_FIELD = SdkField
            .<List<TagFilter>> builder(MarshallingType.LIST)
            .memberName("onPremisesInstanceTagFilters")
            .getter(getter(DeploymentGroupInfo::onPremisesInstanceTagFilters))
            .setter(setter(Builder::onPremisesInstanceTagFilters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("onPremisesInstanceTagFilters")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<TagFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(TagFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<AutoScalingGroup>> AUTO_SCALING_GROUPS_FIELD = SdkField
            .<List<AutoScalingGroup>> builder(MarshallingType.LIST)
            .memberName("autoScalingGroups")
            .getter(getter(DeploymentGroupInfo::autoScalingGroups))
            .setter(setter(Builder::autoScalingGroups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("autoScalingGroups").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AutoScalingGroup> builder(MarshallingType.SDK_POJO)
                                            .constructor(AutoScalingGroup::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> SERVICE_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("serviceRoleArn").getter(getter(DeploymentGroupInfo::serviceRoleArn))
            .setter(setter(Builder::serviceRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceRoleArn").build()).build();

    private static final SdkField<RevisionLocation> TARGET_REVISION_FIELD = SdkField
            .<RevisionLocation> builder(MarshallingType.SDK_POJO).memberName("targetRevision")
            .getter(getter(DeploymentGroupInfo::targetRevision)).setter(setter(Builder::targetRevision))
            .constructor(RevisionLocation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetRevision").build()).build();

    private static final SdkField<List<TriggerConfig>> TRIGGER_CONFIGURATIONS_FIELD = SdkField
            .<List<TriggerConfig>> builder(MarshallingType.LIST)
            .memberName("triggerConfigurations")
            .getter(getter(DeploymentGroupInfo::triggerConfigurations))
            .setter(setter(Builder::triggerConfigurations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("triggerConfigurations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<TriggerConfig> builder(MarshallingType.SDK_POJO)
                                            .constructor(TriggerConfig::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<AlarmConfiguration> ALARM_CONFIGURATION_FIELD = SdkField
            .<AlarmConfiguration> builder(MarshallingType.SDK_POJO).memberName("alarmConfiguration")
            .getter(getter(DeploymentGroupInfo::alarmConfiguration)).setter(setter(Builder::alarmConfiguration))
            .constructor(AlarmConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("alarmConfiguration").build())
            .build();

    private static final SdkField<AutoRollbackConfiguration> AUTO_ROLLBACK_CONFIGURATION_FIELD = SdkField
            .<AutoRollbackConfiguration> builder(MarshallingType.SDK_POJO).memberName("autoRollbackConfiguration")
            .getter(getter(DeploymentGroupInfo::autoRollbackConfiguration)).setter(setter(Builder::autoRollbackConfiguration))
            .constructor(AutoRollbackConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("autoRollbackConfiguration").build())
            .build();

    private static final SdkField<DeploymentStyle> DEPLOYMENT_STYLE_FIELD = SdkField
            .<DeploymentStyle> builder(MarshallingType.SDK_POJO).memberName("deploymentStyle")
            .getter(getter(DeploymentGroupInfo::deploymentStyle)).setter(setter(Builder::deploymentStyle))
            .constructor(DeploymentStyle::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deploymentStyle").build()).build();

    private static final SdkField<String> OUTDATED_INSTANCES_STRATEGY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("outdatedInstancesStrategy").getter(getter(DeploymentGroupInfo::outdatedInstancesStrategyAsString))
            .setter(setter(Builder::outdatedInstancesStrategy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outdatedInstancesStrategy").build())
            .build();

    private static final SdkField<BlueGreenDeploymentConfiguration> BLUE_GREEN_DEPLOYMENT_CONFIGURATION_FIELD = SdkField
            .<BlueGreenDeploymentConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("blueGreenDeploymentConfiguration")
            .getter(getter(DeploymentGroupInfo::blueGreenDeploymentConfiguration))
            .setter(setter(Builder::blueGreenDeploymentConfiguration))
            .constructor(BlueGreenDeploymentConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("blueGreenDeploymentConfiguration")
                    .build()).build();

    private static final SdkField<LoadBalancerInfo> LOAD_BALANCER_INFO_FIELD = SdkField
            .<LoadBalancerInfo> builder(MarshallingType.SDK_POJO).memberName("loadBalancerInfo")
            .getter(getter(DeploymentGroupInfo::loadBalancerInfo)).setter(setter(Builder::loadBalancerInfo))
            .constructor(LoadBalancerInfo::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("loadBalancerInfo").build()).build();

    private static final SdkField<LastDeploymentInfo> LAST_SUCCESSFUL_DEPLOYMENT_FIELD = SdkField
            .<LastDeploymentInfo> builder(MarshallingType.SDK_POJO).memberName("lastSuccessfulDeployment")
            .getter(getter(DeploymentGroupInfo::lastSuccessfulDeployment)).setter(setter(Builder::lastSuccessfulDeployment))
            .constructor(LastDeploymentInfo::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastSuccessfulDeployment").build())
            .build();

    private static final SdkField<LastDeploymentInfo> LAST_ATTEMPTED_DEPLOYMENT_FIELD = SdkField
            .<LastDeploymentInfo> builder(MarshallingType.SDK_POJO).memberName("lastAttemptedDeployment")
            .getter(getter(DeploymentGroupInfo::lastAttemptedDeployment)).setter(setter(Builder::lastAttemptedDeployment))
            .constructor(LastDeploymentInfo::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastAttemptedDeployment").build())
            .build();

    private static final SdkField<EC2TagSet> EC2_TAG_SET_FIELD = SdkField.<EC2TagSet> builder(MarshallingType.SDK_POJO)
            .memberName("ec2TagSet").getter(getter(DeploymentGroupInfo::ec2TagSet)).setter(setter(Builder::ec2TagSet))
            .constructor(EC2TagSet::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ec2TagSet").build()).build();

    private static final SdkField<OnPremisesTagSet> ON_PREMISES_TAG_SET_FIELD = SdkField
            .<OnPremisesTagSet> builder(MarshallingType.SDK_POJO).memberName("onPremisesTagSet")
            .getter(getter(DeploymentGroupInfo::onPremisesTagSet)).setter(setter(Builder::onPremisesTagSet))
            .constructor(OnPremisesTagSet::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("onPremisesTagSet").build()).build();

    private static final SdkField<String> COMPUTE_PLATFORM_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("computePlatform").getter(getter(DeploymentGroupInfo::computePlatformAsString))
            .setter(setter(Builder::computePlatform))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("computePlatform").build()).build();

    private static final SdkField<List<ECSService>> ECS_SERVICES_FIELD = SdkField
            .<List<ECSService>> builder(MarshallingType.LIST)
            .memberName("ecsServices")
            .getter(getter(DeploymentGroupInfo::ecsServices))
            .setter(setter(Builder::ecsServices))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ecsServices").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ECSService> builder(MarshallingType.SDK_POJO)
                                            .constructor(ECSService::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_NAME_FIELD,
            DEPLOYMENT_GROUP_ID_FIELD, DEPLOYMENT_GROUP_NAME_FIELD, DEPLOYMENT_CONFIG_NAME_FIELD, EC2_TAG_FILTERS_FIELD,
            ON_PREMISES_INSTANCE_TAG_FILTERS_FIELD, AUTO_SCALING_GROUPS_FIELD, SERVICE_ROLE_ARN_FIELD, TARGET_REVISION_FIELD,
            TRIGGER_CONFIGURATIONS_FIELD, ALARM_CONFIGURATION_FIELD, AUTO_ROLLBACK_CONFIGURATION_FIELD, DEPLOYMENT_STYLE_FIELD,
            OUTDATED_INSTANCES_STRATEGY_FIELD, BLUE_GREEN_DEPLOYMENT_CONFIGURATION_FIELD, LOAD_BALANCER_INFO_FIELD,
            LAST_SUCCESSFUL_DEPLOYMENT_FIELD, LAST_ATTEMPTED_DEPLOYMENT_FIELD, EC2_TAG_SET_FIELD, ON_PREMISES_TAG_SET_FIELD,
            COMPUTE_PLATFORM_FIELD, ECS_SERVICES_FIELD));

    private static final long serialVersionUID = 1L;

    private final String applicationName;

    private final String deploymentGroupId;

    private final String deploymentGroupName;

    private final String deploymentConfigName;

    private final List<EC2TagFilter> ec2TagFilters;

    private final List<TagFilter> onPremisesInstanceTagFilters;

    private final List<AutoScalingGroup> autoScalingGroups;

    private final String serviceRoleArn;

    private final RevisionLocation targetRevision;

    private final List<TriggerConfig> triggerConfigurations;

    private final AlarmConfiguration alarmConfiguration;

    private final AutoRollbackConfiguration autoRollbackConfiguration;

    private final DeploymentStyle deploymentStyle;

    private final String outdatedInstancesStrategy;

    private final BlueGreenDeploymentConfiguration blueGreenDeploymentConfiguration;

    private final LoadBalancerInfo loadBalancerInfo;

    private final LastDeploymentInfo lastSuccessfulDeployment;

    private final LastDeploymentInfo lastAttemptedDeployment;

    private final EC2TagSet ec2TagSet;

    private final OnPremisesTagSet onPremisesTagSet;

    private final String computePlatform;

    private final List<ECSService> ecsServices;

    private DeploymentGroupInfo(BuilderImpl builder) {
        this.applicationName = builder.applicationName;
        this.deploymentGroupId = builder.deploymentGroupId;
        this.deploymentGroupName = builder.deploymentGroupName;
        this.deploymentConfigName = builder.deploymentConfigName;
        this.ec2TagFilters = builder.ec2TagFilters;
        this.onPremisesInstanceTagFilters = builder.onPremisesInstanceTagFilters;
        this.autoScalingGroups = builder.autoScalingGroups;
        this.serviceRoleArn = builder.serviceRoleArn;
        this.targetRevision = builder.targetRevision;
        this.triggerConfigurations = builder.triggerConfigurations;
        this.alarmConfiguration = builder.alarmConfiguration;
        this.autoRollbackConfiguration = builder.autoRollbackConfiguration;
        this.deploymentStyle = builder.deploymentStyle;
        this.outdatedInstancesStrategy = builder.outdatedInstancesStrategy;
        this.blueGreenDeploymentConfiguration = builder.blueGreenDeploymentConfiguration;
        this.loadBalancerInfo = builder.loadBalancerInfo;
        this.lastSuccessfulDeployment = builder.lastSuccessfulDeployment;
        this.lastAttemptedDeployment = builder.lastAttemptedDeployment;
        this.ec2TagSet = builder.ec2TagSet;
        this.onPremisesTagSet = builder.onPremisesTagSet;
        this.computePlatform = builder.computePlatform;
        this.ecsServices = builder.ecsServices;
    }

    /**
     * <p>
     * The application name.
     * </p>
     * 
     * @return The application name.
     */
    public final String applicationName() {
        return applicationName;
    }

    /**
     * <p>
     * The deployment group ID.
     * </p>
     * 
     * @return The deployment group ID.
     */
    public final String deploymentGroupId() {
        return deploymentGroupId;
    }

    /**
     * <p>
     * The deployment group name.
     * </p>
     * 
     * @return The deployment group name.
     */
    public final String deploymentGroupName() {
        return deploymentGroupName;
    }

    /**
     * <p>
     * The deployment configuration name.
     * </p>
     * 
     * @return The deployment configuration name.
     */
    public final String deploymentConfigName() {
        return deploymentConfigName;
    }

    /**
     * For responses, this returns true if the service returned a value for the Ec2TagFilters property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasEc2TagFilters() {
        return ec2TagFilters != null && !(ec2TagFilters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The Amazon EC2 tags on which to filter. The deployment group includes EC2 instances with any of the specified
     * tags.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEc2TagFilters} method.
     * </p>
     * 
     * @return The Amazon EC2 tags on which to filter. The deployment group includes EC2 instances with any of the
     *         specified tags.
     */
    public final List<EC2TagFilter> ec2TagFilters() {
        return ec2TagFilters;
    }

    /**
     * For responses, this returns true if the service returned a value for the OnPremisesInstanceTagFilters property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasOnPremisesInstanceTagFilters() {
        return onPremisesInstanceTagFilters != null && !(onPremisesInstanceTagFilters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The on-premises instance tags on which to filter. The deployment group includes on-premises instances with any of
     * the specified tags.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOnPremisesInstanceTagFilters} method.
     * </p>
     * 
     * @return The on-premises instance tags on which to filter. The deployment group includes on-premises instances
     *         with any of the specified tags.
     */
    public final List<TagFilter> onPremisesInstanceTagFilters() {
        return onPremisesInstanceTagFilters;
    }

    /**
     * For responses, this returns true if the service returned a value for the AutoScalingGroups property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAutoScalingGroups() {
        return autoScalingGroups != null && !(autoScalingGroups instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of associated Auto Scaling groups.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAutoScalingGroups} method.
     * </p>
     * 
     * @return A list of associated Auto Scaling groups.
     */
    public final List<AutoScalingGroup> autoScalingGroups() {
        return autoScalingGroups;
    }

    /**
     * <p>
     * A service role Amazon Resource Name (ARN) that grants CodeDeploy permission to make calls to AWS services on your
     * behalf. For more information, see <a
     * href="https://docs.aws.amazon.com/codedeploy/latest/userguide/getting-started-create-service-role.html">Create a
     * Service Role for AWS CodeDeploy</a> in the <i>AWS CodeDeploy User Guide</i>.
     * </p>
     * 
     * @return A service role Amazon Resource Name (ARN) that grants CodeDeploy permission to make calls to AWS services
     *         on your behalf. For more information, see <a
     *         href="https://docs.aws.amazon.com/codedeploy/latest/userguide/getting-started-create-service-role.html"
     *         >Create a Service Role for AWS CodeDeploy</a> in the <i>AWS CodeDeploy User Guide</i>.
     */
    public final String serviceRoleArn() {
        return serviceRoleArn;
    }

    /**
     * <p>
     * Information about the deployment group's target revision, including type and location.
     * </p>
     * 
     * @return Information about the deployment group's target revision, including type and location.
     */
    public final RevisionLocation targetRevision() {
        return targetRevision;
    }

    /**
     * For responses, this returns true if the service returned a value for the TriggerConfigurations property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasTriggerConfigurations() {
        return triggerConfigurations != null && !(triggerConfigurations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about triggers associated with the deployment group.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTriggerConfigurations} method.
     * </p>
     * 
     * @return Information about triggers associated with the deployment group.
     */
    public final List<TriggerConfig> triggerConfigurations() {
        return triggerConfigurations;
    }

    /**
     * <p>
     * A list of alarms associated with the deployment group.
     * </p>
     * 
     * @return A list of alarms associated with the deployment group.
     */
    public final AlarmConfiguration alarmConfiguration() {
        return alarmConfiguration;
    }

    /**
     * <p>
     * Information about the automatic rollback configuration associated with the deployment group.
     * </p>
     * 
     * @return Information about the automatic rollback configuration associated with the deployment group.
     */
    public final AutoRollbackConfiguration autoRollbackConfiguration() {
        return autoRollbackConfiguration;
    }

    /**
     * <p>
     * Information about the type of deployment, either in-place or blue/green, you want to run and whether to route
     * deployment traffic behind a load balancer.
     * </p>
     * 
     * @return Information about the type of deployment, either in-place or blue/green, you want to run and whether to
     *         route deployment traffic behind a load balancer.
     */
    public final DeploymentStyle deploymentStyle() {
        return deploymentStyle;
    }

    /**
     * <p>
     * Indicates what happens when new EC2 instances are launched mid-deployment and do not receive the deployed
     * application revision.
     * </p>
     * <p>
     * If this option is set to <code>UPDATE</code> or is unspecified, CodeDeploy initiates one or more 'auto-update
     * outdated instances' deployments to apply the deployed application revision to the new EC2 instances.
     * </p>
     * <p>
     * If this option is set to <code>IGNORE</code>, CodeDeploy does not initiate a deployment to update the new EC2
     * instances. This may result in instances having different revisions.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #outdatedInstancesStrategy} will return {@link OutdatedInstancesStrategy#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #outdatedInstancesStrategyAsString}.
     * </p>
     * 
     * @return Indicates what happens when new EC2 instances are launched mid-deployment and do not receive the deployed
     *         application revision.</p>
     *         <p>
     *         If this option is set to <code>UPDATE</code> or is unspecified, CodeDeploy initiates one or more
     *         'auto-update outdated instances' deployments to apply the deployed application revision to the new EC2
     *         instances.
     *         </p>
     *         <p>
     *         If this option is set to <code>IGNORE</code>, CodeDeploy does not initiate a deployment to update the new
     *         EC2 instances. This may result in instances having different revisions.
     * @see OutdatedInstancesStrategy
     */
    public final OutdatedInstancesStrategy outdatedInstancesStrategy() {
        return OutdatedInstancesStrategy.fromValue(outdatedInstancesStrategy);
    }

    /**
     * <p>
     * Indicates what happens when new EC2 instances are launched mid-deployment and do not receive the deployed
     * application revision.
     * </p>
     * <p>
     * If this option is set to <code>UPDATE</code> or is unspecified, CodeDeploy initiates one or more 'auto-update
     * outdated instances' deployments to apply the deployed application revision to the new EC2 instances.
     * </p>
     * <p>
     * If this option is set to <code>IGNORE</code>, CodeDeploy does not initiate a deployment to update the new EC2
     * instances. This may result in instances having different revisions.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #outdatedInstancesStrategy} will return {@link OutdatedInstancesStrategy#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #outdatedInstancesStrategyAsString}.
     * </p>
     * 
     * @return Indicates what happens when new EC2 instances are launched mid-deployment and do not receive the deployed
     *         application revision.</p>
     *         <p>
     *         If this option is set to <code>UPDATE</code> or is unspecified, CodeDeploy initiates one or more
     *         'auto-update outdated instances' deployments to apply the deployed application revision to the new EC2
     *         instances.
     *         </p>
     *         <p>
     *         If this option is set to <code>IGNORE</code>, CodeDeploy does not initiate a deployment to update the new
     *         EC2 instances. This may result in instances having different revisions.
     * @see OutdatedInstancesStrategy
     */
    public final String outdatedInstancesStrategyAsString() {
        return outdatedInstancesStrategy;
    }

    /**
     * <p>
     * Information about blue/green deployment options for a deployment group.
     * </p>
     * 
     * @return Information about blue/green deployment options for a deployment group.
     */
    public final BlueGreenDeploymentConfiguration blueGreenDeploymentConfiguration() {
        return blueGreenDeploymentConfiguration;
    }

    /**
     * <p>
     * Information about the load balancer to use in a deployment.
     * </p>
     * 
     * @return Information about the load balancer to use in a deployment.
     */
    public final LoadBalancerInfo loadBalancerInfo() {
        return loadBalancerInfo;
    }

    /**
     * <p>
     * Information about the most recent successful deployment to the deployment group.
     * </p>
     * 
     * @return Information about the most recent successful deployment to the deployment group.
     */
    public final LastDeploymentInfo lastSuccessfulDeployment() {
        return lastSuccessfulDeployment;
    }

    /**
     * <p>
     * Information about the most recent attempted deployment to the deployment group.
     * </p>
     * 
     * @return Information about the most recent attempted deployment to the deployment group.
     */
    public final LastDeploymentInfo lastAttemptedDeployment() {
        return lastAttemptedDeployment;
    }

    /**
     * <p>
     * Information about groups of tags applied to an EC2 instance. The deployment group includes only EC2 instances
     * identified by all of the tag groups. Cannot be used in the same call as ec2TagFilters.
     * </p>
     * 
     * @return Information about groups of tags applied to an EC2 instance. The deployment group includes only EC2
     *         instances identified by all of the tag groups. Cannot be used in the same call as ec2TagFilters.
     */
    public final EC2TagSet ec2TagSet() {
        return ec2TagSet;
    }

    /**
     * <p>
     * Information about groups of tags applied to an on-premises instance. The deployment group includes only
     * on-premises instances identified by all the tag groups. Cannot be used in the same call as
     * onPremisesInstanceTagFilters.
     * </p>
     * 
     * @return Information about groups of tags applied to an on-premises instance. The deployment group includes only
     *         on-premises instances identified by all the tag groups. Cannot be used in the same call as
     *         onPremisesInstanceTagFilters.
     */
    public final OnPremisesTagSet onPremisesTagSet() {
        return onPremisesTagSet;
    }

    /**
     * <p>
     * The destination platform type for the deployment (<code>Lambda</code>, <code>Server</code>, or <code>ECS</code>).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #computePlatform}
     * will return {@link ComputePlatform#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #computePlatformAsString}.
     * </p>
     * 
     * @return The destination platform type for the deployment (<code>Lambda</code>, <code>Server</code>, or
     *         <code>ECS</code>).
     * @see ComputePlatform
     */
    public final ComputePlatform computePlatform() {
        return ComputePlatform.fromValue(computePlatform);
    }

    /**
     * <p>
     * The destination platform type for the deployment (<code>Lambda</code>, <code>Server</code>, or <code>ECS</code>).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #computePlatform}
     * will return {@link ComputePlatform#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #computePlatformAsString}.
     * </p>
     * 
     * @return The destination platform type for the deployment (<code>Lambda</code>, <code>Server</code>, or
     *         <code>ECS</code>).
     * @see ComputePlatform
     */
    public final String computePlatformAsString() {
        return computePlatform;
    }

    /**
     * For responses, this returns true if the service returned a value for the EcsServices property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasEcsServices() {
        return ecsServices != null && !(ecsServices instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The target Amazon ECS services in the deployment group. This applies only to deployment groups that use the
     * Amazon ECS compute platform. A target Amazon ECS service is specified as an Amazon ECS cluster and service name
     * pair using the format <code>&lt;clustername&gt;:&lt;servicename&gt;</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEcsServices} method.
     * </p>
     * 
     * @return The target Amazon ECS services in the deployment group. This applies only to deployment groups that use
     *         the Amazon ECS compute platform. A target Amazon ECS service is specified as an Amazon ECS cluster and
     *         service name pair using the format <code>&lt;clustername&gt;:&lt;servicename&gt;</code>.
     */
    public final List<ECSService> ecsServices() {
        return ecsServices;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(applicationName());
        hashCode = 31 * hashCode + Objects.hashCode(deploymentGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(deploymentGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(deploymentConfigName());
        hashCode = 31 * hashCode + Objects.hashCode(hasEc2TagFilters() ? ec2TagFilters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasOnPremisesInstanceTagFilters() ? onPremisesInstanceTagFilters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasAutoScalingGroups() ? autoScalingGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(serviceRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(targetRevision());
        hashCode = 31 * hashCode + Objects.hashCode(hasTriggerConfigurations() ? triggerConfigurations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(alarmConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(autoRollbackConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(deploymentStyle());
        hashCode = 31 * hashCode + Objects.hashCode(outdatedInstancesStrategyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(blueGreenDeploymentConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(loadBalancerInfo());
        hashCode = 31 * hashCode + Objects.hashCode(lastSuccessfulDeployment());
        hashCode = 31 * hashCode + Objects.hashCode(lastAttemptedDeployment());
        hashCode = 31 * hashCode + Objects.hashCode(ec2TagSet());
        hashCode = 31 * hashCode + Objects.hashCode(onPremisesTagSet());
        hashCode = 31 * hashCode + Objects.hashCode(computePlatformAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasEcsServices() ? ecsServices() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeploymentGroupInfo)) {
            return false;
        }
        DeploymentGroupInfo other = (DeploymentGroupInfo) obj;
        return Objects.equals(applicationName(), other.applicationName())
                && Objects.equals(deploymentGroupId(), other.deploymentGroupId())
                && Objects.equals(deploymentGroupName(), other.deploymentGroupName())
                && Objects.equals(deploymentConfigName(), other.deploymentConfigName())
                && hasEc2TagFilters() == other.hasEc2TagFilters() && Objects.equals(ec2TagFilters(), other.ec2TagFilters())
                && hasOnPremisesInstanceTagFilters() == other.hasOnPremisesInstanceTagFilters()
                && Objects.equals(onPremisesInstanceTagFilters(), other.onPremisesInstanceTagFilters())
                && hasAutoScalingGroups() == other.hasAutoScalingGroups()
                && Objects.equals(autoScalingGroups(), other.autoScalingGroups())
                && Objects.equals(serviceRoleArn(), other.serviceRoleArn())
                && Objects.equals(targetRevision(), other.targetRevision())
                && hasTriggerConfigurations() == other.hasTriggerConfigurations()
                && Objects.equals(triggerConfigurations(), other.triggerConfigurations())
                && Objects.equals(alarmConfiguration(), other.alarmConfiguration())
                && Objects.equals(autoRollbackConfiguration(), other.autoRollbackConfiguration())
                && Objects.equals(deploymentStyle(), other.deploymentStyle())
                && Objects.equals(outdatedInstancesStrategyAsString(), other.outdatedInstancesStrategyAsString())
                && Objects.equals(blueGreenDeploymentConfiguration(), other.blueGreenDeploymentConfiguration())
                && Objects.equals(loadBalancerInfo(), other.loadBalancerInfo())
                && Objects.equals(lastSuccessfulDeployment(), other.lastSuccessfulDeployment())
                && Objects.equals(lastAttemptedDeployment(), other.lastAttemptedDeployment())
                && Objects.equals(ec2TagSet(), other.ec2TagSet()) && Objects.equals(onPremisesTagSet(), other.onPremisesTagSet())
                && Objects.equals(computePlatformAsString(), other.computePlatformAsString())
                && hasEcsServices() == other.hasEcsServices() && Objects.equals(ecsServices(), other.ecsServices());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeploymentGroupInfo").add("ApplicationName", applicationName())
                .add("DeploymentGroupId", deploymentGroupId()).add("DeploymentGroupName", deploymentGroupName())
                .add("DeploymentConfigName", deploymentConfigName())
                .add("Ec2TagFilters", hasEc2TagFilters() ? ec2TagFilters() : null)
                .add("OnPremisesInstanceTagFilters", hasOnPremisesInstanceTagFilters() ? onPremisesInstanceTagFilters() : null)
                .add("AutoScalingGroups", hasAutoScalingGroups() ? autoScalingGroups() : null)
                .add("ServiceRoleArn", serviceRoleArn()).add("TargetRevision", targetRevision())
                .add("TriggerConfigurations", hasTriggerConfigurations() ? triggerConfigurations() : null)
                .add("AlarmConfiguration", alarmConfiguration()).add("AutoRollbackConfiguration", autoRollbackConfiguration())
                .add("DeploymentStyle", deploymentStyle()).add("OutdatedInstancesStrategy", outdatedInstancesStrategyAsString())
                .add("BlueGreenDeploymentConfiguration", blueGreenDeploymentConfiguration())
                .add("LoadBalancerInfo", loadBalancerInfo()).add("LastSuccessfulDeployment", lastSuccessfulDeployment())
                .add("LastAttemptedDeployment", lastAttemptedDeployment()).add("Ec2TagSet", ec2TagSet())
                .add("OnPremisesTagSet", onPremisesTagSet()).add("ComputePlatform", computePlatformAsString())
                .add("EcsServices", hasEcsServices() ? ecsServices() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "applicationName":
            return Optional.ofNullable(clazz.cast(applicationName()));
        case "deploymentGroupId":
            return Optional.ofNullable(clazz.cast(deploymentGroupId()));
        case "deploymentGroupName":
            return Optional.ofNullable(clazz.cast(deploymentGroupName()));
        case "deploymentConfigName":
            return Optional.ofNullable(clazz.cast(deploymentConfigName()));
        case "ec2TagFilters":
            return Optional.ofNullable(clazz.cast(ec2TagFilters()));
        case "onPremisesInstanceTagFilters":
            return Optional.ofNullable(clazz.cast(onPremisesInstanceTagFilters()));
        case "autoScalingGroups":
            return Optional.ofNullable(clazz.cast(autoScalingGroups()));
        case "serviceRoleArn":
            return Optional.ofNullable(clazz.cast(serviceRoleArn()));
        case "targetRevision":
            return Optional.ofNullable(clazz.cast(targetRevision()));
        case "triggerConfigurations":
            return Optional.ofNullable(clazz.cast(triggerConfigurations()));
        case "alarmConfiguration":
            return Optional.ofNullable(clazz.cast(alarmConfiguration()));
        case "autoRollbackConfiguration":
            return Optional.ofNullable(clazz.cast(autoRollbackConfiguration()));
        case "deploymentStyle":
            return Optional.ofNullable(clazz.cast(deploymentStyle()));
        case "outdatedInstancesStrategy":
            return Optional.ofNullable(clazz.cast(outdatedInstancesStrategyAsString()));
        case "blueGreenDeploymentConfiguration":
            return Optional.ofNullable(clazz.cast(blueGreenDeploymentConfiguration()));
        case "loadBalancerInfo":
            return Optional.ofNullable(clazz.cast(loadBalancerInfo()));
        case "lastSuccessfulDeployment":
            return Optional.ofNullable(clazz.cast(lastSuccessfulDeployment()));
        case "lastAttemptedDeployment":
            return Optional.ofNullable(clazz.cast(lastAttemptedDeployment()));
        case "ec2TagSet":
            return Optional.ofNullable(clazz.cast(ec2TagSet()));
        case "onPremisesTagSet":
            return Optional.ofNullable(clazz.cast(onPremisesTagSet()));
        case "computePlatform":
            return Optional.ofNullable(clazz.cast(computePlatformAsString()));
        case "ecsServices":
            return Optional.ofNullable(clazz.cast(ecsServices()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeploymentGroupInfo, T> g) {
        return obj -> g.apply((DeploymentGroupInfo) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DeploymentGroupInfo> {
        /**
         * <p>
         * The application name.
         * </p>
         * 
         * @param applicationName
         *        The application name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationName(String applicationName);

        /**
         * <p>
         * The deployment group ID.
         * </p>
         * 
         * @param deploymentGroupId
         *        The deployment group ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deploymentGroupId(String deploymentGroupId);

        /**
         * <p>
         * The deployment group name.
         * </p>
         * 
         * @param deploymentGroupName
         *        The deployment group name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deploymentGroupName(String deploymentGroupName);

        /**
         * <p>
         * The deployment configuration name.
         * </p>
         * 
         * @param deploymentConfigName
         *        The deployment configuration name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deploymentConfigName(String deploymentConfigName);

        /**
         * <p>
         * The Amazon EC2 tags on which to filter. The deployment group includes EC2 instances with any of the specified
         * tags.
         * </p>
         * 
         * @param ec2TagFilters
         *        The Amazon EC2 tags on which to filter. The deployment group includes EC2 instances with any of the
         *        specified tags.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ec2TagFilters(Collection<EC2TagFilter> ec2TagFilters);

        /**
         * <p>
         * The Amazon EC2 tags on which to filter. The deployment group includes EC2 instances with any of the specified
         * tags.
         * </p>
         * 
         * @param ec2TagFilters
         *        The Amazon EC2 tags on which to filter. The deployment group includes EC2 instances with any of the
         *        specified tags.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ec2TagFilters(EC2TagFilter... ec2TagFilters);

        /**
         * <p>
         * The Amazon EC2 tags on which to filter. The deployment group includes EC2 instances with any of the specified
         * tags.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<EC2TagFilter>.Builder} avoiding the
         * need to create one manually via {@link List<EC2TagFilter>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<EC2TagFilter>.Builder#build()} is called immediately and its
         * result is passed to {@link #ec2TagFilters(List<EC2TagFilter>)}.
         * 
         * @param ec2TagFilters
         *        a consumer that will call methods on {@link List<EC2TagFilter>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ec2TagFilters(List<EC2TagFilter>)
         */
        Builder ec2TagFilters(Consumer<EC2TagFilter.Builder>... ec2TagFilters);

        /**
         * <p>
         * The on-premises instance tags on which to filter. The deployment group includes on-premises instances with
         * any of the specified tags.
         * </p>
         * 
         * @param onPremisesInstanceTagFilters
         *        The on-premises instance tags on which to filter. The deployment group includes on-premises instances
         *        with any of the specified tags.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder onPremisesInstanceTagFilters(Collection<TagFilter> onPremisesInstanceTagFilters);

        /**
         * <p>
         * The on-premises instance tags on which to filter. The deployment group includes on-premises instances with
         * any of the specified tags.
         * </p>
         * 
         * @param onPremisesInstanceTagFilters
         *        The on-premises instance tags on which to filter. The deployment group includes on-premises instances
         *        with any of the specified tags.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder onPremisesInstanceTagFilters(TagFilter... onPremisesInstanceTagFilters);

        /**
         * <p>
         * The on-premises instance tags on which to filter. The deployment group includes on-premises instances with
         * any of the specified tags.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<TagFilter>.Builder} avoiding the
         * need to create one manually via {@link List<TagFilter>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<TagFilter>.Builder#build()} is called immediately and its
         * result is passed to {@link #onPremisesInstanceTagFilters(List<TagFilter>)}.
         * 
         * @param onPremisesInstanceTagFilters
         *        a consumer that will call methods on {@link List<TagFilter>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #onPremisesInstanceTagFilters(List<TagFilter>)
         */
        Builder onPremisesInstanceTagFilters(Consumer<TagFilter.Builder>... onPremisesInstanceTagFilters);

        /**
         * <p>
         * A list of associated Auto Scaling groups.
         * </p>
         * 
         * @param autoScalingGroups
         *        A list of associated Auto Scaling groups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoScalingGroups(Collection<AutoScalingGroup> autoScalingGroups);

        /**
         * <p>
         * A list of associated Auto Scaling groups.
         * </p>
         * 
         * @param autoScalingGroups
         *        A list of associated Auto Scaling groups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoScalingGroups(AutoScalingGroup... autoScalingGroups);

        /**
         * <p>
         * A list of associated Auto Scaling groups.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<AutoScalingGroup>.Builder} avoiding
         * the need to create one manually via {@link List<AutoScalingGroup>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<AutoScalingGroup>.Builder#build()} is called immediately and
         * its result is passed to {@link #autoScalingGroups(List<AutoScalingGroup>)}.
         * 
         * @param autoScalingGroups
         *        a consumer that will call methods on {@link List<AutoScalingGroup>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #autoScalingGroups(List<AutoScalingGroup>)
         */
        Builder autoScalingGroups(Consumer<AutoScalingGroup.Builder>... autoScalingGroups);

        /**
         * <p>
         * A service role Amazon Resource Name (ARN) that grants CodeDeploy permission to make calls to AWS services on
         * your behalf. For more information, see <a
         * href="https://docs.aws.amazon.com/codedeploy/latest/userguide/getting-started-create-service-role.html"
         * >Create a Service Role for AWS CodeDeploy</a> in the <i>AWS CodeDeploy User Guide</i>.
         * </p>
         * 
         * @param serviceRoleArn
         *        A service role Amazon Resource Name (ARN) that grants CodeDeploy permission to make calls to AWS
         *        services on your behalf. For more information, see <a href=
         *        "https://docs.aws.amazon.com/codedeploy/latest/userguide/getting-started-create-service-role.html"
         *        >Create a Service Role for AWS CodeDeploy</a> in the <i>AWS CodeDeploy User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceRoleArn(String serviceRoleArn);

        /**
         * <p>
         * Information about the deployment group's target revision, including type and location.
         * </p>
         * 
         * @param targetRevision
         *        Information about the deployment group's target revision, including type and location.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetRevision(RevisionLocation targetRevision);

        /**
         * <p>
         * Information about the deployment group's target revision, including type and location.
         * </p>
         * This is a convenience method that creates an instance of the {@link RevisionLocation.Builder} avoiding the
         * need to create one manually via {@link RevisionLocation#builder()}.
         *
         * When the {@link Consumer} completes, {@link RevisionLocation.Builder#build()} is called immediately and its
         * result is passed to {@link #targetRevision(RevisionLocation)}.
         * 
         * @param targetRevision
         *        a consumer that will call methods on {@link RevisionLocation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #targetRevision(RevisionLocation)
         */
        default Builder targetRevision(Consumer<RevisionLocation.Builder> targetRevision) {
            return targetRevision(RevisionLocation.builder().applyMutation(targetRevision).build());
        }

        /**
         * <p>
         * Information about triggers associated with the deployment group.
         * </p>
         * 
         * @param triggerConfigurations
         *        Information about triggers associated with the deployment group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder triggerConfigurations(Collection<TriggerConfig> triggerConfigurations);

        /**
         * <p>
         * Information about triggers associated with the deployment group.
         * </p>
         * 
         * @param triggerConfigurations
         *        Information about triggers associated with the deployment group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder triggerConfigurations(TriggerConfig... triggerConfigurations);

        /**
         * <p>
         * Information about triggers associated with the deployment group.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<TriggerConfig>.Builder} avoiding the
         * need to create one manually via {@link List<TriggerConfig>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<TriggerConfig>.Builder#build()} is called immediately and
         * its result is passed to {@link #triggerConfigurations(List<TriggerConfig>)}.
         * 
         * @param triggerConfigurations
         *        a consumer that will call methods on {@link List<TriggerConfig>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #triggerConfigurations(List<TriggerConfig>)
         */
        Builder triggerConfigurations(Consumer<TriggerConfig.Builder>... triggerConfigurations);

        /**
         * <p>
         * A list of alarms associated with the deployment group.
         * </p>
         * 
         * @param alarmConfiguration
         *        A list of alarms associated with the deployment group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder alarmConfiguration(AlarmConfiguration alarmConfiguration);

        /**
         * <p>
         * A list of alarms associated with the deployment group.
         * </p>
         * This is a convenience method that creates an instance of the {@link AlarmConfiguration.Builder} avoiding the
         * need to create one manually via {@link AlarmConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link AlarmConfiguration.Builder#build()} is called immediately and its
         * result is passed to {@link #alarmConfiguration(AlarmConfiguration)}.
         * 
         * @param alarmConfiguration
         *        a consumer that will call methods on {@link AlarmConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #alarmConfiguration(AlarmConfiguration)
         */
        default Builder alarmConfiguration(Consumer<AlarmConfiguration.Builder> alarmConfiguration) {
            return alarmConfiguration(AlarmConfiguration.builder().applyMutation(alarmConfiguration).build());
        }

        /**
         * <p>
         * Information about the automatic rollback configuration associated with the deployment group.
         * </p>
         * 
         * @param autoRollbackConfiguration
         *        Information about the automatic rollback configuration associated with the deployment group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoRollbackConfiguration(AutoRollbackConfiguration autoRollbackConfiguration);

        /**
         * <p>
         * Information about the automatic rollback configuration associated with the deployment group.
         * </p>
         * This is a convenience method that creates an instance of the {@link AutoRollbackConfiguration.Builder}
         * avoiding the need to create one manually via {@link AutoRollbackConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link AutoRollbackConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #autoRollbackConfiguration(AutoRollbackConfiguration)}.
         * 
         * @param autoRollbackConfiguration
         *        a consumer that will call methods on {@link AutoRollbackConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #autoRollbackConfiguration(AutoRollbackConfiguration)
         */
        default Builder autoRollbackConfiguration(Consumer<AutoRollbackConfiguration.Builder> autoRollbackConfiguration) {
            return autoRollbackConfiguration(AutoRollbackConfiguration.builder().applyMutation(autoRollbackConfiguration).build());
        }

        /**
         * <p>
         * Information about the type of deployment, either in-place or blue/green, you want to run and whether to route
         * deployment traffic behind a load balancer.
         * </p>
         * 
         * @param deploymentStyle
         *        Information about the type of deployment, either in-place or blue/green, you want to run and whether
         *        to route deployment traffic behind a load balancer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deploymentStyle(DeploymentStyle deploymentStyle);

        /**
         * <p>
         * Information about the type of deployment, either in-place or blue/green, you want to run and whether to route
         * deployment traffic behind a load balancer.
         * </p>
         * This is a convenience method that creates an instance of the {@link DeploymentStyle.Builder} avoiding the
         * need to create one manually via {@link DeploymentStyle#builder()}.
         *
         * When the {@link Consumer} completes, {@link DeploymentStyle.Builder#build()} is called immediately and its
         * result is passed to {@link #deploymentStyle(DeploymentStyle)}.
         * 
         * @param deploymentStyle
         *        a consumer that will call methods on {@link DeploymentStyle.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #deploymentStyle(DeploymentStyle)
         */
        default Builder deploymentStyle(Consumer<DeploymentStyle.Builder> deploymentStyle) {
            return deploymentStyle(DeploymentStyle.builder().applyMutation(deploymentStyle).build());
        }

        /**
         * <p>
         * Indicates what happens when new EC2 instances are launched mid-deployment and do not receive the deployed
         * application revision.
         * </p>
         * <p>
         * If this option is set to <code>UPDATE</code> or is unspecified, CodeDeploy initiates one or more 'auto-update
         * outdated instances' deployments to apply the deployed application revision to the new EC2 instances.
         * </p>
         * <p>
         * If this option is set to <code>IGNORE</code>, CodeDeploy does not initiate a deployment to update the new EC2
         * instances. This may result in instances having different revisions.
         * </p>
         * 
         * @param outdatedInstancesStrategy
         *        Indicates what happens when new EC2 instances are launched mid-deployment and do not receive the
         *        deployed application revision.</p>
         *        <p>
         *        If this option is set to <code>UPDATE</code> or is unspecified, CodeDeploy initiates one or more
         *        'auto-update outdated instances' deployments to apply the deployed application revision to the new EC2
         *        instances.
         *        </p>
         *        <p>
         *        If this option is set to <code>IGNORE</code>, CodeDeploy does not initiate a deployment to update the
         *        new EC2 instances. This may result in instances having different revisions.
         * @see OutdatedInstancesStrategy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OutdatedInstancesStrategy
         */
        Builder outdatedInstancesStrategy(String outdatedInstancesStrategy);

        /**
         * <p>
         * Indicates what happens when new EC2 instances are launched mid-deployment and do not receive the deployed
         * application revision.
         * </p>
         * <p>
         * If this option is set to <code>UPDATE</code> or is unspecified, CodeDeploy initiates one or more 'auto-update
         * outdated instances' deployments to apply the deployed application revision to the new EC2 instances.
         * </p>
         * <p>
         * If this option is set to <code>IGNORE</code>, CodeDeploy does not initiate a deployment to update the new EC2
         * instances. This may result in instances having different revisions.
         * </p>
         * 
         * @param outdatedInstancesStrategy
         *        Indicates what happens when new EC2 instances are launched mid-deployment and do not receive the
         *        deployed application revision.</p>
         *        <p>
         *        If this option is set to <code>UPDATE</code> or is unspecified, CodeDeploy initiates one or more
         *        'auto-update outdated instances' deployments to apply the deployed application revision to the new EC2
         *        instances.
         *        </p>
         *        <p>
         *        If this option is set to <code>IGNORE</code>, CodeDeploy does not initiate a deployment to update the
         *        new EC2 instances. This may result in instances having different revisions.
         * @see OutdatedInstancesStrategy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OutdatedInstancesStrategy
         */
        Builder outdatedInstancesStrategy(OutdatedInstancesStrategy outdatedInstancesStrategy);

        /**
         * <p>
         * Information about blue/green deployment options for a deployment group.
         * </p>
         * 
         * @param blueGreenDeploymentConfiguration
         *        Information about blue/green deployment options for a deployment group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blueGreenDeploymentConfiguration(BlueGreenDeploymentConfiguration blueGreenDeploymentConfiguration);

        /**
         * <p>
         * Information about blue/green deployment options for a deployment group.
         * </p>
         * This is a convenience method that creates an instance of the {@link BlueGreenDeploymentConfiguration.Builder}
         * avoiding the need to create one manually via {@link BlueGreenDeploymentConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link BlueGreenDeploymentConfiguration.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #blueGreenDeploymentConfiguration(BlueGreenDeploymentConfiguration)}.
         * 
         * @param blueGreenDeploymentConfiguration
         *        a consumer that will call methods on {@link BlueGreenDeploymentConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #blueGreenDeploymentConfiguration(BlueGreenDeploymentConfiguration)
         */
        default Builder blueGreenDeploymentConfiguration(
                Consumer<BlueGreenDeploymentConfiguration.Builder> blueGreenDeploymentConfiguration) {
            return blueGreenDeploymentConfiguration(BlueGreenDeploymentConfiguration.builder()
                    .applyMutation(blueGreenDeploymentConfiguration).build());
        }

        /**
         * <p>
         * Information about the load balancer to use in a deployment.
         * </p>
         * 
         * @param loadBalancerInfo
         *        Information about the load balancer to use in a deployment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder loadBalancerInfo(LoadBalancerInfo loadBalancerInfo);

        /**
         * <p>
         * Information about the load balancer to use in a deployment.
         * </p>
         * This is a convenience method that creates an instance of the {@link LoadBalancerInfo.Builder} avoiding the
         * need to create one manually via {@link LoadBalancerInfo#builder()}.
         *
         * When the {@link Consumer} completes, {@link LoadBalancerInfo.Builder#build()} is called immediately and its
         * result is passed to {@link #loadBalancerInfo(LoadBalancerInfo)}.
         * 
         * @param loadBalancerInfo
         *        a consumer that will call methods on {@link LoadBalancerInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #loadBalancerInfo(LoadBalancerInfo)
         */
        default Builder loadBalancerInfo(Consumer<LoadBalancerInfo.Builder> loadBalancerInfo) {
            return loadBalancerInfo(LoadBalancerInfo.builder().applyMutation(loadBalancerInfo).build());
        }

        /**
         * <p>
         * Information about the most recent successful deployment to the deployment group.
         * </p>
         * 
         * @param lastSuccessfulDeployment
         *        Information about the most recent successful deployment to the deployment group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastSuccessfulDeployment(LastDeploymentInfo lastSuccessfulDeployment);

        /**
         * <p>
         * Information about the most recent successful deployment to the deployment group.
         * </p>
         * This is a convenience method that creates an instance of the {@link LastDeploymentInfo.Builder} avoiding the
         * need to create one manually via {@link LastDeploymentInfo#builder()}.
         *
         * When the {@link Consumer} completes, {@link LastDeploymentInfo.Builder#build()} is called immediately and its
         * result is passed to {@link #lastSuccessfulDeployment(LastDeploymentInfo)}.
         * 
         * @param lastSuccessfulDeployment
         *        a consumer that will call methods on {@link LastDeploymentInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lastSuccessfulDeployment(LastDeploymentInfo)
         */
        default Builder lastSuccessfulDeployment(Consumer<LastDeploymentInfo.Builder> lastSuccessfulDeployment) {
            return lastSuccessfulDeployment(LastDeploymentInfo.builder().applyMutation(lastSuccessfulDeployment).build());
        }

        /**
         * <p>
         * Information about the most recent attempted deployment to the deployment group.
         * </p>
         * 
         * @param lastAttemptedDeployment
         *        Information about the most recent attempted deployment to the deployment group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastAttemptedDeployment(LastDeploymentInfo lastAttemptedDeployment);

        /**
         * <p>
         * Information about the most recent attempted deployment to the deployment group.
         * </p>
         * This is a convenience method that creates an instance of the {@link LastDeploymentInfo.Builder} avoiding the
         * need to create one manually via {@link LastDeploymentInfo#builder()}.
         *
         * When the {@link Consumer} completes, {@link LastDeploymentInfo.Builder#build()} is called immediately and its
         * result is passed to {@link #lastAttemptedDeployment(LastDeploymentInfo)}.
         * 
         * @param lastAttemptedDeployment
         *        a consumer that will call methods on {@link LastDeploymentInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lastAttemptedDeployment(LastDeploymentInfo)
         */
        default Builder lastAttemptedDeployment(Consumer<LastDeploymentInfo.Builder> lastAttemptedDeployment) {
            return lastAttemptedDeployment(LastDeploymentInfo.builder().applyMutation(lastAttemptedDeployment).build());
        }

        /**
         * <p>
         * Information about groups of tags applied to an EC2 instance. The deployment group includes only EC2 instances
         * identified by all of the tag groups. Cannot be used in the same call as ec2TagFilters.
         * </p>
         * 
         * @param ec2TagSet
         *        Information about groups of tags applied to an EC2 instance. The deployment group includes only EC2
         *        instances identified by all of the tag groups. Cannot be used in the same call as ec2TagFilters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ec2TagSet(EC2TagSet ec2TagSet);

        /**
         * <p>
         * Information about groups of tags applied to an EC2 instance. The deployment group includes only EC2 instances
         * identified by all of the tag groups. Cannot be used in the same call as ec2TagFilters.
         * </p>
         * This is a convenience method that creates an instance of the {@link EC2TagSet.Builder} avoiding the need to
         * create one manually via {@link EC2TagSet#builder()}.
         *
         * When the {@link Consumer} completes, {@link EC2TagSet.Builder#build()} is called immediately and its result
         * is passed to {@link #ec2TagSet(EC2TagSet)}.
         * 
         * @param ec2TagSet
         *        a consumer that will call methods on {@link EC2TagSet.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ec2TagSet(EC2TagSet)
         */
        default Builder ec2TagSet(Consumer<EC2TagSet.Builder> ec2TagSet) {
            return ec2TagSet(EC2TagSet.builder().applyMutation(ec2TagSet).build());
        }

        /**
         * <p>
         * Information about groups of tags applied to an on-premises instance. The deployment group includes only
         * on-premises instances identified by all the tag groups. Cannot be used in the same call as
         * onPremisesInstanceTagFilters.
         * </p>
         * 
         * @param onPremisesTagSet
         *        Information about groups of tags applied to an on-premises instance. The deployment group includes
         *        only on-premises instances identified by all the tag groups. Cannot be used in the same call as
         *        onPremisesInstanceTagFilters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder onPremisesTagSet(OnPremisesTagSet onPremisesTagSet);

        /**
         * <p>
         * Information about groups of tags applied to an on-premises instance. The deployment group includes only
         * on-premises instances identified by all the tag groups. Cannot be used in the same call as
         * onPremisesInstanceTagFilters.
         * </p>
         * This is a convenience method that creates an instance of the {@link OnPremisesTagSet.Builder} avoiding the
         * need to create one manually via {@link OnPremisesTagSet#builder()}.
         *
         * When the {@link Consumer} completes, {@link OnPremisesTagSet.Builder#build()} is called immediately and its
         * result is passed to {@link #onPremisesTagSet(OnPremisesTagSet)}.
         * 
         * @param onPremisesTagSet
         *        a consumer that will call methods on {@link OnPremisesTagSet.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #onPremisesTagSet(OnPremisesTagSet)
         */
        default Builder onPremisesTagSet(Consumer<OnPremisesTagSet.Builder> onPremisesTagSet) {
            return onPremisesTagSet(OnPremisesTagSet.builder().applyMutation(onPremisesTagSet).build());
        }

        /**
         * <p>
         * The destination platform type for the deployment (<code>Lambda</code>, <code>Server</code>, or
         * <code>ECS</code>).
         * </p>
         * 
         * @param computePlatform
         *        The destination platform type for the deployment (<code>Lambda</code>, <code>Server</code>, or
         *        <code>ECS</code>).
         * @see ComputePlatform
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ComputePlatform
         */
        Builder computePlatform(String computePlatform);

        /**
         * <p>
         * The destination platform type for the deployment (<code>Lambda</code>, <code>Server</code>, or
         * <code>ECS</code>).
         * </p>
         * 
         * @param computePlatform
         *        The destination platform type for the deployment (<code>Lambda</code>, <code>Server</code>, or
         *        <code>ECS</code>).
         * @see ComputePlatform
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ComputePlatform
         */
        Builder computePlatform(ComputePlatform computePlatform);

        /**
         * <p>
         * The target Amazon ECS services in the deployment group. This applies only to deployment groups that use the
         * Amazon ECS compute platform. A target Amazon ECS service is specified as an Amazon ECS cluster and service
         * name pair using the format <code>&lt;clustername&gt;:&lt;servicename&gt;</code>.
         * </p>
         * 
         * @param ecsServices
         *        The target Amazon ECS services in the deployment group. This applies only to deployment groups that
         *        use the Amazon ECS compute platform. A target Amazon ECS service is specified as an Amazon ECS cluster
         *        and service name pair using the format <code>&lt;clustername&gt;:&lt;servicename&gt;</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ecsServices(Collection<ECSService> ecsServices);

        /**
         * <p>
         * The target Amazon ECS services in the deployment group. This applies only to deployment groups that use the
         * Amazon ECS compute platform. A target Amazon ECS service is specified as an Amazon ECS cluster and service
         * name pair using the format <code>&lt;clustername&gt;:&lt;servicename&gt;</code>.
         * </p>
         * 
         * @param ecsServices
         *        The target Amazon ECS services in the deployment group. This applies only to deployment groups that
         *        use the Amazon ECS compute platform. A target Amazon ECS service is specified as an Amazon ECS cluster
         *        and service name pair using the format <code>&lt;clustername&gt;:&lt;servicename&gt;</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ecsServices(ECSService... ecsServices);

        /**
         * <p>
         * The target Amazon ECS services in the deployment group. This applies only to deployment groups that use the
         * Amazon ECS compute platform. A target Amazon ECS service is specified as an Amazon ECS cluster and service
         * name pair using the format <code>&lt;clustername&gt;:&lt;servicename&gt;</code>.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<ECSService>.Builder} avoiding the
         * need to create one manually via {@link List<ECSService>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ECSService>.Builder#build()} is called immediately and its
         * result is passed to {@link #ecsServices(List<ECSService>)}.
         * 
         * @param ecsServices
         *        a consumer that will call methods on {@link List<ECSService>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ecsServices(List<ECSService>)
         */
        Builder ecsServices(Consumer<ECSService.Builder>... ecsServices);
    }

    static final class BuilderImpl implements Builder {
        private String applicationName;

        private String deploymentGroupId;

        private String deploymentGroupName;

        private String deploymentConfigName;

        private List<EC2TagFilter> ec2TagFilters = DefaultSdkAutoConstructList.getInstance();

        private List<TagFilter> onPremisesInstanceTagFilters = DefaultSdkAutoConstructList.getInstance();

        private List<AutoScalingGroup> autoScalingGroups = DefaultSdkAutoConstructList.getInstance();

        private String serviceRoleArn;

        private RevisionLocation targetRevision;

        private List<TriggerConfig> triggerConfigurations = DefaultSdkAutoConstructList.getInstance();

        private AlarmConfiguration alarmConfiguration;

        private AutoRollbackConfiguration autoRollbackConfiguration;

        private DeploymentStyle deploymentStyle;

        private String outdatedInstancesStrategy;

        private BlueGreenDeploymentConfiguration blueGreenDeploymentConfiguration;

        private LoadBalancerInfo loadBalancerInfo;

        private LastDeploymentInfo lastSuccessfulDeployment;

        private LastDeploymentInfo lastAttemptedDeployment;

        private EC2TagSet ec2TagSet;

        private OnPremisesTagSet onPremisesTagSet;

        private String computePlatform;

        private List<ECSService> ecsServices = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DeploymentGroupInfo model) {
            applicationName(model.applicationName);
            deploymentGroupId(model.deploymentGroupId);
            deploymentGroupName(model.deploymentGroupName);
            deploymentConfigName(model.deploymentConfigName);
            ec2TagFilters(model.ec2TagFilters);
            onPremisesInstanceTagFilters(model.onPremisesInstanceTagFilters);
            autoScalingGroups(model.autoScalingGroups);
            serviceRoleArn(model.serviceRoleArn);
            targetRevision(model.targetRevision);
            triggerConfigurations(model.triggerConfigurations);
            alarmConfiguration(model.alarmConfiguration);
            autoRollbackConfiguration(model.autoRollbackConfiguration);
            deploymentStyle(model.deploymentStyle);
            outdatedInstancesStrategy(model.outdatedInstancesStrategy);
            blueGreenDeploymentConfiguration(model.blueGreenDeploymentConfiguration);
            loadBalancerInfo(model.loadBalancerInfo);
            lastSuccessfulDeployment(model.lastSuccessfulDeployment);
            lastAttemptedDeployment(model.lastAttemptedDeployment);
            ec2TagSet(model.ec2TagSet);
            onPremisesTagSet(model.onPremisesTagSet);
            computePlatform(model.computePlatform);
            ecsServices(model.ecsServices);
        }

        public final String getApplicationName() {
            return applicationName;
        }

        public final void setApplicationName(String applicationName) {
            this.applicationName = applicationName;
        }

        @Override
        @Transient
        public final Builder applicationName(String applicationName) {
            this.applicationName = applicationName;
            return this;
        }

        public final String getDeploymentGroupId() {
            return deploymentGroupId;
        }

        public final void setDeploymentGroupId(String deploymentGroupId) {
            this.deploymentGroupId = deploymentGroupId;
        }

        @Override
        @Transient
        public final Builder deploymentGroupId(String deploymentGroupId) {
            this.deploymentGroupId = deploymentGroupId;
            return this;
        }

        public final String getDeploymentGroupName() {
            return deploymentGroupName;
        }

        public final void setDeploymentGroupName(String deploymentGroupName) {
            this.deploymentGroupName = deploymentGroupName;
        }

        @Override
        @Transient
        public final Builder deploymentGroupName(String deploymentGroupName) {
            this.deploymentGroupName = deploymentGroupName;
            return this;
        }

        public final String getDeploymentConfigName() {
            return deploymentConfigName;
        }

        public final void setDeploymentConfigName(String deploymentConfigName) {
            this.deploymentConfigName = deploymentConfigName;
        }

        @Override
        @Transient
        public final Builder deploymentConfigName(String deploymentConfigName) {
            this.deploymentConfigName = deploymentConfigName;
            return this;
        }

        public final List<EC2TagFilter.Builder> getEc2TagFilters() {
            List<EC2TagFilter.Builder> result = EC2TagFilterListCopier.copyToBuilder(this.ec2TagFilters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEc2TagFilters(Collection<EC2TagFilter.BuilderImpl> ec2TagFilters) {
            this.ec2TagFilters = EC2TagFilterListCopier.copyFromBuilder(ec2TagFilters);
        }

        @Override
        @Transient
        public final Builder ec2TagFilters(Collection<EC2TagFilter> ec2TagFilters) {
            this.ec2TagFilters = EC2TagFilterListCopier.copy(ec2TagFilters);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder ec2TagFilters(EC2TagFilter... ec2TagFilters) {
            ec2TagFilters(Arrays.asList(ec2TagFilters));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder ec2TagFilters(Consumer<EC2TagFilter.Builder>... ec2TagFilters) {
            ec2TagFilters(Stream.of(ec2TagFilters).map(c -> EC2TagFilter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<TagFilter.Builder> getOnPremisesInstanceTagFilters() {
            List<TagFilter.Builder> result = TagFilterListCopier.copyToBuilder(this.onPremisesInstanceTagFilters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOnPremisesInstanceTagFilters(Collection<TagFilter.BuilderImpl> onPremisesInstanceTagFilters) {
            this.onPremisesInstanceTagFilters = TagFilterListCopier.copyFromBuilder(onPremisesInstanceTagFilters);
        }

        @Override
        @Transient
        public final Builder onPremisesInstanceTagFilters(Collection<TagFilter> onPremisesInstanceTagFilters) {
            this.onPremisesInstanceTagFilters = TagFilterListCopier.copy(onPremisesInstanceTagFilters);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder onPremisesInstanceTagFilters(TagFilter... onPremisesInstanceTagFilters) {
            onPremisesInstanceTagFilters(Arrays.asList(onPremisesInstanceTagFilters));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder onPremisesInstanceTagFilters(Consumer<TagFilter.Builder>... onPremisesInstanceTagFilters) {
            onPremisesInstanceTagFilters(Stream.of(onPremisesInstanceTagFilters)
                    .map(c -> TagFilter.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<AutoScalingGroup.Builder> getAutoScalingGroups() {
            List<AutoScalingGroup.Builder> result = AutoScalingGroupListCopier.copyToBuilder(this.autoScalingGroups);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAutoScalingGroups(Collection<AutoScalingGroup.BuilderImpl> autoScalingGroups) {
            this.autoScalingGroups = AutoScalingGroupListCopier.copyFromBuilder(autoScalingGroups);
        }

        @Override
        @Transient
        public final Builder autoScalingGroups(Collection<AutoScalingGroup> autoScalingGroups) {
            this.autoScalingGroups = AutoScalingGroupListCopier.copy(autoScalingGroups);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder autoScalingGroups(AutoScalingGroup... autoScalingGroups) {
            autoScalingGroups(Arrays.asList(autoScalingGroups));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder autoScalingGroups(Consumer<AutoScalingGroup.Builder>... autoScalingGroups) {
            autoScalingGroups(Stream.of(autoScalingGroups).map(c -> AutoScalingGroup.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getServiceRoleArn() {
            return serviceRoleArn;
        }

        public final void setServiceRoleArn(String serviceRoleArn) {
            this.serviceRoleArn = serviceRoleArn;
        }

        @Override
        @Transient
        public final Builder serviceRoleArn(String serviceRoleArn) {
            this.serviceRoleArn = serviceRoleArn;
            return this;
        }

        public final RevisionLocation.Builder getTargetRevision() {
            return targetRevision != null ? targetRevision.toBuilder() : null;
        }

        public final void setTargetRevision(RevisionLocation.BuilderImpl targetRevision) {
            this.targetRevision = targetRevision != null ? targetRevision.build() : null;
        }

        @Override
        @Transient
        public final Builder targetRevision(RevisionLocation targetRevision) {
            this.targetRevision = targetRevision;
            return this;
        }

        public final List<TriggerConfig.Builder> getTriggerConfigurations() {
            List<TriggerConfig.Builder> result = TriggerConfigListCopier.copyToBuilder(this.triggerConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTriggerConfigurations(Collection<TriggerConfig.BuilderImpl> triggerConfigurations) {
            this.triggerConfigurations = TriggerConfigListCopier.copyFromBuilder(triggerConfigurations);
        }

        @Override
        @Transient
        public final Builder triggerConfigurations(Collection<TriggerConfig> triggerConfigurations) {
            this.triggerConfigurations = TriggerConfigListCopier.copy(triggerConfigurations);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder triggerConfigurations(TriggerConfig... triggerConfigurations) {
            triggerConfigurations(Arrays.asList(triggerConfigurations));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder triggerConfigurations(Consumer<TriggerConfig.Builder>... triggerConfigurations) {
            triggerConfigurations(Stream.of(triggerConfigurations).map(c -> TriggerConfig.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final AlarmConfiguration.Builder getAlarmConfiguration() {
            return alarmConfiguration != null ? alarmConfiguration.toBuilder() : null;
        }

        public final void setAlarmConfiguration(AlarmConfiguration.BuilderImpl alarmConfiguration) {
            this.alarmConfiguration = alarmConfiguration != null ? alarmConfiguration.build() : null;
        }

        @Override
        @Transient
        public final Builder alarmConfiguration(AlarmConfiguration alarmConfiguration) {
            this.alarmConfiguration = alarmConfiguration;
            return this;
        }

        public final AutoRollbackConfiguration.Builder getAutoRollbackConfiguration() {
            return autoRollbackConfiguration != null ? autoRollbackConfiguration.toBuilder() : null;
        }

        public final void setAutoRollbackConfiguration(AutoRollbackConfiguration.BuilderImpl autoRollbackConfiguration) {
            this.autoRollbackConfiguration = autoRollbackConfiguration != null ? autoRollbackConfiguration.build() : null;
        }

        @Override
        @Transient
        public final Builder autoRollbackConfiguration(AutoRollbackConfiguration autoRollbackConfiguration) {
            this.autoRollbackConfiguration = autoRollbackConfiguration;
            return this;
        }

        public final DeploymentStyle.Builder getDeploymentStyle() {
            return deploymentStyle != null ? deploymentStyle.toBuilder() : null;
        }

        public final void setDeploymentStyle(DeploymentStyle.BuilderImpl deploymentStyle) {
            this.deploymentStyle = deploymentStyle != null ? deploymentStyle.build() : null;
        }

        @Override
        @Transient
        public final Builder deploymentStyle(DeploymentStyle deploymentStyle) {
            this.deploymentStyle = deploymentStyle;
            return this;
        }

        public final String getOutdatedInstancesStrategy() {
            return outdatedInstancesStrategy;
        }

        public final void setOutdatedInstancesStrategy(String outdatedInstancesStrategy) {
            this.outdatedInstancesStrategy = outdatedInstancesStrategy;
        }

        @Override
        @Transient
        public final Builder outdatedInstancesStrategy(String outdatedInstancesStrategy) {
            this.outdatedInstancesStrategy = outdatedInstancesStrategy;
            return this;
        }

        @Override
        @Transient
        public final Builder outdatedInstancesStrategy(OutdatedInstancesStrategy outdatedInstancesStrategy) {
            this.outdatedInstancesStrategy(outdatedInstancesStrategy == null ? null : outdatedInstancesStrategy.toString());
            return this;
        }

        public final BlueGreenDeploymentConfiguration.Builder getBlueGreenDeploymentConfiguration() {
            return blueGreenDeploymentConfiguration != null ? blueGreenDeploymentConfiguration.toBuilder() : null;
        }

        public final void setBlueGreenDeploymentConfiguration(
                BlueGreenDeploymentConfiguration.BuilderImpl blueGreenDeploymentConfiguration) {
            this.blueGreenDeploymentConfiguration = blueGreenDeploymentConfiguration != null ? blueGreenDeploymentConfiguration
                    .build() : null;
        }

        @Override
        @Transient
        public final Builder blueGreenDeploymentConfiguration(BlueGreenDeploymentConfiguration blueGreenDeploymentConfiguration) {
            this.blueGreenDeploymentConfiguration = blueGreenDeploymentConfiguration;
            return this;
        }

        public final LoadBalancerInfo.Builder getLoadBalancerInfo() {
            return loadBalancerInfo != null ? loadBalancerInfo.toBuilder() : null;
        }

        public final void setLoadBalancerInfo(LoadBalancerInfo.BuilderImpl loadBalancerInfo) {
            this.loadBalancerInfo = loadBalancerInfo != null ? loadBalancerInfo.build() : null;
        }

        @Override
        @Transient
        public final Builder loadBalancerInfo(LoadBalancerInfo loadBalancerInfo) {
            this.loadBalancerInfo = loadBalancerInfo;
            return this;
        }

        public final LastDeploymentInfo.Builder getLastSuccessfulDeployment() {
            return lastSuccessfulDeployment != null ? lastSuccessfulDeployment.toBuilder() : null;
        }

        public final void setLastSuccessfulDeployment(LastDeploymentInfo.BuilderImpl lastSuccessfulDeployment) {
            this.lastSuccessfulDeployment = lastSuccessfulDeployment != null ? lastSuccessfulDeployment.build() : null;
        }

        @Override
        @Transient
        public final Builder lastSuccessfulDeployment(LastDeploymentInfo lastSuccessfulDeployment) {
            this.lastSuccessfulDeployment = lastSuccessfulDeployment;
            return this;
        }

        public final LastDeploymentInfo.Builder getLastAttemptedDeployment() {
            return lastAttemptedDeployment != null ? lastAttemptedDeployment.toBuilder() : null;
        }

        public final void setLastAttemptedDeployment(LastDeploymentInfo.BuilderImpl lastAttemptedDeployment) {
            this.lastAttemptedDeployment = lastAttemptedDeployment != null ? lastAttemptedDeployment.build() : null;
        }

        @Override
        @Transient
        public final Builder lastAttemptedDeployment(LastDeploymentInfo lastAttemptedDeployment) {
            this.lastAttemptedDeployment = lastAttemptedDeployment;
            return this;
        }

        public final EC2TagSet.Builder getEc2TagSet() {
            return ec2TagSet != null ? ec2TagSet.toBuilder() : null;
        }

        public final void setEc2TagSet(EC2TagSet.BuilderImpl ec2TagSet) {
            this.ec2TagSet = ec2TagSet != null ? ec2TagSet.build() : null;
        }

        @Override
        @Transient
        public final Builder ec2TagSet(EC2TagSet ec2TagSet) {
            this.ec2TagSet = ec2TagSet;
            return this;
        }

        public final OnPremisesTagSet.Builder getOnPremisesTagSet() {
            return onPremisesTagSet != null ? onPremisesTagSet.toBuilder() : null;
        }

        public final void setOnPremisesTagSet(OnPremisesTagSet.BuilderImpl onPremisesTagSet) {
            this.onPremisesTagSet = onPremisesTagSet != null ? onPremisesTagSet.build() : null;
        }

        @Override
        @Transient
        public final Builder onPremisesTagSet(OnPremisesTagSet onPremisesTagSet) {
            this.onPremisesTagSet = onPremisesTagSet;
            return this;
        }

        public final String getComputePlatform() {
            return computePlatform;
        }

        public final void setComputePlatform(String computePlatform) {
            this.computePlatform = computePlatform;
        }

        @Override
        @Transient
        public final Builder computePlatform(String computePlatform) {
            this.computePlatform = computePlatform;
            return this;
        }

        @Override
        @Transient
        public final Builder computePlatform(ComputePlatform computePlatform) {
            this.computePlatform(computePlatform == null ? null : computePlatform.toString());
            return this;
        }

        public final List<ECSService.Builder> getEcsServices() {
            List<ECSService.Builder> result = ECSServiceListCopier.copyToBuilder(this.ecsServices);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEcsServices(Collection<ECSService.BuilderImpl> ecsServices) {
            this.ecsServices = ECSServiceListCopier.copyFromBuilder(ecsServices);
        }

        @Override
        @Transient
        public final Builder ecsServices(Collection<ECSService> ecsServices) {
            this.ecsServices = ECSServiceListCopier.copy(ecsServices);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder ecsServices(ECSService... ecsServices) {
            ecsServices(Arrays.asList(ecsServices));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder ecsServices(Consumer<ECSService.Builder>... ecsServices) {
            ecsServices(Stream.of(ecsServices).map(c -> ECSService.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public DeploymentGroupInfo build() {
            return new DeploymentGroupInfo(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
