/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codedeploy.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A configuration that shifts traffic from one version of a Lambda function or ECS task set to another in two
 * increments. The original and target Lambda function versions or ECS task sets are specified in the deployment's
 * AppSpec file.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TimeBasedCanary implements SdkPojo, Serializable, ToCopyableBuilder<TimeBasedCanary.Builder, TimeBasedCanary> {
    private static final SdkField<Integer> CANARY_PERCENTAGE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("canaryPercentage").getter(getter(TimeBasedCanary::canaryPercentage))
            .setter(setter(Builder::canaryPercentage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("canaryPercentage").build()).build();

    private static final SdkField<Integer> CANARY_INTERVAL_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("canaryInterval").getter(getter(TimeBasedCanary::canaryInterval)).setter(setter(Builder::canaryInterval))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("canaryInterval").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CANARY_PERCENTAGE_FIELD,
            CANARY_INTERVAL_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer canaryPercentage;

    private final Integer canaryInterval;

    private TimeBasedCanary(BuilderImpl builder) {
        this.canaryPercentage = builder.canaryPercentage;
        this.canaryInterval = builder.canaryInterval;
    }

    /**
     * <p>
     * The percentage of traffic to shift in the first increment of a <code>TimeBasedCanary</code> deployment.
     * </p>
     * 
     * @return The percentage of traffic to shift in the first increment of a <code>TimeBasedCanary</code> deployment.
     */
    public final Integer canaryPercentage() {
        return canaryPercentage;
    }

    /**
     * <p>
     * The number of minutes between the first and second traffic shifts of a <code>TimeBasedCanary</code> deployment.
     * </p>
     * 
     * @return The number of minutes between the first and second traffic shifts of a <code>TimeBasedCanary</code>
     *         deployment.
     */
    public final Integer canaryInterval() {
        return canaryInterval;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(canaryPercentage());
        hashCode = 31 * hashCode + Objects.hashCode(canaryInterval());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TimeBasedCanary)) {
            return false;
        }
        TimeBasedCanary other = (TimeBasedCanary) obj;
        return Objects.equals(canaryPercentage(), other.canaryPercentage())
                && Objects.equals(canaryInterval(), other.canaryInterval());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TimeBasedCanary").add("CanaryPercentage", canaryPercentage())
                .add("CanaryInterval", canaryInterval()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "canaryPercentage":
            return Optional.ofNullable(clazz.cast(canaryPercentage()));
        case "canaryInterval":
            return Optional.ofNullable(clazz.cast(canaryInterval()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TimeBasedCanary, T> g) {
        return obj -> g.apply((TimeBasedCanary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TimeBasedCanary> {
        /**
         * <p>
         * The percentage of traffic to shift in the first increment of a <code>TimeBasedCanary</code> deployment.
         * </p>
         * 
         * @param canaryPercentage
         *        The percentage of traffic to shift in the first increment of a <code>TimeBasedCanary</code>
         *        deployment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder canaryPercentage(Integer canaryPercentage);

        /**
         * <p>
         * The number of minutes between the first and second traffic shifts of a <code>TimeBasedCanary</code>
         * deployment.
         * </p>
         * 
         * @param canaryInterval
         *        The number of minutes between the first and second traffic shifts of a <code>TimeBasedCanary</code>
         *        deployment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder canaryInterval(Integer canaryInterval);
    }

    static final class BuilderImpl implements Builder {
        private Integer canaryPercentage;

        private Integer canaryInterval;

        private BuilderImpl() {
        }

        private BuilderImpl(TimeBasedCanary model) {
            canaryPercentage(model.canaryPercentage);
            canaryInterval(model.canaryInterval);
        }

        public final Integer getCanaryPercentage() {
            return canaryPercentage;
        }

        public final void setCanaryPercentage(Integer canaryPercentage) {
            this.canaryPercentage = canaryPercentage;
        }

        @Override
        public final Builder canaryPercentage(Integer canaryPercentage) {
            this.canaryPercentage = canaryPercentage;
            return this;
        }

        public final Integer getCanaryInterval() {
            return canaryInterval;
        }

        public final void setCanaryInterval(Integer canaryInterval) {
            this.canaryInterval = canaryInterval;
        }

        @Override
        public final Builder canaryInterval(Integer canaryInterval) {
            this.canaryInterval = canaryInterval;
            return this;
        }

        @Override
        public TimeBasedCanary build() {
            return new TimeBasedCanary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
