/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codedeploy.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RawString
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RawString> {
    private static final SdkField<String> CONTENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("content").getter(RawString.getter(RawString::content)).setter(RawString.setter(Builder::content)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("content").build()}).build();
    private static final SdkField<String> SHA256_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sha256").getter(RawString.getter(RawString::sha256)).setter(RawString.setter(Builder::sha256)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sha256").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTENT_FIELD, SHA256_FIELD));
    private static final long serialVersionUID = 1L;
    private final String content;
    private final String sha256;

    private RawString(BuilderImpl builder) {
        this.content = builder.content;
        this.sha256 = builder.sha256;
    }

    public final String content() {
        return this.content;
    }

    public final String sha256() {
        return this.sha256;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.content());
        hashCode = 31 * hashCode + Objects.hashCode(this.sha256());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RawString)) {
            return false;
        }
        RawString other = (RawString)obj;
        return Objects.equals(this.content(), other.content()) && Objects.equals(this.sha256(), other.sha256());
    }

    public final String toString() {
        return ToString.builder((String)"RawString").add("Content", (Object)this.content()).add("Sha256", (Object)this.sha256()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "content": {
                return Optional.ofNullable(clazz.cast(this.content()));
            }
            case "sha256": {
                return Optional.ofNullable(clazz.cast(this.sha256()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RawString, T> g) {
        return obj -> g.apply((RawString)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String content;
        private String sha256;

        private BuilderImpl() {
        }

        private BuilderImpl(RawString model) {
            this.content(model.content);
            this.sha256(model.sha256);
        }

        public final String getContent() {
            return this.content;
        }

        public final void setContent(String content) {
            this.content = content;
        }

        @Override
        @Transient
        public final Builder content(String content) {
            this.content = content;
            return this;
        }

        public final String getSha256() {
            return this.sha256;
        }

        public final void setSha256(String sha256) {
            this.sha256 = sha256;
        }

        @Override
        @Transient
        public final Builder sha256(String sha256) {
            this.sha256 = sha256;
            return this;
        }

        public RawString build() {
            return new RawString(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RawString> {
        public Builder content(String var1);

        public Builder sha256(String var1);
    }
}

