/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codedeploy.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A revision for an AWS Lambda or Amazon ECS deployment that is a YAML-formatted or JSON-formatted string. For AWS
 * Lambda and Amazon ECS deployments, the revision is the same as the AppSpec file. This method replaces the deprecated
 * <code>RawString</code> data type.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AppSpecContent implements SdkPojo, Serializable, ToCopyableBuilder<AppSpecContent.Builder, AppSpecContent> {
    private static final SdkField<String> CONTENT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("content")
            .getter(getter(AppSpecContent::content)).setter(setter(Builder::content))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("content").build()).build();

    private static final SdkField<String> SHA256_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("sha256")
            .getter(getter(AppSpecContent::sha256)).setter(setter(Builder::sha256))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sha256").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTENT_FIELD, SHA256_FIELD));

    private static final long serialVersionUID = 1L;

    private final String content;

    private final String sha256;

    private AppSpecContent(BuilderImpl builder) {
        this.content = builder.content;
        this.sha256 = builder.sha256;
    }

    /**
     * <p>
     * The YAML-formatted or JSON-formatted revision string.
     * </p>
     * <p>
     * For an AWS Lambda deployment, the content includes a Lambda function name, the alias for its original version,
     * and the alias for its replacement version. The deployment shifts traffic from the original version of the Lambda
     * function to the replacement version.
     * </p>
     * <p>
     * For an Amazon ECS deployment, the content includes the task name, information about the load balancer that serves
     * traffic to the container, and more.
     * </p>
     * <p>
     * For both types of deployments, the content can specify Lambda functions that run at specified hooks, such as
     * <code>BeforeInstall</code>, during a deployment.
     * </p>
     * 
     * @return The YAML-formatted or JSON-formatted revision string. </p>
     *         <p>
     *         For an AWS Lambda deployment, the content includes a Lambda function name, the alias for its original
     *         version, and the alias for its replacement version. The deployment shifts traffic from the original
     *         version of the Lambda function to the replacement version.
     *         </p>
     *         <p>
     *         For an Amazon ECS deployment, the content includes the task name, information about the load balancer
     *         that serves traffic to the container, and more.
     *         </p>
     *         <p>
     *         For both types of deployments, the content can specify Lambda functions that run at specified hooks, such
     *         as <code>BeforeInstall</code>, during a deployment.
     */
    public final String content() {
        return content;
    }

    /**
     * <p>
     * The SHA256 hash value of the revision content.
     * </p>
     * 
     * @return The SHA256 hash value of the revision content.
     */
    public final String sha256() {
        return sha256;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(content());
        hashCode = 31 * hashCode + Objects.hashCode(sha256());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AppSpecContent)) {
            return false;
        }
        AppSpecContent other = (AppSpecContent) obj;
        return Objects.equals(content(), other.content()) && Objects.equals(sha256(), other.sha256());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AppSpecContent").add("Content", content()).add("Sha256", sha256()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "content":
            return Optional.ofNullable(clazz.cast(content()));
        case "sha256":
            return Optional.ofNullable(clazz.cast(sha256()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AppSpecContent, T> g) {
        return obj -> g.apply((AppSpecContent) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AppSpecContent> {
        /**
         * <p>
         * The YAML-formatted or JSON-formatted revision string.
         * </p>
         * <p>
         * For an AWS Lambda deployment, the content includes a Lambda function name, the alias for its original
         * version, and the alias for its replacement version. The deployment shifts traffic from the original version
         * of the Lambda function to the replacement version.
         * </p>
         * <p>
         * For an Amazon ECS deployment, the content includes the task name, information about the load balancer that
         * serves traffic to the container, and more.
         * </p>
         * <p>
         * For both types of deployments, the content can specify Lambda functions that run at specified hooks, such as
         * <code>BeforeInstall</code>, during a deployment.
         * </p>
         * 
         * @param content
         *        The YAML-formatted or JSON-formatted revision string. </p>
         *        <p>
         *        For an AWS Lambda deployment, the content includes a Lambda function name, the alias for its original
         *        version, and the alias for its replacement version. The deployment shifts traffic from the original
         *        version of the Lambda function to the replacement version.
         *        </p>
         *        <p>
         *        For an Amazon ECS deployment, the content includes the task name, information about the load balancer
         *        that serves traffic to the container, and more.
         *        </p>
         *        <p>
         *        For both types of deployments, the content can specify Lambda functions that run at specified hooks,
         *        such as <code>BeforeInstall</code>, during a deployment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder content(String content);

        /**
         * <p>
         * The SHA256 hash value of the revision content.
         * </p>
         * 
         * @param sha256
         *        The SHA256 hash value of the revision content.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sha256(String sha256);
    }

    static final class BuilderImpl implements Builder {
        private String content;

        private String sha256;

        private BuilderImpl() {
        }

        private BuilderImpl(AppSpecContent model) {
            content(model.content);
            sha256(model.sha256);
        }

        public final String getContent() {
            return content;
        }

        public final void setContent(String content) {
            this.content = content;
        }

        @Override
        @Transient
        public final Builder content(String content) {
            this.content = content;
            return this;
        }

        public final String getSha256() {
            return sha256;
        }

        public final void setSha256(String sha256) {
            this.sha256 = sha256;
        }

        @Override
        @Transient
        public final Builder sha256(String sha256) {
            this.sha256 = sha256;
            return this;
        }

        @Override
        public AppSpecContent build() {
            return new AppSpecContent(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
