/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codedeploy.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum DeploymentCreator {
    USER("user"),
    AUTOSCALING("autoscaling"),
    CODE_DEPLOY_ROLLBACK("codeDeployRollback"),
    CODE_DEPLOY("CodeDeploy"),
    CODE_DEPLOY_AUTO_UPDATE("CodeDeployAutoUpdate"),
    CLOUD_FORMATION("CloudFormation"),
    CLOUD_FORMATION_ROLLBACK("CloudFormationRollback"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private DeploymentCreator(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static DeploymentCreator fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(DeploymentCreator.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<DeploymentCreator> knownValues() {
        return Stream.of(DeploymentCreator.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

