/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codedeploy.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the input of a BatchGetDeployments operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchGetDeploymentsRequest extends CodeDeployRequest implements
        ToCopyableBuilder<BatchGetDeploymentsRequest.Builder, BatchGetDeploymentsRequest> {
    private static final SdkField<List<String>> DEPLOYMENT_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(BatchGetDeploymentsRequest::deploymentIds))
            .setter(setter(Builder::deploymentIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deploymentIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEPLOYMENT_IDS_FIELD));

    private final List<String> deploymentIds;

    private BatchGetDeploymentsRequest(BuilderImpl builder) {
        super(builder);
        this.deploymentIds = builder.deploymentIds;
    }

    /**
     * <p>
     * A list of deployment IDs, separated by spaces.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of deployment IDs, separated by spaces.
     */
    public List<String> deploymentIds() {
        return deploymentIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(deploymentIds());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetDeploymentsRequest)) {
            return false;
        }
        BatchGetDeploymentsRequest other = (BatchGetDeploymentsRequest) obj;
        return Objects.equals(deploymentIds(), other.deploymentIds());
    }

    @Override
    public String toString() {
        return ToString.builder("BatchGetDeploymentsRequest").add("DeploymentIds", deploymentIds()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "deploymentIds":
            return Optional.ofNullable(clazz.cast(deploymentIds()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchGetDeploymentsRequest, T> g) {
        return obj -> g.apply((BatchGetDeploymentsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodeDeployRequest.Builder, SdkPojo, CopyableBuilder<Builder, BatchGetDeploymentsRequest> {
        /**
         * <p>
         * A list of deployment IDs, separated by spaces.
         * </p>
         * 
         * @param deploymentIds
         *        A list of deployment IDs, separated by spaces.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deploymentIds(Collection<String> deploymentIds);

        /**
         * <p>
         * A list of deployment IDs, separated by spaces.
         * </p>
         * 
         * @param deploymentIds
         *        A list of deployment IDs, separated by spaces.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deploymentIds(String... deploymentIds);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CodeDeployRequest.BuilderImpl implements Builder {
        private List<String> deploymentIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetDeploymentsRequest model) {
            super(model);
            deploymentIds(model.deploymentIds);
        }

        public final Collection<String> getDeploymentIds() {
            return deploymentIds;
        }

        @Override
        public final Builder deploymentIds(Collection<String> deploymentIds) {
            this.deploymentIds = DeploymentsListCopier.copy(deploymentIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deploymentIds(String... deploymentIds) {
            deploymentIds(Arrays.asList(deploymentIds));
            return this;
        }

        public final void setDeploymentIds(Collection<String> deploymentIds) {
            this.deploymentIds = DeploymentsListCopier.copy(deploymentIds);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BatchGetDeploymentsRequest build() {
            return new BatchGetDeploymentsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
